/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.formsolutions;

import de.cismet.cids.custom.utils.formsolutions.FormSolutionsProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FormSolutionBestellungSpecialLogger {
    private static final Logger LOG = Logger.getLogger(FormSolutionBestellungSpecialLogger.class);
    private final FileWriter specialLogWriter;

    private FormSolutionBestellungSpecialLogger() {
        FileWriter specialLogWriter = null;
        String specialLogAbsPath = FormSolutionsProperties.getInstance().getSpecialLogAbsPath();
        try {
            File specialLogFile;
            if (specialLogAbsPath != null && !specialLogAbsPath.isEmpty() && (!(specialLogFile = new File(specialLogAbsPath)).exists() || specialLogFile.isFile() && specialLogFile.canWrite())) {
                specialLogWriter = new FileWriter(specialLogFile, true);
            }
        }
        catch (IOException ex) {
            LOG.error((Object)"special log file writer could not be created", (Throwable)ex);
        }
        this.specialLogWriter = specialLogWriter;
    }

    public synchronized void log(String message) {
        if (this.specialLogWriter != null) {
            try {
                this.specialLogWriter.write(System.currentTimeMillis() + " - " + message + "\n");
                this.specialLogWriter.flush();
            }
            catch (IOException ex) {
                LOG.warn((Object)"could not write to logSpecial", (Throwable)ex);
            }
        }
    }

    public static FormSolutionBestellungSpecialLogger getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    private static final class LazyInitialiser {
        private static final FormSolutionBestellungSpecialLogger INSTANCE = new FormSolutionBestellungSpecialLogger();

        private LazyInitialiser() {
        }
    }
}

