/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.vermessungsunterlagen;

import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenProperties;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class VermessungsunterlagenFtpHelper {
    private final VermessungsunterlagenProperties properties = VermessungsunterlagenProperties.fromServerResources();

    private FTPClient getConnectedFTPClient() throws Exception {
        FTPClient ftpClient = new FTPClient();
        ftpClient.connect(this.properties.getFtpHost());
        int reply = ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            ftpClient.disconnect();
            throw new Exception("Exception in connecting to FTP Server");
        }
        ftpClient.login(this.properties.getFtpLogin(), this.properties.getFtpPass());
        return ftpClient;
    }

    public void uploadToFTP(InputStream in, String ftpZipPath) throws Exception {
        FTPClient connectedFtpClient = this.getConnectedFTPClient();
        connectedFtpClient.enterLocalPassiveMode();
        connectedFtpClient.setFileType(2);
        connectedFtpClient.storeFile(ftpZipPath, in);
    }

    public InputStream downloadFromFTP(String ftpFilePath) throws Exception {
        FTPClient connectedFtpClient = this.getConnectedFTPClient();
        connectedFtpClient.enterLocalPassiveMode();
        connectedFtpClient.setFileType(2);
        return connectedFtpClient.retrieveFileStream(ftpFilePath);
    }
}

