/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.vermessungsunterlagen;

import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class VermessungsunterlagenProperties {
    private static final transient Logger LOG = Logger.getLogger(VermessungsunterlagenProperties.class);
    public static final String FROM_WEBDAV = "webdav";
    public static final String FROM_FTP = "ftp";
    public static final String DIR_PREFIX = "05124";
    private static VermessungsunterlagenProperties PROPERTIES;
    private final Properties properties;
    private final String cidsLogin;
    private final String absPathTmp;
    private final boolean ftpEnabled;
    private final String ftpHost;
    private final String ftpLogin;
    private final String ftpPass;
    private final String ftpPath;
    private final boolean webDavEnabled;
    private final String webDavHost;
    private final String webDavLogin;
    private final String webDavPass;
    private final String webDavPath;
    private final String absPathTest;
    private final String absPathPdfRisse;
    private final String absPathPdfNivP;
    private final String absPathPdfPnrVermstelle;
    private final String jobResultFrom;
    private final String downloadFrom;
    private final String profilKennungAnonym;
    private final String profilKennungRegistriert;

    public VermessungsunterlagenProperties(Properties properties) {
        this.properties = properties;
        this.cidsLogin = this.readProperty("CIDS_LOGIN", null);
        this.absPathTmp = this.readProperty("ABS_PATH_TMP", "/tmp");
        this.ftpEnabled = Boolean.parseBoolean(this.readProperty("FTP_ENABLED", "true"));
        this.ftpHost = this.readProperty("FTP_HOST", null);
        this.ftpLogin = this.readProperty("FTP_LOGIN", null);
        this.ftpPass = this.readProperty("FTP_PASS", null);
        this.ftpPath = this.readProperty("FTP_PATH", null);
        this.webDavEnabled = Boolean.parseBoolean(this.readProperty("WEBDAV_ENABLED", "false"));
        this.webDavHost = this.readProperty("WEBDAV_HOST", null);
        this.webDavLogin = this.readProperty("WEBDAV_LOGIN", null);
        this.webDavPass = this.readProperty("WEBDAV_PASS", null);
        this.webDavPath = this.readProperty("WEBDAV_PATH", null);
        this.absPathTest = this.readProperty("ABS_PATH_TEST", null);
        this.absPathPdfRisse = this.readProperty("ABS_PATH_PDF_RISSE", null);
        this.absPathPdfNivP = this.readProperty("ABS_PATH_PDF_NIVP", null);
        this.absPathPdfPnrVermstelle = this.readProperty("ABS_PATH_PDF_PNR_VERMSTELLE", null);
        this.jobResultFrom = this.readProperty("JOB_RESULT_FROM", FROM_WEBDAV);
        this.downloadFrom = this.readProperty("DOWNLOAD_FROM", FROM_WEBDAV);
        this.profilKennungAnonym = this.readProperty("PROFIL_KENNUNG_ANONYM", "VUPtemp");
        this.profilKennungRegistriert = this.readProperty("PROFIL_KENNUNG_REGISTRIERT", "VUPdst");
    }

    private String readProperty(String property, String defaultValue) {
        String value = defaultValue;
        try {
            value = this.getProperties().getProperty(property, defaultValue);
        }
        catch (Exception ex) {
            String message = "could not read " + property + " from " + WundaBlauServerResources.VERMESSUNGSUNTERLAGENPORTAL_PROPERTIES.getValue() + ". setting to default value: " + defaultValue;
            LOG.warn((Object)message, (Throwable)ex);
        }
        return value;
    }

    public String getPath(String jobKey) {
        return this.getAbsPathTmp() + "/" + DIR_PREFIX + "_" + jobKey.replace("/", "--");
    }

    public static VermessungsunterlagenProperties fromServerResources() {
        if (PROPERTIES == null) {
            try {
                PROPERTIES = new VermessungsunterlagenProperties(ServerResourcesLoader.getInstance().loadProperties(WundaBlauServerResources.VERMESSUNGSUNTERLAGENPORTAL_PROPERTIES.getValue()));
            }
            catch (Exception ex) {
                LOG.error((Object)"VermessungsunterlagenHelper could not load the properties", (Throwable)ex);
            }
        }
        return PROPERTIES;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getCidsLogin() {
        return this.cidsLogin;
    }

    public String getAbsPathTmp() {
        return this.absPathTmp;
    }

    public boolean isFtpEnabled() {
        return this.ftpEnabled;
    }

    public String getFtpHost() {
        return this.ftpHost;
    }

    public String getFtpLogin() {
        return this.ftpLogin;
    }

    public String getFtpPass() {
        return this.ftpPass;
    }

    public String getFtpPath() {
        return this.ftpPath;
    }

    public boolean isWebDavEnabled() {
        return this.webDavEnabled;
    }

    public String getWebDavHost() {
        return this.webDavHost;
    }

    public String getWebDavLogin() {
        return this.webDavLogin;
    }

    public String getWebDavPass() {
        return this.webDavPass;
    }

    public String getWebDavPath() {
        return this.webDavPath;
    }

    public String getAbsPathTest() {
        return this.absPathTest;
    }

    public String getAbsPathPdfRisse() {
        return this.absPathPdfRisse;
    }

    public String getAbsPathPdfNivP() {
        return this.absPathPdfNivP;
    }

    public String getAbsPathPdfPnrVermstelle() {
        return this.absPathPdfPnrVermstelle;
    }

    public String getJobResultFrom() {
        return this.jobResultFrom;
    }

    public String getDownloadFrom() {
        return this.downloadFrom;
    }

    public String getProfilKennungAnonym() {
        return this.profilKennungAnonym;
    }

    public String getProfilKennungRegistriert() {
        return this.profilKennungRegistriert;
    }
}

