/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.vermessungsunterlagen.tasks;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.utils.AsyncDownloadHelper;
import de.cismet.cids.custom.utils.nas.NasProduct;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenHandler;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenProperties;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenTask;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenTaskRetryable;
import de.cismet.cids.custom.utils.vermessungsunterlagen.exceptions.VermessungsunterlagenTaskException;
import de.cismet.cids.custom.wunda_blau.search.actions.NasDataQueryAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import java.io.File;
import java.io.FileOutputStream;

public abstract class VermUntTaskNas
extends VermessungsunterlagenTask
implements VermessungsunterlagenTaskRetryable {
    private static final String XML_EXTENSION = ".xml";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String DXF_EXTENSION = ".dxf";
    private static final int NAS_POLLING_FREQUENCY_MS = 5000;
    private final Geometry geometry;
    private final NasProduct product;
    private final String requestId;
    private boolean anonymous;
    private String orderId;

    public VermUntTaskNas(String type, String jobkey, String requestId, Geometry geometry, NasProduct product, boolean anonymous) {
        super(type, jobkey);
        this.requestId = requestId;
        this.geometry = geometry;
        this.product = product;
        this.anonymous = anonymous;
    }

    @Override
    public void performTask() throws VermessungsunterlagenTaskException {
        GeometryCollection geometryCollection = VermUntTaskNas.generateSearchGeomCollection(this.geometry);
        String extension = this.product.getFormat().equals(NasProduct.Format.DXF.toString()) ? DXF_EXTENSION : (this.isNASOrderSplitted(geometryCollection) ? ZIP_EXTENSION : XML_EXTENSION);
        String filename = VermessungsunterlagenHandler.NAS_PRODUCT_PUNKTE.getKey().equals(this.product.getKey()) ? this.getJobKey() + "_Koord" : this.getJobKey();
        File fileToSaveTo = new File(this.getPath() + "/" + filename.replace("/", "--") + extension);
        if (this.orderId == null) {
            this.orderId = this.sendNasRequest(this.product, geometryCollection, this.requestId, this.anonymous ? VermessungsunterlagenProperties.fromServerResources().getProfilKennungAnonym() : VermessungsunterlagenProperties.fromServerResources().getProfilKennungRegistriert());
            if (this.orderId == null) {
                String message = "Der NAS-Server hat keine OrderID zur\u00fcckgeliefert. Der Download kann nicht gestartet werden.";
                LOG.error((Object)"Der NAS-Server hat keine OrderID zur\u00fcckgeliefert. Der Download kann nicht gestartet werden.", (Throwable)new Exception());
                throw new VermessungsunterlagenTaskException(this.getType(), "Der NAS-Server hat keine OrderID zur\u00fcckgeliefert. Der Download kann nicht gestartet werden.");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"NAS Download: Request correctly sended start polling the result from server (max 1 hour)");
        }
        NasDataQueryAction action = new NasDataQueryAction();
        action.setUser(this.getUser());
        ServerActionParameter paramMethod = new ServerActionParameter(NasDataQueryAction.PARAMETER_TYPE.METHOD.toString(), (Object)NasDataQueryAction.METHOD_TYPE.GET);
        ServerActionParameter paramOrderId = new ServerActionParameter(NasDataQueryAction.PARAMETER_TYPE.ORDER_ID.toString(), (Object)this.orderId);
        byte[] content = null;
        while (content == null || content.length == 0) {
            if (Thread.interrupted()) {
                LOG.info((Object)"result fetching thread was interrupted");
                break;
            }
            content = (byte[])AsyncDownloadHelper.actionResultToByteArrayIfPossible(action.execute(null, paramOrderId, paramMethod));
            if (content == null) {
                String message = "Beim Abfragen der NAS-Ergebnisse kam es zu einem unerwarteten Fehler.";
                LOG.error((Object)"Beim Abfragen der NAS-Ergebnisse kam es zu einem unerwarteten Fehler.", (Throwable)new Exception());
                throw new VermessungsunterlagenTaskException(this.getType(), "Beim Abfragen der NAS-Ergebnisse kam es zu einem unerwarteten Fehler.");
            }
            if (content.length != 0) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                LOG.info((Object)"result fetching thread was interrupted", (Throwable)ex);
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"NAS Download: Polling is finished.");
        }
        if (content != null) {
            try (FileOutputStream out = new FileOutputStream(fileToSaveTo);){
                out.write(content);
            }
            catch (Exception ex) {
                String message = "Beim Schreiben der NAS-Order in die Datei '" + fileToSaveTo + "' kam es zu einem unerwarteten Fehler.";
                LOG.error((Object)message, (Throwable)ex);
                throw new VermessungsunterlagenTaskException(this.getType(), message, ex);
            }
        }
    }

    private String sendNasRequest(NasProduct product, GeometryCollection geometrieCollection, String requestId, String profilKennung) throws VermessungsunterlagenTaskException {
        NasDataQueryAction action = new NasDataQueryAction();
        action.setUser(this.getUser());
        String result = (String)action.execute(null, new ServerActionParameter(NasDataQueryAction.PARAMETER_TYPE.TEMPLATE.toString(), (Object)product), new ServerActionParameter(NasDataQueryAction.PARAMETER_TYPE.GEOMETRY_COLLECTION.toString(), (Object)geometrieCollection), new ServerActionParameter(NasDataQueryAction.PARAMETER_TYPE.METHOD.toString(), (Object)NasDataQueryAction.METHOD_TYPE.ADD), new ServerActionParameter(NasDataQueryAction.PARAMETER_TYPE.REQUEST_ID.toString(), (Object)requestId), new ServerActionParameter(NasDataQueryAction.PARAMETER_TYPE.PROFIL_KENNUNG.toString(), (Object)profilKennung));
        if (result == null) {
            String message = "Beim Absetzen des Requests an den NAS-Server kam es zu einem unerwarteten Fehler.";
            LOG.error((Object)"Beim Absetzen des Requests an den NAS-Server kam es zu einem unerwarteten Fehler.", (Throwable)new Exception());
            throw new VermessungsunterlagenTaskException(this.getType(), "Beim Absetzen des Requests an den NAS-Server kam es zu einem unerwarteten Fehler.");
        }
        return result;
    }

    private static GeometryCollection generateSearchGeomCollection(Geometry geometry) {
        GeometryFactory gf = new GeometryFactory(geometry.getPrecisionModel(), geometry.getSRID());
        Geometry[] geoms = null;
        if (geometry instanceof MultiPolygon) {
            MultiPolygon mp = (MultiPolygon)geometry;
            geoms = new Geometry[mp.getNumGeometries()];
            for (int i = 0; i < mp.getNumGeometries(); ++i) {
                Geometry g;
                geoms[i] = g = mp.getGeometryN(i);
            }
        } else if (geometry instanceof Polygon) {
            geoms = new Geometry[]{geometry};
        }
        if (geoms == null) {
            return null;
        }
        return new GeometryCollection(geoms, gf);
    }

    private boolean isNASOrderSplitted(GeometryCollection geoms) {
        Envelope env = geoms.getEnvelopeInternal();
        double xSize = env.getMaxX() - env.getMinX();
        double ySize = env.getMaxY() - env.getMinY();
        return xSize > 500.0 && ySize > 500.0;
    }

    @Override
    protected String getSubPath() {
        return "/NAS";
    }

    @Override
    public long getMaxTotalWaitTimeMs() {
        return 1023000L;
    }

    @Override
    public long getFirstWaitTimeMs() {
        return 1000L;
    }

    @Override
    public double getWaitTimeMultiplicator() {
        return 2.0;
    }
}

