/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.vermessungsunterlagen.tasks;

import de.cismet.cids.custom.utils.pointnumberreservation.PointNumberReservation;
import de.cismet.cids.custom.utils.pointnumberreservation.PointNumberReservationRequest;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenAnfrageBean;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenTask;
import de.cismet.cids.custom.utils.vermessungsunterlagen.exceptions.VermessungsunterlagenTaskException;
import de.cismet.cids.custom.wunda_blau.search.actions.PointNumberReservationServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import java.io.File;
import java.util.Collection;
import org.apache.commons.io.FileUtils;

public class VermUntTaskPNR
extends VermessungsunterlagenTask {
    public static final String TYPE = "PNR";
    private final String auftragsnummer;
    private final String vermessungsstelle;
    private final VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean[] punktnummernreservierungBeans;

    public VermUntTaskPNR(String jobKey, String vermessungsstelle, String auftragsnummer, VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean[] punktnummernreservierungBeans) {
        super(TYPE, jobKey);
        this.auftragsnummer = auftragsnummer;
        this.vermessungsstelle = vermessungsstelle;
        this.punktnummernreservierungBeans = punktnummernreservierungBeans;
    }

    @Override
    protected void performTask() throws VermessungsunterlagenTaskException {
        if (this.vermessungsstelle == null) {
            File src = new File(this.getProperties().getAbsPathPdfPnrVermstelle());
            File dst = new File(this.getPath() + "/" + src.getName());
            if (!dst.exists()) {
                try {
                    FileUtils.copyFile((File)src, (File)dst);
                }
                catch (Exception ex) {
                    String message = "Beim Kopieren des PNR-Informations-PDFs kam es zu einem unerwarteten Fehler.";
                    throw new VermessungsunterlagenTaskException(this.getType(), "Beim Kopieren des PNR-Informations-PDFs kam es zu einem unerwarteten Fehler.", ex);
                }
            }
        } else if (this.punktnummernreservierungBeans != null) {
            Collection<PointNumberReservation> reservations = this.getReservations();
            boolean first = reservations == null || reservations.isEmpty();
            for (VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean bean : this.punktnummernreservierungBeans) {
                if (bean.getAnzahlPunktnummern() <= 0) continue;
                try {
                    PointNumberReservationRequest result = this.doReservation(bean, !first);
                    if (result != null) {
                        String filebasename = this.getPath() + "/" + this.auftragsnummer + "_" + bean.getUtmKilometerQuadrat();
                        if (result.isSuccessfull()) {
                            if (!this.isPointNumberBeanValid(result)) {
                                throw new VermessungsunterlagenTaskException(this.getType(), "Ung\u00fcltige Antwort des Punktnummernreservierungsdienstes.");
                            }
                            FileUtils.writeStringToFile((File)new File(filebasename + ".xml"), (String)result.getRawResult(), (String)"UTF-8");
                            FileUtils.writeStringToFile((File)new File(filebasename + ".txt"), (String)result.createTxtProtokoll(), (String)"ISO-8859-1");
                        } else {
                            FileUtils.writeStringToFile((File)new File(filebasename + ".txt"), (String)result.getProtokoll(), (String)"ISO-8859-1");
                        }
                    } else {
                        throw new VermessungsunterlagenTaskException(this.getType(), "Ung\u00fcltige Antwort des Punktnummernreservierungsdienstes.");
                    }
                    first = false;
                }
                catch (Exception ex) {
                    String message = "Beim Herunterladen des Punktnummernreservierungsprotokolls kam es zu einem unerwarteten Fehler.";
                    throw new VermessungsunterlagenTaskException(this.getType(), "Beim Herunterladen des Punktnummernreservierungsprotokolls kam es zu einem unerwarteten Fehler.", ex);
                }
            }
        }
    }

    private boolean isPointNumberBeanValid(PointNumberReservationRequest content) {
        if (content == null) {
            return false;
        }
        if (content.getAntragsnummer() == null || content.getAntragsnummer().isEmpty()) {
            return false;
        }
        return content.getPointNumbers() != null && !content.getPointNumbers().isEmpty();
    }

    @Override
    protected String getSubPath() {
        return "/PNR";
    }

    private Collection<PointNumberReservation> getReservations() {
        ServerActionParameter sapPrefix = new ServerActionParameter(PointNumberReservationServerAction.Parameter.PREFIX.toString(), (Object)this.vermessungsstelle.substring(2));
        ServerActionParameter sapAuftragsnummer = new ServerActionParameter(PointNumberReservationServerAction.Parameter.AUFTRAG_NUMMER.toString(), (Object)this.auftragsnummer);
        ServerActionParameter sapAction = new ServerActionParameter(PointNumberReservationServerAction.Parameter.ACTION.toString(), (Object)PointNumberReservationServerAction.Action.GET_POINT_NUMBERS);
        PointNumberReservationServerAction action = new PointNumberReservationServerAction();
        action.setUser(this.getUser());
        action.setMetaService(this.getMetaService());
        Collection request = (Collection)action.execute(null, sapAction, sapPrefix, sapAuftragsnummer);
        return request;
    }

    protected PointNumberReservationRequest doReservation(VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean bean, boolean ergaenzen) {
        ServerActionParameter sapAction = ergaenzen ? new ServerActionParameter(PointNumberReservationServerAction.Parameter.ACTION.toString(), (Object)PointNumberReservationServerAction.Action.DO_ADDITION) : new ServerActionParameter(PointNumberReservationServerAction.Parameter.ACTION.toString(), (Object)PointNumberReservationServerAction.Action.DO_RESERVATION);
        ServerActionParameter sapPrefix = new ServerActionParameter(PointNumberReservationServerAction.Parameter.PREFIX.toString(), (Object)this.vermessungsstelle.substring(2));
        ServerActionParameter sapAuftragsnummer = new ServerActionParameter(PointNumberReservationServerAction.Parameter.AUFTRAG_NUMMER.toString(), (Object)this.auftragsnummer);
        ServerActionParameter sapNummerierungsbezirk = new ServerActionParameter(PointNumberReservationServerAction.Parameter.NBZ.toString(), (Object)bean.getUtmKilometerQuadrat());
        ServerActionParameter sapAnzahl = new ServerActionParameter(PointNumberReservationServerAction.Parameter.ANZAHL.toString(), (Object)bean.getAnzahlPunktnummern());
        ServerActionParameter sapStartwert = new ServerActionParameter(PointNumberReservationServerAction.Parameter.STARTWERT.toString(), (Object)0);
        PointNumberReservationServerAction action = new PointNumberReservationServerAction();
        action.setUser(this.getUser());
        action.setMetaService(this.getMetaService());
        return (PointNumberReservationRequest)action.execute(null, sapAction, sapPrefix, sapAuftragsnummer, sapNummerierungsbezirk, sapAnzahl, sapStartwert);
    }
}

