/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.vermessungsunterlagen.tasks;

import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.utils.alkis.ServerAlkisConf;
import de.cismet.cids.custom.utils.alkis.VermessungsRissReportHelper;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenTask;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenTaskRetryable;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenUtils;
import de.cismet.cids.custom.utils.vermessungsunterlagen.exceptions.VermessungsunterlagenTaskException;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.commons.security.handler.SimpleHttpAccessHandler;
import de.cismet.commons.utils.MultiPagePictureReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.commons.io.FileUtils;

public abstract class VermUntTaskRisse
extends VermessungsunterlagenTask
implements VermessungsunterlagenTaskRetryable {
    private final Collection<CidsBean> risseBeans;
    private final String host;
    private final String auftragsnummer;
    private final String projektnummer;

    public VermUntTaskRisse(String type, String jobkey, Collection<CidsBean> risseBeans, String host, String auftragsnummer, String projektnummer) {
        super(type, jobkey);
        this.risseBeans = risseBeans;
        this.host = host;
        this.auftragsnummer = auftragsnummer;
        this.projektnummer = projektnummer;
    }

    @Override
    public void performTask() throws VermessungsunterlagenTaskException {
        String prefix = ServerAlkisConf.getInstance().getVermessungHostBilder().equalsIgnoreCase(this.host) ? "Vermessungsrisse-Bericht" : "Erg\u00e4nzende-Dokumente-Bericht";
        String suffix = this.getJobKey().substring(this.getJobKey().indexOf("_") + 1, this.getJobKey().length());
        String filename = this.getPath() + "/" + prefix + "_" + suffix.replace("/", "--") + ".pdf";
        File src = new File(this.getProperties().getAbsPathPdfRisse());
        File dst = new File(this.getPath() + "/" + src.getName());
        if (!dst.exists()) {
            try {
                FileUtils.copyFile((File)src, (File)dst);
            }
            catch (Exception ex) {
                String message = "Beim Kopieren des Risse-Informations-PDFs kam es zu einem unerwarteten Fehler.";
                throw new VermessungsunterlagenTaskException(this.getType(), "Beim Kopieren des Risse-Informations-PDFs kam es zu einem unerwarteten Fehler.", ex);
            }
        }
        Object[] tmp = new VermessungsRissReportHelper(this.getUser(), this.getMetaService(), this.getConnectionContext()).generateReportData(this.auftragsnummer, this.projektnummer, this.risseBeans, this.host, MultiPagePictureReader.class);
        Collection reportBeans = (Collection)tmp[0];
        Map parameters = (Map)tmp[1];
        Collection additionalFilesToDownload = (Collection)tmp[2];
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(reportBeans);
        try {
            FileOutputStream out = new FileOutputStream(filename);
            Object object = null;
            try {
                VermessungsunterlagenUtils.jasperReportDownload(ServerResourcesLoader.getInstance().loadJasperReport(WundaBlauServerResources.VERMESSUNGSRISSE_JASPER.getValue()), parameters, (JRDataSource)dataSource, out);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (object != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)out).close();
                    }
                }
            }
        }
        catch (Exception ex) {
            String message = "Beim Erzeugen des Vermessungsrisse-Berichtes kam es zu einem unerwarteten Fehler.";
            throw new VermessungsunterlagenTaskException(this.getType(), "Beim Erzeugen des Vermessungsrisse-Berichtes kam es zu einem unerwarteten Fehler.", ex);
        }
        SimpleHttpAccessHandler extendedAccessHandler = new SimpleHttpAccessHandler();
        for (URL additionalFileToDownload : additionalFilesToDownload) {
            String additionalFilename = this.getPath() + "/" + additionalFileToDownload.getFile().substring(additionalFileToDownload.getFile().lastIndexOf(47) + 1);
            String pureAdditionalFilename = additionalFilename.substring(0, additionalFilename.lastIndexOf(46));
            try {
                InputStream in = extendedAccessHandler.doRequest(additionalFileToDownload);
                Throwable throwable = null;
                try {
                    FileOutputStream out = new FileOutputStream(additionalFilename);
                    Throwable throwable2 = null;
                    try {
                        VermessungsunterlagenUtils.downloadStream(in, out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"could not download additional File", (Throwable)ex);
                VermessungsunterlagenUtils.writeExceptionJson(ex, this.getProperties().getPath(this.getJobKey()) + "/fehlerprotokoll_" + pureAdditionalFilename + ".json");
            }
        }
    }

    @Override
    protected String getSubPath() {
        return "/Risse";
    }

    @Override
    public long getMaxTotalWaitTimeMs() {
        return 1023000L;
    }

    @Override
    public long getFirstWaitTimeMs() {
        return 1000L;
    }

    @Override
    public double getWaitTimeMultiplicator() {
        return 2.0;
    }
}

