/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.custom.utils.StampedJasperReportServerAction;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungGruppeInfo;
import de.cismet.cids.server.actions.ServerActionHelper;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.log4j.Logger;

public class BaulastBescheinigungReportServerAction
extends StampedJasperReportServerAction
implements ConnectionContextStore,
UserAwareServerAction,
MetaServiceStore {
    private static final Logger LOG = Logger.getLogger(BaulastBescheinigungReportServerAction.class);
    private static final String PARAMETER_JOBNUMBER = "JOBNUMBER";
    private static final String PARAMETER_PROJECTNAME = "PROJECTNAME";
    private static final String PARAMETER_HAS_BELASTET = "HAS_BELASTET";
    private static final String PARAMETER_HAS_BEGUENSTIGT = "HAS_BEGUENSTIGT";
    private static final String PARAMETER_FABRICATIONNOTICE = "FABRICATIONNOTICE";
    private static final String PARAMETER_FABRICATIONDATE = "FABRICATIONDATE";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String TASK_NAME = "baulastBescheinigungReport";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    @Override
    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        try {
            BerechtigungspruefungBescheinigungGruppeInfo bescheinigungGruppeInfo = null;
            Date fabricationDate = null;
            String fertigungsVermerk = null;
            String jobNumber = null;
            String projectName = null;
            Object anfrageSchluessel = null;
            if (params != null) {
                for (ServerActionParameter sap : params) {
                    if (sap.getKey().equals(Parameter.BESCHEINIGUNGGRUPPE_INFO.toString())) {
                        bescheinigungGruppeInfo = (BerechtigungspruefungBescheinigungGruppeInfo)OBJECT_MAPPER.readValue((String)sap.getValue(), BerechtigungspruefungBescheinigungGruppeInfo.class);
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.FABRICATION_DATE.toString())) {
                        fabricationDate = new Date((Long)sap.getValue());
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.FERTIGUNGS_VERMERK.toString())) {
                        fertigungsVermerk = (String)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.JOB_NUMBER.toString())) {
                        jobNumber = (String)sap.getValue();
                        continue;
                    }
                    if (!sap.getKey().equals(Parameter.PROJECT_NAME.toString())) continue;
                    projectName = (String)sap.getValue();
                }
            }
            if (bescheinigungGruppeInfo != null) {
                List<BerechtigungspruefungBescheinigungGruppeInfo> reportBeans = Arrays.asList(bescheinigungGruppeInfo);
                JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(reportBeans);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put(PARAMETER_JOBNUMBER, jobNumber);
                parameters.put(PARAMETER_PROJECTNAME, projectName);
                parameters.put(PARAMETER_HAS_BELASTET, !bescheinigungGruppeInfo.getBaulastenBelastet().isEmpty());
                parameters.put(PARAMETER_FABRICATIONDATE, new SimpleDateFormat("dd.MM.yyyy").format(fabricationDate));
                parameters.put(PARAMETER_HAS_BEGUENSTIGT, !bescheinigungGruppeInfo.getBaulastenBeguenstigt().isEmpty());
                parameters.put(PARAMETER_FABRICATIONNOTICE, fertigungsVermerk);
                parameters.put("SUBREPORT_DIR", DomainServerImpl.getServerProperties().getServerResourcesBasePath() + "/");
                return ServerActionHelper.asyncByteArrayHelper((Object)this.generateReport(parameters, (JRDataSource)dataSource), (String)"BaulastReport.pdf");
            }
            return null;
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return ex;
        }
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    protected JasperReport getJasperReport() throws Exception {
        return ServerResourcesLoader.getInstance().loadJasperReport(WundaBlauServerResources.BAULASTBESCHEINIGUNG_JASPER.getValue());
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum Parameter {
        BESCHEINIGUNGGRUPPE_INFO,
        FABRICATION_DATE,
        FERTIGUNGS_VERMERK,
        JOB_NUMBER,
        PROJECT_NAME;

    }
}

