/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import de.cismet.cids.custom.utils.PotenzialflaechenProperties;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.DefaultServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.utils.serverresources.PropertiesServerResource;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.File;
import java.io.FilenameFilter;
import org.apache.log4j.Logger;

public class DeletePotenzialflaecheReportCacheServerAction
extends DefaultServerAction {
    private static final transient Logger LOG = Logger.getLogger(DeletePotenzialflaecheReportCacheServerAction.class);
    public static final String TASK_NAME = "deletePotenzialflaecheReportCache";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final PropertiesServerResource POTENZIALFLAECHEN_PROPERTIES = (PropertiesServerResource)WundaBlauServerResources.POTENZIALFLAECHEN_PROPERTIES.getValue();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        try {
            Integer[] flaecheIds = null;
            if (params != null) {
                for (ServerActionParameter sap : params) {
                    Object value = sap.getValue();
                    if (!sap.getKey().equals(Parameter.POTENZIALFLAECHE.toString())) continue;
                    flaecheIds = (Integer[])sap.getValue();
                }
            }
            if (flaecheIds != null) {
                PotenzialflaechenProperties props = (PotenzialflaechenProperties)ServerResourcesLoader.getInstance().get(this.POTENZIALFLAECHEN_PROPERTIES);
                String cacheDirectoryString = props.getPictureCacheDirectory();
                File cacheDirectory = new File(cacheDirectoryString);
                if (cacheDirectory.exists() && cacheDirectory.isDirectory()) {
                    for (final Integer tmpId : flaecheIds) {
                        FilenameFilter filter = new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.startsWith(tmpId + "_");
                            }
                        };
                        for (File tmp : cacheDirectory.listFiles(filter)) {
                            if (!tmp.exists()) continue;
                            try {
                                tmp.delete();
                            }
                            catch (Exception e) {
                                LOG.error((Object)("Cannot delete file " + tmp.getAbsolutePath()), (Throwable)e);
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while creating report", (Throwable)ex);
            return false;
        }
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum Parameter {
        POTENZIALFLAECHE;

    }
}

