/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.wunda_blau.search.actions.orbit.OrbitStacTools;
import de.cismet.cids.custom.wunda_blau.search.actions.orbit.StacEntry;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import org.apache.log4j.Logger;

public class GetOrbitAuthAction
implements ServerAction {
    private static final Logger LOG = Logger.getLogger(GetOrbitAuthAction.class);
    public static final String TASK_NAME = "getOrbitAuth";

    public Object execute(Object body, ServerActionParameter ... saps) {
        String stac = null;
        String stacOptions = null;
        String ipAddress = null;
        for (ServerActionParameter sap : saps) {
            if (sap.getKey().equals(PARAMETER_TYPE.STAC.toString())) {
                stac = (String)sap.getValue();
                continue;
            }
            if (sap.getKey().equals(PARAMETER_TYPE.STAC_OPTIONS.toString())) {
                stacOptions = (String)sap.getValue();
                continue;
            }
            if (!sap.getKey().equals(PARAMETER_TYPE.IP.toString())) continue;
            ipAddress = (String)sap.getValue();
        }
        StacEntry stacEntry = OrbitStacTools.getInstance().getEntry(stac);
        if (stacEntry != null) {
            long ts = System.currentTimeMillis();
            long offset = 0L;
            offset = stacEntry.getIpAddress() != null && stacEntry.getIpAddress().equals(ipAddress) ? 86400000L : 36000000L;
            if (stacEntry.getTimestamp() + offset > ts) {
                try {
                    String ret = ServerResourcesLoader.getInstance().loadText(WundaBlauServerResources.ORBIT_AUTH_JSON.getValue());
                    ret = ret.replaceAll("###socketChannelId###", stacEntry.getSocketChannelId());
                    return ret;
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error during GetOrbitAuthAction", (Throwable)ex);
                }
            } else {
                OrbitStacTools.getInstance().removeStac(stac);
            }
        }
        return "";
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public static enum PARAMETER_TYPE {
        STAC,
        STAC_OPTIONS,
        IP;

    }
}

