/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.newuser.User;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.GeometryCollection;
import de.cismet.cids.custom.utils.alkis.ServerAlkisProducts;
import de.cismet.cids.custom.utils.nas.NasProduct;
import de.cismet.cids.custom.wunda_blau.search.actions.NasGetObjekteServerAction;
import de.cismet.cids.server.actions.ServerActionHelper;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UploadableInputStream;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.commons.security.AccessHandler;
import de.cismet.commons.security.handler.SimpleHttpAccessHandler;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class NasCsvDataQueryAction
implements UserAwareServerAction {
    private static final transient Logger LOG = Logger.getLogger(NasCsvDataQueryAction.class);
    public static final String TASKNAME = "nasCsvDataQuery";
    private User user;

    public Object execute(Object body, ServerActionParameter ... params) {
        NasProduct nasProduct = null;
        GeometryCollection geoms = null;
        METHOD_TYPE method = null;
        String auftrag = "";
        for (ServerActionParameter sap : params) {
            if (sap.getKey().equals(PARAMETER_TYPE.TEMPLATE.toString())) {
                nasProduct = (NasProduct)sap.getValue();
                continue;
            }
            if (sap.getKey().equals(PARAMETER_TYPE.GEOMETRY_COLLECTION.toString())) {
                geoms = (GeometryCollection)sap.getValue();
                continue;
            }
            if (sap.getKey().equals(PARAMETER_TYPE.AUFTRAGSNUMMER.toString())) {
                auftrag = (String)sap.getValue();
                continue;
            }
            if (!sap.getKey().equals(PARAMETER_TYPE.METHOD.toString())) continue;
            method = (METHOD_TYPE)((Object)sap.getValue());
        }
        if (method == METHOD_TYPE.CREATE && nasProduct != null) {
            try {
                NasGetObjekteServerAction action = new NasGetObjekteServerAction();
                ServerActionParameter[] parameter = new ServerActionParameter[]{new ServerActionParameter(NasGetObjekteServerAction.Parameter.SEARCH_TYPE.name(), (Object)NasGetObjekteServerAction.NasSearchType.FLURSTUECKE), new ServerActionParameter(NasGetObjekteServerAction.Parameter.GEOMETRY.name(), (Object)geoms)};
                Object landparcels = action.execute(null, parameter);
                if (landparcels instanceof String) {
                    URL url = new URL(nasProduct.getServer());
                    String para = nasProduct.getTemplateContent().replace("%landparcels%", (String)landparcels);
                    String auftragsnummer = this.getRequestId(this.user, auftrag);
                    para = para.replace("%auftrag%", auftragsnummer);
                    para = para + ServerAlkisProducts.getInstance().getIdentification();
                    HashMap<String, String> requestHeaders = new HashMap<String, String>();
                    requestHeaders.put("content-type", "application/x-www-form-urlencoded");
                    InputStream is = new SimpleHttpAccessHandler().doRequest(url, (Reader)new StringReader(para), "application/x-www-form-urlencoded", AccessHandler.ACCESS_METHODS.POST_REQUEST, requestHeaders, null);
                    ObjectMapper mapper = new ObjectMapper(new JsonFactory());
                    JsonNode node = mapper.readTree(is);
                    JsonNode id = node.get("id");
                    if (id != null) {
                        String orderId = id.asText();
                        URL getUrl = ServerAlkisProducts.getInstance().getCsvGetResultURL(nasProduct.getServer(), orderId);
                        InputStream resultIs = new SimpleHttpAccessHandler().doRequest(getUrl);
                        return ServerActionHelper.asyncByteArrayHelper((Object)new UploadableInputStream(resultIs), (String)orderId);
                    }
                    throw new Exception("no order id retrieved");
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error during NAS Request " + nasProduct.key), (Throwable)e);
            }
        }
        return null;
    }

    private String getRequestId(User user, String requestId) {
        return user.getName() + "_" + requestId;
    }

    public String getTaskName() {
        return TASKNAME;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public static enum PARAMETER_TYPE {
        TEMPLATE,
        GEOMETRY_COLLECTION,
        METHOD,
        AUFTRAGSNUMMER;

    }

    public static enum METHOD_TYPE {
        CREATE,
        GET;

    }
}

