/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.GeometryCollection;
import de.cismet.cids.custom.utils.nas.NASProductGenerator;
import de.cismet.cids.custom.utils.nas.NasProduct;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import org.apache.log4j.Logger;

public class NasDataQueryAction
implements UserAwareServerAction {
    private static final transient Logger LOG = Logger.getLogger(NasDataQueryAction.class);
    private User user;

    public Object execute(Object body, ServerActionParameter ... params) {
        NasProduct nasProduct = null;
        GeometryCollection geoms = null;
        METHOD_TYPE method = null;
        String orderId = null;
        String requestId = null;
        String profilKennung = null;
        for (ServerActionParameter sap : params) {
            if (sap.getKey().equals(PARAMETER_TYPE.TEMPLATE.toString())) {
                nasProduct = (NasProduct)sap.getValue();
                continue;
            }
            if (sap.getKey().equals(PARAMETER_TYPE.GEOMETRY_COLLECTION.toString())) {
                geoms = (GeometryCollection)sap.getValue();
                continue;
            }
            if (sap.getKey().equals(PARAMETER_TYPE.METHOD.toString())) {
                method = (METHOD_TYPE)((Object)sap.getValue());
                continue;
            }
            if (sap.getKey().equals(PARAMETER_TYPE.ORDER_ID.toString())) {
                orderId = (String)sap.getValue();
                continue;
            }
            if (sap.getKey().equals(PARAMETER_TYPE.REQUEST_ID.toString())) {
                requestId = (String)sap.getValue();
                continue;
            }
            if (!sap.getKey().equals(PARAMETER_TYPE.PROFIL_KENNUNG.toString())) continue;
            profilKennung = (String)sap.getValue();
        }
        if (method == METHOD_TYPE.ADD) {
            return NASProductGenerator.instance().executeAsynchQuery(nasProduct, geoms, this.user, requestId, profilKennung);
        }
        if (method == METHOD_TYPE.GET) {
            if (orderId == null) {
                LOG.error((Object)"missing order id for get request");
                return null;
            }
            return NASProductGenerator.instance().getResultForOrder(orderId, this.user);
        }
        if (method == METHOD_TYPE.GET_ALL) {
            return NASProductGenerator.instance().getUndeliveredOrders(this.user);
        }
        if (method == METHOD_TYPE.CANCEL) {
            NASProductGenerator.instance().cancelOrder(orderId, this.user);
        }
        return null;
    }

    public String getTaskName() {
        return "nasDataQuery";
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public static enum PARAMETER_TYPE {
        TEMPLATE,
        GEOMETRY_COLLECTION,
        METHOD,
        ORDER_ID,
        REQUEST_ID,
        PROFIL_KENNUNG;

    }

    public static enum METHOD_TYPE {
        ADD,
        GET,
        GET_ALL,
        CANCEL;

    }
}

