/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.wunda_blau.search.server.CidsMauernSearchStatement;
import de.cismet.cids.custom.wunda_blau.search.server.SearchProperties;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openide.util.Exceptions;

public class NasZaehlObjekteServerAction
implements ServerAction,
MetaServiceStore,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(CidsMauernSearchStatement.class);
    public static final String TASK_NAME = "nasZaehlObjekte";
    private static final String INTERSECTS_BUFFER = SearchProperties.getInstance().getIntersectsBuffer();
    private static final String FLURSTUECK_STMT = "select count(*) as Anzahl from ax_flurstueck where st_intersects(wkb_geometry,<geom>)";
    private static final String GEAEUDE_STMT = "select count(*) as Anzahl from ax_gebaeude where st_intersects(wkb_geometry,<geom>)";
    private static final String DACH_PKT_STMT = "SELECT count (*) FROM sic_regen_dachpg where st_intersects(wkb_geometry,<geom>)";
    private static final String BODEN_PKT_STMT = "SELECT count (*) FROM sic_regen_bodenpg where st_intersects(wkb_geometry,<geom>)";
    private static final String ADRESE_STMT = "SELECT DISTINCT i.class_id , i.object_id, s.stringrep FROM geom g, cs_attr_object_derived i LEFT OUTER JOIN cs_cache s ON ( s.class_id =i.class_id AND s.object_id=i.object_id ) WHERE i.attr_class_id = ( SELECT cs_class.id FROM cs_class WHERE cs_class.table_name::text ILIKE 'GEOM'::text ) AND i.attr_object_id = g.id AND i.class_id IN ((select id from cs_Class where table_name ilike 'adresse')) AND geo_field && st_GeometryFromText('<geom>') AND st_intersects(st_buffer(geo_field, " + INTERSECTS_BUFFER + "),st_buffer(st_GeometryFromText('<geom>'), " + INTERSECTS_BUFFER + ")) ORDER BY 1,2,3";
    private Connection fmeConn = null;
    private final String url;
    private final String user;
    private final String pw;
    private final boolean initError;
    private MetaService metaService;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public NasZaehlObjekteServerAction() {
        boolean initError = false;
        String url = null;
        String user = null;
        String pw = null;
        try {
            if (DomainServerImpl.getServerProperties() != null && "WUNDA_BLAU".equals(DomainServerImpl.getServerProperties().getServerName())) {
                Properties serviceProperties = new Properties();
                serviceProperties.load(ServerResourcesLoader.getInstance().loadStringReader(WundaBlauServerResources.FME_DB_CONN_PROPERTIES.getValue()));
                url = serviceProperties.getProperty("connection_url");
                user = serviceProperties.getProperty("connection_username");
                pw = serviceProperties.getProperty("connection_pw");
                this.initConnection();
            } else {
                initError = true;
            }
        }
        catch (SearchException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"error during initialisation of fme db connection.", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            initError = true;
            LOG.warn((Object)"error during initialisation of fme db connection. Could not read properties file. Search disabled", (Throwable)ex);
        }
        this.initError = initError;
        this.url = url;
        this.user = user;
        this.pw = pw;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        Geometry geometry = null;
        Enum searchType = null;
        if (params != null) {
            for (ServerActionParameter sap : params) {
                if (sap.getKey().equals(Parameter.SEARCH_TYPE.toString())) {
                    searchType = (NasSearchType)((Object)sap.getValue());
                    continue;
                }
                if (!sap.getKey().equals(Parameter.GEOMETRY.toString())) continue;
                geometry = (Geometry)sap.getValue();
            }
        }
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        if (this.initError) {
            LOG.warn((Object)"NasZaehlObjekteSearch initialisation error. An error during reading fme_db_con properties occured.");
            return resultList;
        }
        try {
            if (null != searchType) {
                switch (1.$SwitchMap$de$cismet$cids$custom$wunda_blau$search$actions$NasZaehlObjekteServerAction$NasSearchType[searchType.ordinal()]) {
                    case 1: {
                        resultList.add(this.getFlurstueckObjectsCount(geometry));
                        break;
                    }
                    case 2: {
                        resultList.add(this.getGebaeudeObjectsCount(geometry));
                        break;
                    }
                    case 3: {
                        resultList.add(this.getAddressenCount(geometry));
                        break;
                    }
                    case 4: {
                        resultList.add(this.getBodenpunkteObjectsCount(geometry));
                        break;
                    }
                    case 5: {
                        resultList.add(this.getDachpunkteObjectsCount(geometry));
                        break;
                    }
                }
            }
            return resultList;
        }
        catch (SearchException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    private int getFlurstueckObjectsCount(Geometry geometry) throws SearchException {
        return this.getObjectsCount(FLURSTUECK_STMT, geometry);
    }

    private int getGebaeudeObjectsCount(Geometry geometry) throws SearchException {
        return this.getObjectsCount(GEAEUDE_STMT, geometry);
    }

    private int getBodenpunkteObjectsCount(Geometry geometry) throws SearchException {
        return this.getObjectsCount(BODEN_PKT_STMT, geometry);
    }

    private int getDachpunkteObjectsCount(Geometry geometry) throws SearchException {
        return this.getObjectsCount(DACH_PKT_STMT, geometry);
    }

    private synchronized int getObjectsCount(String statement, Geometry geometry) throws SearchException {
        Statement st = null;
        try {
            if (this.fmeConn == null || this.fmeConn.isClosed()) {
                this.initConnection();
            }
            st = this.fmeConn.createStatement();
            StringBuilder sb = new StringBuilder();
            String geostring = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)geometry);
            if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
                sb.append(statement.replace("<geom>", "st_buffer(st_GeometryFromText('" + geostring + "'), 0.000001)"));
            }
            if (st != null && !this.fmeConn.isClosed() && !st.isClosed()) {
                st.execute(sb.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("query: " + sb.toString()));
                }
                ResultSet rs = st.getResultSet();
                rs.next();
                int n = rs.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException ex) {
            LOG.error((Object)"Error during NasZaehlobjekteSearch", (Throwable)ex);
            throw new SearchException("Error during NasZaehlobjekteSearch");
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private int getAddressenCount(Geometry geometry) throws SearchException {
        MetaService ms = this.getMetaService();
        if (ms != null) {
            try {
                StringBuilder sb = new StringBuilder();
                String geostring = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)geometry);
                if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
                    sb.append(ADRESE_STMT.replace("<geom>", geostring));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("query: " + sb.toString()));
                }
                ArrayList lists = ms.performCustomSearch(sb.toString(), this.getConnectionContext());
                return lists.size();
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return 0;
    }

    private void initConnection() throws SearchException {
        try {
            this.fmeConn = DriverManager.getConnection(this.url, this.user, this.pw);
        }
        catch (SQLException ex) {
            throw new SearchException("Error during NasZaehlObjekte search.Could not create db connection to fme_import database", (Throwable)ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum NasSearchType {
        FLURSTUECKE,
        GEBAEUDE,
        ADRESSE,
        DACHPUNKTE,
        BODENPUNKTE;

    }

    public static enum Parameter {
        GEOMETRY,
        SEARCH_TYPE;

    }
}

