/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import io.socket.client.IO;
import io.socket.client.Socket;
import java.util.Properties;

class SocketIOSocketProvider {
    Socket socket;

    private SocketIOSocketProvider() throws Exception {
        IO.Options opts = new IO.Options();
        opts.transports = new String[]{"websocket"};
        Properties settings = ServerResourcesLoader.getInstance().loadProperties(WundaBlauServerResources.ORBIT_SETTINGS_PROPERTIES.getValue());
        String SOCKET_BROADCASTER = settings.getProperty("socketBroadcaster");
        this.socket = IO.socket((String)SOCKET_BROADCASTER).connect();
    }

    public static SocketIOSocketProvider getInstance() {
        return LazyInitializer.INSTANCE;
    }

    public Socket getSocket() {
        return this.socket;
    }

    private static final class LazyInitializer {
        private static final SocketIOSocketProvider INSTANCE;

        private LazyInitializer() {
        }

        static {
            try {
                INSTANCE = new SocketIOSocketProvider();
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception while initializing ServerStamperUtils", ex);
            }
        }
    }
}

