/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.newuser.User;
import Sirius.server.sql.DBConnection;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.log4j.Logger;

public class WohnlagenKategorisierungServerAction
implements ServerAction,
UserAwareServerAction,
MetaServiceStore {
    private static final transient Logger LOG = Logger.getLogger(WohnlagenKategorisierungServerAction.class);
    public static final String TASK_NAME = "wohnlagenKategorisierung";
    private User user;
    private MetaService metaService;

    public String getTaskName() {
        return TASK_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Object body, ServerActionParameter ... params) {
        block16: {
            try {
                PreparedStatement insert;
                Connection connection;
                block17: {
                    Collection wohnlageNodes = null;
                    MetaObjectNode kategorieNode = null;
                    String bemerkung = null;
                    if (params != null) {
                        for (ServerActionParameter sap : params) {
                            if (sap.getKey().equals(ParameterType.WOHNLAGEN.toString())) {
                                wohnlageNodes = (Collection)sap.getValue();
                                continue;
                            }
                            if (sap.getKey().equals(ParameterType.KATEGORIE.toString())) {
                                kategorieNode = (MetaObjectNode)sap.getValue();
                                continue;
                            }
                            if (!sap.getKey().equals(ParameterType.BEMERKUNG.toString())) continue;
                            bemerkung = (String)sap.getValue();
                        }
                    }
                    if (wohnlageNodes == null) break block16;
                    String DELETE_QUERY = "DELETE FROM wohnlage_kategorisierung WHERE fk_wohnlage = ? AND login_name = ?";
                    String INSERT_QUERY_WITH_KATEGORIE = "INSERT INTO wohnlage_kategorisierung (fk_wohnlage, login_name, bemerkung, fk_kategorie) VALUES (?, ?, ?, ?)";
                    String INSERT_QUERY_WITHOUT_KATEGORIE = "INSERT INTO wohnlage_kategorisierung (fk_wohnlage, login_name, bemerkung) VALUES (?, ?, ?)";
                    connection = DomainServerImpl.getServerInstance().getConnectionPool().getConnection();
                    PreparedStatement delete = connection.prepareStatement("DELETE FROM wohnlage_kategorisierung WHERE fk_wohnlage = ? AND login_name = ?");
                    insert = kategorieNode == null ? connection.prepareStatement("INSERT INTO wohnlage_kategorisierung (fk_wohnlage, login_name, bemerkung) VALUES (?, ?, ?)") : connection.prepareStatement("INSERT INTO wohnlage_kategorisierung (fk_wohnlage, login_name, bemerkung, fk_kategorie) VALUES (?, ?, ?, ?)");
                    try {
                        connection.setAutoCommit(false);
                        for (MetaObjectNode wohnlageNode : wohnlageNodes) {
                            delete.setInt(1, wohnlageNode.getObjectId());
                            delete.setString(2, this.getUser().getName());
                            delete.executeUpdate();
                            insert.setInt(1, wohnlageNode.getObjectId());
                            insert.setString(2, this.getUser().getName());
                            insert.setString(3, bemerkung);
                            if (kategorieNode != null) {
                                insert.setInt(4, kategorieNode.getObjectId());
                            }
                            insert.executeUpdate();
                        }
                        connection.commit();
                        if (delete == null) break block17;
                    }
                    catch (SQLException ex) {
                        block18: {
                            try {
                                LOG.error((Object)"Error while updating wohnlage_kategorisierung. rolling back", (Throwable)ex);
                                connection.rollback();
                                if (delete == null) break block18;
                            }
                            catch (Throwable throwable) {
                                if (delete != null) {
                                    delete.close();
                                }
                                if (insert != null) {
                                    insert.close();
                                }
                                DBConnection.closeConnections((Connection[])new Connection[]{connection});
                                throw throwable;
                            }
                            delete.close();
                        }
                        if (insert != null) {
                            insert.close();
                        }
                        DBConnection.closeConnections((Connection[])new Connection[]{connection});
                        break block16;
                    }
                    delete.close();
                }
                if (insert != null) {
                    insert.close();
                }
                DBConnection.closeConnections((Connection[])new Connection[]{connection});
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                return ex;
            }
        }
        return null;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public static enum ParameterType {
        WOHNLAGEN,
        KATEGORIE,
        BEMERKUNG;

    }
}

