/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wunda_blau.search.server.RestApiMonGeometrySearch;
import de.cismet.cids.custom.wunda_blau.search.server.RestApiMonSearch;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;

public class AlkisLandparcelGeometryMonSearch
extends RestApiMonGeometrySearch {
    private static final transient Logger LOG = Logger.getLogger(AlkisLandparcelGeometryMonSearch.class);

    public AlkisLandparcelGeometryMonSearch() {
        this(null, null);
    }

    public AlkisLandparcelGeometryMonSearch(Geometry geometry) {
        this(geometry, null);
    }

    public AlkisLandparcelGeometryMonSearch(Double buffer) {
        this(null, buffer);
    }

    public AlkisLandparcelGeometryMonSearch(Geometry geometry, Double buffer) {
        this.setGeometry(geometry);
        this.setBuffer(buffer);
        this.setSearchInfo(new SearchInfo(this.getClass().getName(), this.getClass().getSimpleName(), "Builtin Legacy Search to delegate the operation AlkisLandparcel to the cids Pure REST Search API.", Arrays.asList(new SearchParameterInfo[]{new RestApiMonSearch.MySearchParameterInfo("searchFor", Type.STRING), new RestApiMonSearch.MySearchParameterInfo("geom", Type.UNDEFINED)}), (SearchParameterInfo)new RestApiMonSearch.MySearchParameterInfo("return", Type.ENTITY_REFERENCE, true)));
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            Geometry geometry = this.getGeometry();
            String geomCondition = this.getGeomCondition();
            String area = geometry != null ? String.format("st_area(st_intersection(alkis_landparcel.geometrie, st_GeomFromEWKT('%1$s')))", PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)geometry)) : "st_area(alkis_landparcel.geometrie)";
            String query = "SELECT     (SELECT id FROM cs_class WHERE table_name ILIKE 'alkis_landparcel') AS class_id,   object_id,   min(object_name),   sum(area) FROM (   SELECT     " + area + " AS area,     alkis_landparcel.id AS object_id,     alkis_landparcel.alkis_id AS object_name   FROM alkis_landparcel   " + (geomCondition != null ? "WHERE " + geomCondition : " ") + ") AS sub GROUP BY object_id ORDER BY sum(area) DESC;";
            if (query != null) {
                MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
                ArrayList resultList = ms.performCustomSearch(query, this.getConnectionContext());
                for (ArrayList al : resultList) {
                    int cid = (Integer)al.get(0);
                    int oid = (Integer)al.get(1);
                    String name = (String)al.get(2);
                    MetaObjectNode mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, name, null, null);
                    result.add(mon);
                }
            }
            return result;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while searching for AlkisLandparcel object", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected String getGeomCondition() {
        Geometry geometry = this.getGeometry();
        if (geometry != null) {
            String geomStringFromText = String.format("st_GeomFromEWKT('%s')", PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)geometry));
            return String.format("(alkis_landparcel.geometrie && %s AND st_intersects(%s, alkis_landparcel.geometrie))", geomStringFromText, this.getBuffer() != null ? String.format("st_buffer(%s, %f)", geomStringFromText, this.getBuffer()) : geomStringFromText);
        }
        return null;
    }
}

