/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class BerechtigungspruefungOffeneAnfragenStatement
extends AbstractCidsServerSearch
implements ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(BerechtigungspruefungOffeneAnfragenStatement.class);
    private static final String QUERY_TEMPLATE = "SELECT schluessel FROM berechtigungspruefung WHERE pruefstatus IS NULL AND produkttyp IN (%s) ORDER BY anfrage_timestamp DESC";
    private static final String QUERY_PRUEFER_TEMPLATE = "SELECT schluessel FROM berechtigungspruefung WHERE pruefstatus AND produkttyp IN (%s)' AND (pruefer IS NULL OR pruefer like '%s') IS NULL ORDER BY anfrage_timestamp DESC";
    private final boolean checkPruefer;
    private final Collection<String> produkttypList;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public BerechtigungspruefungOffeneAnfragenStatement(Collection<String> produkttypList) {
        this(false, produkttypList);
    }

    public BerechtigungspruefungOffeneAnfragenStatement(boolean checkPruefer, Collection<String> produkttypList) {
        this.checkPruefer = checkPruefer;
        this.produkttypList = produkttypList;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (ms != null) {
            try {
                StringBuffer sb = new StringBuffer();
                for (String produkttyp : this.produkttypList) {
                    if (sb.length() != 0) {
                        sb.append(", ");
                    }
                    sb.append("'").append(produkttyp).append("'");
                }
                String in = sb.toString();
                String query = this.checkPruefer ? String.format(QUERY_PRUEFER_TEMPLATE, in, this.getUser().getName()) : String.format(QUERY_TEMPLATE, in);
                ArrayList lists = ms.performCustomSearch(query, this.getConnectionContext());
                ArrayList<String> schluesselListe = new ArrayList<String>();
                if (lists != null && !lists.isEmpty()) {
                    for (List list : lists) {
                        schluesselListe.add((String)list.iterator().next());
                    }
                }
                return schluesselListe;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        return null;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

