/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.custom.wunda_blau.search.server.BillingStatisticsReportServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BillingJahresberichtReportServerSearch
extends BillingStatisticsReportServerSearch {
    private static final Logger LOG = Logger.getLogger(BillingJahresberichtReportServerSearch.class);
    private static final String PRODUCTS_LK = "lk";
    private static final String PRODUCTS_BL = "bl";
    private static final String PRODUCTS_KO = "ko";
    public static final String KUNDEN_ABRECHNUNG_WIEDERVERKAEUFER = "kundenAbrechnungWiederverkaeuferJahrlich";
    public static final String ANZAHL_KUNDEN = "anzahlKundenPerGruppe";
    public static final String VERWENDUNGSZWECK_GESCHAEFTSBUCHNUMMERN_KOSTENPFLICHTIG = "anzahlGeschaeftsbuchnummernKostenpflichtig";
    public static final String VERWENDUNGSZWECK_GESCHAEFTSBUCHNUMMERN_KOSTENPFLICHTIG_LK = "anzahlGeschaeftsbuchnummernKostenpflichtigLk";
    public static final String VERWENDUNGSZWECK_GESCHAEFTSBUCHNUMMERN_KOSTENPFLICHTIG_BL = "anzahlGeschaeftsbuchnummernKostenpflichtigBl";
    public static final String VERWENDUNGSZWECK_GESCHAEFTSBUCHNUMMERN_KOSTENPFLICHTIG_KO = "anzahlGeschaeftsbuchnummernKostenpflichtigKo";
    public static final String VERWENDUNGSZWECK_GESCHAEFTSBUCHNUMMERN_KOSTENFREI = "anzahlGeschaeftsbuchnummernKostenfrei";
    public static final String VERWENDUNGSZWECK_GESCHAEFTSBUCHNUMMERN_KOSTENFREI_LK = "anzahlGeschaeftsbuchnummernKostenfreiLk";
    public static final String VERWENDUNGSZWECK_GESCHAEFTSBUCHNUMMERN_KOSTENFREI_BL = "anzahlGeschaeftsbuchnummernKostenfreiBl";
    public static final String VERWENDUNGSZWECK_GESCHAEFTSBUCHNUMMERN_KOSTENFREI_KO = "anzahlGeschaeftsbuchnummernKostenfreiKo";
    public static final String VERWENDUNGSZWECK_DOWNLOADS_KOSTENPFLICHTIG = "anzahlDownloadsKostenpflichtig";
    public static final String VERWENDUNGSZWECK_DOWNLOADS_KOSTENPFLICHTIG_LK = "anzahlDownloadsKostenpflichtigLk";
    public static final String VERWENDUNGSZWECK_DOWNLOADS_KOSTENPFLICHTIG_BL = "anzahlDownloadsKostenpflichtigBl";
    public static final String VERWENDUNGSZWECK_DOWNLOADS_KOSTENPFLICHTIG_KO = "anzahlDownloadsKostenpflichtigKo";
    public static final String VERWENDUNGSZWECK_DOWNLOADS_KOSTENFREI = "anzahlDownloadsGeschaeftsbuchnummerKostenfrei";
    public static final String VERWENDUNGSZWECK_DOWNLOADS_KOSTENFREI_LK = "anzahlDownloadsGeschaeftsbuchnummerKostenfreiLk";
    public static final String VERWENDUNGSZWECK_DOWNLOADS_KOSTENFREI_BL = "anzahlDownloadsGeschaeftsbuchnummerKostenfreiBl";
    public static final String VERWENDUNGSZWECK_DOWNLOADS_KOSTENFREI_KO = "anzahlDownloadsGeschaeftsbuchnummerKostenfreiKo";
    public static final String VERWENDUNGSZWECK_ANZAHL = "anzahlVerwendungszwecke";
    public static final String VERWENDUNGSZWECK_ANZAHL_LK = "anzahlVerwendungszweckeLk";
    public static final String VERWENDUNGSZWECK_ANZAHL_KO = "anzahlVerwendungszweckeBl";
    public static final String VERWENDUNGSZWECK_ANZAHL_BL = "anzahlVerwendungszweckeKo";
    public static final String VERWENDUNGSZWECK_SUMME_EINNAHMEN = "anzahlVerwendungszweckeSummeEinnahmen";
    public static final String VERWENDUNGSZWECK_SUMME_EINNAHMEN_LK = "anzahlVerwendungszweckeSummeEinnahmenLk";
    public static final String VERWENDUNGSZWECK_SUMME_EINNAHMEN_BL = "anzahlVerwendungszweckeSummeEinnahmenBl";
    public static final String VERWENDUNGSZWECK_SUMME_EINNAHMEN_KO = "anzahlVerwendungszweckeSummeEinnahmenKo";
    public static final String ANZAHL_VERMESSUNGSUNTERLAGEN_TS3 = "anzahlProdukteVermessungsunterlagenTs3";
    public static final String ANZAHL_VERMESSUNGSUNTERLAGEN_TS4 = "anzahlProdukteVermessungsunterlagenTs4";
    private static final SimpleDateFormat POSTGRES_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String QUERY_KUNDEN_ABRECHNUNG_WIEDERVERKAUEFER = "select kunde.name  from billing_kunde as kunde join billing_kunde_kundengruppe_array as verbindung on kunde.id = verbindung.kunde join billing_kundengruppe as gruppe on verbindung.billing_kundengruppe_reference = gruppe.kunden_arr where gruppe.name ='Abrechnung_Wiederverkaeufer_j\u00e4hrlich'  and (vertragsende is null or date_trunc('day',vertragsende) >= '${from}' and date_trunc('day',vertragsende) <= '${till}') order by kunde.name;";
    private static final String QUERY_ANZAHL_KUNDEN_PER_GRUPPE = "select gruppe.name, count(kunde.name)from billing_kunde as kunde join billing_kunde_kundengruppe_array as verbindung on kunde.id = verbindung.kunde join billing_kundengruppe as gruppe on verbindung.billing_kundengruppe_reference = gruppe.kunden_arr where (vertragsende is null or vertragsende >= '${till}') group by gruppe.name order by gruppe.name asc;";
    private static final String QUERY_ANZAHL_GESCHAEFTSBUCHNUMMER_KOSTENPLICHTIG = "select sub.verwendungskey, count(*) from (select distinct geschaeftsbuchnummer,username,verwendungskey from billing_billing LEFT JOIN billing_jahresbericht_products ON billing_billing.produktkey = billing_jahresbericht_products.key where ${productKeys} and date_trunc('day',abrechnungsdatum) >= '${from}' and date_trunc('day',abrechnungsdatum) <= '${till}' and storniert is null and username not like 'NICHT-ZAEHLEN%' and not (netto_summe =0 or netto_summe is null)) as sub group by sub.verwendungskey;";
    private static final String QUERY_ANZAHL_GESCHAEFTSBUCHNUMMER_KOSTENFREI = "select sub.verwendungskey, count(*) from (select distinct geschaeftsbuchnummer,username,verwendungskey from billing_billing LEFT JOIN billing_jahresbericht_products ON billing_billing.produktkey = billing_jahresbericht_products.key where ${productKeys} and date_trunc('day',ts) >= '${from}' and date_trunc('day',ts) <= '${till}' and storniert is null and username not like 'NICHT-ZAEHLEN%' and (netto_summe =0 or netto_summe is null)) as sub group by sub.verwendungskey;";
    private static final String QUERY_ANZAHL_DOWNLOADS_KOSTENPFLICHTIG = "select verwendungskey, count(*) from billing_billing LEFT JOIN billing_jahresbericht_products ON billing_billing.produktkey = billing_jahresbericht_products.key where ${productKeys} and date_trunc('day',abrechnungsdatum) >= '${from}' and date_trunc('day',abrechnungsdatum) <= '${till}' and storniert is null and username not like 'NICHT-ZAEHLEN%' and not (netto_summe =0 or netto_summe is null) group by verwendungskey;";
    private static final String QUERY_ANZAHL_DOWNLOADS_KOSTENFREI = "select verwendungskey, count(*) from billing_billing LEFT JOIN billing_jahresbericht_products ON billing_billing.produktkey = billing_jahresbericht_products.key where ${productKeys} and date_trunc('day',abrechnungsdatum) >= '${from}' and date_trunc('day',abrechnungsdatum) <= '${till}' and storniert is null and username not like 'NICHT-ZAEHLEN%' and (netto_summe =0 or netto_summe is null) group by verwendungskey;";
    private static final String QUERY_SUMME_PRO_VERWENDUNGSZWECK = "select verwendungskey, sum(netto_summe) from billing_billing LEFT JOIN billing_jahresbericht_products ON billing_billing.produktkey = billing_jahresbericht_products.key where ${productKeys} and date_trunc('day',abrechnungsdatum) >= '${from}' and date_trunc('day',abrechnungsdatum) <= '${till}' and storniert is null and username not like 'NICHT-ZAEHLEN%' and not (netto_summe =0 or netto_summe is null) group by verwendungskey;";
    private static final String QUERY_ANZAHL_PRODUKTE_VERMESSUNGSUNTERLAGEN_TS3 = "select produktbezeichnung,count(id) from ( select         produktbezeichnung, id from billing_billing where         verwendungszweck = 'Vermessungsunterlagen (amtlicher Lageplan TS 3)'         and date_trunc('day',ts) >= '${from}' and date_trunc('day',ts) <= '${till}'         and storniert is null         and username not like 'NICHT-ZAEHLEN%' group by produktbezeichnung, id order by produktbezeichnung) as temptable group by produktbezeichnung;";
    private static final String QUERY_ANZAHL_PRODUKTE_VERMESSUNGSUNTERLAGEN_TS4 = "select produktbezeichnung,count(id) from ( select         produktbezeichnung, id from billing_billing where         verwendungszweck = 'Vermessungsunterlagen (hoheitliche Vermessung TS 4)'         and date_trunc('day',ts) >= '${from}' and date_trunc('day',ts) <= '${till}'         and storniert is null         and username not like 'NICHT-ZAEHLEN%' group by produktbezeichnung, id order by produktbezeichnung) as temptable group by produktbezeichnung;";
    private final Date from;
    private final Date till;

    public BillingJahresberichtReportServerSearch(String billingBeanIds, Date from, Date till) {
        super(billingBeanIds);
        this.from = from;
        this.till = till;
    }

    @Override
    public Collection performServerSearch() throws SearchException {
        MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (ms != null) {
            try {
                HashMap<String, ArrayList> results = new HashMap<String, ArrayList>();
                this.excuteQueryAndConvertAmountResults(ms, results, QUERY_KUNDEN_ABRECHNUNG_WIEDERVERKAUEFER, KUNDEN_ABRECHNUNG_WIEDERVERKAEUFER);
                this.excuteQueryAndConvertAmountResults(ms, results, QUERY_ANZAHL_KUNDEN_PER_GRUPPE, ANZAHL_KUNDEN);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_ANZAHL_GESCHAEFTSBUCHNUMMER_KOSTENPLICHTIG, null, VERWENDUNGSZWECK_GESCHAEFTSBUCHNUMMERN_KOSTENPFLICHTIG);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_ANZAHL_GESCHAEFTSBUCHNUMMER_KOSTENPLICHTIG, PRODUCTS_LK, VERWENDUNGSZWECK_GESCHAEFTSBUCHNUMMERN_KOSTENPFLICHTIG_LK);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_ANZAHL_GESCHAEFTSBUCHNUMMER_KOSTENPLICHTIG, PRODUCTS_BL, VERWENDUNGSZWECK_GESCHAEFTSBUCHNUMMERN_KOSTENPFLICHTIG_BL);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_ANZAHL_GESCHAEFTSBUCHNUMMER_KOSTENPLICHTIG, PRODUCTS_KO, VERWENDUNGSZWECK_GESCHAEFTSBUCHNUMMERN_KOSTENPFLICHTIG_KO);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_ANZAHL_GESCHAEFTSBUCHNUMMER_KOSTENFREI, null, VERWENDUNGSZWECK_GESCHAEFTSBUCHNUMMERN_KOSTENFREI);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_ANZAHL_GESCHAEFTSBUCHNUMMER_KOSTENFREI, PRODUCTS_LK, VERWENDUNGSZWECK_GESCHAEFTSBUCHNUMMERN_KOSTENFREI_LK);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_ANZAHL_GESCHAEFTSBUCHNUMMER_KOSTENFREI, PRODUCTS_BL, VERWENDUNGSZWECK_GESCHAEFTSBUCHNUMMERN_KOSTENFREI_BL);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_ANZAHL_GESCHAEFTSBUCHNUMMER_KOSTENFREI, PRODUCTS_KO, VERWENDUNGSZWECK_GESCHAEFTSBUCHNUMMERN_KOSTENFREI_KO);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_ANZAHL_DOWNLOADS_KOSTENPFLICHTIG, null, VERWENDUNGSZWECK_DOWNLOADS_KOSTENPFLICHTIG);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_ANZAHL_DOWNLOADS_KOSTENPFLICHTIG, PRODUCTS_LK, VERWENDUNGSZWECK_DOWNLOADS_KOSTENPFLICHTIG_LK);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_ANZAHL_DOWNLOADS_KOSTENFREI, PRODUCTS_LK, VERWENDUNGSZWECK_DOWNLOADS_KOSTENFREI_LK);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_ANZAHL_DOWNLOADS_KOSTENPFLICHTIG, PRODUCTS_BL, VERWENDUNGSZWECK_DOWNLOADS_KOSTENPFLICHTIG_BL);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_ANZAHL_DOWNLOADS_KOSTENFREI, null, VERWENDUNGSZWECK_DOWNLOADS_KOSTENFREI);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_ANZAHL_DOWNLOADS_KOSTENFREI, PRODUCTS_BL, VERWENDUNGSZWECK_DOWNLOADS_KOSTENFREI_BL);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_ANZAHL_DOWNLOADS_KOSTENPFLICHTIG, PRODUCTS_KO, VERWENDUNGSZWECK_DOWNLOADS_KOSTENPFLICHTIG_KO);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_ANZAHL_DOWNLOADS_KOSTENFREI, PRODUCTS_KO, VERWENDUNGSZWECK_DOWNLOADS_KOSTENFREI_KO);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_SUMME_PRO_VERWENDUNGSZWECK, null, VERWENDUNGSZWECK_SUMME_EINNAHMEN);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_SUMME_PRO_VERWENDUNGSZWECK, PRODUCTS_LK, VERWENDUNGSZWECK_SUMME_EINNAHMEN_LK);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_SUMME_PRO_VERWENDUNGSZWECK, PRODUCTS_BL, VERWENDUNGSZWECK_SUMME_EINNAHMEN_BL);
                this.excuteQueryAndConvertAmountPerVerwendungszweckResults(ms, results, QUERY_SUMME_PRO_VERWENDUNGSZWECK, PRODUCTS_KO, VERWENDUNGSZWECK_SUMME_EINNAHMEN_KO);
                this.excuteQueryAndConvertAmountResults(ms, results, QUERY_ANZAHL_PRODUKTE_VERMESSUNGSUNTERLAGEN_TS3, ANZAHL_VERMESSUNGSUNTERLAGEN_TS3);
                this.excuteQueryAndConvertAmountResults(ms, results, QUERY_ANZAHL_PRODUKTE_VERMESSUNGSUNTERLAGEN_TS4, ANZAHL_VERMESSUNGSUNTERLAGEN_TS4);
                Collection sup = super.performServerSearch();
                if (sup != null) {
                    results.putAll((HashMap)sup.iterator().next());
                }
                ArrayList<HashMap<String, ArrayList>> resultWrapper = new ArrayList<HashMap<String, ArrayList>>(1);
                resultWrapper.add(results);
                return resultWrapper;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        return null;
    }

    private void excuteQueryAndConvertAmountResults(MetaService ms, HashMap<String, ArrayList> results, String query, String key) throws RemoteException {
        ArrayList lists = ms.performCustomSearch(query.replace("${from}", POSTGRES_DATE_FORMAT.format(this.from)).replace("${till}", POSTGRES_DATE_FORMAT.format(this.till)), this.getConnectionContext());
        if (lists != null && !lists.isEmpty()) {
            ArrayList<AmountBean> beans = new ArrayList<AmountBean>();
            for (ArrayList row : lists) {
                AmountBean bean = new AmountBean();
                if (row.size() == 1) {
                    bean.setName((String)row.get(0));
                } else {
                    bean.setName((String)row.get(0));
                    bean.setNumber((Number)row.get(1));
                }
                beans.add(bean);
            }
            results.put(key, beans);
        }
    }

    private void excuteQueryAndConvertAmountPerVerwendungszweckResults(MetaService ms, HashMap<String, ArrayList> results, String query, String productCategory, String key) throws RemoteException {
        String filledQuery = query.replace("${productKeys}", productCategory != null ? " billing_jahresbericht_products.category = '" + productCategory + "' " : " TRUE ").replace("${from}", POSTGRES_DATE_FORMAT.format(this.from)).replace("${till}", POSTGRES_DATE_FORMAT.format(this.till));
        LOG.info((Object)filledQuery);
        ArrayList lists = ms.performCustomSearch(filledQuery, this.getConnectionContext());
        if (lists != null) {
            AnzahlProVerwendungszweckBean bean = new AnzahlProVerwendungszweckBean();
            for (ArrayList row : lists) {
                String name = (String)row.get(0);
                Number number = (Number)row.get(1);
                if ("eigG".equalsIgnoreCase(name)) {
                    bean.setNumberEigG(number);
                    continue;
                }
                if ("eigG frei".equalsIgnoreCase(name)) {
                    bean.setNumberEigG_frei(number);
                    continue;
                }
                if ("VU aL".equalsIgnoreCase(name)) {
                    bean.setNumberVU_aL(number);
                    continue;
                }
                if ("VU hV".equalsIgnoreCase(name)) {
                    bean.setNumberVU_hV(number);
                    continue;
                }
                if ("VU s".equalsIgnoreCase(name)) {
                    bean.setNumberVU_s(number);
                    continue;
                }
                if ("WV ein".equalsIgnoreCase(name)) {
                    bean.setNumberWV_ein(number);
                    continue;
                }
                if (!"GDZ".equalsIgnoreCase(name)) continue;
                bean.setNumberGDZ(number);
            }
            ArrayList<AnzahlProVerwendungszweckBean> beans = new ArrayList<AnzahlProVerwendungszweckBean>();
            beans.add(bean);
            results.put(key, beans);
        }
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return ConnectionContext.createDummy();
    }

    public class AnzahlProVerwendungszweckBean
    implements Serializable {
        private Number numberEigG = 0L;
        private Number numberEigG_frei = 0L;
        private Number numberVU_aL = 0L;
        private Number numberVU_hV = 0L;
        private Number numberVU_s = 0L;
        private Number numberWV_ein = 0L;
        private Number numberGDZ = 0L;

        public Number getNumberEigG() {
            return this.numberEigG;
        }

        public Number getNumberEigG_frei() {
            return this.numberEigG_frei;
        }

        public Number getNumberVU_aL() {
            return this.numberVU_aL;
        }

        public Number getNumberVU_hV() {
            return this.numberVU_hV;
        }

        public Number getNumberVU_s() {
            return this.numberVU_s;
        }

        public Number getNumberWV_ein() {
            return this.numberWV_ein;
        }

        public Number getNumberGDZ() {
            return this.numberGDZ;
        }

        public void setNumberEigG(Number numberEigG) {
            this.numberEigG = numberEigG;
        }

        public void setNumberEigG_frei(Number numberEigG_frei) {
            this.numberEigG_frei = numberEigG_frei;
        }

        public void setNumberVU_aL(Number numberVU_aL) {
            this.numberVU_aL = numberVU_aL;
        }

        public void setNumberVU_hV(Number numberVU_hV) {
            this.numberVU_hV = numberVU_hV;
        }

        public void setNumberVU_s(Number numberVU_s) {
            this.numberVU_s = numberVU_s;
        }

        public void setNumberWV_ein(Number numberWV_ein) {
            this.numberWV_ein = numberWV_ein;
        }

        public void setNumberGDZ(Number numberGDZ) {
            this.numberGDZ = numberGDZ;
        }
    }

    public class KundeBean
    implements Serializable {
        private String name = "";

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public class AmountBean
    implements Serializable {
        private Number number = 0L;
        private String name = "";

        public Number getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public void setNumber(Number number) {
            this.number = number;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

