/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wunda_blau.search.server.RestApiMonGeometrySearch;
import de.cismet.cids.custom.wunda_blau.search.server.RestApiMonSearch;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;

public class BodenrichtwertZoneMonSearch
extends RestApiMonGeometrySearch {
    private static final transient Logger LOG = Logger.getLogger(BodenrichtwertZoneMonSearch.class);

    public BodenrichtwertZoneMonSearch() {
        this(null, null);
    }

    public BodenrichtwertZoneMonSearch(Double buffer) {
        this(null, buffer);
    }

    public BodenrichtwertZoneMonSearch(Geometry geometry, Double buffer) {
        this.setGeometry(geometry);
        this.setBuffer(buffer);
        this.setSearchInfo(new SearchInfo(this.getClass().getName(), this.getClass().getSimpleName(), "Builtin Legacy Search to delegate the operation Wohnlagenkategorisierung to the cids Pure REST Search API.", Arrays.asList(new SearchParameterInfo[]{new RestApiMonSearch.MySearchParameterInfo("searchFor", Type.STRING), new RestApiMonSearch.MySearchParameterInfo("geom", Type.UNDEFINED)}), (SearchParameterInfo)new RestApiMonSearch.MySearchParameterInfo("return", Type.ENTITY_REFERENCE, true)));
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            Geometry geometry = this.getGeometry();
            String geomCondition = this.getGeomCondition();
            String area = geometry != null ? String.format("st_area(st_intersection(geom.geo_field, st_GeometryFromText('%1$s')))", PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)geometry)) : "st_area(geom.geo_field)";
            String query = "SELECT   (SELECT id FROM cs_class WHERE table_name ILIKE 'brw_zone') AS class_id,   object_id,   min(object_name),   sum(area) FROM (   SELECT     " + area + " AS area,     (SELECT id FROM cs_class WHERE table_name ILIKE 'brw_zone') AS class_id,     brw_zone.id AS object_id,     CASE WHEN brw_zone.bodenrichtwert IS NOT NULL AND brw_zone.bodenrichtwert NOT LIKE '' THEN brw_zone.bodenrichtwert || '\u20ac/m\u00b2 ' ELSE '' END || '(' || brw_zone.entwicklungszustand || CASE WHEN brw_zone.geschosszahl IS NOT NULL THEN ', ' || brw_zone.geschosszahl ELSE '' END || ')' AS object_name   FROM brw_zone \n  " + (geomCondition != null ? "LEFT JOIN geom ON geom.id = brw_zone.fk_geom " : " ") + "  " + (geomCondition != null ? "WHERE " + geomCondition : " ") + ") AS sub GROUP BY object_id ORDER BY sum(area) DESC;";
            if (query != null) {
                MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
                ArrayList resultList = ms.performCustomSearch(query, this.getConnectionContext());
                for (ArrayList al : resultList) {
                    int cid = (Integer)al.get(0);
                    int oid = (Integer)al.get(1);
                    String name = (String)al.get(2);
                    MetaObjectNode mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, name, null, null);
                    result.add(mon);
                }
            }
            return result;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while searching for brw_zone object", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

