/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.sql.PreparableStatement;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.wunda_blau.search.server.SearchProperties;
import de.cismet.cids.server.search.builtin.DefaultGeoSearch;
import java.util.Locale;
import org.apache.log4j.Logger;

public final class BufferingGeosearch
extends DefaultGeoSearch {
    private static final transient Logger LOG = Logger.getLogger(BufferingGeosearch.class);
    private static final String GEO_FIELD = "geom_val";
    private GeomMode geomMode = GeomMode.INTERSECTS;
    private Double buffer;

    public BufferingGeosearch() {
        if (SearchProperties.getInstance().getIntersectsBuffer() != null) {
            try {
                this.buffer = Double.parseDouble(SearchProperties.getInstance().getIntersectsBuffer());
            }
            catch (Exception ex) {
                LOG.error((Object)"error while parsing IntersectsBuffer from SearchProperties to double", (Throwable)ex);
            }
        }
    }

    public void setBuffer(Double buffer) {
        this.buffer = buffer;
    }

    public void setGeomMode(GeomMode geomMode) {
        this.geomMode = geomMode;
    }

    public PreparableStatement getSearchSql(String domainKey) {
        String geomFunctionParamB;
        String geomFunctionParamA;
        String geomFunction;
        String sql = "SELECT DISTINCT i.class_id ocid, i.object_id as oid, c.stringrep, c.geometry, c.lightweight_json \nFROM            cs_attr_geom g, \n                cs_attr_object_derived i \n                LEFT OUTER JOIN cs_cache c \n                ON ( c.class_id =i.class_id AND c.object_id=i.object_id ) \nWHERE           i.attr_class_id = g.class_id\nAND             i.attr_object_id = g.object_id\nAND i.class_id IN <cidsClassesInStatement> \nAND geom_val && st_geomfromtext('SRID=<cidsSearchGeometrySRID>;<cidsSearchGeometryWKT>')\nAND <geomStatement>\nORDER BY        1,2,3";
        Geometry searchGeometry = this.getGeometry();
        switch (this.geomMode) {
            case CONTAINS: {
                geomFunction = "st_contains";
                break;
            }
            case WITHIN: {
                geomFunction = "st_within";
                break;
            }
            default: {
                geomFunction = "st_intersects";
            }
        }
        String searchGeomFromText = "st_geomfromtext('SRID=<cidsSearchGeometrySRID>;<cidsSearchGeometryWKT>')";
        String bufferedSearchGeomFromText = this.buffer != null ? String.format(Locale.US, "st_buffer(%s, %f)", "st_geomfromtext('SRID=<cidsSearchGeometrySRID>;<cidsSearchGeometryWKT>')", this.buffer) : "st_geomfromtext('SRID=<cidsSearchGeometrySRID>;<cidsSearchGeometryWKT>')";
        String bufferedTargetGeomText = this.buffer != null ? String.format(Locale.US, "st_buffer(geom_val, %f)", this.buffer) : GEO_FIELD;
        String geomFunctionString = "%s(%s, %s)";
        if (searchGeometry.getSRID() == 4326) {
            geomFunctionParamA = GEO_FIELD;
            geomFunctionParamB = "st_geomfromtext('SRID=<cidsSearchGeometrySRID>;<cidsSearchGeometryWKT>')";
        } else if (searchGeometry instanceof Polygon || searchGeometry instanceof MultiPolygon) {
            geomFunctionParamA = bufferedTargetGeomText;
            geomFunctionParamB = bufferedSearchGeomFromText;
        } else {
            geomFunctionParamA = bufferedTargetGeomText;
            geomFunctionParamB = "st_geomfromtext('SRID=<cidsSearchGeometrySRID>;<cidsSearchGeometryWKT>')";
        }
        String geomStatement = String.format("%s(%s, %s)", geomFunction, geomFunctionParamA, geomFunctionParamB);
        String cidsSearchGeometryWKT = searchGeometry.toText();
        String sridString = Integer.toString(searchGeometry.getSRID());
        String classesInStatement = (String)this.getClassesInSnippetsPerDomain().get(domainKey);
        if (cidsSearchGeometryWKT == null || cidsSearchGeometryWKT.trim().length() == 0 || sridString == null || sridString.trim().length() == 0) {
            LOG.error((Object)"Search geometry or srid is not given. Can't perform a search without those information.");
            return null;
        }
        if (classesInStatement == null || classesInStatement.trim().length() == 0) {
            LOG.warn((Object)("There are no search classes defined for domain '" + domainKey + "'. This domain will be skipped."));
            return null;
        }
        PreparableStatement ps = new PreparableStatement("SELECT DISTINCT i.class_id ocid, i.object_id as oid, c.stringrep, c.geometry, c.lightweight_json \nFROM            cs_attr_geom g, \n                cs_attr_object_derived i \n                LEFT OUTER JOIN cs_cache c \n                ON ( c.class_id =i.class_id AND c.object_id=i.object_id ) \nWHERE           i.attr_class_id = g.class_id\nAND             i.attr_object_id = g.object_id\nAND i.class_id IN <cidsClassesInStatement> \nAND geom_val && st_geomfromtext('SRID=<cidsSearchGeometrySRID>;<cidsSearchGeometryWKT>')\nAND <geomStatement>\nORDER BY        1,2,3".replaceAll("<geomStatement>", geomStatement).replaceAll("<cidsClassesInStatement>", classesInStatement).replaceAll("<cidsSearchGeometryWKT>", cidsSearchGeometryWKT).replaceAll("<cidsSearchGeometrySRID>", sridString), new int[0]);
        ps.setObjects(new Object[0]);
        return ps;
    }

    public static enum GeomMode {
        INTERSECTS,
        WITHIN,
        CONTAINS;

    }
}

