/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wunda_blau.search.server.BaulastSearchInfo;
import de.cismet.cids.custom.wunda_blau.search.server.FlurstueckInfo;
import de.cismet.cids.custom.wunda_blau.search.server.SearchProperties;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;

public class CidsBaulastSearchStatement
extends AbstractCidsServerSearch
implements MetaObjectNodeServerSearch,
ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(CidsBaulastSearchStatement.class);
    private static final String INTERSECTS_BUFFER = SearchProperties.getInstance().getIntersectsBuffer();
    private String blattnummer;
    private Result result;
    private boolean gueltig;
    private boolean ungueltig;
    private boolean belastet;
    private boolean beguenstigt;
    private Geometry geometry;
    private List<FlurstueckInfo> flurstuecke;
    private String art;
    private final int baulastClassID;
    private final int baulastblattClassID;
    private String blattnummerquerypart = "";
    private String gueltigquerypart = "";
    private String ungueltigquerypart = "";
    private String geoquerypart = "";
    private String fsquerypart = "";
    private String artquerypart = "";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public CidsBaulastSearchStatement(BaulastSearchInfo searchInfo, int baulastClassID, int baulastblattClassID) {
        this.baulastClassID = baulastClassID;
        this.baulastblattClassID = baulastblattClassID;
        this.result = searchInfo.getResult();
        this.blattnummer = searchInfo.getBlattnummer();
        if (this.blattnummer != null) {
            this.blattnummer = StringEscapeUtils.escapeSql((String)this.blattnummer);
        }
        this.gueltig = searchInfo.isGueltig();
        this.ungueltig = searchInfo.isUngueltig();
        this.beguenstigt = searchInfo.isBeguenstigt();
        this.belastet = searchInfo.isBelastet();
        this.art = searchInfo.getArt();
        if (this.art != null) {
            this.art = StringEscapeUtils.escapeSql((String)this.art);
        }
        this.geometry = searchInfo.getGeometry();
        this.flurstuecke = searchInfo.getFlurstuecke();
        if (this.blattnummer != null && this.blattnummer.length() > 0) {
            this.blattnummerquerypart = " and l.blattnummer ~* '^[0]*" + this.blattnummer + "[[:alpha:]]?$'";
        }
        if (!this.gueltig || !this.ungueltig) {
            if (!this.gueltig && !this.ungueltig) {
                this.gueltigquerypart = " and false";
            } else if (this.gueltig) {
                this.gueltigquerypart = " and loeschungsdatum is null and geschlossen_am is null";
            } else if (this.ungueltig) {
                this.ungueltigquerypart = " and (loeschungsdatum is not null or geschlossen_am is not null)";
            }
        }
        if (this.geometry != null && !this.geometry.isEmpty()) {
            String geomString = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)this.geometry);
            this.geoquerypart = " and f.umschreibendes_rechteck && st_GeomFromEWKT('" + geomString + "') and st_intersects(f.umschreibendes_rechteck,st_buffer(st_GeomFromEWKT('" + geomString + "'), " + INTERSECTS_BUFFER + "))";
        }
        if (this.art != null && this.art.length() > 0) {
            this.artquerypart = " and l.id = la.baulast_reference and la.baulast_art = a.id and a.baulast_art = '" + this.art + "'";
        }
        this.fsquerypart = this.getSqlByFlurstuecksInfo(this.flurstuecke);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            String primary = this.getPrimaryQuery();
            String secondary = this.getSecondaryQuery();
            MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
            ArrayList primaryResultList = ms.performCustomSearch(primary, this.getConnectionContext());
            ArrayList<MetaObjectNode> aln = new ArrayList<MetaObjectNode>();
            for (ArrayList al : primaryResultList) {
                int cid = (Integer)al.get(0);
                int oid = (Integer)al.get(1);
                MetaObjectNode mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, (String)al.get(2), null, null);
                aln.add(mon);
            }
            if (this.flurstuecke != null && this.flurstuecke.size() > 0) {
                ArrayList secondaryResultList = ms.performCustomSearch(secondary, this.getConnectionContext());
                for (ArrayList al : secondaryResultList) {
                    int cid = (Integer)al.get(0);
                    int oid = (Integer)al.get(1);
                    MetaObjectNode mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, "indirekt: " + (String)al.get(2), null, null);
                    aln.add(mon);
                }
            }
            return aln;
        }
        catch (Exception e) {
            LOG.error((Object)"Problem der Baulastensuche", (Throwable)e);
            throw new RuntimeException("Problem der Baulastensuche", e);
        }
    }

    private String getSqlByFlurstuecksInfo(Collection<FlurstueckInfo> fis) {
        assert (fis != null);
        String queryPart = "";
        if (fis.size() > 0) {
            queryPart = queryPart + " AND ( ";
            for (FlurstueckInfo fi : fis) {
                queryPart = queryPart + this.getSqlByFlurstuecksInfo(fi);
                queryPart = queryPart + " or ";
            }
            queryPart = queryPart.substring(0, queryPart.length() - 4);
            queryPart = queryPart + " ) ";
        }
        return queryPart;
    }

    private String getSqlByFlurstuecksInfo(FlurstueckInfo fi) {
        return " ( k.gemarkung = '" + fi.gemarkung + "' and k.flur = '" + StringEscapeUtils.escapeSql((String)fi.flur) + "' and k.zaehler = '" + StringEscapeUtils.escapeSql((String)fi.zaehler) + "' and k.nenner = '" + StringEscapeUtils.escapeSql((String)fi.nenner) + "' ) ";
    }

    private String getBelastetBeguenstigtSubselect() {
        if (this.belastet || this.beguenstigt) {
            String subselect = "";
            subselect = subselect + " (";
            if (this.beguenstigt) {
                subselect = subselect + " select * from alb_baulast_flurstuecke_beguenstigt";
                if (this.belastet) {
                    subselect = subselect + " UNION";
                }
            }
            if (this.belastet) {
                subselect = subselect + " select * from alb_baulast_flurstuecke_belastet";
            }
            subselect = subselect + " ) as fsj";
            return subselect;
        }
        return " (SELECT * FROM   alb_baulast_flurstuecke_beguenstigt where true=false) AS fsj";
    }

    private String getPrimaryQuery() {
        String query = "";
        String queryBlattPrefix = "SELECT " + this.baulastblattClassID + "  AS class_id, \n       b.id AS object_id, \n       b.blattnummer \nFROM   alb_baulastblatt b \nWHERE  b.blattnummer IN (SELECT blattnummer \n                         FROM \n       (";
        String queryMid = "\nSELECT " + this.baulastClassID + "  AS class_id, \n               l.id AS object_id, \n               l.blattnummer|| '/' || case when l.laufende_nummer is not null then l.laufende_nummer else 'keine laufende Nummer' end, \n               l.blattnummer , \n               l.laufende_nummer \n        FROM   alb_baulast l \n               left outer join alb_baulast_baulastarten la on (l.id = la.baulast_reference) \n               left outer join alb_baulast_art a on (la.baulast_art = a.id),\n" + this.getBelastetBeguenstigtSubselect() + "\n               , \n               alb_flurstueck_kicker k";
        if (this.geometry != null && !this.geometry.isEmpty()) {
            queryMid = queryMid + ", \n               flurstueck f ";
        }
        queryMid = queryMid + "\n        WHERE  1 = 1 \n               AND l.id = fsj.baulast_reference \n               AND fsj.flurstueck = k.id ";
        if (this.geometry != null && !this.geometry.isEmpty()) {
            queryMid = queryMid + "\n               AND k.fs_referenz = f.id ";
        }
        queryMid = queryMid + "\n               " + this.blattnummerquerypart;
        if (this.geometry != null && !this.geometry.isEmpty()) {
            queryMid = queryMid + "\n               " + this.geoquerypart;
        }
        queryMid = queryMid + "\n               " + this.artquerypart + "\n               " + this.ungueltigquerypart + "\n               " + this.gueltigquerypart + "\n               " + this.fsquerypart;
        String queryBlattPostfix = "\n) AS x \n                        ) \nGROUP  BY b.blattnummer, \n          class_id, \n          object_id \nORDER  BY b.blattnummer ";
        String queryBaulastPostfix = "\n group by blattnummer, laufende_nummer, class_id, object_id\n order by blattnummer, laufende_nummer";
        query = this.result == Result.BAULASTBLATT ? queryBlattPrefix + queryMid + "\n) AS x \n                        ) \nGROUP  BY b.blattnummer, \n          class_id, \n          object_id \nORDER  BY b.blattnummer " : queryMid + "\n group by blattnummer, laufende_nummer, class_id, object_id\n order by blattnummer, laufende_nummer";
        return query;
    }

    private String getSecondaryQuery() {
        String query = "";
        String queryBlattPrefix = "SELECT " + this.baulastblattClassID + "        AS class_id, \n       b.id       AS object_id, \n       b.blattnummer \nFROM   alb_baulastblatt b \nWHERE  b.blattnummer IN (SELECT blattnummer \n                         FROM (";
        String queryMid = "\n       SELECT " + this.baulastClassID + "  AS class_id, \n               l.id AS object_id, \n               l.blattnummer|| '/' || case when l.laufende_nummer is not null then l.laufende_nummer else 'keine laufende Nummer' end, \n               l.blattnummer, \n               l.laufende_nummer \n        FROM   alb_baulast l \n               left outer join alb_baulast_baulastarten la on (l.id = la.baulast_reference) \n               left outer join alb_baulast_art a on (la.baulast_art = a.id),\n               alb_flurstueck_kicker k, \n               flurstueck f, \n" + this.getBelastetBeguenstigtSubselect() + "\n               , \n              (SELECT f.gemarkungs_nr gemarkung, \n                      f.flur          flur, \n                      f.fstnr_z       zaehler, \n                      f.fstnr_n       nenner \n               FROM   alb_flurstueck_kicker k, \n                      flurstueck f, \n                      (SELECT f.id fid, \n                              k.id kid, \n                              umschreibendes_rechteck as geo_field\n                       FROM   alb_flurstueck_kicker k \n                              LEFT OUTER JOIN (SELECT \n                              flurstueck \n                                               FROM \n                              alb_baulast_flurstuecke_beguenstigt \n                                               UNION \n                                               SELECT flurstueck \n                                               FROM \n                              alb_baulast_flurstuecke_belastet \n                                              ) AS x \n                                ON ( x.flurstueck = k.id ), \n                              flurstueck f \n                       WHERE  x.flurstueck IS NULL \n                              AND k.fs_referenz = f.id \n                              " + this.fsquerypart + "\n                                                     ) AS y \n               WHERE  k.fs_referenz = f.id \n                      AND CASE WHEN NOT st_isEmpty(y.geo_field) AND NOT st_isEmpty(f.umschreibendes_rechteck) THEN y.geo_field && f.umschreibendes_rechteck ELSE FALSE END \n                      AND CASE WHEN NOT st_isEmpty(y.geo_field) AND NOT st_isEmpty(f.umschreibendes_rechteck) AND NOT st_isEmpty(St_buffer(y.geo_field," + INTERSECTS_BUFFER + ")) AND NOT st_isEmpty(St_buffer(f.umschreibendes_rechteck, " + INTERSECTS_BUFFER + ")) THEN st_Intersects(St_buffer(y.geo_field, " + INTERSECTS_BUFFER + "), St_buffer(f.umschreibendes_rechteck, " + INTERSECTS_BUFFER + ")) ELSE FALSE END \n                      AND NOT y.fid = f.id \n                      AND CASE WHEN NOT st_isEmpty(y.geo_field) AND NOT st_isEmpty(f.umschreibendes_rechteck) AND NOT st_isEmpty(st_Buffer(y.geo_field, -0.005)) AND NOT st_isEmpty(St_buffer(f.umschreibendes_rechteck, " + INTERSECTS_BUFFER + ")) THEN st_Intersects(st_Buffer(y.geo_field, -0.005), St_buffer(f.umschreibendes_rechteck, " + INTERSECTS_BUFFER + ")) ELSE FALSE END) AS indirekt \n                                 WHERE  1 = 1 \n                                        AND l.id = fsj.baulast_reference \n                                        AND fsj.flurstueck = k.id \n                                        AND k.fs_referenz = f.id \n                                        AND f.gemarkungs_nr = indirekt.gemarkung \n                                        AND f.flur = indirekt.flur \n                                        AND f.fstnr_z = indirekt.zaehler \n                                        AND f.fstnr_n = indirekt.nenner \n                                      " + this.blattnummerquerypart + "\n                                      " + this.artquerypart + "\n                                      " + this.ungueltigquerypart + "\n                                      " + this.gueltigquerypart;
        String queryBlattPostfix = "\n)AS x) \nGROUP  BY b.blattnummer, \n          class_id, \n          object_id \nORDER  BY b.blattnummer";
        String queryBaulastPostfix = "\n group by blattnummer, laufende_nummer, class_id, object_id\n order by blattnummer, laufende_nummer";
        query = this.result == Result.BAULASTBLATT ? queryBlattPrefix + queryMid + "\n)AS x) \nGROUP  BY b.blattnummer, \n          class_id, \n          object_id \nORDER  BY b.blattnummer" : queryMid + "\n group by blattnummer, laufende_nummer, class_id, object_id\n order by blattnummer, laufende_nummer";
        return query;
    }

    public static void main(String[] args) {
        BaulastSearchInfo bsi = new BaulastSearchInfo();
        bsi.setResult(Result.BAULASTBLATT);
        bsi.setBlattnummer("9724");
        CidsBaulastSearchStatement css = new CidsBaulastSearchStatement(bsi, 177, 182);
        System.out.println(css.getPrimaryQuery());
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum Result {
        BAULAST,
        BAULASTBLATT;

    }
}

