/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.tostringconverter.wunda_blau.BillingBillingToStringConverter;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Logger;

public class CidsBillingSearchStatement
extends AbstractCidsServerSearch
implements ConnectionContextStore,
MetaObjectNodeServerSearch {
    private static final Logger LOG = Logger.getLogger(CidsBillingSearchStatement.class);
    private static final String CIDSCLASS = "billing";
    private static final String DOMAIN = "WUNDA_BLAU";
    private String geschaeftsbuchnummer;
    private String projekt;
    private String userID;
    private String abrechnungsturnusID;
    private ArrayList<String> verwendungszweckKeys = new ArrayList();
    private Kostentyp kostentyp = Kostentyp.IGNORIEREN;
    private Date from;
    private Date till;
    private Date abrechnungsdatumFrom;
    private Date abrechnungsdatumTill;
    private StringBuilder query;
    private final SimpleDateFormat postgresDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private ArrayList<MetaObject> kundeMetaObjects = new ArrayList();
    private String kundenname;
    private Boolean showStornierteBillings = false;
    private Boolean showAbgerechneteBillings = false;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public CidsBillingSearchStatement() {
    }

    public CidsBillingSearchStatement(MetaObject kundeMetaObject) {
        this.kundeMetaObjects.add(kundeMetaObject);
    }

    public CidsBillingSearchStatement(ArrayList<MetaObject> kundeMetaObjects) {
        this.kundeMetaObjects = kundeMetaObjects;
    }

    public CidsBillingSearchStatement(String kundenname) {
        this.kundenname = kundenname;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection<MetaObjectNode> performServerSearch() throws SearchException {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN);
        if (ms != null) {
            try {
                ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
                this.generateQuery();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The used query is: " + this.query.toString()));
                }
                ArrayList searchResult = ms.performCustomSearch(this.query.toString(), this.getConnectionContext());
                for (ArrayList al : searchResult) {
                    int cid = (Integer)al.get(0);
                    int oid = (Integer)al.get(1);
                    String geschaeftsbuchnummer = (String)al.get(2);
                    String kundenname = (String)al.get(3);
                    String username = (String)al.get(4);
                    Date angelegt = (Date)al.get(5);
                    String name = BillingBillingToStringConverter.createString(geschaeftsbuchnummer, kundenname, username, angelegt);
                    MetaObjectNode mon = new MetaObjectNode(DOMAIN, oid, cid, name, null, null);
                    result.add(mon);
                }
                return result;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }

    public Date getAbrechnungsdatumFrom() {
        return this.abrechnungsdatumFrom;
    }

    public void setAbrechnungsdatumFrom(Date abrechnungsdatumFrom) {
        this.abrechnungsdatumFrom = abrechnungsdatumFrom;
    }

    public Date getAbrechnungsdatumTill() {
        return this.abrechnungsdatumTill;
    }

    public void setAbrechnungsdatumTill(Date abrechnungsdatumTill) {
        this.abrechnungsdatumTill = abrechnungsdatumTill;
    }

    public String generateQuery() {
        this.query = new StringBuilder();
        this.query.append("SELECT (SELECT id                 FROM    cs_class                 WHERE   name ilike 'billing'                 ), b.id, b.geschaeftsbuchnummer, kunde.name, b.username, b.ts ");
        this.query.append(" FROM billing_billing b");
        this.query.append(" JOIN billing_kunden_logins as logins");
        this.query.append("     ON b.angelegt_durch = logins.id");
        this.query.append(" JOIN billing_kunde as kunde");
        this.query.append("     ON logins.kunde = kunde.id");
        this.query.append(" WHERE ");
        this.appendKunde();
        this.appendUserIds();
        this.appendGeschaeftsbuchnummer();
        this.appendProjekt();
        this.appendVerwendungszweckKeys();
        this.appendKostentyp();
        this.appendDates();
        this.appendAbrechnungsturnus();
        this.appendStornoAndAbgerechnet();
        return this.query.toString();
    }

    private void appendKunde() {
        if (this.kundenname == null) {
            if (this.kundeMetaObjects.isEmpty()) {
                this.query.append(" b.username NOT ILIKE 'muster_%' AND b.username NOT ILIKE 'test_%' ");
            } else {
                StringBuilder customerListString = new StringBuilder(" kunde.id in (");
                for (MetaObject kundeMetaObject : this.kundeMetaObjects) {
                    customerListString.append(kundeMetaObject.getBean().getProperty("id"));
                    customerListString.append(",");
                }
                customerListString.deleteCharAt(customerListString.length() - 1);
                customerListString.append(")");
                this.query.append(customerListString.toString());
            }
        } else {
            this.query.append(" kunde.name ilike '%").append(this.kundenname).append("%' ");
        }
    }

    private void appendUserIds() {
        if (this.userID != null && !this.userID.equals("")) {
            this.query.append("and angelegt_durch  = ").append(this.userID).append(" ");
        }
    }

    private void appendGeschaeftsbuchnummer() {
        if (this.geschaeftsbuchnummer != null && !this.geschaeftsbuchnummer.equals("")) {
            this.query.append("and geschaeftsbuchnummer ilike '%").append(this.geschaeftsbuchnummer).append("%' ");
        }
    }

    private void appendProjekt() {
        if (this.projekt != null && !this.projekt.equals("")) {
            this.query.append("and projektbezeichnung ilike '%").append(this.projekt).append("%' ");
        }
    }

    private void appendVerwendungszweckKeys() {
        if (!this.verwendungszweckKeys.isEmpty()) {
            StringBuilder verwendungszweckListString = new StringBuilder("(");
            for (String verwendungszweckKey : this.verwendungszweckKeys) {
                verwendungszweckListString.append(" '");
                verwendungszweckListString.append(verwendungszweckKey);
                verwendungszweckListString.append("',");
            }
            verwendungszweckListString.deleteCharAt(verwendungszweckListString.length() - 1);
            verwendungszweckListString.append(")");
            this.query.append("and verwendungskey in ").append(verwendungszweckListString.toString()).append(" ");
        }
    }

    private void appendKostentyp() {
        switch (this.kostentyp) {
            case KOSTENFREI: {
                this.query.append("and netto_summe = 0 ");
                break;
            }
            case KOSTENPFLICHTIG: {
                this.query.append("and netto_summe > 0 ");
            }
        }
    }

    private void appendDates() {
        if (this.from != null) {
            if (this.till == null || this.postgresDateFormat.format(this.from).equals(this.postgresDateFormat.format(this.till))) {
                this.query.append(" and date_trunc('day',ts) = '");
                this.query.append(this.postgresDateFormat.format(this.from));
                this.query.append("' ");
            } else {
                this.query.append(" and date_trunc('day',ts) >= '");
                this.query.append(this.postgresDateFormat.format(this.from));
                this.query.append("' ");
                this.query.append(" and date_trunc('day',ts) <= '");
                this.query.append(this.postgresDateFormat.format(this.till));
                this.query.append("' ");
            }
        }
        if (this.abrechnungsdatumFrom != null) {
            if (this.abrechnungsdatumTill == null || this.postgresDateFormat.format(this.abrechnungsdatumFrom).equals(this.postgresDateFormat.format(this.abrechnungsdatumTill))) {
                this.query.append(" and date_trunc('day',abrechnungsdatum) = '");
                this.query.append(this.postgresDateFormat.format(this.abrechnungsdatumFrom));
                this.query.append("' ");
            } else {
                this.query.append(" and date_trunc('day',abrechnungsdatum) >= '");
                this.query.append(this.postgresDateFormat.format(this.abrechnungsdatumFrom));
                this.query.append("' ");
                this.query.append(" and date_trunc('day',abrechnungsdatum) <= '");
                this.query.append(this.postgresDateFormat.format(this.abrechnungsdatumTill));
                this.query.append("' ");
            }
        }
    }

    private void appendAbrechnungsturnus() {
        if (this.abrechnungsturnusID != null && !this.abrechnungsturnusID.equals("")) {
            this.query.append(" and kunde.abrechnungsturnus = ").append(this.abrechnungsturnusID).append(" ");
        }
    }

    private void appendStornoAndAbgerechnet() {
        if (Boolean.TRUE.equals(this.showStornierteBillings)) {
            this.query.append(" and b.storniert is true ");
        } else if (Boolean.FALSE.equals(this.showStornierteBillings)) {
            this.query.append(" and b.storniert is not true ");
        }
        if (Boolean.TRUE.equals(this.showAbgerechneteBillings)) {
            this.query.append(" and b.abgerechnet is true ");
        } else if (Boolean.FALSE.equals(this.showAbgerechneteBillings)) {
            this.query.append(" and b.abgerechnet is not true ");
        }
    }

    public String getGeschaeftsbuchnummer() {
        return this.geschaeftsbuchnummer;
    }

    public void setGeschaeftsbuchnummer(String geschaeftsbuchnummer) {
        this.geschaeftsbuchnummer = geschaeftsbuchnummer;
    }

    public ArrayList<MetaObject> getKundeMetaObjects() {
        return this.kundeMetaObjects;
    }

    public void setKundeMetaObjects(ArrayList<MetaObject> kundeMetaObjects) {
        this.kundeMetaObjects = kundeMetaObjects;
    }

    public String getProjekt() {
        return this.projekt;
    }

    public void setProjekt(String projekt) {
        this.projekt = projekt;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public ArrayList<String> getVerwendungszweckKeys() {
        return this.verwendungszweckKeys;
    }

    public void setVerwendungszweckKeys(ArrayList<String> verwendungszweckKeys) {
        this.verwendungszweckKeys = verwendungszweckKeys;
    }

    public Kostentyp getKostentyp() {
        return this.kostentyp;
    }

    public void setKostentyp(Kostentyp kostentyp) {
        this.kostentyp = kostentyp;
    }

    public Date getFrom() {
        return this.from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public Date getTill() {
        return this.till;
    }

    public void setTill(Date till) {
        this.till = till;
    }

    public String getAbrechnungsturnusID() {
        return this.abrechnungsturnusID;
    }

    public void setAbrechnungsturnusID(String abrechnungsturnusID) {
        this.abrechnungsturnusID = abrechnungsturnusID;
    }

    @Deprecated
    public boolean isShowOnlyStornierteBillings() {
        return Boolean.TRUE.equals(this.isShowStornierteBillings());
    }

    public Boolean isShowStornierteBillings() {
        return this.showStornierteBillings;
    }

    public void setShowOnlyStornierteBillings(boolean showOnlyStornierteBillings) {
        this.setShowStornierteBillings(showOnlyStornierteBillings);
    }

    public void setShowStornierteBillings(Boolean showStornierteBillings) {
        this.showStornierteBillings = showStornierteBillings;
    }

    public Boolean isShowAbgerechneteBillings() {
        return this.showAbgerechneteBillings;
    }

    public void setShowAbgerechneteBillings(Boolean showAbgerechneteBillings) {
        this.showAbgerechneteBillings = showAbgerechneteBillings;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum Kostentyp {
        KOSTENPFLICHTIG,
        KOSTENFREI,
        IGNORIEREN;

    }
}

