/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.ActionService;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.wunda_blau.search.server.SearchProperties;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CidsGrundwassermessstelleSearch
extends AbstractCidsServerSearch
implements MetaObjectNodeServerSearch {
    private static final transient Logger LOG = Logger.getLogger(CidsGrundwassermessstelleSearch.class);
    private static final String INTERSECTS_BUFFER = SearchProperties.getInstance().getIntersectsBuffer();
    private final Geometry geom;
    private final Date messungVon;
    private final Date messungBis;
    private final Collection<StoffFilter> wertePairs;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public CidsGrundwassermessstelleSearch(Geometry geom, Date messungVon, Date messungBis, Collection<StoffFilter> wertePairs) {
        this.geom = geom;
        this.messungVon = messungVon;
        this.messungBis = messungBis;
        this.wertePairs = wertePairs;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            String geomWhere;
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            Properties properties = new Properties();
            ActionService as = (ActionService)this.getActiveLocalServers().get("WUNDA_BLAU");
            properties.load(new StringReader((String)as.executeTask(this.getUser(), "getServerResource", (Object)WundaBlauServerResources.ALKIS_CONF.getValue(), this.getConnectionContext(), new ServerActionParameter[0])));
            ArrayList<String> conditions = new ArrayList<String>();
            String messungVonQuery = "grundwassermessstelle_messung.datum >= '" + this.messungVon + "'";
            String messungBisQuery = "grundwassermessstelle_messung.datum <= '" + this.messungBis + "'";
            if (this.messungVon != null && this.messungBis != null) {
                conditions.add("(" + messungVonQuery + "AND " + messungBisQuery + ")");
            } else if (this.messungBis != null) {
                conditions.add("(" + messungBisQuery + ")");
            } else if (this.messungVon != null) {
                conditions.add("(" + messungVonQuery + ")");
            }
            if (this.wertePairs != null) {
                for (StoffFilter wertPair : this.wertePairs) {
                    if (wertPair.getStoffSchuessel() == null) continue;
                    String schluesselQuery = "grundwassermessstelle_messwert.stoff_schluessel = '" + wertPair.getStoffSchuessel() + "'";
                    String messwertVonQuery = "abs(grundwassermessstelle_messwert.wert) >= " + wertPair.getVonValue();
                    String messwertBisQuery = "abs(grundwassermessstelle_messwert.wert) <= " + wertPair.getBisValue();
                    if (wertPair.getVonValue() != null && wertPair.getBisValue() != null) {
                        conditions.add("(" + schluesselQuery + " AND " + messwertVonQuery + " AND " + messwertBisQuery + ")");
                        continue;
                    }
                    if (wertPair.getBisValue() != null) {
                        conditions.add("(" + schluesselQuery + " AND " + messwertBisQuery + ")");
                        continue;
                    }
                    if (wertPair.getVonValue() == null) continue;
                    conditions.add("(" + schluesselQuery + " AND " + messwertVonQuery + ")");
                }
            }
            String geomJoin = this.geom != null ? " LEFT OUTER JOIN geom ON grundwassermessstelle.geometrie = geom.id" : "";
            if (this.geom != null) {
                String geostring = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)this.geom);
                geomWhere = " AND (geom.geo_field && st_GeometryFromText('" + geostring + "') AND st_intersects(st_buffer(geo_field, " + INTERSECTS_BUFFER + "),st_GeometryFromText('" + geostring + "')))";
            } else {
                geomWhere = "";
            }
            String query = "SELECT (SELECT c.id FROM cs_class c WHERE table_name ilike 'grundwassermessstelle') AS class_id, grundwassermessstelle.id, max(grundwassermessstelle.name) AS name FROM grundwassermessstelle_messwert LEFT JOIN grundwassermessstelle_messung ON grundwassermessstelle_messwert.messung = grundwassermessstelle_messung.id LEFT JOIN grundwassermessstelle ON grundwassermessstelle_messung.messstelle_id = grundwassermessstelle.id " + geomJoin + (conditions.isEmpty() ? " WHERE TRUE" + geomWhere : " wHERE " + String.join((CharSequence)" AND ", conditions) + geomWhere) + " GROUP BY (grundwassermessstelle.id)";
            MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
            ArrayList resultList = ms.performCustomSearch(query, this.getConnectionContext());
            for (ArrayList al : resultList) {
                int cid = (Integer)al.get(0);
                int oid = (Integer)al.get(1);
                String name = (String)al.get(2);
                MetaObjectNode mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, name, null, null);
                result.add(mon);
            }
            return result;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while searching for messungen", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static class StoffFilter
    implements Serializable {
        private final String stoffSchuessel;
        private final Double vonValue;
        private final Double bisValue;

        public String getStoffSchuessel() {
            return this.stoffSchuessel;
        }

        public Double getVonValue() {
            return this.vonValue;
        }

        public Double getBisValue() {
            return this.bisValue;
        }

        public StoffFilter(String stoffSchuessel, Double vonValue, Double bisValue) {
            this.stoffSchuessel = stoffSchuessel;
            this.vonValue = vonValue;
            this.bisValue = bisValue;
        }
    }
}

