/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.wunda_blau.search.server.SearchProperties;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;

public class CidsMeasurementPointSearchStatement
extends AbstractCidsServerSearch
implements MetaObjectNodeServerSearch,
ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(CidsMeasurementPointSearchStatement.class);
    private static final String DOMAIN = "WUNDA_BLAU";
    private static final String CIDSCLASS_ALKIS = "alkis_point";
    private static final String CIDSCLASS_NIVELLEMENT = "nivellement_punkt";
    private static final String SQL_ALKIS = "SELECT DISTINCT (SELECT c.id FROM cs_class c WHERE table_name ilike 'alkis_point') as class_id, ap.id, ap.pointcode as name FROM <fromClause> <whereClause>";
    private static final String SQL_ORDERBY_ALKIS = " ORDER BY ap.pointcode DESC";
    private static final String SQL_NIVELLEMENT = "SELECT DISTINCT (SELECT c.id FROM cs_class c WHERE table_name ilike 'nivellement_punkt') as class_id, np.id, np.dgk_blattnummer || lpad(np.laufende_nummer, 3, '0') FROM <fromClause> <whereClause>";
    private static final String SQL_ORDERBY_NIVELLEMENT = " ORDER BY np.dgk_blattnummer || lpad(np.laufende_nummer, 3, '0') DESC";
    private static final String SQL_ORDERBY_BOTH = " ORDER BY name DESC";
    private static final String INTERSECTS_BUFFER = SearchProperties.getInstance().getIntersectsBuffer();
    private final String pointcode;
    private Collection<Pointtype> pointtypes;
    private GST gst;
    private Geometry geometry;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public CidsMeasurementPointSearchStatement(String pointcode, Collection<Pointtype> pointtypes, GST gst, Geometry geometry) {
        this.pointcode = StringEscapeUtils.escapeSql((String)pointcode);
        this.pointtypes = pointtypes;
        this.gst = gst;
        this.geometry = geometry;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            LOG.info((Object)("Starting search for points. Pointcode: '" + this.pointcode + "', pointtypes: '" + this.pointtypes + "', GST: '" + (Object)((Object)this.gst) + "', geometry: '" + this.geometry + "'."));
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            if (this.pointtypes == null || this.pointtypes.isEmpty()) {
                LOG.warn((Object)"There is no pointtype specified. Cancel search..");
                return result;
            }
            MetaService metaService = (MetaService)this.getActiveLocalServers().get(DOMAIN);
            if (metaService == null) {
                LOG.error((Object)"Could not retrieve MetaService 'WUNDA_BLAU'.");
                return result;
            }
            StringBuilder sqlBuilder = new StringBuilder();
            String sqlOrderBy = "";
            if (this.pointtypes.contains((Object)Pointtype.AUFNAHMEPUNKTE) || this.pointtypes.contains((Object)Pointtype.BESONDERE_BAUWERKSPUNKTE) || this.pointtypes.contains((Object)Pointtype.BESONDERE_GEBAEUDEPUNKTE) || this.pointtypes.contains((Object)Pointtype.BESONDERE_TOPOGRAPHISCHE_PUNKTE) || this.pointtypes.contains((Object)Pointtype.GRENZPUNKTE) || this.pointtypes.contains((Object)Pointtype.SONSTIGE_VERMESSUNGSPUNKTE)) {
                String sqlAlkis = SQL_ALKIS.replace("<fromClause>", this.generateFromClauseForAlkis()).replace("<whereClause>", this.generateWhereClauseForAlkis());
                sqlBuilder.append(sqlAlkis);
                sqlOrderBy = SQL_ORDERBY_ALKIS;
            }
            if (this.pointtypes.contains((Object)Pointtype.NIVELLEMENT_PUNKTE)) {
                if (sqlOrderBy.length() == 0) {
                    sqlOrderBy = SQL_ORDERBY_NIVELLEMENT;
                } else {
                    sqlBuilder.append(" UNION ");
                    sqlOrderBy = SQL_ORDERBY_BOTH;
                }
                String sqlNivellement = SQL_NIVELLEMENT.replace("<fromClause>", this.generateFromClauseForNivellement()).replace("<whereClause>", this.generateWhereClauseForNivellement());
                sqlBuilder.append(sqlNivellement);
            }
            if (sqlBuilder.length() > 0) {
                sqlBuilder.append(sqlOrderBy);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Executing SQL statement '" + sqlBuilder.toString() + "'."));
            }
            ArrayList resultset = metaService.performCustomSearch(sqlBuilder.toString(), this.getConnectionContext());
            for (ArrayList measurementPoint : resultset) {
                int classID = (Integer)measurementPoint.get(0);
                int objectID = (Integer)measurementPoint.get(1);
                String name = (String)measurementPoint.get(2);
                MetaObjectNode node = new MetaObjectNode(DOMAIN, objectID, classID, name, null, null);
                result.add(node);
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)"Problem", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected String generateFromClauseForAlkis() {
        String fromClause = null;
        fromClause = this.geometry != null ? CIDSCLASS_ALKIS.concat(" ap ") : CIDSCLASS_ALKIS.concat(" ap");
        return fromClause;
    }

    protected String generateWhereClauseForAlkis() {
        StringBuilder whereClauseBuilder = new StringBuilder();
        String conjunction = "WHERE ";
        if (this.pointcode != null && this.pointcode.trim().length() > 0) {
            whereClauseBuilder.append(conjunction);
            whereClauseBuilder.append("ap.pointcode like '");
            whereClauseBuilder.append(this.pointcode);
            whereClauseBuilder.append('\'');
            conjunction = " AND ";
        }
        if (this.pointtypes != null && !this.pointtypes.isEmpty()) {
            whereClauseBuilder.append(conjunction);
            whereClauseBuilder.append('(');
            Iterator<Pointtype> pointtypesIter = this.pointtypes.iterator();
            while (pointtypesIter.hasNext()) {
                Pointtype pointtype = pointtypesIter.next();
                whereClauseBuilder.append("ap.pointtype=");
                whereClauseBuilder.append(pointtype.getId());
                if (!pointtypesIter.hasNext()) continue;
                whereClauseBuilder.append(" OR ");
            }
            whereClauseBuilder.append(')');
            conjunction = " AND ";
        }
        if (this.gst != null) {
            whereClauseBuilder.append(conjunction);
            whereClauseBuilder.append('(');
            int[] condition = this.gst.getCondition();
            for (int i = 0; i < condition.length; ++i) {
                whereClauseBuilder.append("ap.gst=");
                whereClauseBuilder.append(condition[i]);
                if (i >= condition.length - 1) continue;
                whereClauseBuilder.append(" OR ");
            }
            whereClauseBuilder.append(')');
            conjunction = " AND ";
        }
        if (this.geometry != null) {
            String geomString = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)this.geometry);
            whereClauseBuilder.append(conjunction);
            conjunction = " AND ";
            whereClauseBuilder.append("ap.geom && st_GeomFromEWKT('").append(geomString).append("')");
            whereClauseBuilder.append(conjunction);
            whereClauseBuilder.append("st_intersects(ap.geom, st_buffer(st_GeomFromEWKT('").append(geomString).append("'), ").append(INTERSECTS_BUFFER).append("))");
        }
        return whereClauseBuilder.toString();
    }

    protected String generateFromClauseForNivellement() {
        String fromClause = null;
        fromClause = this.geometry != null ? CIDSCLASS_NIVELLEMENT.concat(" np, geom g") : CIDSCLASS_NIVELLEMENT.concat(" np");
        return fromClause;
    }

    protected String generateWhereClauseForNivellement() {
        StringBuilder whereClauseBuilder = new StringBuilder();
        String conjunction = "WHERE ";
        whereClauseBuilder.append(conjunction);
        whereClauseBuilder.append("np.historisch = false");
        conjunction = " AND ";
        if (this.pointcode != null && this.pointcode.trim().length() > 0) {
            whereClauseBuilder.append(conjunction);
            whereClauseBuilder.append("np.dgk_blattnummer || lpad(np.laufende_nummer, 3, '0') like '");
            whereClauseBuilder.append(this.pointcode);
            whereClauseBuilder.append('\'');
            conjunction = " AND ";
        }
        if (this.geometry != null) {
            String geomString = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)this.geometry);
            whereClauseBuilder.append(conjunction);
            conjunction = " AND ";
            whereClauseBuilder.append("np.geometrie = g.id");
            whereClauseBuilder.append(conjunction);
            whereClauseBuilder.append("g.geo_field && st_GeometryFromText('").append(geomString).append("')");
            whereClauseBuilder.append(conjunction);
            if (this.geometry instanceof Polygon || this.geometry instanceof MultiPolygon) {
                whereClauseBuilder.append("st_intersects(st_buffer(g.geo_field, " + INTERSECTS_BUFFER + "), st_buffer(st_GeometryFromText('").append(geomString).append("'), " + INTERSECTS_BUFFER + "))");
            } else {
                whereClauseBuilder.append("st_intersects(st_buffer(g.geo_field, " + INTERSECTS_BUFFER + "), st_GeometryFromText('").append(geomString).append("'))");
            }
        }
        return whereClauseBuilder.toString();
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum GST {
        LE2(new int[]{1000, 1100, 1200, 2000}),
        LE3(new int[]{1000, 1100, 1200, 2000, 2100}),
        LE6(new int[]{1000, 1100, 1200, 2000, 2100, 2200}),
        LE10(new int[]{1000, 1100, 1200, 2000, 2100, 2200, 2300});

        private int[] condition;

        private GST(int[] condition) {
            this.condition = condition;
        }

        public int[] getCondition() {
            return this.condition;
        }
    }

    public static enum Pointtype {
        AUFNAHMEPUNKTE(4),
        SONSTIGE_VERMESSUNGSPUNKTE(5),
        GRENZPUNKTE(1),
        BESONDERE_GEBAEUDEPUNKTE(2),
        BESONDERE_BAUWERKSPUNKTE(3),
        BESONDERE_TOPOGRAPHISCHE_PUNKTE(6),
        NIVELLEMENT_PUNKTE(-1);

        private int id;

        private Pointtype(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

