/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wunda_blau.search.server.SearchProperties;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class CidsVermessungRissSearchStatement
extends AbstractCidsServerSearch
implements MetaObjectNodeServerSearch,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(CidsVermessungRissSearchStatement.class);
    private static final String DOMAIN = "WUNDA_BLAU";
    private static final String CIDSCLASS = "vermessung_riss";
    private static final String INTERSECTS_BUFFER = SearchProperties.getInstance().getIntersectsBuffer();
    private static final String SQL = "SELECT DISTINCT (SELECT c.id FROM cs_class c WHERE table_name ilike 'vermessung_riss') as class_id, vr.id, vr.schluessel||' - '||vg.name||' - '||vr.flur||' - '||vr.blatt as name FROM <fromClause> <whereClause> ORDER BY name";
    private static final String FROM = "vermessung_riss vr JOIN vermessung_gemarkung vg ON vr.gemarkung = vg.id";
    private static final String JOIN_KICKER = " JOIN vermessung_riss_flurstuecksvermessung vrf ON vr.id = vrf.vermessung_riss_reference JOIN vermessung_flurstuecksvermessung vf ON vrf.flurstuecksvermessung = vf.id JOIN vermessung_flurstueck_kicker vfk ON vf.flurstueck = vfk.id";
    private static final String JOIN_GEOM = " JOIN geom g ON vr.geometrie = g.id";
    public static final String FLURSTUECK_GEMARKUNG = "gemarkung";
    public static final String FLURSTUECK_FLUR = "flur";
    public static final String FLURSTUECK_ZAEHLER = "zaehler";
    public static final String FLURSTUECK_NENNER = "nenner";
    public static final String FLURSTUECK_VERAENDERUNGSART = "veraenderungsart";
    private String schluessel;
    private String gemarkung;
    private String flur;
    private String blatt;
    private Collection<String> schluesselCollection;
    private Geometry geometry;
    private Collection<Map<String, String>> flurstuecke;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public CidsVermessungRissSearchStatement(String schluessel, String gemarkung, String flur, String blatt, Collection<String> schluesselCollection, Geometry geometry, Collection<Map<String, String>> flurstuecke) {
        this.schluessel = schluessel;
        this.gemarkung = gemarkung;
        this.flur = flur;
        this.blatt = blatt;
        this.schluesselCollection = schluesselCollection;
        this.geometry = geometry;
        this.flurstuecke = flurstuecke;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            if (!(this.schluessel != null && this.schluessel.trim().length() > 0 || this.gemarkung != null || this.flur != null && this.flur.trim().length() > 0 || this.blatt != null && this.blatt.trim().length() > 0 || this.schluesselCollection != null && !this.schluesselCollection.isEmpty() || this.geometry != null || this.flurstuecke != null && !this.flurstuecke.isEmpty())) {
                LOG.warn((Object)"No filters provided. Cancel search.");
                return result;
            }
            StringBuilder sqlBuilder = new StringBuilder();
            MetaService metaService = (MetaService)this.getActiveLocalServers().get(DOMAIN);
            if (metaService == null) {
                LOG.error((Object)"Could not retrieve MetaService 'WUNDA_BLAU'.");
                return result;
            }
            sqlBuilder.append(SQL.replace("<fromClause>", this.generateFromClause()).replace("<whereClause>", this.generateWhereClause()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Executing SQL statement '" + sqlBuilder.toString() + "'."));
            }
            ArrayList resultset = metaService.performCustomSearch(sqlBuilder.toString(), this.getConnectionContext());
            for (ArrayList measurementPoint : resultset) {
                int classID = (Integer)measurementPoint.get(0);
                int objectID = (Integer)measurementPoint.get(1);
                String name = (String)measurementPoint.get(2);
                MetaObjectNode node = new MetaObjectNode(DOMAIN, objectID, classID, name, null, null);
                result.add(node);
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)"Problem", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String generateFromClause() {
        StringBuilder result = new StringBuilder(FROM);
        if (this.geometry != null && !this.geometry.isEmpty()) {
            result.append(JOIN_GEOM);
        }
        if (this.flurstuecke != null && !this.flurstuecke.isEmpty()) {
            result.append(JOIN_KICKER);
        }
        return result.toString();
    }

    private String generateWhereClause() {
        StringBuilder result = new StringBuilder();
        String conjunction = "WHERE ";
        if (this.schluessel != null && this.schluessel.trim().length() > 0) {
            result.append(conjunction);
            result.append("vr.schluessel LIKE '");
            result.append(this.schluessel);
            result.append('\'');
            conjunction = " AND ";
        }
        if (this.gemarkung != null && this.gemarkung.trim().length() > 0) {
            result.append(conjunction);
            result.append("vr.gemarkung::text LIKE '");
            result.append(this.gemarkung);
            result.append('\'');
            conjunction = " AND ";
        }
        if (this.flur != null && this.flur.trim().length() > 0) {
            result.append(conjunction);
            result.append("vr.flur LIKE '");
            result.append(this.flur);
            result.append('\'');
            conjunction = " AND ";
        }
        if (this.blatt != null && this.blatt.trim().length() > 0) {
            result.append(conjunction);
            result.append("vr.blatt LIKE '");
            result.append(this.blatt);
            result.append('\'');
            conjunction = " AND ";
        }
        if (this.schluesselCollection != null && !this.schluesselCollection.isEmpty()) {
            result.append(conjunction);
            result.append("vr.schluessel IN (");
            Iterator<String> schluessel = this.schluesselCollection.iterator();
            while (schluessel.hasNext()) {
                result.append('\'');
                result.append(schluessel.next());
                result.append('\'');
                if (!schluessel.hasNext()) continue;
                result.append(',');
            }
            result.append(')');
            conjunction = " AND ";
        }
        if (this.geometry != null) {
            String geomString = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)this.geometry);
            result.append(conjunction);
            conjunction = " AND ";
            result.append("st_intersects(g.geo_field").append(", st_buffer(st_GeomFromEWKT('").append(geomString).append("'), ").append(INTERSECTS_BUFFER).append("))");
        }
        if (this.flurstuecke != null && !this.flurstuecke.isEmpty()) {
            result.append(conjunction);
            result.append('(');
            boolean firstFlurstueck = true;
            for (Map<String, String> flurstueck : this.flurstuecke) {
                String gemarkung = flurstueck.get(FLURSTUECK_GEMARKUNG);
                String flur = flurstueck.get(FLURSTUECK_FLUR);
                String zaehler = flurstueck.get(FLURSTUECK_ZAEHLER);
                String nenner = flurstueck.get(FLURSTUECK_NENNER);
                String veraenderungsart = flurstueck.get(FLURSTUECK_VERAENDERUNGSART);
                StringBuilder flurstueckBuilder = new StringBuilder();
                String flurstueckConjunction = "";
                if (gemarkung != null && gemarkung.trim().length() > 0) {
                    flurstueckBuilder.append("vfk.gemarkung::text LIKE '");
                    flurstueckBuilder.append(gemarkung);
                    flurstueckBuilder.append('\'');
                    flurstueckConjunction = " AND ";
                }
                if (flur != null && flur.trim().length() > 0) {
                    flurstueckBuilder.append(flurstueckConjunction);
                    flurstueckBuilder.append("vfk.flur LIKE '");
                    flurstueckBuilder.append(flur);
                    flurstueckBuilder.append('\'');
                    flurstueckConjunction = " AND ";
                }
                if (zaehler != null && zaehler.trim().length() > 0) {
                    flurstueckBuilder.append(flurstueckConjunction);
                    flurstueckBuilder.append("vfk.zaehler LIKE '");
                    flurstueckBuilder.append(zaehler);
                    flurstueckBuilder.append('\'');
                    flurstueckConjunction = " AND ";
                }
                if (nenner != null && nenner.trim().length() > 0) {
                    flurstueckBuilder.append(flurstueckConjunction);
                    flurstueckBuilder.append("vfk.nenner LIKE '");
                    flurstueckBuilder.append(nenner);
                    flurstueckBuilder.append('\'');
                    flurstueckConjunction = " AND ";
                }
                if (veraenderungsart != null && veraenderungsart.trim().length() > 0) {
                    flurstueckBuilder.append(flurstueckConjunction);
                    flurstueckBuilder.append("vf.veraenderungsart::text LIKE '");
                    flurstueckBuilder.append(veraenderungsart);
                    flurstueckBuilder.append('\'');
                }
                if (flurstueckBuilder.length() <= 0) continue;
                if (!firstFlurstueck) {
                    result.append(" OR ");
                } else {
                    firstFlurstueck = false;
                }
                result.append('(');
                result.append((CharSequence)flurstueckBuilder);
                result.append(')');
            }
            result.append(')');
        }
        return result.toString();
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

