/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ObjectsPermissionsSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch,
ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(ObjectsPermissionsSearch.class);
    private static final String CLASSNAME__OBJECTPERMISSIONS = "cs_objectpermissions";
    private static final String QUERY_TEMPLATE_ALL = "SELECT (SELECT id from cs_class WHERE table_name ILIKE '%1$s'), id FROM %1$s";
    private static final String QUERY_TEMPLATE_OBJECT = "SELECT (SELECT id from cs_class WHERE table_name ILIKE '%1$s'), id FROM %1$s WHERE class_id = %2$dAND (object_id IS NULL OR object_id = %3$d)";
    private static final String QUERY_TEMPLATE_CLASS = "SELECT (SELECT id from cs_class WHERE table_name ILIKE '%1$s'), id FROM %1$s WHERE class_id = %2$d";
    private static final SearchInfo SEARCH_INFO = ObjectsPermissionsSearch.createSearchInfo();
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final Collection<MetaObjectNode> objectMons;

    public ObjectsPermissionsSearch(MetaObjectNode ... objectMons) {
        this.objectMons = objectMons != null ? Arrays.asList(objectMons) : null;
    }

    private static SearchInfo createSearchInfo() {
        return new SearchInfo(ObjectsPermissionsSearch.class.getName(), ObjectsPermissionsSearch.class.getSimpleName(), "Builtin Legacy Search to delegate the operation ObjectsPermissionsSearch to the cids Pure REST Search API.", Arrays.asList(new SearchParameterInfo[]{new MySearchParameterInfo("objectMons", Type.ENTITY_REFERENCE), new MySearchParameterInfo("searchBy", Type.UNDEFINED)}), (SearchParameterInfo)new MySearchParameterInfo("return", Type.ENTITY_REFERENCE, true));
    }

    public SearchInfo getSearchInfo() {
        return SEARCH_INFO;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection<MetaObjectNode> getObjectMons() {
        return this.objectMons;
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            Collection<MetaObjectNode> objectMonsAllDomains = this.getObjectMons();
            if (objectMonsAllDomains != null) {
                HashMap objectMonsPerDomain = new HashMap();
                for (MetaObjectNode objectMon : objectMonsAllDomains) {
                    Collection<MetaObjectNode> objectMonsSingleDomain;
                    if (objectMon == null) continue;
                    String domain = objectMon.getDomain();
                    if (objectMonsPerDomain.containsKey(domain)) {
                        objectMonsSingleDomain = (Collection)objectMonsPerDomain.get(domain);
                    } else {
                        objectMonsSingleDomain = new ArrayList();
                        objectMonsPerDomain.put(domain, objectMonsSingleDomain);
                    }
                    objectMonsSingleDomain.add(objectMon);
                }
                for (String domain : objectMonsPerDomain.keySet()) {
                    Collection objectMonsSingleDomain = (Collection)objectMonsPerDomain.get(domain);
                    ArrayList<String> subQuery = new ArrayList<String>();
                    if (objectMonsSingleDomain == null) continue;
                    for (MetaObjectNode objectMon : objectMonsSingleDomain) {
                        if (objectMon == null) continue;
                        if (objectMon.getObjectId() < 0) {
                            subQuery.add(String.format(QUERY_TEMPLATE_CLASS, CLASSNAME__OBJECTPERMISSIONS, objectMon.getClassId()));
                            continue;
                        }
                        subQuery.add(String.format(QUERY_TEMPLATE_OBJECT, CLASSNAME__OBJECTPERMISSIONS, objectMon.getClassId(), objectMon.getObjectId()));
                    }
                    String query = String.format("%s;", String.join((CharSequence)" UNION ", subQuery));
                    MetaService metaService = (MetaService)this.getActiveLocalServers().get(domain);
                    ArrayList resultList = metaService.performCustomSearch(query, this.getConnectionContext());
                    for (ArrayList al : resultList) {
                        int cid = (Integer)al.get(0);
                        int oid = (Integer)al.get(1);
                        MetaObjectNode mon = new MetaObjectNode(domain, oid, cid);
                        result.add(mon);
                    }
                }
            } else {
                MetaService metaService = (MetaService)this.getActiveLocalServers().get("?");
                String query = String.format("%s;", String.format(QUERY_TEMPLATE_ALL, CLASSNAME__OBJECTPERMISSIONS));
                ArrayList resultList = metaService.performCustomSearch(query, this.getConnectionContext());
                for (ArrayList al : resultList) {
                    int cid = (Integer)al.get(0);
                    int oid = (Integer)al.get(1);
                    MetaObjectNode mon = new MetaObjectNode("*", oid, cid);
                    result.add(mon);
                }
            }
            return result;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while searching for objects permissions", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private static class MySearchParameterInfo
    extends SearchParameterInfo {
        private MySearchParameterInfo(String key, Type type) {
            this(key, type, (Boolean)null);
        }

        private MySearchParameterInfo(String key, Type type, Boolean array) {
            super.setKey(key);
            super.setType(type);
            if (array != null) {
                super.setArray(array.booleanValue());
            }
        }
    }
}

