/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.cidsx.server.search.builtin.legacy.LightweightMetaObjectsSearch;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;

public class StrAdrStrasseLightweightSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch,
LightweightMetaObjectsSearch,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(StrAdrStrasseLightweightSearch.class);
    public static final String TOSTRING_TEMPLATE = "%1$s (%2$s)";
    public static final String[] TOSTRING_FIELDS = new String[]{Subject.NAME.toString(), Subject.SCHLUESSEL.toString()};
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final SearchInfo searchInfo;
    private Subject subject = Subject.NAME;
    private Geometry geom;
    private Integer sortDistanceLimit;
    private String representationPattern;
    private String[] representationFields;

    public StrAdrStrasseLightweightSearch() {
        this(Subject.NAME, TOSTRING_TEMPLATE, TOSTRING_FIELDS);
    }

    public StrAdrStrasseLightweightSearch(Subject subject, String representationPattern, String[] representationFields) {
        this.searchInfo = new SearchInfo(((Object)((Object)this)).getClass().getName(), ((Object)((Object)this)).getClass().getSimpleName(), "Builtin Legacy Search to delegate the operation getLightweightMetaObjectsByQuery to the cids Pure REST Search API.", Arrays.asList(new SearchParameterInfo[]{new MySearchParameterInfo("representationPattern", Type.STRING, true), new MySearchParameterInfo("representationFields", Type.STRING, true)}), (SearchParameterInfo)new MySearchParameterInfo("return", Type.ENTITY_REFERENCE, true));
        this.setRepresentationPattern(representationPattern);
        this.setRepresentationFields(representationFields);
        this.setSubject(subject);
        this.setGeom(this.geom);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private static String createUnionQuery(Subject subject, Geometry geom, Integer limitCount) {
        ArrayList<String> queries = new ArrayList<String>();
        if (geom != null) {
            queries.add(String.format("SELECT id, CASE WHEN distance IS NOT NULL THEN name || ' [' || distance::int || 'm]' ELSE name END AS name, schluessel, distance FROM (\n%s\n) AS queryA", StrAdrStrasseLightweightSearch.createQuery(subject, geom, limitCount)));
        }
        if (geom == null || limitCount != null) {
            queries.add(String.format("SELECT id, name, schluessel, 99999999 AS distance FROM (\n%s\n) AS queryB", StrAdrStrasseLightweightSearch.createQuery(subject, null, null)));
        }
        return String.format("%s\nORDER BY distance, name", String.join((CharSequence)"\nUNION\n", queries));
    }

    private static String createQuery(Subject subject, Geometry geom, Integer limitCount) {
        ArrayList<String> selectFields = new ArrayList<String>();
        ArrayList<String> leftJoins = new ArrayList<String>();
        ArrayList whereConditions = new ArrayList();
        ArrayList<String> groupBys = new ArrayList<String>();
        ArrayList<String> orderBys = new ArrayList<String>();
        String name = String.format("str_adr_strasse.%s", subject.toString());
        selectFields.add("str_adr_strasse.id AS id");
        selectFields.add(Subject.NAME.equals((Object)subject) ? "str_adr_strasse.name AS name" : "str_adr_strasse_schluessel AS name");
        selectFields.add("str_adr_strasse_schluessel.schluessel AS schluessel");
        leftJoins.add("str_adr_strasse_schluessel ON str_adr_strasse.schluessel = str_adr_strasse_schluessel.id");
        if (geom != null) {
            selectFields.add(String.format("min(st_distance(geom.geo_field, GeomFromEWKT('%s'))) AS distance", PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)geom)));
            leftJoins.add("kst_segment ON strassenschluessel = str_adr_strasse_schluessel.schluessel");
            leftJoins.add("geom ON kst_segment.geom = geom.id");
            groupBys.add("str_adr_strasse.id");
            groupBys.add("str_adr_strasse_schluessel.schluessel");
            groupBys.add(name);
            orderBys.add("distance ASC");
        }
        orderBys.add(String.format("str_adr_strasse.%s", subject.toString()));
        String select = "SELECT " + String.join((CharSequence)", ", selectFields);
        String from = "FROM str_adr_strasse" + (leftJoins.isEmpty() ? "" : "\nLEFT JOIN " + String.join((CharSequence)"\nLEFT JOIN ", leftJoins));
        String where = whereConditions.isEmpty() ? "" : " WHERE " + String.join((CharSequence)" AND ", whereConditions);
        String groupBy = groupBys.isEmpty() ? "" : "GROUP BY " + String.join((CharSequence)", ", groupBys);
        String orderBy = orderBys.isEmpty() ? "" : "ORDER BY " + String.join((CharSequence)", ", orderBys);
        String limit = limitCount != null ? String.format("LIMIT %s", Integer.toString(limitCount)) : "";
        return String.format("%s\n%s\n%s\n%s\n%s\n%s", select, from, where, groupBy, orderBy, limit);
    }

    public static void main(String[] args) throws ParseException {
        Geometry searchGeometry = new WKTReader().read("POINT(369087.00 5681046.50)");
        searchGeometry.setSRID(25832);
        System.out.println(StrAdrStrasseLightweightSearch.createUnionQuery(Subject.NAME, searchGeometry, 17));
    }

    public Collection performServerSearch() throws SearchException {
        MetaService metaService = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (metaService == null) {
            String message = "Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'";
            LOG.error((Object)"Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'");
            throw new SearchException("Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'");
        }
        String query = StrAdrStrasseLightweightSearch.createUnionQuery(this.subject, this.geom, this.sortDistanceLimit);
        try {
            MetaClass mc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"str_adr_strasse", (ConnectionContext)this.getConnectionContext());
            if (this.getRepresentationPattern() != null) {
                return Arrays.asList(metaService.getLightweightMetaObjectsByQuery(mc.getID(), this.getUser(), query, this.getRepresentationFields(), this.getRepresentationPattern(), this.getConnectionContext()));
            }
            return Arrays.asList(metaService.getLightweightMetaObjectsByQuery(mc.getID(), this.getUser(), query, this.getRepresentationFields(), this.getConnectionContext()));
        }
        catch (Exception ex) {
            throw new SearchException("error while loading lwmos", (Throwable)ex);
        }
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Geometry getGeom() {
        return this.geom;
    }

    public void setGeom(Geometry geom) {
        this.geom = geom;
    }

    public Integer getSortDistanceLimit() {
        return this.sortDistanceLimit;
    }

    public void setSortDistanceLimit(Integer sortDistanceLimit) {
        this.sortDistanceLimit = sortDistanceLimit;
    }

    public String getRepresentationPattern() {
        return this.representationPattern;
    }

    public void setRepresentationPattern(String representationPattern) {
        this.representationPattern = representationPattern;
    }

    public String[] getRepresentationFields() {
        return this.representationFields;
    }

    public void setRepresentationFields(String[] representationFields) {
        this.representationFields = representationFields;
    }

    private class MySearchParameterInfo
    extends SearchParameterInfo {
        private MySearchParameterInfo(String key, Type type) {
            this(key, type, null);
        }

        private MySearchParameterInfo(String key, Type type, Boolean array) {
            super.setKey(key);
            super.setType(type);
            if (array != null) {
                super.setArray(array.booleanValue());
            }
        }
    }

    public static enum Subject {
        NAME{

            public String toString() {
                return "name";
            }
        }
        ,
        SCHLUESSEL{

            public String toString() {
                return "schluessel";
            }
        };

    }
}

