/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.cidsx.server.search.builtin.legacy.LightweightMetaObjectsSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class VermessungFlurstueckKickerLightweightSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch,
LightweightMetaObjectsSearch,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(VermessungFlurstueckKickerLightweightSearch.class);
    public static final String FLURSTUECK_KICKER_TABLE_NAME_VIEW = "vermessung_flurstueck_kicker";
    public static final String FLURSTUECK_KICKER_TABLE_NAME = "vermessung_flurstueck_kicker";
    private static final String FLURSTUECK_GEMARKUNG = "gemarkung";
    private static final String FLURSTUECK_FLUR = "flur";
    private static final String FLURSTUECK_ZAEHLER = "zaehler";
    private static final String FLURSTUECK_NENNER = "nenner";
    private static final String VERMESSUNG_GEMARKUNG_TABLE_NAME = "vermessung_gemarkung";
    private static final String VERMESSUNG_GEMARKUNG_ID = "id";
    private static final String VERMESSUNG_GEMARKUNG_NAME = "name";
    private final SearchInfo searchInfo;
    private SearchFor searchFor;
    private String gemarkungsnummer;
    private String flur;
    private String zaehler;
    private String nenner;
    private String[] representationFields;
    private String representationPattern;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public VermessungFlurstueckKickerLightweightSearch() {
        this.searchInfo = new SearchInfo();
        this.searchInfo.setKey(((Object)((Object)this)).getClass().getName());
        this.searchInfo.setName(((Object)((Object)this)).getClass().getSimpleName());
        this.searchInfo.setDescription("Builtin Legacy Search to delegate the operation getLightweightMetaObjectsByQuery to the cids Pure REST Search API.");
        LinkedList<SearchParameterInfo> parameterDescription = new LinkedList<SearchParameterInfo>();
        SearchParameterInfo searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("gemarkungsnummer");
        searchParameterInfo.setType(Type.STRING);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey(FLURSTUECK_FLUR);
        searchParameterInfo.setType(Type.STRING);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey(FLURSTUECK_ZAEHLER);
        searchParameterInfo.setType(Type.STRING);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey(FLURSTUECK_NENNER);
        searchParameterInfo.setType(Type.STRING);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("searchFor");
        searchParameterInfo.setType(Type.UNDEFINED);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("representationFields");
        searchParameterInfo.setType(Type.STRING);
        searchParameterInfo.setArray(true);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("representationPattern");
        searchParameterInfo.setType(Type.STRING);
        parameterDescription.add(searchParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        SearchParameterInfo resultParameterInfo = new SearchParameterInfo();
        resultParameterInfo.setKey("return");
        resultParameterInfo.setArray(true);
        resultParameterInfo.setType(Type.ENTITY_REFERENCE);
        this.searchInfo.setResultDescription(resultParameterInfo);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        if (this.searchFor != null) {
            String query;
            MetaClass metaClassToUse;
            MetaClass vermessungsGemarkungenMetaClass;
            MetaClass flurstueckKickerMetaClass;
            MetaService metaService = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
            if (metaService == null) {
                String message = "Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'";
                LOG.error((Object)"Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'");
                throw new SearchException("Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'");
            }
            try {
                flurstueckKickerMetaClass = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"vermessung_flurstueck_kicker", (ConnectionContext)this.getConnectionContext());
                vermessungsGemarkungenMetaClass = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)VERMESSUNG_GEMARKUNG_TABLE_NAME, (ConnectionContext)this.getConnectionContext());
            }
            catch (Exception ex) {
                throw new SearchException("error while loadomg metaclass", (Throwable)ex);
            }
            switch (this.searchFor) {
                case ALLE_FLUSTUECKE: {
                    metaClassToUse = flurstueckKickerMetaClass;
                    query = "select id,gemarkung,flur,zaehler,nenner from vermessung_flurstueck_kicker order by gemarkung, flur, zaehler, nenner";
                    break;
                }
                case FLURSTUECKE: {
                    metaClassToUse = flurstueckKickerMetaClass;
                    if (this.getGemarkungsnummer() == null) {
                        throw new SearchException("gemarkung has to be set");
                    }
                    if (this.getFlur() == null) {
                        throw new SearchException("flur has to be set");
                    }
                    if (this.getZaehler() == null) {
                        throw new SearchException("zaehler has to be set");
                    }
                    if (this.getNenner() == null) {
                        throw new SearchException("nenner has to be set");
                    }
                    query = "select id, gemarkung,flur,zaehler,nenner from vermessung_flurstueck_kicker where gemarkung = " + this.getGemarkungsnummer() + " and " + FLURSTUECK_FLUR + " = '" + this.getFlur() + "' and " + FLURSTUECK_ZAEHLER + " = '" + this.getZaehler() + "' and " + FLURSTUECK_NENNER + " = '" + this.getNenner() + "'";
                    break;
                }
                case ALLE_GEMARKUNGEN: {
                    metaClassToUse = vermessungsGemarkungenMetaClass;
                    query = "select  f.gemarkung as id, f.gemarkung, min(g.name) as name from vermessung_flurstueck_kicker f join vermessung_gemarkung g on f.gemarkung = g.id group by f.gemarkung order by f.gemarkung";
                    break;
                }
                case GEMARKUNG: {
                    metaClassToUse = vermessungsGemarkungenMetaClass;
                    if (this.getGemarkungsnummer() == null) {
                        throw new SearchException("gemarkung has to be set");
                    }
                    query = "select * from vermessung_gemarkung where id = " + this.getGemarkungsnummer();
                    break;
                }
                case FLURE: {
                    metaClassToUse = flurstueckKickerMetaClass;
                    if (this.getGemarkungsnummer() == null) {
                        throw new SearchException("gemarkung has to be set");
                    }
                    query = "select min(id) as id, flur from vermessung_flurstueck_kicker where gemarkung = " + this.getGemarkungsnummer() + " group by " + FLURSTUECK_FLUR + " order by " + FLURSTUECK_FLUR;
                    break;
                }
                case ZAEHLER_NENNER: {
                    metaClassToUse = flurstueckKickerMetaClass;
                    if (this.getGemarkungsnummer() == null) {
                        throw new SearchException("gemarkung has to be set");
                    }
                    if (this.getFlur() == null) {
                        throw new SearchException("flur has to be set");
                    }
                    query = "select min(id) as id, zaehler, nenner, flur, gemarkung from vermessung_flurstueck_kicker where gemarkung = " + this.getGemarkungsnummer() + " and " + FLURSTUECK_FLUR + " = '" + this.getFlur() + "' group by " + FLURSTUECK_ZAEHLER + ", " + FLURSTUECK_NENNER + ", " + FLURSTUECK_FLUR + ", " + FLURSTUECK_GEMARKUNG;
                    break;
                }
                default: {
                    metaClassToUse = flurstueckKickerMetaClass;
                    query = null;
                }
            }
            try {
                if (this.getRepresentationPattern() != null) {
                    return Arrays.asList(metaService.getLightweightMetaObjectsByQuery(metaClassToUse.getID(), this.getUser(), query, this.getRepresentationFields(), this.getRepresentationPattern(), this.getConnectionContext()));
                }
                return Arrays.asList(metaService.getLightweightMetaObjectsByQuery(metaClassToUse.getID(), this.getUser(), query, this.getRepresentationFields(), this.getConnectionContext()));
            }
            catch (RemoteException ex) {
                throw new SearchException("error while loading lwmos (MetaClass:+" + metaClassToUse.getID() + ", Query:" + query + ")", (Throwable)ex);
            }
        }
        throw new SearchException("searchFor has to be set");
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public SearchFor getSearchFor() {
        return this.searchFor;
    }

    public void setSearchFor(SearchFor searchFor) {
        this.searchFor = searchFor;
    }

    public String getGemarkungsnummer() {
        return this.gemarkungsnummer;
    }

    public void setGemarkungsnummer(String gemarkungsnummer) {
        this.gemarkungsnummer = gemarkungsnummer;
    }

    public String getFlur() {
        return this.flur;
    }

    public void setFlur(String flur) {
        this.flur = flur;
    }

    public String getZaehler() {
        return this.zaehler;
    }

    public void setZaehler(String zaehler) {
        this.zaehler = zaehler;
    }

    public String getNenner() {
        return this.nenner;
    }

    public void setNenner(String nenner) {
        this.nenner = nenner;
    }

    public String[] getRepresentationFields() {
        return this.representationFields;
    }

    public void setRepresentationFields(String[] representationFields) {
        this.representationFields = representationFields;
    }

    public String getRepresentationPattern() {
        return this.representationPattern;
    }

    public void setRepresentationPattern(String representationPattern) {
        this.representationPattern = representationPattern;
    }

    public static enum SearchFor {
        ALLE_FLUSTUECKE,
        FLURSTUECKE,
        ALLE_GEMARKUNGEN,
        GEMARKUNG,
        FLURE,
        ZAEHLER_NENNER;

    }
}

