/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wunda_blau.search.server.RestApiMonGeometrySearch;
import de.cismet.cids.custom.wunda_blau.search.server.RestApiMonSearch;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;

public class WohnlagenKategorisierungMonSearch
extends RestApiMonGeometrySearch {
    private static final transient Logger LOG = Logger.getLogger(WohnlagenKategorisierungMonSearch.class);

    public WohnlagenKategorisierungMonSearch() {
        this(null, null, null);
    }

    public WohnlagenKategorisierungMonSearch(Double cutoff) {
        this(cutoff, null, null);
    }

    public WohnlagenKategorisierungMonSearch(Double cutoff, Double buffer) {
        this(cutoff, null, buffer);
    }

    public WohnlagenKategorisierungMonSearch(Double cutoff, Geometry geometry) {
        this(cutoff, geometry, null);
    }

    public WohnlagenKategorisierungMonSearch(Double cutoff, Geometry geometry, Double buffer) {
        this.setCutoff(cutoff);
        this.setGeometry(geometry);
        this.setBuffer(buffer);
        this.setSearchInfo(new SearchInfo(this.getClass().getName(), this.getClass().getSimpleName(), "Builtin Legacy Search to delegate the operation Wohnlagenkategorisierung to the cids Pure REST Search API.", Arrays.asList(new SearchParameterInfo[]{new RestApiMonSearch.MySearchParameterInfo("searchFor", Type.STRING), new RestApiMonSearch.MySearchParameterInfo("geom", Type.UNDEFINED)}), (SearchParameterInfo)new RestApiMonSearch.MySearchParameterInfo("return", Type.ENTITY_REFERENCE, true)));
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            String geomCondition;
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            Geometry geometry = this.getGeometry();
            if (geometry != null) {
                String geomString = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)geometry);
                geomCondition = "(geom.geo_field && st_GeometryFromText('" + geomString + "') AND st_intersects(" + (this.getBuffer() != null ? "st_buffer(st_GeometryFromText('" + geomString + "'), " + this.getBuffer() + ")" : "geo_field") + ", geo_field))";
            } else {
                geomCondition = null;
            }
            String area = geometry != null ? String.format("st_area(st_intersection(geom.geo_field, st_GeometryFromText('%1$s')))", PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)geometry)) : "st_area(geom.geo_field)";
            Double cutoff = this.getCutoff();
            String query = "SELECT * FROM ( SELECT   (SELECT id FROM cs_class WHERE table_name ILIKE 'wohnlage_kategorie') AS class_id,   object_id,   min(object_name),   sum(area) FROM (   SELECT     " + area + " AS area,     wohnlage_kategorie.id AS object_id,     wohnlage_kategorie.name AS object_name   FROM wohnlage_flaeche   LEFT JOIN wohnlage_kategorie ON wohnlage_kategorie.id = wohnlage_flaeche.fk_wohnlage_kategorie   " + (geomCondition != null ? "LEFT JOIN geom ON geom.id = wohnlage_flaeche.fk_geom " : " ") + "  " + (geomCondition != null ? "WHERE " + geomCondition : " ") + ") AS sub GROUP BY object_id ORDER BY sum(area) DESC ) AS sub2 " + (geometry != null && cutoff != null ? " WHERE sum >= " + geometry.getArea() * cutoff : "") + ";";
            if (query != null) {
                MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
                ArrayList resultList = ms.performCustomSearch(query, this.getConnectionContext());
                for (ArrayList al : resultList) {
                    int cid = (Integer)al.get(0);
                    int oid = (Integer)al.get(1);
                    String name = (String)al.get(2);
                    result.add(new MetaObjectNode("WUNDA_BLAU", oid, cid, name, null, null));
                }
            }
            return result;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while searching for wohnlagenkategorisierung object", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

