/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.startuphooks;

import de.cismet.cids.custom.utils.motd.MotdRetriever;
import de.cismet.cids.custom.utils.motd.MotdRetrieverListener;
import de.cismet.cids.custom.utils.motd.MotdRetrieverListenerEvent;
import de.cismet.cids.custom.wunda_blau.startuphooks.AbstractWundaBlauStartupHook;
import de.cismet.cids.server.messages.CidsServerMessageManagerImpl;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class MotdStartupHook
extends AbstractWundaBlauStartupHook {
    private static final transient Logger LOG = Logger.getLogger(MotdStartupHook.class);
    public static final String MOTD_MESSAGE_TOTD = "totd";
    public static final String MOTD_MESSAGE_TOTD_EXTERN = "totd_extern";
    public static final String MOTD_MESSAGE_MOTD = "motd";
    public static final String MOTD_MESSAGE_MOTD_EXTERN = "motd_extern";

    public void domainServerStarted() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MotdStartupHook.this.waitForMetaService();
                    MotdRetriever retriever = new MotdRetriever(MotdStartupHook.this.getProperties());
                    if (retriever.init(MotdStartupHook.this.getDomain())) {
                        retriever.addMotdRetrieverListener(new MotdRetrieverListener(){

                            @Override
                            public void totdChanged(MotdRetrieverListenerEvent event) {
                                if (event.isExtern()) {
                                    CidsServerMessageManagerImpl.getInstance().publishMessage(MotdStartupHook.MOTD_MESSAGE_TOTD_EXTERN, (Object)event.getContent(), true, MotdStartupHook.this.getConnectionContext());
                                } else {
                                    CidsServerMessageManagerImpl.getInstance().publishMessage(MotdStartupHook.MOTD_MESSAGE_TOTD, (Object)event.getContent(), true, MotdStartupHook.this.getConnectionContext());
                                }
                            }

                            @Override
                            public void motdChanged(MotdRetrieverListenerEvent event) {
                                if (event.isExtern()) {
                                    CidsServerMessageManagerImpl.getInstance().publishMessage(MotdStartupHook.MOTD_MESSAGE_MOTD_EXTERN, (Object)event.getContent(), false, MotdStartupHook.this.getConnectionContext());
                                } else {
                                    CidsServerMessageManagerImpl.getInstance().publishMessage(MotdStartupHook.MOTD_MESSAGE_MOTD, (Object)event.getContent(), false, MotdStartupHook.this.getConnectionContext());
                                }
                            }
                        });
                        retriever.start();
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)"Error while initializing the MotdRetriever !", (Throwable)ex);
                }
            }
        }).start();
    }

    public abstract Properties getProperties() throws Exception;

    @Override
    public abstract String getDomain();
}

