/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.deletionprovider;

import Sirius.server.localserver.object.AbstractCustomDeletionProvider;
import Sirius.server.localserver.object.DeletionProviderClientException;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BaumSorteDeletionProvider
extends AbstractCustomDeletionProvider {
    private static final Logger LOG = Logger.getLogger(BaumSorteDeletionProvider.class);
    private static final String TABLE_NAME = "baum_sorte";
    private static final String FIELD__ID = "id";
    private static final String FIELD__FK = "fk_sorte";
    private static final String TABLE_NAME_SEARCH_E = "baum_ersatzbaum";
    private static final String DELETE_TEXT = "Diese Sorte kann nicht gel\u00f6scht werden, da diese verwendet wird.";

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isMatching(User user, MetaObject metaObject) {
        if (!super.isMatching(user, metaObject)) {
            return false;
        }
        CidsBean sorteBean = metaObject.getBean();
        Integer sorte_id = (Integer)sorteBean.getProperty(FIELD__ID);
        String queryArtInErsatz = String.format("SELECT * FROM %s WHERE %s = %d;", TABLE_NAME_SEARCH_E, FIELD__FK, sorte_id);
        try {
            ArrayList artArrayE = this.getMetaService().performCustomSearch(queryArtInErsatz, this.getConnectionContext());
            if (!artArrayE.isEmpty()) {
                return true;
            }
        }
        catch (RemoteException ex) {
            LOG.error((Object)"Cannot delete sorte object", (Throwable)ex);
        }
        return false;
    }

    public boolean customDeleteMetaObject(User user, MetaObject metaObject) throws Exception {
        throw new DeletionProviderClientException(DELETE_TEXT);
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

