/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.deletionprovider;

import Sirius.server.localserver.object.AbstractCustomDeletionProvider;
import Sirius.server.localserver.object.DeletionProviderClientException;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class PfSchluesseltabelleDeletionProvider
extends AbstractCustomDeletionProvider {
    private static final Logger LOG = Logger.getLogger(PfSchluesseltabelleDeletionProvider.class);
    public static final String TABLE_NAME = "pf_schluesseltabelle";
    private static final String STILL_USED = "Dieser Eintrag darf nicht gel\u00f6scht werden, da er noch referenziert wird verwendet wird.";
    private static final String SYSTEM_TABLE = "Die Eintr\u00e4ge zu den Schl\u00fcsseltabellen d\u00fcrfen nicht gel\u00f6scht werden.";
    private static final String TABLENAMES_TEMPLATE = "SELECT DISTINCT table_name FROM %s;";
    private static final String QUERY_TEMPLATE = "SELECT * FROM selexecute((  SELECT 'SELECT   sub.table_name AS table_name,   count(sub.object_id) AS num_of FROM (  ' || array_to_string(array_agg('SELECT ' || sub.field_name || '::bigint AS object_id, ''' || sub.table_name || '''::text AS table_name FROM ' || sub.table_name), ' UNION ') || ' ) AS sub WHERE sub.object_id = ' || %2$d || ' GROUP BY sub.table_name ' AS execution_query   FROM (    SELECT DISTINCT class.table_name, attr.field_name     FROM       cs_class AS class,       cs_attr AS attr     WHERE       attr.class_id = class.id       AND attr.foreign_key_references_to = %1$d   ) AS sub )) AS (table_name text, num_of bigint);";
    private final Set<String> matchingTableNames = new HashSet<String>();
    private boolean initalized = false;

    public final void refreshMatchingTableNames() throws Exception {
        String query = String.format(TABLENAMES_TEMPLATE, TABLE_NAME);
        ArrayList result = this.getMetaService().performCustomSearch(query, this.getConnectionContext());
        for (List row : result) {
            if (row == null) continue;
            String tableName = (String)row.get(0);
            this.matchingTableNames.add(tableName);
        }
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMatching(User user, MetaObject metaObject) {
        if (!super.isMatching(user, metaObject)) {
            return false;
        }
        if (!this.initalized) {
            Set<String> set = this.matchingTableNames;
            synchronized (set) {
                try {
                    this.refreshMatchingTableNames();
                }
                catch (Throwable ex) {
                    LOG.error((Object)ex, ex);
                }
                finally {
                    this.initalized = true;
                }
            }
        }
        return metaObject != null && metaObject.getMetaClass() != null && metaObject.getMetaClass().getTableName() != null && this.matchingTableNames.contains(metaObject.getMetaClass().getTableName());
    }

    public boolean customDeleteMetaObject(User user, MetaObject metaObject) throws Exception {
        if (metaObject != null) {
            if (metaObject.getMetaClass().getTableName().equalsIgnoreCase(TABLE_NAME)) {
                throw new DeletionProviderClientException(SYSTEM_TABLE);
            }
            int objectId = metaObject.getId();
            int classId = metaObject.getClassID();
            String query = String.format(QUERY_TEMPLATE, classId, objectId);
            ArrayList result = this.getMetaService().performCustomSearch(query, this.getConnectionContext());
            if (result.size() > 0) {
                throw new DeletionProviderClientException(STILL_USED);
            }
        }
        return false;
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

