/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.deletionprovider;

import Sirius.server.localserver.object.AbstractCustomDeletionProvider;
import Sirius.server.localserver.object.DeletionProviderClientException;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class UaLeistungenDeletionProvider
extends AbstractCustomDeletionProvider {
    private static final Logger LOG = Logger.getLogger(UaLeistungenDeletionProvider.class);
    private static final String TABLE_NAME = "ua_leistungen";
    private static final String FIELD__ID = "id";
    private static final String FIELD__FK = "fk_leistungen";
    private static final String TABLE_NAME_SEARCH = "ua_firma_leistungen_leistungen";
    private static final String CAUSE = "Diese Leistung kann nicht gel\u00f6scht werden, da diese bei mindestens einem Einsatz verwendet wird.";
    private String deleteText = "Diese Leistung kann nicht gel\u00f6scht werden, da diese verwendet wird.";

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isMatching(User user, MetaObject metaObject) {
        if (!super.isMatching(user, metaObject)) {
            return false;
        }
        CidsBean leistBean = metaObject.getBean();
        Integer leist_id = leistBean.getPrimaryKeyValue();
        String queryLeistIn = String.format("SELECT * FROM %s WHERE %s = %d;", TABLE_NAME_SEARCH, FIELD__FK, leist_id);
        try {
            ArrayList leistArray = this.getMetaService().performCustomSearch(queryLeistIn, this.getConnectionContext());
            if (!leistArray.isEmpty()) {
                this.deleteText = CAUSE;
                return true;
            }
        }
        catch (RemoteException ex) {
            LOG.error((Object)"Cannot delete Leistung object", (Throwable)ex);
        }
        return false;
    }

    public boolean customDeleteMetaObject(User user, MetaObject metaObject) throws Exception {
        throw new DeletionProviderClientException(this.deleteText);
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

