/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.deletionprovider;

import Sirius.server.localserver.object.AbstractCustomDeletionProvider;
import Sirius.server.localserver.object.DeletionProviderClientException;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class VkKontaktDeletionProvider
extends AbstractCustomDeletionProvider {
    private static final Logger LOG = Logger.getLogger(VkKontaktDeletionProvider.class);
    private static final String TABLE_NAME = "vk_kontakt";
    private static final String FIELD__FK = "fk_kontakt";
    private static final String TABLE_NAME_SEARCH = "vk_vorhaben";
    private static final String CAUSE = "Dieser Kontakt kann nicht gel\u00f6scht werden, da dieser bei mindestens einem Vorhaben verwendet wird.";
    private String deleteText = "Dieser Kontakt kann nicht gel\u00f6scht werden, da dieser verwendet wird.";

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isMatching(User user, MetaObject metaObject) {
        if (!super.isMatching(user, metaObject)) {
            return false;
        }
        CidsBean kontaktBean = metaObject.getBean();
        Integer kontakt_id = kontaktBean.getPrimaryKeyValue();
        String queryKontakt = String.format("SELECT * FROM %s WHERE %s = %d;", TABLE_NAME_SEARCH, FIELD__FK, kontakt_id);
        try {
            ArrayList kontaktArray = this.getMetaService().performCustomSearch(queryKontakt, this.getConnectionContext());
            if (!kontaktArray.isEmpty()) {
                this.deleteText = CAUSE;
                return true;
            }
        }
        catch (RemoteException ex) {
            LOG.error((Object)"Cannot delete Kontakt object", (Throwable)ex);
        }
        return false;
    }

    public boolean customDeleteMetaObject(User user, MetaObject metaObject) throws Exception {
        throw new DeletionProviderClientException(this.deleteText);
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

