/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils;

import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AlboProperties {
    private static final transient Logger LOG = Logger.getLogger(AlboProperties.class);
    protected static final WundaBlauServerResources SERVER_RESOURCE = WundaBlauServerResources.ALBO_PROPERTIES;
    private static final int DEFAULT_VORGANG_MAP_DPI = 300;
    private static final int DEFAULT_VORGANG_MAP_WIDTH = 275;
    private static final int DEFAULT_VORGANG_MAP_HEIGHT = 130;
    private static final String DEFAULT_EXPORT_TMP_ABS_PATH = "/tmp";
    private static final String DEFAULT_EXPORT_VIEW_NAME = "view_albo_export";
    private static final String DEFAULT_EXPORT_ORDERBY_FIELD = "id";
    private static final String DEFAULT_EXPORT_ROWID_FIELD = "id";
    private static final String DEFAULT_WRT_PROJECTION = "PROJCS[\"ETRS_1989_UTM_Zone_32N\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]";
    private final Properties properties;
    private final String flaecheMapUrl;
    private final Integer flaecheMapWidth;
    private final Integer flaecheMapHeight;
    private final Integer flaecheMapDpi;
    private final String wzKlassifikationLink;
    private final String vorgangMapUrl;
    private final Integer vorgangMapWidth;
    private final Integer vorgangMapHeight;
    private final Integer vorgangMapDpi;
    private final String exportTmpAbsPath;
    private final String exportViewName;
    private final String exportOrderbyField;
    private final String exportRowidField;
    private final String wrtProjection;

    protected AlboProperties(Properties properties) {
        this.properties = properties;
        this.flaecheMapUrl = this.valueOfString("flaecheMapUrl", null);
        this.flaecheMapWidth = this.valueOfInteger("flaecheMapWidth", null);
        this.flaecheMapHeight = this.valueOfInteger("flaecheMapHeight", null);
        this.flaecheMapDpi = this.valueOfInteger("flaecheMapDpi", null);
        this.wzKlassifikationLink = this.valueOfString("wz_klassifikation_link", null);
        this.vorgangMapUrl = this.valueOfString("vorgang_map_url", null);
        this.vorgangMapDpi = this.valueOfInteger("vorgang_map_dpi", 300);
        this.vorgangMapWidth = this.valueOfInteger("vorgang_map_width", 275);
        this.vorgangMapHeight = this.valueOfInteger("vorgang_map_height", 130);
        this.exportTmpAbsPath = this.valueOfString("export_tmp_abs_path", DEFAULT_EXPORT_TMP_ABS_PATH);
        this.exportViewName = this.valueOfString("export_view_name", DEFAULT_EXPORT_VIEW_NAME);
        this.exportOrderbyField = this.valueOfString("export_orderby_field", "id");
        this.exportRowidField = this.valueOfString("export_rowid_field", "id");
        this.wrtProjection = this.valueOfString("wrtProjection", DEFAULT_WRT_PROJECTION);
    }

    public String getColorOfArt(String art) {
        return art != null ? this.valueOfString(String.format("%s_color", art), null) : null;
    }

    public static AlboProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public final String valueOfString(String property, String defaultValue) {
        String value = defaultValue;
        if (this.properties.getProperty(property) != null) {
            value = this.properties.getProperty(property);
        }
        return value;
    }

    public final Integer valueOfInteger(String property, Integer defaultValue) {
        Integer value = defaultValue;
        try {
            value = Integer.valueOf(this.properties.getProperty(property));
        }
        catch (Exception ex) {
            LOG.warn((Object)String.format("value of %s is set to %s and can't be cast to Integer.", property, this.properties.getProperty(property)), (Throwable)ex);
        }
        return value;
    }

    public final Boolean valueOfBoolean(String property, Boolean defaultValue) {
        Boolean value = defaultValue;
        try {
            value = Boolean.valueOf(this.properties.getProperty(property));
        }
        catch (Exception ex) {
            LOG.warn((Object)String.format("value of %s is set to %s and can't be cast to Boolean.", property, this.properties.getProperty(property)), (Throwable)ex);
        }
        return value;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getFlaecheMapUrl() {
        return this.flaecheMapUrl;
    }

    public Integer getFlaecheMapWidth() {
        return this.flaecheMapWidth;
    }

    public Integer getFlaecheMapHeight() {
        return this.flaecheMapHeight;
    }

    public Integer getFlaecheMapDpi() {
        return this.flaecheMapDpi;
    }

    public String getWzKlassifikationLink() {
        return this.wzKlassifikationLink;
    }

    public String getVorgangMapUrl() {
        return this.vorgangMapUrl;
    }

    public Integer getVorgangMapWidth() {
        return this.vorgangMapWidth;
    }

    public Integer getVorgangMapHeight() {
        return this.vorgangMapHeight;
    }

    public Integer getVorgangMapDpi() {
        return this.vorgangMapDpi;
    }

    public String getExportTmpAbsPath() {
        return this.exportTmpAbsPath;
    }

    public String getExportViewName() {
        return this.exportViewName;
    }

    public String getExportOrderbyField() {
        return this.exportOrderbyField;
    }

    public String getExportRowidField() {
        return this.exportRowidField;
    }

    public String getWrtProjection() {
        return this.wrtProjection;
    }

    private static final class LazyInitialiser {
        private static final AlboProperties INSTANCE;

        private LazyInitialiser() {
        }

        public static AlboProperties getNewInstance() {
            try {
                return new AlboProperties(ServerResourcesLoader.getInstance().loadProperties(SERVER_RESOURCE.getValue()));
            }
            catch (Throwable ex) {
                throw new RuntimeException("Exception while initializing AlboProperties", ex);
            }
        }

        static {
            try {
                INSTANCE = LazyInitialiser.getNewInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception while initializing AlboProperties", ex);
            }
        }
    }
}

