/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.newuser.User;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.custom.utils.BaumMapImageFactoryConfiguration;
import de.cismet.cids.custom.utils.BaumProperties;
import de.cismet.cids.custom.utils.ByteArrayFactoryHandler;
import de.cismet.cids.custom.wunda_blau.search.server.BaumChildLightweightSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.SearchException;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.log4j.Logger;
import org.openide.util.Exceptions;

public class BaumMeldungReportScriptlet
extends JRDefaultScriptlet
implements ConnectionContextProvider {
    protected static final Logger LOG = Logger.getLogger(BaumMeldungReportScriptlet.class);
    private static final String CHILD_TOSTRING_TEMPLATE = "%s";
    private static final String TABLE_GEBIET = "baum_gebiet";
    private static final String TABLE_MELDUNG = "baum_meldung";
    private static final String TABLE_SCHADEN = "baum_schaden";
    private static final String TABLE_OT = "baum_ortstermin";
    private static final String TABLE_OT_TEIL = "baum_teilnehmer";
    private static final String TABLE_ARRAY = "baum_meldung_ansprechpartner";
    private static final String TABLE_OT_AP = "baum_ortstermin_ansprechpartner";
    private static final String TABLE_AP_TEL = "baum_telefon";
    private static final String TABLE_S_KRONE = "baum_schaden_krone";
    private static final String TABLE_S_STAMM = "baum_schaden_stamm";
    private static final String TABLE_S_WURZEL = "baum_schaden_wurzel";
    private static final String TABLE_S_MASS = "baum_schaden_massnahme";
    private static final String TABLE_FEST = "baum_festsetzung";
    private static final String TABLE_ERSATZ = "baum_ersatz";
    private static final String TABLE_ERSATZBAUM = "baum_ersatzbaum";
    private static final String TABLE_KONTROLLE = "baum_kontrolle";
    private static final String[] CHILD_TOSTRING_FIELDS = new String[]{"id"};
    private static final String FIELD__REFERENCE_MELDUNG = "baum_meldung_reference";
    private static final String FIELD__MELDUNG = "fk_meldung";
    private static final String FIELD__OT = "fk_ortstermin";
    private static final String FIELD__REFERENCE_OT = "baum_ortstermin_reference";
    private static final String FIELD__REFERENCE_S = "baum_schaden_reference";
    private static final String FIELD__GEBIET = "fk_gebiet";
    private static final String FIELD__AP = "fk_ansprechpartner";
    private static final String FIELD__NAME = "name";
    private static final String FIELD__KRONE = "fk_krone";
    private static final String FIELD__STAMM = "fk_stamm";
    private static final String FIELD__WURZEL = "fk_wurzel";
    private static final String FIELD__MASS = "fk_massnahme";
    private static final String FIELD__SCHADEN = "fk_schaden";
    private static final String FIELD__ERSATZ = "fk_ersatz";
    private static final String FIELD__GEOM = "fk_geom";
    private static final String FIELD__GEOM_GEO_FIELD = "fk_geom.geo_field";
    private static final int DEFAULT_MAP_DPI = 300;
    private static final int DEFAULT_BUFFER = 50;
    private static final int DEFAULT_MAP_WIDTH = 300;
    private static final int DEFAULT_MAP_HEIGHT = 200;
    private static final String DEFAULT__SRS = "EPSG:25832";
    private static final double DEFAULT__HOME_X1 = 6.7;
    private static final double DEFAULT__HOME_Y1 = 49.1;
    private static final double DEFAULT__HOME_X2 = 7.1;
    private static final double DEFAULT__HOME_Y2 = 49.33;
    private static final String DEFAULT_COLOR = "#888888";
    private static final String BAUM_MAP_IMAGE_FACTORY = "de.cismet.cids.custom.reports.wunda_blau.BaumMapImageFactory";
    private final BaumChildLightweightSearch searchChild = new BaumChildLightweightSearch("%s", CHILD_TOSTRING_FIELDS, "baum_meldung", "fk_gebiet");
    private final MetaService metaService;
    private final User user;
    private final Map<Integer, MetaObjectNode> beansSchadenMap = new HashMap<Integer, MetaObjectNode>();
    private final Map<Integer, MetaObjectNode> beansErsatzMap = new HashMap<Integer, MetaObjectNode>();
    private final Map<Integer, MetaObjectNode> beansFestMap = new HashMap<Integer, MetaObjectNode>();
    private final Map<Integer, MetaObjectNode> beansBaumMap = new HashMap<Integer, MetaObjectNode>();
    private final ConnectionContext connectionContext;

    public BaumMeldungReportScriptlet(MetaService metaService, User user, ConnectionContext connectionContext) {
        this.metaService = metaService;
        this.user = user;
        this.connectionContext = connectionContext;
    }

    public JRDataSource getChildrenFrom(int idGebiet) throws SearchException {
        this.searchChild.setParentId(idGebiet);
        this.searchChild.setFkField(FIELD__GEBIET);
        this.searchChild.setTable(TABLE_MELDUNG);
        this.searchChild.setRepresentationFields(CHILD_TOSTRING_FIELDS);
        HashMap<String, MetaService> map = new HashMap<String, MetaService>();
        map.put("WUNDA_BLAU", this.metaService);
        this.searchChild.setActiveLocalServers(map);
        Collection mons = this.searchChild.performServerSearch();
        ArrayList beansMeldung = new ArrayList();
        if (!mons.isEmpty()) {
            mons.forEach(mon -> {
                try {
                    MetaObject mo = this.metaService.getMetaObject(this.user, mon.getObjectId(), mon.getClassId(), this.getConnectionContext());
                    beansMeldung.add(mo.getBean());
                }
                catch (RemoteException e) {
                    LOG.error((Object)"Error while retrieving meta object", (Throwable)e);
                }
            });
        }
        JRBeanCollectionDataSource meldungenDataSource = new JRBeanCollectionDataSource(beansMeldung);
        return meldungenDataSource;
    }

    public JRDataSource getMeldungen(int idGebiet) throws SearchException {
        this.searchChild.setParentId(idGebiet);
        this.searchChild.setFkField(FIELD__GEBIET);
        this.searchChild.setTable(TABLE_MELDUNG);
        return this.getChildren();
    }

    public JRDataSource getSchaeden(int idMeldung) throws SearchException {
        this.searchChild.setParentId(idMeldung);
        this.searchChild.setFkField(FIELD__MELDUNG);
        this.searchChild.setTable(TABLE_SCHADEN);
        return this.getChildren();
    }

    public JRDataSource getFestsetzungen(int idSchaden) throws SearchException {
        this.searchChild.setParentId(idSchaden);
        this.searchChild.setFkField(FIELD__SCHADEN);
        this.searchChild.setTable(TABLE_FEST);
        return this.getChildren();
    }

    public JRDataSource getErsatzpflanzungen(int idSchaden) throws SearchException {
        this.searchChild.setParentId(idSchaden);
        this.searchChild.setFkField(FIELD__SCHADEN);
        this.searchChild.setTable(TABLE_ERSATZ);
        return this.getChildren();
    }

    public JRDataSource getErsatzbaeume(int idErsatz) throws SearchException {
        this.searchChild.setParentId(idErsatz);
        this.searchChild.setFkField(FIELD__ERSATZ);
        this.searchChild.setTable(TABLE_ERSATZBAUM);
        return this.getChildren();
    }

    public JRDataSource getKontrollen(int idErsatz) throws SearchException {
        this.searchChild.setParentId(idErsatz);
        this.searchChild.setFkField(FIELD__ERSATZ);
        this.searchChild.setTable(TABLE_KONTROLLE);
        return this.getChildren();
    }

    public JRDataSource getAps(int idMeldung) throws SearchException {
        this.searchChild.setParentId(idMeldung);
        this.searchChild.setFkField(FIELD__REFERENCE_MELDUNG);
        this.searchChild.setTable(TABLE_ARRAY);
        this.searchChild.setRepresentationFields(CHILD_TOSTRING_FIELDS);
        HashMap<String, MetaService> map = new HashMap<String, MetaService>();
        map.put("WUNDA_BLAU", this.metaService);
        this.searchChild.setActiveLocalServers(map);
        Collection mons = this.searchChild.performServerSearch();
        ArrayList beansAps = new ArrayList();
        if (!mons.isEmpty()) {
            mons.forEach(mon -> {
                try {
                    MetaObject mo = this.metaService.getMetaObject(this.user, mon.getObjectId(), mon.getClassId(), this.getConnectionContext());
                    CidsBean arrayBean = mo.getBean();
                    CidsBean apBean = (CidsBean)arrayBean.getProperty(FIELD__AP);
                    beansAps.add(apBean);
                }
                catch (RemoteException e) {
                    LOG.error((Object)"Error while retrieving meta object", (Throwable)e);
                }
            });
        }
        JRBeanCollectionDataSource apsDataSource = new JRBeanCollectionDataSource(beansAps);
        return apsDataSource;
    }

    public List<CidsBean> getChildrenBeans(String fk) {
        HashMap<String, MetaService> map = new HashMap<String, MetaService>();
        map.put("WUNDA_BLAU", this.metaService);
        this.searchChild.setActiveLocalServers(map);
        ArrayList<CidsBean> beansChildren = new ArrayList<CidsBean>();
        try {
            Collection mons = this.searchChild.performServerSearch();
            if (!mons.isEmpty()) {
                mons.forEach(mon -> {
                    try {
                        MetaObject mo = this.metaService.getMetaObject(this.user, mon.getObjectId(), mon.getClassId(), this.getConnectionContext());
                        CidsBean arrayBean = mo.getBean();
                        CidsBean childBean = (CidsBean)arrayBean.getProperty(fk);
                        beansChildren.add(childBean);
                    }
                    catch (RemoteException e) {
                        LOG.error((Object)"Error while retrieving meta object", (Throwable)e);
                    }
                });
            }
        }
        catch (SearchException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return beansChildren;
    }

    public JRDataSource getChildrenOverArray(String fk) throws SearchException {
        List<CidsBean> beansChildren = this.getChildrenBeans(fk);
        JRBeanCollectionDataSource childrenDataSource = new JRBeanCollectionDataSource(beansChildren);
        return childrenDataSource;
    }

    public JRDataSource getOtAps(int id) throws SearchException {
        this.searchChild.setParentId(id);
        this.searchChild.setFkField(FIELD__REFERENCE_OT);
        this.searchChild.setTable(TABLE_OT_AP);
        this.searchChild.setRepresentationFields(CHILD_TOSTRING_FIELDS);
        return this.getChildrenOverArray(FIELD__AP);
    }

    public JRDataSource getApTels(int idAp) throws SearchException {
        this.searchChild.setParentId(idAp);
        this.searchChild.setFkField(FIELD__AP);
        this.searchChild.setTable(TABLE_AP_TEL);
        return this.getChildren();
    }

    public JRDataSource getOts(int idMeldung) throws SearchException {
        this.searchChild.setParentId(idMeldung);
        this.searchChild.setFkField(FIELD__MELDUNG);
        this.searchChild.setTable(TABLE_OT);
        return this.getChildren();
    }

    public JRDataSource getOtTeils(int idOt) throws SearchException {
        this.searchChild.setParentId(idOt);
        this.searchChild.setFkField(FIELD__OT);
        this.searchChild.setTable(TABLE_OT_TEIL);
        return this.getChildren();
    }

    public JRDataSource getChildren() throws SearchException {
        this.searchChild.setRepresentationFields(CHILD_TOSTRING_FIELDS);
        HashMap<String, MetaService> map = new HashMap<String, MetaService>();
        map.put("WUNDA_BLAU", this.metaService);
        this.searchChild.setActiveLocalServers(map);
        Collection mons = this.searchChild.performServerSearch();
        ArrayList<CidsBean> beansChild = new ArrayList<CidsBean>();
        if (!mons.isEmpty()) {
            for (MetaObjectNode mon : mons) {
                try {
                    MetaObject mo = this.metaService.getMetaObject(this.user, mon.getObjectId(), mon.getClassId(), this.getConnectionContext());
                    CidsBean bean = mo.getBean();
                    beansChild.add(bean);
                    switch (mo.getMetaClass().getName()) {
                        case "baum_schaden": {
                            this.beansSchadenMap.put(mon.getObjectId(), mon);
                            break;
                        }
                        case "baum_ersatz": {
                            this.beansErsatzMap.put(mon.getObjectId(), mon);
                            break;
                        }
                        case "baum_festsetzung": {
                            this.beansFestMap.put(mon.getObjectId(), mon);
                            break;
                        }
                        case "baum_ersatzbaum": {
                            this.beansBaumMap.put(mon.getObjectId(), mon);
                        }
                    }
                }
                catch (RemoteException e) {
                    LOG.error((Object)"Error while retrieving meta object", (Throwable)e);
                }
            }
        }
        JRBeanCollectionDataSource childDataSource = new JRBeanCollectionDataSource(beansChild);
        return childDataSource;
    }

    public MetaObjectNode getSchadenBean(Integer id) {
        return this.beansSchadenMap.get(id);
    }

    public MetaObjectNode getErsatzBean(Integer id) {
        return this.beansErsatzMap.get(id);
    }

    public MetaObjectNode getFestBean(Integer id) {
        return this.beansFestMap.get(id);
    }

    public MetaObjectNode getBaumBean(Integer id) {
        return this.beansBaumMap.get(id);
    }

    public String concatenatedKrone(int idSchaden) {
        this.searchChild.setParentId(idSchaden);
        this.searchChild.setFkField(FIELD__REFERENCE_S);
        this.searchChild.setTable(TABLE_S_KRONE);
        return this.getConcatenatedArray(FIELD__KRONE);
    }

    public String concatenatedStamm(int idSchaden) {
        this.searchChild.setParentId(idSchaden);
        this.searchChild.setFkField(FIELD__REFERENCE_S);
        this.searchChild.setTable(TABLE_S_STAMM);
        return this.getConcatenatedArray(FIELD__STAMM);
    }

    public String concatenatedWurzel(int idSchaden) {
        this.searchChild.setParentId(idSchaden);
        this.searchChild.setFkField(FIELD__REFERENCE_S);
        this.searchChild.setTable(TABLE_S_WURZEL);
        return this.getConcatenatedArray(FIELD__WURZEL);
    }

    public String concatenatedMassnahme(int idSchaden) {
        this.searchChild.setParentId(idSchaden);
        this.searchChild.setFkField(FIELD__REFERENCE_S);
        this.searchChild.setTable(TABLE_S_MASS);
        return this.getConcatenatedArray(FIELD__MASS).equals("") ? "keine" : this.getConcatenatedArray(FIELD__MASS);
    }

    public String getConcatenatedArray(String fk) {
        List<CidsBean> beansChildren = this.getChildrenBeans(fk);
        ArrayList listChildren = new ArrayList();
        String children = "";
        if (beansChildren != null) {
            beansChildren.forEach(childBean -> listChildren.add(childBean.getProperty(FIELD__NAME).toString()));
            children = listChildren.isEmpty() ? "" : String.join((CharSequence)", ", listChildren);
        }
        return children;
    }

    public BufferedImage generateMap(Collection<BaumMapImageFactoryConfiguration.ObjectIdentifier> mons, double buffer, Integer width, Integer height, Integer dpi, String url) throws Exception {
        BaumProperties properties = BaumProperties.getInstance();
        BaumMapImageFactoryConfiguration config = new BaumMapImageFactoryConfiguration();
        config.setMons(mons);
        config.setWidth(width);
        config.setHeight(height);
        config.setBuffer(buffer);
        config.setMapDpi(dpi);
        config.setMapUrl(url);
        config.setSrs(properties != null ? properties.getMapSrs() : DEFAULT__SRS);
        config.setBbX1(6.7);
        config.setBbY1(49.1);
        config.setBbX2(7.1);
        config.setBbY2(49.33);
        HashMap<String, String> colorMap = new HashMap<String, String>();
        colorMap.put(TABLE_GEBIET, properties != null && properties.getGebietColor() != null ? properties.getGebietColor() : DEFAULT_COLOR);
        colorMap.put(TABLE_SCHADEN, properties != null && properties.getSchadenColor() != null ? properties.getSchadenColor() : DEFAULT_COLOR);
        colorMap.put(TABLE_ERSATZ, properties != null && properties.getErsatzColor() != null ? properties.getErsatzColor() : DEFAULT_COLOR);
        colorMap.put(TABLE_ERSATZBAUM, properties != null && properties.getBaumColor() != null ? properties.getBaumColor() : DEFAULT_COLOR);
        colorMap.put(TABLE_FEST, properties != null && properties.getFestColor() != null ? properties.getFestColor() : DEFAULT_COLOR);
        config.setColorMap(colorMap);
        byte[] bytes = ByteArrayFactoryHandler.getInstance().execute(BAUM_MAP_IMAGE_FACTORY, new ObjectMapper().writeValueAsString((Object)config), this.getUser(), this.getConnectionContext());
        return ImageIO.read(new ByteArrayInputStream(bytes));
    }

    public BufferedImage generateGebietMap(MetaObjectNode gebietMon) throws Exception {
        BaumProperties properties = BaumProperties.getInstance();
        List<BaumMapImageFactoryConfiguration.ObjectIdentifier> mons = Arrays.asList(new BaumMapImageFactoryConfiguration.ObjectIdentifier(gebietMon.getObjectId(), gebietMon.getClassId()));
        Integer width = properties != null ? properties.getGebietMapWidth() : 300;
        Integer height = properties != null ? properties.getGebietMapHeight() : 200;
        double buffer = properties != null ? properties.getGebietMapBuffer() : 50.0;
        Integer dpi = properties != null ? properties.getGebietMapDpi() : 300;
        String url = properties != null ? properties.getUrlDefault() : null;
        return this.generateMap(mons, buffer, width, height, dpi, url);
    }

    public BufferedImage generateSchadenMap(MetaObjectNode schadenMon) throws Exception {
        BaumProperties properties = BaumProperties.getInstance();
        List<BaumMapImageFactoryConfiguration.ObjectIdentifier> mons = Arrays.asList(new BaumMapImageFactoryConfiguration.ObjectIdentifier(schadenMon.getObjectId(), schadenMon.getClassId()));
        Integer width = properties != null ? properties.getSchadenMapWidth() : 300;
        Integer height = properties != null ? properties.getSchadenMapHeight() : 200;
        double buffer = properties != null ? properties.getSchadenMapBuffer() : 50.0;
        Integer dpi = properties != null ? properties.getSchadenMapDpi() : 300;
        String url = properties != null ? properties.getUrlSchaden() : null;
        return this.generateMap(mons, buffer, width, height, dpi, url);
    }

    public boolean isErsatzGeom(MetaObjectNode ersatzMon) throws Exception {
        try {
            MetaObject mo = this.metaService.getMetaObject(this.user, ersatzMon.getObjectId(), ersatzMon.getClassId(), this.getConnectionContext());
            if (mo.getBean() != null && mo.getBean().getProperty(FIELD__GEOM) != null && mo.getBean().getProperty(FIELD__GEOM_GEO_FIELD) != null) {
                return true;
            }
        }
        catch (RemoteException e) {
            LOG.error((Object)"Error while retrieving meta object", (Throwable)e);
        }
        return false;
    }

    public BufferedImage generateErsatzMap(MetaObjectNode ersatzMon) throws Exception {
        BaumProperties properties = BaumProperties.getInstance();
        try {
            MetaObject mo = this.metaService.getMetaObject(this.user, ersatzMon.getObjectId(), ersatzMon.getClassId(), this.getConnectionContext());
            if (mo.getBean() == null || mo.getBean().getProperty(FIELD__GEOM_GEO_FIELD) == null) {
                return null;
            }
            int ersatzId = mo.getBean().getPrimaryKeyValue();
            this.getErsatzbaeume(ersatzId);
            ArrayList<BaumMapImageFactoryConfiguration.ObjectIdentifier> mons = new ArrayList<BaumMapImageFactoryConfiguration.ObjectIdentifier>();
            mons.add(new BaumMapImageFactoryConfiguration.ObjectIdentifier(ersatzMon.getObjectId(), ersatzMon.getClassId()));
            for (MetaObjectNode monBaum : this.beansBaumMap.values()) {
                MetaObject moBaum = this.metaService.getMetaObject(this.user, monBaum.getObjectId(), monBaum.getClassId(), this.getConnectionContext());
                if (((CidsBean)moBaum.getBean().getProperty(FIELD__ERSATZ)).getPrimaryKeyValue() != ersatzId) continue;
                mons.add(new BaumMapImageFactoryConfiguration.ObjectIdentifier(monBaum.getObjectId(), monBaum.getClassId()));
            }
            Integer width = properties != null ? properties.getErsatzMapWidth() : 300;
            Integer height = properties != null ? properties.getErsatzMapHeight() : 200;
            double buffer = properties != null ? properties.getErsatzMapBuffer() : 50.0;
            Integer dpi = properties != null ? properties.getErsatzMapDpi() : 300;
            String url = properties != null ? properties.getUrlDefault() : null;
            return this.generateMap(mons, buffer, width, height, dpi, url);
        }
        catch (RemoteException e) {
            LOG.error((Object)"Error while retrieving meta object", (Throwable)e);
            return null;
        }
    }

    public BufferedImage generateFestMap(MetaObjectNode festMon) throws Exception {
        BaumProperties properties = BaumProperties.getInstance();
        List<BaumMapImageFactoryConfiguration.ObjectIdentifier> mons = Arrays.asList(new BaumMapImageFactoryConfiguration.ObjectIdentifier(festMon.getObjectId(), festMon.getClassId()));
        Integer width = properties != null ? properties.getFestMapWidth() : 300;
        Integer height = properties != null ? properties.getFestMapHeight() : 200;
        double buffer = properties != null ? properties.getFestMapBuffer() : 50.0;
        Integer dpi = properties != null ? properties.getFestMapDpi() : 300;
        String url = properties != null ? properties.getUrlFestsetzung() : null;
        return this.generateMap(mons, buffer, width, height, dpi, url);
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public User getUser() {
        return this.user;
    }
}

