/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils;

import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class BaumProperties {
    private static final transient Logger LOG = Logger.getLogger(BaumProperties.class);
    protected static final WundaBlauServerResources SERVER_RESOURCE = WundaBlauServerResources.BAUM_CONF_PROPERTIES;
    private final Properties properties;
    private final String urlFestsetzung;
    private final String urlSchaden;
    private final String urlDefault;
    private final Integer gebietMapDpi;
    private final Integer gebietMapWidth;
    private final Integer gebietMapHeight;
    private final Double gebietMapBuffer;
    private final Integer schadenMapDpi;
    private final Integer schadenMapWidth;
    private final Integer schadenMapHeight;
    private final Double schadenMapBuffer;
    private final Integer ersatzMapDpi;
    private final Integer ersatzMapWidth;
    private final Integer ersatzMapHeight;
    private final Double ersatzMapBuffer;
    private final Integer festMapDpi;
    private final Integer festMapWidth;
    private final Integer festMapHeight;
    private final Double festMapBuffer;
    private final String mapSrs;
    private final String gebietColor;
    private final String ersatzColor;
    private final String baumColor;
    private final String festColor;
    private final String schadenColor;

    protected BaumProperties(Properties properties) {
        this.properties = properties;
        this.urlFestsetzung = String.valueOf(properties.getProperty("MAP_CALL_STRING_FESTSETZUNG"));
        this.urlSchaden = String.valueOf(properties.getProperty("MAP_CALL_STRING_SCHADEN"));
        this.urlDefault = String.valueOf(properties.getProperty("MAP_CALL_STRING_DEFAULT"));
        this.gebietMapDpi = Integer.valueOf(properties.getProperty("GEBIET_MAP_DPI"));
        this.gebietMapHeight = Integer.valueOf(properties.getProperty("GEBIET_MAP_HEIGHT"));
        this.gebietMapWidth = Integer.valueOf(properties.getProperty("GEBIET_MAP_WIDTH"));
        this.gebietMapBuffer = Double.valueOf(properties.getProperty("GEBIET_MAP_BUFFER"));
        this.schadenMapDpi = Integer.valueOf(properties.getProperty("SCHADEN_MAP_DPI"));
        this.schadenMapHeight = Integer.valueOf(properties.getProperty("SCHADEN_MAP_HEIGHT"));
        this.schadenMapWidth = Integer.valueOf(properties.getProperty("SCHADEN_MAP_WIDTH"));
        this.schadenMapBuffer = Double.valueOf(properties.getProperty("SCHADEN_MAP_BUFFER"));
        this.ersatzMapDpi = Integer.valueOf(properties.getProperty("ERSATZ_MAP_DPI"));
        this.ersatzMapHeight = Integer.valueOf(properties.getProperty("ERSATZ_MAP_HEIGHT"));
        this.ersatzMapWidth = Integer.valueOf(properties.getProperty("ERSATZ_MAP_WIDTH"));
        this.ersatzMapBuffer = Double.valueOf(properties.getProperty("ERSATZ_MAP_BUFFER"));
        this.festMapDpi = Integer.valueOf(properties.getProperty("FEST_MAP_DPI"));
        this.festMapHeight = Integer.valueOf(properties.getProperty("FEST_MAP_HEIGHT"));
        this.festMapWidth = Integer.valueOf(properties.getProperty("FEST_MAP_WIDTH"));
        this.festMapBuffer = Double.valueOf(properties.getProperty("FEST_MAP_BUFFER"));
        this.mapSrs = String.valueOf(properties.getProperty("MAP_SRS"));
        this.gebietColor = String.valueOf(properties.getProperty("GEBIET_COLOR"));
        this.ersatzColor = String.valueOf(properties.getProperty("ERSATZ_COLOR"));
        this.baumColor = String.valueOf(properties.getProperty("BAUM_COLOR"));
        this.festColor = String.valueOf(properties.getProperty("FEST_COLOR"));
        this.schadenColor = String.valueOf(properties.getProperty("SCHADEN_COLOR"));
    }

    public static BaumProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public final String valueOfString(String property, String defaultValue) {
        String value = defaultValue;
        if (this.properties.getProperty(property) != null) {
            value = this.properties.getProperty(property);
        }
        return value;
    }

    public final Integer valueOfInteger(String property, Integer defaultValue) {
        Integer value = defaultValue;
        try {
            value = Integer.valueOf(this.properties.getProperty(property));
        }
        catch (NumberFormatException ex) {
            LOG.warn((Object)String.format("value of %s is set to %s and can't be cast to Integer.", property, this.properties.getProperty(property)), (Throwable)ex);
        }
        return value;
    }

    public final Boolean valueOfBoolean(String property, Boolean defaultValue) {
        Boolean value = defaultValue;
        try {
            value = Boolean.valueOf(this.properties.getProperty(property));
        }
        catch (Exception ex) {
            LOG.warn((Object)String.format("value of %s is set to %s and can't be cast to Boolean.", property, this.properties.getProperty(property)), (Throwable)ex);
        }
        return value;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getUrlFestsetzung() {
        return this.urlFestsetzung;
    }

    public String getUrlSchaden() {
        return this.urlSchaden;
    }

    public String getUrlDefault() {
        return this.urlDefault;
    }

    public Integer getGebietMapDpi() {
        return this.gebietMapDpi;
    }

    public Integer getGebietMapWidth() {
        return this.gebietMapWidth;
    }

    public Integer getGebietMapHeight() {
        return this.gebietMapHeight;
    }

    public Double getGebietMapBuffer() {
        return this.gebietMapBuffer;
    }

    public Integer getSchadenMapDpi() {
        return this.schadenMapDpi;
    }

    public Integer getSchadenMapWidth() {
        return this.schadenMapWidth;
    }

    public Integer getSchadenMapHeight() {
        return this.schadenMapHeight;
    }

    public Double getSchadenMapBuffer() {
        return this.schadenMapBuffer;
    }

    public Integer getErsatzMapDpi() {
        return this.ersatzMapDpi;
    }

    public Integer getErsatzMapWidth() {
        return this.ersatzMapWidth;
    }

    public Integer getErsatzMapHeight() {
        return this.ersatzMapHeight;
    }

    public Double getErsatzMapBuffer() {
        return this.ersatzMapBuffer;
    }

    public Integer getFestMapDpi() {
        return this.festMapDpi;
    }

    public Integer getFestMapWidth() {
        return this.festMapWidth;
    }

    public Integer getFestMapHeight() {
        return this.festMapHeight;
    }

    public Double getFestMapBuffer() {
        return this.festMapBuffer;
    }

    public String getMapSrs() {
        return this.mapSrs;
    }

    public String getGebietColor() {
        return this.gebietColor;
    }

    public String getErsatzColor() {
        return this.ersatzColor;
    }

    public String getBaumColor() {
        return this.baumColor;
    }

    public String getFestColor() {
        return this.festColor;
    }

    public String getSchadenColor() {
        return this.schadenColor;
    }

    private static final class LazyInitialiser {
        private static final BaumProperties INSTANCE;

        private LazyInitialiser() {
        }

        public static BaumProperties getNewInstance() {
            try {
                return new BaumProperties(ServerResourcesLoader.getInstance().loadProperties(SERVER_RESOURCE.getValue()));
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception while initializing BaumProperties", ex);
            }
        }

        static {
            try {
                INSTANCE = LazyInitialiser.getNewInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception while initializing BaumProperties", ex);
            }
        }
    }
}

