/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils;

import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import java.util.Properties;

public class StaticProperties {
    private final String poiSignaturUrlPrefix;
    private final String poiSignaturUrlSuffix;
    private final String poiSignaturDefaultIcon;
    private final String fortfuehrungsnachweiseUrlPrefix;
    private final String albBaulastUrlPrefix;
    private final String albBaulastDocumentPath;

    protected StaticProperties(Properties properties) {
        this.poiSignaturUrlPrefix = properties.getProperty("poi_signatur_url_prefix");
        this.poiSignaturUrlSuffix = properties.getProperty("poi_signatur_url_suffix");
        this.poiSignaturDefaultIcon = properties.getProperty("poi_signatur_default_icon");
        this.fortfuehrungsnachweiseUrlPrefix = properties.getProperty("fortfuehrungsnachweise_url_prefix");
        this.albBaulastUrlPrefix = properties.getProperty("baulasten_dokumenten_url_prefix");
        this.albBaulastDocumentPath = properties.getProperty("baulasten_dokumenten_pfad");
    }

    public static StaticProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public String getPoiSignaturUrlPrefix() {
        return this.poiSignaturUrlPrefix;
    }

    public String getPoiSignaturUrlSuffix() {
        return this.poiSignaturUrlSuffix;
    }

    public String getPoiSignaturDefaultIcon() {
        return this.poiSignaturDefaultIcon;
    }

    public String getFortfuehrungsnachweiseUrlPrefix() {
        return this.fortfuehrungsnachweiseUrlPrefix;
    }

    public String getAlbBaulastUrlPrefix() {
        return this.albBaulastUrlPrefix;
    }

    public String getAlbBaulastDocumentPath() {
        return this.albBaulastDocumentPath;
    }

    private static final class LazyInitialiser {
        private static final StaticProperties INSTANCE;

        private LazyInitialiser() {
        }

        static {
            try {
                INSTANCE = new StaticProperties(ServerResourcesLoader.getInstance().loadProperties(WundaBlauServerResources.URLCONFIG_PROPERTIES.getValue()));
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception while initializing ServerAlkisConf", ex);
            }
        }
    }
}

