/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.alkis;

import de.aedsicad.aaaweb.rest.api.AlkisInformationApi;
import de.aedsicad.aaaweb.rest.api.AlkisSucheApi;
import de.aedsicad.aaaweb.rest.api.TokenApi;
import de.aedsicad.aaaweb.rest.client.ApiClient;
import de.aedsicad.aaaweb.rest.model.TokenInfo;
import de.cismet.cids.custom.utils.alkis.AlkisRestConf;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public final class AlkisAccessProvider {
    private static final Logger LOG = Logger.getLogger(AlkisAccessProvider.class);
    private final AlkisRestConf alkisRestConf;
    private final AlkisInformationApi alkisInfoService;
    private final AlkisSucheApi alkisSearchService;
    private final TokenApi tokenService;
    private TokenInfo token;

    public AlkisAccessProvider(AlkisRestConf alkisRestConf) {
        this.alkisRestConf = alkisRestConf;
        String tokenServiceUrl = alkisRestConf.getTokenApi();
        String aaaWebApiUrl = alkisRestConf.getAaaWebApi();
        try {
            ApiClient tokenApiClient = new ApiClient();
            tokenApiClient.setBasePath(tokenServiceUrl);
            ApiClient aaaWebApiClient = new ApiClient();
            aaaWebApiClient.setBasePath(aaaWebApiUrl);
            aaaWebApiClient.getHttpClient().setReadTimeout(30L, TimeUnit.SECONDS);
            this.tokenService = new TokenApi(this.getAlkisRestConf().getNewRestServiceUsed() == false, tokenApiClient);
            this.alkisInfoService = new AlkisInformationApi(aaaWebApiClient);
            this.alkisSearchService = new AlkisSucheApi(aaaWebApiClient);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Can not create RestAccessProvider" + tokenServiceUrl + "|" + aaaWebApiUrl, ex);
        }
    }

    public boolean isTokenValid(String token) {
        boolean valid = false;
        try {
            valid = this.tokenService.getToken(token) != null;
        }
        catch (Exception ex) {
            LOG.info((Object)"could not check token info. probably invalid", (Throwable)ex);
        }
        return valid;
    }

    public String login() {
        try {
            String user = this.alkisRestConf.getCreds().getUser();
            String pass = this.alkisRestConf.getCreds().getPassword();
            String extendSecret = "";
            this.token = this.getTokenService().createToken(user, pass, "").getToken();
        }
        catch (Exception ex) {
            LOG.fatal((Object)"login failed", (Throwable)ex);
            this.token = null;
            return null;
        }
        return this.token.getToken();
    }

    public void logout(String token) {
        try {
            this.getTokenService().deleteToken(token);
        }
        catch (Exception exception) {
            // empty catch block
        }
        token = null;
    }

    public AlkisRestConf getAlkisRestConf() {
        return this.alkisRestConf;
    }

    public AlkisInformationApi getAlkisInfoService() {
        return this.alkisInfoService;
    }

    public AlkisSucheApi getAlkisSearchService() {
        return this.alkisSearchService;
    }

    public TokenApi getTokenService() {
        return this.tokenService;
    }

    public TokenInfo getToken() {
        return this.token;
    }
}

