/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.alkis;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public final class AlkisSOAPWorkerService {
    private static final Logger log = Logger.getLogger(AlkisSOAPWorkerService.class);
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private static final int USED_PROCESSORS = Math.max(AVAILABLE_PROCESSORS - 1, 1);
    private static final ThreadPoolExecutor SOAP_EXEC_SERVICE = new ThreadPoolExecutor(USED_PROCESSORS, USED_PROCESSORS, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    private AlkisSOAPWorkerService() {
        throw new AssertionError();
    }

    public static void cancel(Runnable worker) {
        if (worker != null) {
            if (worker instanceof RunnableFuture) {
                ((RunnableFuture)worker).cancel(true);
            }
            SOAP_EXEC_SERVICE.getQueue().remove(worker);
        }
    }

    public static void execute(Runnable worker) {
        if (worker != null) {
            SOAP_EXEC_SERVICE.execute(worker);
        }
    }

    public static void clearWaitingQueue() {
        SOAP_EXEC_SERVICE.getQueue().clear();
    }
}

