/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.billing;

import de.cismet.cids.custom.utils.billing.BillingInfo;
import de.cismet.cids.custom.utils.billing.BillingModus;
import de.cismet.cids.custom.utils.billing.BillingProduct;
import de.cismet.cids.custom.utils.billing.BillingProductGroup;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.custom.utils.billing.BillingUsage;
import java.util.ArrayList;
import java.util.HashMap;

public class BillingInfoHandler {
    private final HashMap<String, BillingModus> modi = new HashMap();
    private final HashMap<String, BillingProduct> products = new HashMap();
    private final HashMap<String, BillingUsage> usages = new HashMap();
    private final HashMap<String, BillingProductGroup> productGroups = new HashMap();

    public BillingInfoHandler(BillingInfo billingInfo) {
        ArrayList<BillingModus> lm = billingInfo.getModi();
        for (BillingModus billingModus : lm) {
            this.modi.put(billingModus.getKey(), billingModus);
        }
        ArrayList<BillingProduct> lp = billingInfo.getProducts();
        for (BillingProduct billingProduct : lp) {
            this.products.put(billingProduct.getId(), billingProduct);
        }
        ArrayList<BillingUsage> arrayList = billingInfo.getUsages();
        for (BillingUsage u : arrayList) {
            this.usages.put(u.getKey(), u);
        }
        ArrayList<BillingProductGroup> arrayList2 = billingInfo.getProductGroups();
        for (BillingProductGroup pg : arrayList2) {
            this.productGroups.put(pg.getKey(), pg);
        }
    }

    public static double calculateRawPrice(BillingProduct product, BillingProductGroupAmount ... amounts) {
        double price = 0.0;
        for (BillingProductGroupAmount pga : amounts) {
            price += (double)pga.getAmount() * product.getPrices().get(pga.getGroup());
        }
        return price;
    }

    public static double calculateRawLBPrice(BillingProduct product, Integer amount) {
        double price = (double)amount.intValue() * product.getPrices().get("ea");
        return price;
    }

    public HashMap<String, BillingModus> getModi() {
        return this.modi;
    }

    public HashMap<String, BillingProduct> getProducts() {
        return this.products;
    }

    public HashMap<String, BillingUsage> getUsages() {
        return this.usages;
    }

    public HashMap<String, BillingProductGroup> getProductGroups() {
        return this.productGroups;
    }
}

