/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.formsolutions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.newuser.User;
import Sirius.server.newuser.UserServer;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.utils.alkis.AlkisProductDescription;
import de.cismet.cids.custom.utils.alkis.AlkisProducts;
import de.cismet.cids.custom.utils.alkis.BaulastBescheinigungHelper;
import de.cismet.cids.custom.utils.alkis.LiegenschaftsbuchauszugHelper;
import de.cismet.cids.custom.utils.alkis.ServerAlkisProducts;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungBillingDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungHandler;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisEinzelnachweisDownloadInfo;
import de.cismet.cids.custom.utils.billing.BillingInfo;
import de.cismet.cids.custom.utils.billing.BillingInfoHandler;
import de.cismet.cids.custom.utils.billing.BillingPrice;
import de.cismet.cids.custom.utils.billing.BillingProduct;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.custom.utils.formsolutions.FormSolutionBestellungSpecialLogger;
import de.cismet.cids.custom.utils.formsolutions.FormSolutionsBestellung;
import de.cismet.cids.custom.utils.formsolutions.FormSolutionsFtpClient;
import de.cismet.cids.custom.utils.formsolutions.FormSolutionsMySqlHelper;
import de.cismet.cids.custom.utils.formsolutions.FormSolutionsProperties;
import de.cismet.cids.custom.wunda_blau.search.server.CidsAlkisSearchStatement;
import de.cismet.cids.custom.wunda_blau.search.server.FormSolutionsBestellungSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.utils.MetaClassCacheService;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.commons.security.AccessHandler;
import de.cismet.commons.security.handler.SimpleHttpAccessHandler;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Logger;
import org.openide.util.Lookup;

public class FormSolutionsBestellungHandler
implements ConnectionContextProvider {
    public static final int STATUS_CREATE = 100;
    public static final int STATUS_FETCH = 70;
    public static final int STATUS_PARSE = 60;
    public static final int STATUS_GETFLURSTUECK = 55;
    public static final int STATUS_SAVE = 50;
    public static final int STATUS_CLOSE = 40;
    public static final int STATUS_WEITERLEITUNG_ABSCHLUSSFORMULAR = 37;
    public static final int STATUS_PRUEFUNG = 35;
    public static final int STATUS_PRODUKT = 20;
    public static final int STATUS_BILLING = 15;
    public static final int STATUS_PENDING = 10;
    public static final int STATUS_DONE = 0;
    public static final int GUTSCHEIN_YES = 1;
    public static final int GUTSCHEIN_NO = 2;
    private static final Logger LOG = Logger.getLogger(FormSolutionsBestellungHandler.class);
    private static final String TEST_CISMET00_PREFIX = "TEST_CISMET00-";
    private static final String GUTSCHEIN_ADDITIONAL_TEXT = "Bestellcode (%s)";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Map<String, MetaClass> METACLASS_CACHE = new HashMap<String, MetaClass>();
    private static final String EXTERNAL_USER_QUERY_TEMPLATE = "SELECT %d, %s FROM %s WHERE name = '%s';";
    private static final String UNFINISHED_BESTELLUNGEN_QUERY_TEMPLATE = "SELECT %d, %s FROM %s WHERE test IS NOT TRUE AND duplicate IS NOT TRUE AND postweg IS NOT TRUE AND fehler IS NULL AND erledigt IS NOT TRUE;";
    private static final String PRODUKT_QUERY_TEMPLATE = "SELECT DISTINCT %d, %s FROM %s WHERE %s LIMIT 1;";
    private static final String BESTELLUNG_BY_TRANSID_QUERY_TEMPLATE = "SELECT DISTINCT %d, %s FROM %s WHERE transid LIKE '%s';";
    private static final String PDF_START = "%PDF";
    private static final String PDF_END = "%%EOF";
    private final User user;
    private final MetaService metaService;
    private final ConnectionContext connectionContext;
    private final SimpleHttpAccessHandler httpHandler = new SimpleHttpAccessHandler(FormSolutionsBestellungHandler.getProperties().getConnectionTimeout() != null ? FormSolutionsBestellungHandler.getProperties().getConnectionTimeout() : 0, FormSolutionsBestellungHandler.getProperties().getSoTimeout() != null ? FormSolutionsBestellungHandler.getProperties().getSoTimeout() : 0);
    private final UsernamePasswordCredentials creds;
    private final String testCismet00Xml;
    private final ProductType testCismet00Type;
    private final Set<String> ignoreTransids = new HashSet<String>();
    private final BaulastBescheinigungHelper baulastBescheinigungHelper;
    private final LiegenschaftsbuchauszugHelper liegenschaftsbuchauszugHelper;
    private final BillingInfoHandler billingInfoHander;

    public FormSolutionsBestellungHandler(MetaService metaService, ConnectionContext connectionContext) {
        this(false, metaService, connectionContext);
    }

    public FormSolutionsBestellungHandler(boolean fromStartupHook, MetaService metaService, ConnectionContext connectionContext) {
        UsernamePasswordCredentials creds = null;
        ProductType testCismet00Type = null;
        String testCismet00Xml = null;
        if (DomainServerImpl.getServerProperties() != null && "WUNDA_BLAU".equals(DomainServerImpl.getServerProperties().getServerName())) {
            try {
                creds = new UsernamePasswordCredentials(FormSolutionsBestellungHandler.getProperties().getUser(), FormSolutionsBestellungHandler.getProperties().getPassword());
            }
            catch (Exception ex) {
                LOG.error((Object)"UsernamePasswordCredentials couldn't be created. FormSolutionServerNewStuffAvailableAction will not work at all !", (Throwable)ex);
            }
            try {
                testCismet00Type = FormSolutionsBestellungHandler.parseProductType(FormSolutionsBestellungHandler.getProperties().getTestType());
            }
            catch (Exception ex) {
                LOG.error((Object)"could not read FormSolutionsConstants.TEST_TYPE. TEST_TYPE stays disabled", (Throwable)ex);
            }
            if (testCismet00Type != null) {
                try (FileInputStream is = new FileInputStream(FormSolutionsBestellungHandler.getProperties().getTestXml());){
                    testCismet00Xml = IOUtils.toString((InputStream)is, (String)"UTF-8");
                }
                catch (Exception ex) {
                    LOG.error((Object)("could not load " + FormSolutionsBestellungHandler.getProperties().getTestXml()), (Throwable)ex);
                }
            }
            String ignoreTransIdsTxt = FormSolutionsBestellungHandler.getProperties().getIgnoreTransIdsTxt();
            try (FileInputStream is = new FileInputStream(ignoreTransIdsTxt);){
                String[] lines;
                String ignoreFileContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
                for (String line : lines = ignoreFileContent.split("\n")) {
                    if (line.trim().isEmpty()) continue;
                    this.ignoreTransids.add(line.trim());
                }
            }
            catch (Exception ex) {
                LOG.error((Object)String.format("could not load %s", ignoreTransIdsTxt), (Throwable)ex);
            }
        }
        BillingInfoHandler billingInfoHander = null;
        try {
            billingInfoHander = new BillingInfoHandler((BillingInfo)this.getObjectMapper().readValue(ServerResourcesLoader.getInstance().loadText(WundaBlauServerResources.BILLING_JSON.getValue()), BillingInfo.class));
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        this.user = FormSolutionsBestellungHandler.getFsUser();
        this.billingInfoHander = billingInfoHander;
        this.baulastBescheinigungHelper = new BaulastBescheinigungHelper(this.user, metaService, connectionContext);
        this.liegenschaftsbuchauszugHelper = new LiegenschaftsbuchauszugHelper(this.user, metaService, connectionContext);
        this.testCismet00Type = testCismet00Type;
        this.testCismet00Xml = testCismet00Xml;
        this.creds = creds;
        this.metaService = metaService;
        this.connectionContext = connectionContext;
    }

    private BaulastBescheinigungHelper getBaulastBescheinigungHelper() {
        return this.baulastBescheinigungHelper;
    }

    private LiegenschaftsbuchauszugHelper getLiegenschaftsbuchauszugHelper() {
        return this.liegenschaftsbuchauszugHelper;
    }

    private CidsBean doBilling(CidsBean bestellungBean, BerechtigungspruefungDownloadInfo downloadinfo, String transid) {
        try {
            CidsBean billingBean = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)"Billing_Billing", (ConnectionContext)this.getConnectionContext());
            boolean isPostweg = Boolean.TRUE.equals(bestellungBean.getProperty("postweg"));
            Timestamp abrechnungsdatum = (Timestamp)bestellungBean.getProperty("eingang_ts");
            String projektBezeichnung = (bestellungBean.getProperty("fk_adresse_rechnung.firma") != null ? (String)bestellungBean.getProperty("fk_adresse_rechnung.firma") + ", " : "") + (String)bestellungBean.getProperty("fk_adresse_rechnung.name") + " " + (String)bestellungBean.getProperty("fk_adresse_rechnung.vorname");
            String kundeLogin = this.extractKundenLogin(bestellungBean);
            String modus = FormSolutionsBestellungHandler.getProperties().getBillingModus();
            String modusbezeichnung = FormSolutionsBestellungHandler.getProperties().getBillingModusbezeichnung();
            Double gebuehr = this.extractGebuehr(bestellungBean);
            String verwendungszweck = isPostweg ? FormSolutionsBestellungHandler.getProperties().getBillingVerwendungskeyPostweg() : FormSolutionsBestellungHandler.getProperties().getBillingVerwendungszweckDownload();
            String verwendungskey = isPostweg ? FormSolutionsBestellungHandler.getProperties().getBillingVerwendungskeyPostweg() : FormSolutionsBestellungHandler.getProperties().getBillingVerwendungskeyDownload();
            String produktkey = (String)bestellungBean.getProperty("fk_produkt.billing_key");
            String produktbezeichnung = (String)bestellungBean.getProperty("fk_produkt.billing_desc");
            billingBean.setProperty("geometrie", (Object)((CidsBean)bestellungBean.getProperty("geometrie")));
            billingBean.setProperty("username", (Object)kundeLogin);
            billingBean.setProperty("angelegt_durch", (Object)this.getExternalUser(kundeLogin));
            billingBean.setProperty("ts", (Object)abrechnungsdatum);
            billingBean.setProperty("abrechnungsdatum", (Object)abrechnungsdatum);
            billingBean.setProperty("modus", (Object)modus);
            billingBean.setProperty("modusbezeichnung", (Object)modusbezeichnung);
            billingBean.setProperty("produktkey", (Object)produktkey);
            billingBean.setProperty("produktbezeichnung", (Object)produktbezeichnung);
            billingBean.setProperty("netto_summe", (Object)gebuehr);
            billingBean.setProperty("brutto_summe", (Object)gebuehr);
            billingBean.setProperty("geschaeftsbuchnummer", (Object)transid);
            billingBean.setProperty("verwendungszweck", (Object)verwendungszweck);
            billingBean.setProperty("verwendungskey", (Object)verwendungskey);
            billingBean.setProperty("projektbezeichnung", (Object)projektBezeichnung);
            billingBean.setProperty("mwst_satz", (Object)0.0);
            billingBean.setProperty("angeschaeftsbuch", (Object)Boolean.FALSE);
            billingBean.setProperty("abgerechnet", (Object)Boolean.TRUE);
            billingBean.setProperty("request", (Object)(downloadinfo != null ? MAPPER.writeValueAsString((Object)downloadinfo) : (String)bestellungBean.getProperty("request_url")));
            if (transid != null && transid.startsWith(TEST_CISMET00_PREFIX)) {
                LOG.info((Object)("Test-Object would have created this Billing-Entry: " + billingBean.getMOString()));
                return null;
            }
            return this.getMetaService().insertMetaObject(this.getUser(), billingBean.getMetaObject(), this.getConnectionContext()).getBean();
        }
        catch (Exception e) {
            LOG.error((Object)"Error during the persitence of the billing log.", (Throwable)e);
            return null;
        }
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    private CidsBean getExternalUser(String loginName) throws Exception {
        MetaClass mc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"billing_kunden_logins", (ConnectionContext)this.getConnectionContext());
        if (mc == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The metaclass for billing_kunden_logins is null. The current user has probably not the needed rights.");
            }
            return null;
        }
        String query = String.format(EXTERNAL_USER_QUERY_TEMPLATE, mc.getID(), mc.getPrimaryKey(), mc.getTableName(), loginName);
        CidsBean externalUser = null;
        MetaObject[] metaObjects = this.getMetaService().getMetaObject(this.getUser(), query, this.getConnectionContext());
        if (metaObjects != null && metaObjects.length > 0) {
            externalUser = metaObjects[0].getBean();
        }
        return externalUser;
    }

    public User getUser() {
        return this.user;
    }

    public static User getFsUser() {
        for (String registryIP : DomainServerImpl.getServerProperties().getRegistryIps()) {
            try {
                Remote userServer = Naming.lookup("rmi://" + registryIP + "/userServer");
                return ((UserServer)userServer).getUser(null, null, "WUNDA_BLAU", FormSolutionsProperties.getInstance().getCidsLogin(), FormSolutionsProperties.getInstance().getCidsPassword());
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        return null;
    }

    public Collection fetchEndExecuteAllOpen() {
        return this.fetchEndExecuteAllOpen(false);
    }

    public Collection fetchEndExecuteAllOpen(boolean test) {
        return this.execute(70, false, test, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection execute(int startStep, boolean repairErrors, boolean test, Collection<MetaObjectNode> mons) {
        Class<FormSolutionsBestellungHandler> clazz = FormSolutionsBestellungHandler.class;
        synchronized (FormSolutionsBestellungHandler.class) {
            if (mons != null && startStep >= 50) {
                throw new IllegalStateException("fetch not allowed with metaobjectnodes");
            }
            Map<String, CidsBean> fsBeanMap = null;
            if (mons != null) {
                fsBeanMap = this.loadCidsEntries(mons);
            }
            Map<String, FormSolutionsBestellung> fsBestellungMap = null;
            Map<String, BerechtigungspruefungDownloadInfo> downloadInfoMap = null;
            switch (startStep) {
                case 50: 
                case 60: 
                case 70: {
                    if (mons == null) {
                        try {
                            if (startStep >= 40) {
                                Map<String, ProductType> typeMap = test ? this.step0GetTransIdsFromTest() : this.step0FetchTransIds();
                                Map<String, Exception> insertExceptionMap = this.step1CreateMySqlEntries(typeMap.keySet());
                                Map<String, String> fsXmlMap = this.step2ExtractXmlParts(typeMap.keySet());
                                fsBestellungMap = this.step3CreateBestellungMap(fsXmlMap, typeMap);
                                fsBeanMap = this.step4CreateCidsEntries(fsXmlMap, fsBestellungMap, typeMap, insertExceptionMap);
                            }
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Die Liste der FormSolutions-Bestellungen konnte nicht abgerufen werden", (Throwable)ex);
                        }
                    }
                }
                case 40: {
                    this.step5CloseTransactions(fsBeanMap);
                }
                case 35: {
                    this.step6PruefungProdukt(fsBeanMap, repairErrors);
                }
                case 20: {
                    downloadInfoMap = this.step7CreateProducts(fsBeanMap, repairErrors);
                }
                case 15: {
                    this.step8Billing(fsBeanMap, downloadInfoMap, repairErrors);
                    if (15 == startStep) break;
                }
                case 0: 
                case 10: {
                    this.step9FinalizeEntries(fsBeanMap, repairErrors);
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return null;
        }
    }

    private Map<String, CidsBean> loadCidsEntries(Collection<MetaObjectNode> mons) {
        this.specialLog("start fetching from DB. Numof objects: " + mons.size());
        HashMap<String, CidsBean> fsBeanMap = new HashMap<String, CidsBean>();
        for (MetaObjectNode mon : mons) {
            try {
                CidsBean bestellungBean = DomainServerImpl.getServerInstance().getMetaObject(this.getUser(), mon.getObjectId(), mon.getClassId(), this.getConnectionContext()).getBean();
                String transid = (String)bestellungBean.getProperty("transid");
                fsBeanMap.put(transid, bestellungBean);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        this.specialLog("objects fetched from DB");
        return fsBeanMap;
    }

    private Map<String, ProductType> step0GetTransIdsFromTest() throws Exception {
        HashMap<String, ProductType> transIdProductTypeMap = new HashMap<String, ProductType>();
        try {
            if (this.testCismet00Type != null) {
                String transId = TEST_CISMET00_PREFIX + RandomStringUtils.randomAlphanumeric((int)8);
                transIdProductTypeMap.put(transId, this.testCismet00Type);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"error while generating TEST_CISMET00 transid", (Throwable)ex);
        }
        return transIdProductTypeMap;
    }

    private Map<String, ProductType> step0FetchTransIds() throws Exception {
        this.specialLog("fetched from FS");
        HashMap<String, ProductType> transIdProductTypeMap = new HashMap<String, ProductType>();
        for (ProductType productType : ProductType.values()) {
            Collection<String> transIds = this.getOpenExtendedTransids(productType);
            for (String transId : transIds) {
                if (!this.isDuplicate(transId)) {
                    transIdProductTypeMap.put(transId, productType);
                    continue;
                }
                this.removeDuplicate(transId);
            }
        }
        for (String transId : this.ignoreTransids) {
            transIdProductTypeMap.remove(transId);
        }
        return transIdProductTypeMap;
    }

    private boolean isDuplicate(String transid) {
        boolean duplicate = false;
        try {
            MetaClass bestellungMc = FormSolutionsBestellungHandler.getMetaClass("fs_bestellung", this.getConnectionContext());
            String searchQuery = String.format(BESTELLUNG_BY_TRANSID_QUERY_TEMPLATE, bestellungMc.getID(), bestellungMc.getTableName() + "." + bestellungMc.getPrimaryKey(), bestellungMc.getTableName(), transid);
            MetaObject[] mos = this.getMetaService().getMetaObject(this.getUser(), searchQuery, this.getConnectionContext());
            if (mos != null && mos.length > 0) {
                duplicate = true;
            }
        }
        catch (Exception ex) {
            String message = "error while search for duplicates for " + transid;
            LOG.error((Object)message, (Throwable)ex);
            this.specialLog(message);
        }
        return duplicate;
    }

    private void removeDuplicate(String transid) {
        try {
            String auftragXml = this.getAuftrag(transid);
            if (auftragXml == null) {
                LOG.warn((Object)("formsolutions no xml data available for duplicated transid " + transid));
            } else {
                LOG.warn((Object)("xml data for duplicated transid " + transid + ":\n" + auftragXml));
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)("Error when retrieving order with transid " + transid), (Throwable)ex);
        }
        try {
            boolean closeVeto;
            boolean vetoAttribute = DomainServerImpl.getServerInstance().hasConfigAttr(this.getUser(), "custom.formsolutions.noclose", this.getConnectionContext());
            boolean bl = closeVeto = transid == null || transid.startsWith(TEST_CISMET00_PREFIX) || vetoAttribute;
            if (this.isServerInProduction() && !closeVeto) {
                this.getHttpAccessHandler().doRequest(new URL(String.format(FormSolutionsBestellungHandler.getProperties().getUrlAuftragDeleteFs(), transid.substring(0, transid.indexOf("-")), transid)), (Reader)new StringReader(""), "text/plain", AccessHandler.ACCESS_METHODS.POST_REQUEST, null, this.creds);
            } else if (closeVeto) {
                LOG.warn((Object)("close veto exists. So the duplicated order will not be deleted. vetoAttribute: " + vetoAttribute));
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)("Error when removing order with transid " + transid), (Throwable)ex);
        }
    }

    private void step8Billing(Map<String, CidsBean> fsBeanMap, Map<String, BerechtigungspruefungDownloadInfo> downloadInfoMap, boolean repairErrors) {
        if (fsBeanMap != null) {
            block5: for (String transid : new ArrayList<String>(fsBeanMap.keySet())) {
                CidsBean bestellungBean = fsBeanMap.get(transid);
                if (bestellungBean == null || !repairErrors && bestellungBean.getProperty("fehler") != null) continue;
                ProductType productType = this.determineProductType(bestellungBean);
                switch (productType) {
                    case SGK: 
                    case ABK: 
                    case LB_ABSCHLUSS: 
                    case BAB_ABSCHLUSS: {
                        try {
                            CidsBean billingBean;
                            if (Boolean.TRUE.equals(bestellungBean.getProperty("duplicate")) || bestellungBean.getProperty("gutschein_code") != null || bestellungBean.getProperty("fk_billing") != null || (billingBean = this.doBilling(bestellungBean, downloadInfoMap != null ? downloadInfoMap.get(transid) : null, transid)) == null) continue block5;
                            bestellungBean.setProperty("fk_billing", (Object)billingBean);
                            this.getMetaService().updateMetaObject(this.getUser(), bestellungBean.getMetaObject(), this.getConnectionContext());
                            break;
                        }
                        catch (Exception ex) {
                            this.setErrorStatus(transid, 15, bestellungBean, "Fehler beim Erzeugen des Billings", ex);
                        }
                    }
                }
            }
        }
    }

    public MetaObject[] getUnfinishedBestellungen() throws Exception {
        MetaClass mcBestellung = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"fs_bestellung", (ConnectionContext)this.getConnectionContext());
        String pruefungQuery = String.format(UNFINISHED_BESTELLUNGEN_QUERY_TEMPLATE, mcBestellung.getID(), mcBestellung.getTableName() + "." + mcBestellung.getPrimaryKey(), mcBestellung.getTableName());
        return this.getMetaService().getMetaObject(this.getUser(), pruefungQuery, this.getConnectionContext());
    }

    private Collection<String> getOpenExtendedTransids(ProductType productType) throws Exception {
        this.specialLog("fetching open transids from FS");
        ArrayList<String> transIds = new ArrayList<String>();
        if (this.isServerInProduction()) {
            try {
                URL auftragsListeUrl;
                StringBuilder stringBuilder = new StringBuilder();
                switch (productType) {
                    case SGK: {
                        auftragsListeUrl = new URL(FormSolutionsBestellungHandler.getProperties().getUrlAuftragslisteSgkFs());
                        break;
                    }
                    case ABK: {
                        auftragsListeUrl = new URL(FormSolutionsBestellungHandler.getProperties().getUrlAuftragslisteAbkFs());
                        break;
                    }
                    case BAB_WEITERLEITUNG: {
                        auftragsListeUrl = new URL(FormSolutionsBestellungHandler.getProperties().getUrlAuftragslisteBb1Fs());
                        break;
                    }
                    case BAB_ABSCHLUSS: {
                        auftragsListeUrl = new URL(FormSolutionsBestellungHandler.getProperties().getUrlAuftragslisteBb2Fs());
                        break;
                    }
                    case LB_WEITERLEITUNG: {
                        auftragsListeUrl = new URL(FormSolutionsBestellungHandler.getProperties().getUrlAuftragslisteLb1Fs());
                        break;
                    }
                    case LB_ABSCHLUSS: {
                        auftragsListeUrl = new URL(FormSolutionsBestellungHandler.getProperties().getUrlAuftragslisteLb2Fs());
                        break;
                    }
                    default: {
                        throw new Exception("unknown product type");
                    }
                }
                try (InputStream in = this.getHttpAccessHandler().doRequest(auftragsListeUrl, (Reader)new StringReader(""), AccessHandler.ACCESS_METHODS.GET_REQUEST, null, this.creds);){
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    while ((line = reader.readLine()) != null) {
                        stringBuilder.append(line);
                    }
                }
                this.specialLog("open transids fetched: " + stringBuilder.toString());
                JsonNode node = MAPPER.readTree(stringBuilder.toString());
                if (node.isArray()) {
                    Iterator it = node.elements();
                    while (it.hasNext()) {
                        JsonNode n = (JsonNode)it.next();
                        JsonNode transidNode = n.get("transID");
                        if (transidNode == null) continue;
                        String transId = transidNode.asText();
                        transIds.add(transId);
                    }
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"error while retrieving open transids", (Throwable)ex);
            }
        }
        return transIds;
    }

    public static void main(String[] args) {
        ArrayList<String> transIds = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            try (FileReader in = new FileReader(new File("/home/therter/resp.json"));){
                String line;
                BufferedReader reader = new BufferedReader(in);
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line);
                }
            }
            System.out.println("out: " + stringBuilder);
            JsonNode node = MAPPER.readTree(stringBuilder.toString());
            if (node.isArray()) {
                Iterator it = node.elements();
                while (it.hasNext()) {
                    JsonNode n = (JsonNode)it.next();
                    JsonNode transidNode = n.get("transID");
                    if (transidNode == null) continue;
                    transIds.add(transidNode.asText());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String id : transIds) {
            System.out.println(id);
        }
    }

    private void step9FinalizeEntries(Map<String, CidsBean> fsBeanMap, boolean repairErrors) {
        if (fsBeanMap != null) {
            ArrayList<String> transids = new ArrayList<String>(fsBeanMap.keySet());
            for (String transid : transids) {
                CidsBean bestellungBean = fsBeanMap.get(transid);
                if (bestellungBean == null || !repairErrors && bestellungBean.getProperty("fehler") != null) continue;
                ProductType productType = this.determineProductType(bestellungBean);
                Boolean propPostweg = (Boolean)bestellungBean.getProperty("postweg");
                switch (productType) {
                    case SGK: 
                    case ABK: 
                    case LB_ABSCHLUSS: 
                    case BAB_ABSCHLUSS: {
                        int okStatus = Boolean.TRUE.equals(propPostweg) ? 10 : 0;
                        try {
                            FormSolutionsBestellungHandler.getMySqlHelper().updateStatus(transid, okStatus);
                            String email = FormSolutionsBestellungHandler.trimedNotEmpty((String)bestellungBean.getProperty("email"));
                            this.doStatusChangedRequest(transid, this.isInternalEmail(email));
                            break;
                        }
                        catch (Exception ex) {
                            this.setErrorStatus(transid, 10, bestellungBean, "Fehler beim Abschlie\u00dfen des MYSQL-Datensatzes", ex);
                        }
                    }
                }
                Boolean propDuplicate = (Boolean)bestellungBean.getProperty("duplicate");
                try {
                    if (!Boolean.TRUE.equals(propDuplicate) && !Boolean.TRUE.equals(propPostweg)) {
                        bestellungBean.setProperty("erledigt", (Object)Boolean.TRUE);
                    }
                    this.getMetaService().updateMetaObject(this.getUser(), bestellungBean.getMetaObject(), this.getConnectionContext());
                }
                catch (Exception ex) {
                    LOG.error((Object)"Fehler beim Persistieren der Bestellung", (Throwable)ex);
                }
            }
        }
    }

    private boolean isInternalEmail(String email) {
        return email != null && (email.endsWith("@cismet.de") || email.endsWith("@stadt.wuppertal.de"));
    }

    private void setErrorStatus(String transid, int status, CidsBean bestellungBean, String message, Exception exception) {
        this.setErrorStatus(transid, status, bestellungBean, message, exception, true);
    }

    private void setErrorStatus(String transid, int status, CidsBean bestellungBean, String message, Exception exception, boolean persist) {
        LOG.error((Object)message, (Throwable)exception);
        if (bestellungBean != null) {
            try {
                bestellungBean.setProperty("fehler", (Object)message);
                bestellungBean.setProperty("fehler_ts", (Object)new Timestamp(new Date().getTime()));
                bestellungBean.setProperty("exception", (Object)this.getObjectMapper().writeValueAsString((Object)exception));
                if (persist) {
                    this.getMetaService().updateMetaObject(this.getUser(), bestellungBean.getMetaObject(), this.getConnectionContext());
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim Persistieren der Bean", (Throwable)ex);
            }
        }
        try {
            FormSolutionsBestellungHandler.getMySqlHelper().updateStatus(transid, -status);
            String email = bestellungBean != null ? FormSolutionsBestellungHandler.trimedNotEmpty((String)bestellungBean.getProperty("email")) : null;
            this.doStatusChangedRequest(transid, this.isInternalEmail(email));
        }
        catch (Exception ex2) {
            LOG.error((Object)"Fehler beim Aktualisieren des MySQL-Datensatzes", (Throwable)ex2);
        }
    }

    private String getAuftrag(String transid) throws Exception {
        this.specialLog("getting auftrag from FS for: " + transid);
        if (transid != null && transid.startsWith(TEST_CISMET00_PREFIX)) {
            return this.testCismet00Xml != null ? this.testCismet00Xml.replace("${TRANSID}", transid) : null;
        }
        if (this.isServerInProduction()) {
            String convertedXml;
            Map map;
            try (InputStream in = this.getHttpAccessHandler().doRequest(new URL(String.format(FormSolutionsBestellungHandler.getProperties().getUrlAuftragFs(), transid.substring(0, transid.indexOf("-")), transid)), (Reader)new StringReader(""), AccessHandler.ACCESS_METHODS.GET_REQUEST, null, this.creds);){
                map = (Map)this.getObjectMapper().readValue(in, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            }
            if (map.get("attachments") != null) {
                byte[] attachements = DatatypeConverter.parseBase64Binary((String)((String)map.get("attachments")));
                File attachementsFile = new File(String.format("%s/%s.zip", FormSolutionsBestellungHandler.getProperties().getAnhangTmpAbsPath(), transid));
                try (FileOutputStream out = new FileOutputStream(attachementsFile);){
                    IOUtils.write((byte[])attachements, (OutputStream)out);
                }
            }
            String xmlBase64 = (String)map.get("xml");
            String xml = null;
            if (xmlBase64 == null || xmlBase64.equals("")) {
                return null;
            }
            xml = new String(DatatypeConverter.parseBase64Binary((String)xmlBase64));
            Charset utf8charset = Charset.forName("UTF-8");
            Charset iso885915charset = Charset.forName("ISO-8859-15");
            ByteBuffer inputBuffer = ByteBuffer.wrap(xml.getBytes());
            CharBuffer data = utf8charset.decode(inputBuffer);
            ByteBuffer outputBuffer = iso885915charset.encode(data);
            byte[] outputData = outputBuffer.array();
            try {
                convertedXml = new String(new String(outputData, "ISO-8859-15").getBytes(), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                LOG.warn((Object)"could not convert to LATIN9", (Throwable)ex);
                convertedXml = xml;
            }
            this.specialLog("auftrag returned from FS: " + convertedXml);
            return convertedXml;
        }
        return null;
    }

    private void doStatusChangedRequest(String transid, boolean toBothSystems) {
        if (this.isServerInProduction()) {
            try {
                this.specialLog("doing status changed request for: " + transid);
                if (transid != null && (transid.toLowerCase().startsWith("kfas_kf600204") || transid.toLowerCase().startsWith("kfas_kf600205"))) {
                    this.getHttpAccessHandler().doRequest(new URL(String.format(FormSolutionsBestellungHandler.getProperties().getUrlStatusUpdateLB(), transid)), (Reader)new StringReader(""), AccessHandler.ACCESS_METHODS.GET_REQUEST);
                } else {
                    this.getHttpAccessHandler().doRequest(new URL(String.format(FormSolutionsBestellungHandler.getProperties().getUrlStatusUpdate(), transid)), (Reader)new StringReader(""), AccessHandler.ACCESS_METHODS.GET_REQUEST);
                    if (toBothSystems && !FormSolutionsBestellungHandler.getProperties().getUrlStatusUpdateLB().equals(FormSolutionsBestellungHandler.getProperties().getUrlStatusUpdate())) {
                        this.getHttpAccessHandler().doRequest(new URL(String.format(FormSolutionsBestellungHandler.getProperties().getUrlStatusUpdateLB(), transid)), (Reader)new StringReader(""), AccessHandler.ACCESS_METHODS.GET_REQUEST);
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"STATUS_UPDATE_URL could not be requested", (Throwable)ex);
            }
        }
    }

    private FormSolutionsBestellung createFormSolutionsBestellung(InputStream in) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{FormSolutionsBestellung.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        jaxbUnmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                LOG.warn((Object)event.getMessage(), event.getLinkedException());
                return true;
            }
        });
        return (FormSolutionsBestellung)jaxbUnmarshaller.unmarshal(in);
    }

    private static String extractProduct(FormSolutionsBestellung formSolutionsBestellung, ProductType type) {
        StringBuffer produktSB;
        if (type == null) {
            return null;
        }
        String farbauspraegung = formSolutionsBestellung.getFarbauspraegung();
        Boolean farbig = "farbig".equals(farbauspraegung) ? Boolean.valueOf(true) : ("Graustufen".equals(farbauspraegung) ? Boolean.valueOf(false) : null);
        String massstab = formSolutionsBestellung.getMassstab();
        switch (type) {
            case SGK: {
                if (farbig != null) {
                    produktSB = new StringBuffer("Stadtgrundkarte mit kom. Erg.").append(Boolean.TRUE.equals(farbig) ? " (farbig)" : " (sw)");
                    break;
                }
                return null;
            }
            case ABK: {
                if (farbig != null) {
                    produktSB = new StringBuffer("Amtliche Basiskarte").append(Boolean.TRUE.equals(farbig) ? " (farbig)" : " (sw)");
                    break;
                }
                return null;
            }
            case BAB_ABSCHLUSS: 
            case BAB_WEITERLEITUNG: {
                return "Baulastenbescheinigung";
            }
            case LB_ABSCHLUSS: 
            case LB_WEITERLEITUNG: {
                return "Liegenschaftsbuchauszug";
            }
            default: {
                return null;
            }
        }
        produktSB.append(", ").append(FormSolutionsBestellungHandler.extractFormat(formSolutionsBestellung)).append(" ").append(massstab);
        return produktSB.toString();
    }

    private static String extractProduktKey(FormSolutionsBestellung formSolutionsBestellung, ProductType type) {
        if (type == null) {
            return null;
        }
        String farbauspraegung = formSolutionsBestellung.getFarbauspraegung();
        switch (type) {
            case SGK: {
                if ("farbig".equals(farbauspraegung)) {
                    return "LK.NRW.K.F";
                }
                if ("Graustufen".equals(farbauspraegung)) {
                    return "LK.NRW.K.SW";
                }
                return null;
            }
            case ABK: {
                if ("farbig".equals(farbauspraegung)) {
                    return "LK.GDBNRW.A.ABKF";
                }
                if ("Graustufen".equals(farbauspraegung)) {
                    return "LK.GDBNRW.A.ABKSW";
                }
                return null;
            }
            case BAB_WEITERLEITUNG: {
                return "BAB_WEITERLEITUNG";
            }
            case BAB_ABSCHLUSS: {
                return "BAB";
            }
            case LB_WEITERLEITUNG: {
                return "LB_WEITERLEITUNG";
            }
            case LB_ABSCHLUSS: {
                return "LB";
            }
        }
        return null;
    }

    private static String extractFormatKey(FormSolutionsBestellung formSolutionsBestellung) {
        String formatKey;
        String rawDin = formSolutionsBestellung.getFormat();
        String rawAusrichtung = formSolutionsBestellung.getAusrichtung();
        if (rawDin != null && rawDin.toUpperCase().contains("DIN") && rawAusrichtung != null) {
            String din = rawDin.trim().toUpperCase().split("DIN")[1].trim();
            String ausrichtung = rawAusrichtung.trim().toLowerCase();
            formatKey = din + "-" + ausrichtung;
        } else {
            formatKey = null;
        }
        return formatKey;
    }

    private static String extractFormat(FormSolutionsBestellung formSolutionsBestellung) {
        String format;
        String rawDin = formSolutionsBestellung.getFormat();
        String rawAusrichtung = formSolutionsBestellung.getAusrichtung();
        if (rawDin != null && rawAusrichtung != null) {
            String din = rawDin.trim().toUpperCase();
            String ausrichtung = rawAusrichtung.trim().toLowerCase();
            format = "hoch".equals(ausrichtung) ? din + " Hochformat" : din + " Querformat";
        } else {
            format = null;
        }
        return format;
    }

    private CidsBean getProduktBean(FormSolutionsBestellung formSolutionsBestellung, ProductType productType) throws RemoteException {
        String produktKey = FormSolutionsBestellungHandler.extractProduktKey(formSolutionsBestellung, productType);
        String formatKey = FormSolutionsBestellungHandler.extractFormatKey(formSolutionsBestellung);
        if (produktKey.equals("LB_WEITERLEITUNG") || produktKey.equals("LB")) {
            String flurstuecke = formSolutionsBestellung.getAusgewaehlteFlurstuecke();
            String buchungsblaetter = formSolutionsBestellung.getAusgewaehlteBuchungsblaetter();
            if (flurstuecke == null) {
                flurstuecke = formSolutionsBestellung.getFlurstueckskennzeichen();
            }
            if (buchungsblaetter == null) {
                buchungsblaetter = formSolutionsBestellung.getBuchungsblattkennzeichen();
            }
            int gebFuseKom = this.getObjectCount(flurstuecke);
            int gebBekom = this.getObjectCount(buchungsblaetter);
            produktKey = gebFuseKom > 0 && gebFuseKom <= gebBekom ? (produktKey.equals("LB_WEITERLEITUNG") ? "fsueKom_WEITERLEITUNG" : "fsueKom") : (produktKey.equals("LB_WEITERLEITUNG") ? "bekom_WEITERLEITUNG" : "bekom");
        }
        MetaClass produktTypMc = FormSolutionsBestellungHandler.getMetaClass("fs_bestellung_produkt_typ", this.getConnectionContext());
        MetaClass produktMc = FormSolutionsBestellungHandler.getMetaClass("fs_bestellung_produkt", this.getConnectionContext());
        MetaClass formatMc = FormSolutionsBestellungHandler.getMetaClass("fs_bestellung_format", this.getConnectionContext());
        String produktQuery = String.format(PRODUKT_QUERY_TEMPLATE, produktMc.getID(), produktMc.getTableName() + "." + produktMc.getPrimaryKey(), produktMc.getTableName() + ", " + produktTypMc.getTableName() + ", " + formatMc.getTableName(), (formatKey != null ? produktMc.getTableName() + ".fk_format = " + formatMc.getTableName() + ".id" : "TRUE") + " AND " + produktMc.getTableName() + ".fk_typ = " + produktTypMc.getTableName() + ".id AND " + produktTypMc.getTableName() + ".key = '" + produktKey + "' AND " + (formatKey != null ? formatMc.getTableName() + ".key = '" + formatKey + "'" : "TRUE"));
        MetaObject[] produktMos = this.getMetaService().getMetaObject(this.getUser(), produktQuery, this.getConnectionContext());
        produktMos[0].setAllClasses(((MetaClassCacheService)Lookup.getDefault().lookup(MetaClassCacheService.class)).getAllClasses(produktMos[0].getDomain(), this.getConnectionContext()));
        return produktMos[0].getBean();
    }

    private int getObjectCount(String objects) {
        if (objects != null) {
            return objects.split(",").length;
        }
        return 0;
    }

    private static String extractLandparcelcode(FormSolutionsBestellung formSolutionsBestellung) {
        LinkedHashSet<String> fskz = new LinkedHashSet<String>();
        String ausgewaehlteFlurstuecke = FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAusgewaehlteFlurstuecke());
        if (ausgewaehlteFlurstuecke != null) {
            for (String tmp : ausgewaehlteFlurstuecke.split(",")) {
                fskz.add(tmp);
            }
        } else {
            String flurstueckskennzeichen1;
            String flurstueckskennzeichen = FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getFlurstueckskennzeichen());
            if (flurstueckskennzeichen != null) {
                for (String tmp : flurstueckskennzeichen.split(",")) {
                    fskz.add(tmp);
                }
                if (fskz.isEmpty()) {
                    fskz.add(flurstueckskennzeichen);
                }
            }
            if ("Anschrift".equals(formSolutionsBestellung.getAuswahlUeber()) && (flurstueckskennzeichen1 = FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getFlurstueckskennzeichen1())) != null) {
                for (String tmp : flurstueckskennzeichen1.split(",")) {
                    fskz.add(tmp);
                }
            }
        }
        if (fskz.isEmpty()) {
            return null;
        }
        Iterator it = fskz.iterator();
        StringBuffer sb = new StringBuffer((String)it.next());
        while (it.hasNext()) {
            sb.append(",").append((String)it.next());
        }
        return sb.toString();
    }

    private static String extractBuchungsblatt(FormSolutionsBestellung formSolutionsBestellung) {
        LinkedHashSet<String> bbkz = new LinkedHashSet<String>();
        String ausgewaehlteBuchungsblaetter = FormSolutionsBestellungHandler.nullWhenEmptyAftertrim(formSolutionsBestellung.getAusgewaehlteBuchungsblaetter());
        if (ausgewaehlteBuchungsblaetter != null) {
            for (String tmp : ausgewaehlteBuchungsblaetter.split(",")) {
                bbkz.add(tmp);
            }
        } else {
            String buchungsblattkennzeichen = FormSolutionsBestellungHandler.nullWhenEmptyAftertrim(formSolutionsBestellung.getBuchungsblattkennzeichen());
            if (buchungsblattkennzeichen != null) {
                for (String tmp : buchungsblattkennzeichen.split(",")) {
                    bbkz.add(tmp);
                }
                if (bbkz.isEmpty()) {
                    bbkz.add(buchungsblattkennzeichen);
                }
            }
        }
        if (bbkz.isEmpty()) {
            return null;
        }
        Iterator it = bbkz.iterator();
        StringBuffer sb = new StringBuffer((String)it.next());
        while (it.hasNext()) {
            sb.append(",").append((String)it.next());
        }
        return sb.toString();
    }

    private static String getQueryParameterValue(String url, String parameterName) throws Exception {
        String[] pairs;
        URI uri = new URI(url);
        String query = uri.getQuery();
        for (String pair : pairs = query.split("&")) {
            String key;
            int idx = pair.indexOf("=");
            if (idx == -1 || !(key = pair.substring(0, idx)).equals(parameterName)) continue;
            return pair.substring(idx + 1);
        }
        return null;
    }

    private static MetaClass getMetaClass(String table_name, ConnectionContext connectionContext) {
        if (!METACLASS_CACHE.containsKey(table_name)) {
            MetaClass mc = null;
            try {
                mc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)table_name, (ConnectionContext)connectionContext);
            }
            catch (Exception ex) {
                LOG.error((Object)("could not get metaclass of " + table_name), (Throwable)ex);
            }
            METACLASS_CACHE.put(table_name, mc);
        }
        return METACLASS_CACHE.get(table_name);
    }

    private CidsBean createBestellungBean(FormSolutionsBestellung formSolutionsBestellung, ProductType productType) throws Exception {
        Double gebuehr;
        boolean isTest;
        CidsBean nachfolgerVonBean;
        boolean isAdresseAlternativVersand;
        MetaClass bestellungMc = FormSolutionsBestellungHandler.getMetaClass("fs_bestellung", this.getConnectionContext());
        MetaClass adresseMc = FormSolutionsBestellungHandler.getMetaClass("fs_bestellung_adresse", this.getConnectionContext());
        Integer tmpPlz = null;
        if (formSolutionsBestellung.getAsPlz() != null) {
            try {
                tmpPlz = Integer.parseInt(formSolutionsBestellung.getAsPlz());
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while parsing PLZ", (Throwable)ex);
            }
        }
        Integer plz = tmpPlz;
        Integer tmpPlz1 = null;
        if (formSolutionsBestellung.getAsPlz1() != null) {
            try {
                tmpPlz1 = Integer.parseInt(formSolutionsBestellung.getAsPlz1());
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while parsing PLZ1", (Throwable)ex);
            }
        }
        Integer plz1 = tmpPlz1;
        boolean isLieferEqualsRechnungAnschrift = "ja".equalsIgnoreCase(formSolutionsBestellung.getDieRechnungsanschriftAuchDieLieferanschrift()) || "ja".equalsIgnoreCase(formSolutionsBestellung.getRechnungsanschriftistLieferanschrift());
        CidsBean bestellungBean = bestellungMc.getEmptyInstance(this.getConnectionContext()).getBean();
        CidsBean adresseRechnungBean = adresseMc.getEmptyInstance(this.getConnectionContext()).getBean();
        CidsBean adresseVersandBean = isLieferEqualsRechnungAnschrift ? adresseRechnungBean : adresseMc.getEmptyInstance(this.getConnectionContext()).getBean();
        boolean checkAlternateAddress = ProductType.BAB_ABSCHLUSS.equals((Object)productType) || ProductType.BAB_WEITERLEITUNG.equals((Object)productType) || ProductType.LB_ABSCHLUSS.equals((Object)productType) || ProductType.LB_WEITERLEITUNG.equals((Object)productType);
        boolean isAdresseAlternativRechnung = formSolutionsBestellung.getAltAdresse() != null;
        boolean bl = isAdresseAlternativVersand = formSolutionsBestellung.getAltAdresseAbweichendeLieferanschrift() != null || formSolutionsBestellung.getAltAdresse1() != null;
        if (checkAlternateAddress && !isAdresseAlternativVersand && !isAdresseAlternativRechnung) {
            adresseVersandBean.setProperty("firma", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getFirmaAbweichendeLieferanschrift()));
            adresseVersandBean.setProperty("vorname", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsVorname1()));
            adresseVersandBean.setProperty("name", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsName1()));
            adresseVersandBean.setProperty("alternativ", null);
            adresseVersandBean.setProperty("strasse", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsStrasse1()));
            adresseVersandBean.setProperty("hausnummer", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsHausnummer1()));
            adresseVersandBean.setProperty("plz", (Object)plz1);
            adresseVersandBean.setProperty("ort", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsOrt1()));
            adresseVersandBean.setProperty("staat", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getStaat1()));
            adresseRechnungBean.setProperty("firma", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getFirma()));
            adresseRechnungBean.setProperty("vorname", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsVorname()));
            adresseRechnungBean.setProperty("name", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsName()));
            adresseRechnungBean.setProperty("alternativ", null);
            adresseRechnungBean.setProperty("strasse", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsStrasse()));
            adresseRechnungBean.setProperty("hausnummer", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsHausnummer()));
            adresseRechnungBean.setProperty("plz", (Object)plz);
            adresseRechnungBean.setProperty("ort", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsOrt()));
            adresseRechnungBean.setProperty("staat", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getStaat()));
        } else if (checkAlternateAddress && isAdresseAlternativVersand && !isAdresseAlternativRechnung) {
            adresseVersandBean.setProperty("firma", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getFirmaAbweichendeLieferanschrift()));
            adresseVersandBean.setProperty("vorname", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsVorname1()));
            adresseVersandBean.setProperty("name", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsName1()));
            adresseVersandBean.setProperty("alternativ", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAltAdresseAbweichendeLieferanschrift()));
            adresseVersandBean.setProperty("strasse", null);
            adresseVersandBean.setProperty("hausnummer", null);
            adresseVersandBean.setProperty("plz", null);
            adresseVersandBean.setProperty("ort", null);
            adresseVersandBean.setProperty("staat", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getStaat1()));
            adresseRechnungBean.setProperty("firma", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getFirma()));
            adresseRechnungBean.setProperty("vorname", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsVorname()));
            adresseRechnungBean.setProperty("name", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsName()));
            adresseRechnungBean.setProperty("alternativ", null);
            adresseRechnungBean.setProperty("strasse", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsStrasse()));
            adresseRechnungBean.setProperty("hausnummer", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsHausnummer()));
            adresseRechnungBean.setProperty("plz", (Object)plz);
            adresseRechnungBean.setProperty("ort", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsOrt()));
            adresseRechnungBean.setProperty("staat", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getStaat()));
        } else if (checkAlternateAddress && !isAdresseAlternativVersand && isAdresseAlternativRechnung) {
            adresseVersandBean.setProperty("firma", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getFirmaAbweichendeLieferanschrift()));
            adresseVersandBean.setProperty("vorname", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsVorname1()));
            adresseVersandBean.setProperty("name", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsName1()));
            adresseVersandBean.setProperty("alternativ", null);
            adresseVersandBean.setProperty("strasse", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsStrasse()));
            adresseVersandBean.setProperty("hausnummer", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsHausnummer()));
            adresseVersandBean.setProperty("plz", (Object)plz);
            adresseVersandBean.setProperty("ort", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsOrt()));
            adresseVersandBean.setProperty("staat", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getStaat1()));
            adresseRechnungBean.setProperty("firma", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getFirma()));
            adresseRechnungBean.setProperty("vorname", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsVorname()));
            adresseRechnungBean.setProperty("name", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsName()));
            adresseRechnungBean.setProperty("alternativ", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAltAdresse()));
            adresseRechnungBean.setProperty("strasse", null);
            adresseRechnungBean.setProperty("hausnummer", null);
            adresseRechnungBean.setProperty("plz", null);
            adresseRechnungBean.setProperty("ort", null);
            adresseRechnungBean.setProperty("staat", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getStaat()));
        } else if (checkAlternateAddress && isAdresseAlternativVersand && isAdresseAlternativRechnung) {
            adresseVersandBean.setProperty("firma", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getFirmaAbweichendeLieferanschrift()));
            adresseVersandBean.setProperty("vorname", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsVorname1()));
            adresseVersandBean.setProperty("name", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsName1()));
            adresseVersandBean.setProperty("alternativ", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAltAdresseAbweichendeLieferanschrift()));
            adresseVersandBean.setProperty("strasse", null);
            adresseVersandBean.setProperty("hausnummer", null);
            adresseVersandBean.setProperty("plz", null);
            adresseVersandBean.setProperty("ort", null);
            adresseVersandBean.setProperty("staat", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getStaat1()));
            adresseRechnungBean.setProperty("firma", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getFirma()));
            adresseRechnungBean.setProperty("vorname", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsVorname()));
            adresseRechnungBean.setProperty("name", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsName()));
            adresseRechnungBean.setProperty("alternativ", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAltAdresse()));
            adresseRechnungBean.setProperty("strasse", null);
            adresseRechnungBean.setProperty("hausnummer", null);
            adresseRechnungBean.setProperty("plz", null);
            adresseRechnungBean.setProperty("ort", null);
            adresseRechnungBean.setProperty("staat", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getStaat()));
        } else if (!checkAlternateAddress) {
            adresseVersandBean.setProperty("firma", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getFirma1()));
            adresseVersandBean.setProperty("vorname", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsVorname1()));
            adresseVersandBean.setProperty("name", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsName1()));
            adresseVersandBean.setProperty("alternativ", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAltAdresse1()));
            adresseVersandBean.setProperty("strasse", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsStrasse1()));
            adresseVersandBean.setProperty("hausnummer", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsHausnummer1()));
            adresseVersandBean.setProperty("plz", (Object)plz1);
            adresseVersandBean.setProperty("ort", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsOrt1()));
            adresseVersandBean.setProperty("staat", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getStaat1()));
            adresseRechnungBean.setProperty("firma", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getFirma()));
            adresseRechnungBean.setProperty("vorname", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsVorname()));
            adresseRechnungBean.setProperty("name", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsName()));
            adresseRechnungBean.setProperty("alternativ", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAltAdresse()));
            adresseRechnungBean.setProperty("strasse", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsStrasse()));
            adresseRechnungBean.setProperty("hausnummer", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsHausnummer()));
            adresseRechnungBean.setProperty("plz", (Object)plz);
            adresseRechnungBean.setProperty("ort", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getAsOrt()));
            adresseRechnungBean.setProperty("staat", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getStaat()));
        }
        String transid = formSolutionsBestellung.getTransId();
        if (ProductType.BAB_ABSCHLUSS.equals((Object)productType) || ProductType.LB_ABSCHLUSS.equals((Object)productType)) {
            String cacheId;
            String fileUrl = formSolutionsBestellung.getFileUrl() != null ? URLDecoder.decode(formSolutionsBestellung.getFileUrl(), "UTF-8") : null;
            String string = cacheId = fileUrl != null ? FormSolutionsBestellungHandler.getQueryParameterValue(fileUrl, "cacheID") : null;
            nachfolgerVonBean = cacheId != null ? this.searchBestellungByCacheId(cacheId) : null;
        } else {
            nachfolgerVonBean = null;
        }
        Integer massstab = formSolutionsBestellung.getMassstab() != null && formSolutionsBestellung.getMassstab().contains(":") ? Integer.valueOf(Integer.parseInt(formSolutionsBestellung.getMassstab().split(":")[1])) : null;
        String landparcelcode = nachfolgerVonBean != null ? (String)nachfolgerVonBean.getProperty("landparcelcode") : FormSolutionsBestellungHandler.extractLandparcelcode(formSolutionsBestellung);
        String buchungsblattcode = nachfolgerVonBean != null ? (String)nachfolgerVonBean.getProperty("buchungsblattcode") : FormSolutionsBestellungHandler.extractBuchungsblatt(formSolutionsBestellung);
        boolean isGutschein = formSolutionsBestellung.getGutschein() != null && 1 == Integer.parseInt(formSolutionsBestellung.getGutschein());
        String gutscheinCode = isGutschein ? formSolutionsBestellung.getGutscheinCode() : null;
        boolean bl2 = isTest = gutscheinCode != null && gutscheinCode.startsWith("T") || transid != null && transid.startsWith(TEST_CISMET00_PREFIX);
        Boolean postweg = "Kartenausdruck".equals(formSolutionsBestellung.getBezugsweg()) ? Boolean.TRUE : ("Post".equals(formSolutionsBestellung.getBezugsweg()) ? Boolean.TRUE : ("PDF-Download".equals(formSolutionsBestellung.getBezugsweg()) ? Boolean.FALSE : null));
        if (isGutschein) {
            gebuehr = 0.0;
        } else {
            Double tmpGebuehr = null;
            try {
                tmpGebuehr = Double.parseDouble(((ProductType.BAB_ABSCHLUSS.equals((Object)productType) || ProductType.LB_ABSCHLUSS.equals((Object)productType)) && Boolean.FALSE.equals(postweg) ? formSolutionsBestellung.getBetragDL() : formSolutionsBestellung.getBetrag()).replaceAll(",", "."));
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while parsing Gebuehr", (Throwable)ex);
            }
            gebuehr = tmpGebuehr;
        }
        CidsBean produktBean = this.getProduktBean(formSolutionsBestellung, productType);
        bestellungBean.setProperty("postweg", (Object)postweg);
        bestellungBean.setProperty("transid", (Object)transid);
        bestellungBean.setProperty("landparcelcode", (Object)landparcelcode);
        bestellungBean.setProperty("buchungsblattcode", (Object)buchungsblattcode);
        bestellungBean.setProperty("fk_produkt", (Object)produktBean);
        bestellungBean.setProperty("massstab", (Object)massstab);
        bestellungBean.setProperty("fk_adresse_versand", (Object)adresseVersandBean);
        bestellungBean.setProperty("fk_adresse_rechnung", (Object)adresseRechnungBean);
        bestellungBean.setProperty("email", (Object)FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getEMailadresse()));
        bestellungBean.setProperty("erledigt", (Object)Boolean.FALSE);
        bestellungBean.setProperty("eingang_ts", (Object)new Timestamp(new Date().getTime()));
        bestellungBean.setProperty("gebuehr", (Object)gebuehr);
        bestellungBean.setProperty("gutschein_code", (Object)gutscheinCode);
        bestellungBean.setProperty("test", (Object)isTest);
        bestellungBean.setProperty("nachfolger_von", (Object)nachfolgerVonBean);
        return bestellungBean;
    }

    private double calculateBabGebuehr(String productKey, String usagekey, BerechtigungspruefungBescheinigungDownloadInfo downloadInfo) {
        BillingProduct product = this.billingInfoHander.getProducts().get(productKey);
        ArrayList<BillingProductGroupAmount> prodAmounts = new ArrayList<BillingProductGroupAmount>();
        for (Map.Entry<String, Integer> amount : downloadInfo.getAmounts().entrySet()) {
            prodAmounts.add(new BillingProductGroupAmount(amount.getKey(), amount.getValue()));
        }
        double raw = BillingInfoHandler.calculateRawPrice(product, prodAmounts.toArray(new BillingProductGroupAmount[0]));
        BillingPrice price = new BillingPrice(raw, usagekey, product);
        return price.getNetto();
    }

    private double calculateLBGebuehr(String productKey, String usagekey, BerechtigungspruefungAlkisEinzelnachweisDownloadInfo downloadInfo) {
        BillingProduct product = this.billingInfoHander.getProducts().get(productKey);
        double raw = BillingInfoHandler.calculateRawLBPrice(product, downloadInfo.getAmounts());
        BillingPrice price = new BillingPrice(raw, usagekey, product);
        return price.getNetto();
    }

    private static String trimedNotEmpty(String string) {
        if (string == null) {
            return null;
        }
        String trimed = string.trim();
        if (trimed.isEmpty()) {
            return null;
        }
        return trimed;
    }

    private static String nullWhenEmptyAftertrim(String string) {
        if (string == null) {
            return null;
        }
        String trimed = string.trim();
        if (trimed.isEmpty()) {
            return null;
        }
        return string;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private AlkisProductDescription getAlkisProductDescription(String produktKey, String dinFormat, Integer massstab) {
        String scale = Integer.toString(massstab);
        AlkisProductDescription selectedProduct = null;
        for (AlkisProductDescription product : ServerAlkisProducts.getInstance().getAlkisMapProducts()) {
            if (!product.getCode().startsWith(produktKey) || !scale.equals(product.getMassstab()) || !dinFormat.equals(product.getDinFormat())) continue;
            selectedProduct = product;
            break;
        }
        return selectedProduct;
    }

    private Collection<CidsBean> executeSearch(MetaObjectNodeServerSearch search) throws Exception {
        HashMap<String, MetaService> localServers = new HashMap<String, MetaService>();
        localServers.put("WUNDA_BLAU", this.getMetaService());
        search.setActiveLocalServers(localServers);
        search.setUser(this.getUser());
        Collection mons = search.performServerSearch();
        ArrayList<CidsBean> cidsBeans = new ArrayList<CidsBean>();
        if (mons != null) {
            for (MetaObjectNode mon : mons) {
                CidsBean cidsBean = this.getMetaService().getMetaObject(this.getUser(), mon.getObjectId(), mon.getClassId(), this.getConnectionContext()).getBean();
                cidsBeans.add(cidsBean);
            }
            return cidsBeans;
        }
        return null;
    }

    private CidsBean executeSingleResultSearch(MetaObjectNodeServerSearch search) throws Exception {
        Collection<CidsBean> cidsBeans = this.executeSearch(search);
        if (cidsBeans != null && !cidsBeans.isEmpty()) {
            return cidsBeans.iterator().next();
        }
        return null;
    }

    private CidsBean searchBestellungByCacheId(String cacheId) throws Exception {
        FormSolutionsBestellungSearch search = new FormSolutionsBestellungSearch();
        search.setCacheId(cacheId);
        return this.executeSingleResultSearch(search);
    }

    private CidsBean getFlurstueck(String flurstueckKennzeichen) throws Exception {
        CidsAlkisSearchStatement search = new CidsAlkisSearchStatement(CidsAlkisSearchStatement.Resulttyp.FLURSTUECK, CidsAlkisSearchStatement.SucheUeber.FLURSTUECKSNUMMER, flurstueckKennzeichen, null);
        return this.executeSingleResultSearch(search);
    }

    private CidsBean getBuchungsblatt(String buchungsblattKennzeichen) throws Exception {
        CidsAlkisSearchStatement search = new CidsAlkisSearchStatement(CidsAlkisSearchStatement.Resulttyp.BUCHUNGSBLATT, CidsAlkisSearchStatement.SucheUeber.BUCHUNGSBLATTNUMMER, AlkisProducts.fixBuchungslattCode(buchungsblattKennzeichen), null, false);
        return this.executeSingleResultSearch(search);
    }

    private URL createProductUrl(CidsBean bestellungBean, boolean ignoreError) throws Exception {
        if (bestellungBean != null && !Boolean.TRUE.equals(bestellungBean.getProperty("duplicate")) && (ignoreError || bestellungBean.getProperty("fehler") == null)) {
            String code = (String)bestellungBean.getProperty("fk_produkt.fk_typ.key");
            String dinFormat = (String)bestellungBean.getProperty("fk_produkt.fk_format.format");
            Integer scale = (Integer)bestellungBean.getProperty("massstab");
            AlkisProductDescription productDesc = this.getAlkisProductDescription(code, dinFormat, scale);
            String flurstueckKennzeichen = ((String)bestellungBean.getProperty("landparcelcode")).split(",")[0];
            String transid = (String)bestellungBean.getProperty("transid");
            Geometry geom = (Geometry)bestellungBean.getProperty("geometrie.geo_field");
            Point center = geom.getEnvelope().getCentroid();
            boolean isGutschein = bestellungBean.getProperty("gutschein_code") != null;
            String gutscheincodeAdditionalText = isGutschein ? String.format(GUTSCHEIN_ADDITIONAL_TEXT, bestellungBean.getProperty("gutschein_code")) : null;
            URL url = ServerAlkisProducts.getInstance().productKarteUrl(flurstueckKennzeichen, productDesc.getCode(), 0, (int)center.getX(), (int)center.getY(), productDesc.getMassstab(), productDesc.getMassstabMin(), productDesc.getMassstabMax(), gutscheincodeAdditionalText, transid, false, null);
            return url;
        }
        return null;
    }

    private void uploadProduktToFtp(InputStream in, String fileName, boolean testPdf) throws Exception {
        File tmpFile = this.writeProduktToFile(in, FormSolutionsBestellungHandler.getProperties().getTmpBrokenpdfsAbsPath() + DomainServerImpl.getServerProperties().getFileSeparator() + fileName);
        if (testPdf) {
            try (FileInputStream Test = new FileInputStream(tmpFile);){
                FormSolutionsBestellungHandler.testPdfValidity(Test);
            }
        }
        String ftpFilePath = FormSolutionsBestellungHandler.getProperties().getProduktBasepath() + "/" + fileName;
        FormSolutionsBestellungHandler.getFtpClient().upload(new FileInputStream(tmpFile), ftpFilePath);
        if (testPdf) {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                FormSolutionsBestellungHandler.getFtpClient().download(ftpFilePath, out);
                try (ByteArrayInputStream inTest = new ByteArrayInputStream(out.toByteArray());){
                    FormSolutionsBestellungHandler.testPdfValidity(inTest);
                }
            }
        }
        if (!FormSolutionsBestellungHandler.getProperties().isDeleteTmpProductAfterSuccessfulUploadDisabled() && tmpFile != null) {
            tmpFile.delete();
        }
    }

    private static String ensureCorrectDirectorySeparator(String filePath) {
        String s = DomainServerImpl.getServerProperties().getFileSeparator();
        return "/".equals(s) ? filePath : filePath.replace("/", s);
    }

    private void saveProduktInFtpMount(InputStream in, String fileName, boolean testPdf) throws Exception {
        File mntFile = this.writeProduktToFile(in, FormSolutionsBestellungHandler.getProperties().getFtpMountAbsPath() + FormSolutionsBestellungHandler.ensureCorrectDirectorySeparator("/" + fileName));
        if (testPdf) {
            try (FileInputStream Test = new FileInputStream(mntFile);){
                FormSolutionsBestellungHandler.testPdfValidity(Test);
            }
        }
    }

    private File writeProduktToFile(InputStream in, String fileName) throws Exception {
        File tmpFile = new File(DomainServerImpl.getServerProperties().getFileSeparator() + fileName);
        try (FileOutputStream out = new FileOutputStream(tmpFile);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        return tmpFile;
    }

    private static void testPdfValidity(InputStream in) throws Exception {
        try (InputStreamReader ir = new InputStreamReader(in);
             BufferedReader rd = new BufferedReader(ir);){
            String line;
            String firstLine = null;
            String lastLine = null;
            while ((line = rd.readLine()) != null) {
                if (firstLine == null) {
                    firstLine = line;
                }
                lastLine = line;
            }
            if (firstLine == null) {
                throw new Exception("PDF broken: first line is null");
            }
            if (!firstLine.startsWith(PDF_START)) {
                throw new Exception("PDF broken: first line doesn't start with %PDF");
            }
            if (!PDF_END.equals(lastLine)) {
                throw new Exception("PDF broken: last line equals %%EOF");
            }
        }
    }

    private Map<String, String> step2ExtractXmlParts(Collection<String> transids) {
        this.specialLog("extracting xml parts for num of objects: " + transids.size());
        HashMap<String, String> fsXmlMap = new HashMap<String, String>(transids.size());
        for (String transid : transids) {
            try {
                String auftragXml = this.getAuftrag(transid);
                if (auftragXml == null) {
                    throw new Exception("xml tag does not contain data");
                }
                fsXmlMap.put(transid, auftragXml);
                FormSolutionsBestellungHandler.getMySqlHelper().updateStatus(transid, 70);
                String email = null;
                if (auftragXml != null) {
                    try (InputStream in = IOUtils.toInputStream((String)auftragXml, (String)"UTF-8");){
                        FormSolutionsBestellung formSolutionsBestellung = this.createFormSolutionsBestellung(in);
                        email = FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getEMailadresse());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.doStatusChangedRequest(transid, this.isInternalEmail(email));
            }
            catch (Exception ex) {
                this.setErrorStatus(transid, 70, null, "Fehler beim Abholen FormSolution", ex);
            }
        }
        return fsXmlMap;
    }

    private Map<String, FormSolutionsBestellung> step3CreateBestellungMap(Map<String, String> fsXmlMap, Map<String, ProductType> typeMap) {
        ArrayList<String> transids = new ArrayList<String>(fsXmlMap.keySet());
        this.specialLog("creating simple bestellung bean for num of objects: " + transids.size());
        HashMap<String, FormSolutionsBestellung> fsBestellungMap = new HashMap<String, FormSolutionsBestellung>(transids.size());
        for (String transid : transids) {
            String auftragXml = fsXmlMap.get(transid);
            try {
                InputStream in = IOUtils.toInputStream((String)auftragXml, (String)"UTF-8");
                Throwable throwable = null;
                try {
                    this.specialLog("creating simple bestellung bean for: " + transid);
                    FormSolutionsBestellung formSolutionsBestellung = this.createFormSolutionsBestellung(in);
                    fsBestellungMap.put(transid, formSolutionsBestellung);
                    this.specialLog("simple bestellung bean created for: " + transids.size());
                    boolean downloadOnly = !"Kartenausdruck".equals(formSolutionsBestellung.getBezugsweg());
                    String email = FormSolutionsBestellungHandler.trimedNotEmpty(formSolutionsBestellung.getEMailadresse());
                    this.specialLog("updating mysql email entry for: " + transid);
                    FormSolutionsBestellungHandler.getMySqlHelper().updateRequest(transid, 60, FormSolutionsBestellungHandler.extractLandparcelcode(formSolutionsBestellung), FormSolutionsBestellungHandler.extractBuchungsblatt(formSolutionsBestellung), FormSolutionsBestellungHandler.extractProduct(formSolutionsBestellung, typeMap.get(transid)), downloadOnly, email);
                    this.doStatusChangedRequest(transid, this.isInternalEmail(email));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception ex) {
                this.setErrorStatus(transid, 60, null, "Fehler beim Parsen FormSolution", ex);
            }
        }
        return fsBestellungMap;
    }

    public boolean isServerInProduction() {
        boolean prod = "production".equalsIgnoreCase(DomainServerImpl.getServerProperties().getDeployEnv());
        return prod;
    }

    private void createGeom(CidsBean bestellungBean) throws Exception {
        MetaClass geomMc = FormSolutionsBestellungHandler.getMetaClass("geom", this.getConnectionContext());
        CidsBean geomBean = geomMc.getEmptyInstance(this.getConnectionContext()).getBean();
        Geometry geom = null;
        if (bestellungBean.getProperty("buchungsblattcode") != null) {
            String[] buchungsblaetter = ((String)bestellungBean.getProperty("buchungsblattcode")).split(",");
            if (bestellungBean.getProperty("landparcelcode") == null || buchungsblaetter.length < ((String)bestellungBean.getProperty("landparcelcode")).split(",").length) {
                for (String buchungsblattcode : buchungsblaetter) {
                    CidsBean buchungsblatt = this.getBuchungsblatt(AlkisProducts.fixBuchungslattCode(buchungsblattcode));
                    if (buchungsblatt == null) {
                        throw new Exception("ALKIS Buchungsblatt wurde nicht gefunden (" + buchungsblattcode + ")");
                    }
                    Object colObj = buchungsblatt.getProperty("landparcels");
                    if (!(colObj instanceof Collection)) continue;
                    List landparcelList = (List)colObj;
                    for (CidsBean landparcel : landparcelList) {
                        Geometry flurgeom = (Geometry)landparcel.getProperty("geometrie");
                        if (geom == null) {
                            geom = flurgeom;
                            continue;
                        }
                        geom = flurgeom.union(geom);
                    }
                }
            }
        }
        if (geom == null && bestellungBean.getProperty("landparcelcode") != null) {
            String[] landparcelcodes;
            for (String landparcelcode : landparcelcodes = ((String)bestellungBean.getProperty("landparcelcode")).split(",")) {
                CidsBean flurstueck = this.getFlurstueck(landparcelcode);
                if (flurstueck == null) {
                    throw new Exception("ALKIS Flurst\u00fcck wurde nicht gefunden (" + landparcelcode + ")");
                }
                Geometry flurgeom = (Geometry)flurstueck.getProperty("geometrie");
                geom = geom == null ? flurgeom : flurgeom.union(geom);
            }
        }
        if (geom != null) {
            geomBean.setProperty("geo_field", geom);
            bestellungBean.setProperty("geometrie", (Object)geomBean);
        }
    }

    private Map<String, CidsBean> step4CreateCidsEntries(Map<String, String> fsXmlMap, Map<String, FormSolutionsBestellung> fsBestellungMap, Map<String, ProductType> typeMap, Map<String, Exception> insertExceptionMap) {
        ArrayList<String> transids = new ArrayList<String>(fsBestellungMap.keySet());
        this.specialLog("creating cids entries for num of objects: " + transids.size());
        HashMap<String, CidsBean> fsBeanMap = new HashMap<String, CidsBean>(transids.size());
        for (String transid : transids) {
            this.specialLog("creating cids entry for: " + transid);
            String auftragXml = fsXmlMap.get(transid);
            FormSolutionsBestellung formSolutionBestellung = fsBestellungMap.get(transid);
            try {
                Exception insertException = insertExceptionMap.get(transid);
                ProductType type = typeMap.get(transid);
                CidsBean bestellungBean = this.createBestellungBean(formSolutionBestellung, type);
                bestellungBean.setProperty("form_xml_orig", (Object)auftragXml);
                bestellungBean.setProperty("duplicate", (Object)false);
                if (insertException != null) {
                    bestellungBean.setProperty("fehler", (Object)"Fehler beim Erzeugen des MySQL-Datensatzes");
                    bestellungBean.setProperty("exception", (Object)this.getObjectMapper().writeValueAsString((Object)insertException));
                    bestellungBean.setProperty("fehler_ts", (Object)new Timestamp(new Date().getTime()));
                }
                try {
                    this.createGeom(bestellungBean);
                }
                catch (Exception ex) {
                    this.setErrorStatus(transid, 55, bestellungBean, "Fehler beim Laden des Flurst\u00fccks", ex, false);
                }
                this.specialLog("persisting cids entry for: " + transid);
                MetaObject persistedMo = this.getMetaService().insertMetaObject(this.getUser(), bestellungBean.getMetaObject(), this.getConnectionContext());
                CidsBean persistedBestellungBean = persistedMo.getBean();
                fsBeanMap.put(transid, persistedBestellungBean);
                FormSolutionsBestellungHandler.getMySqlHelper().updateStatus(transid, 50);
                String email = FormSolutionsBestellungHandler.trimedNotEmpty((String)bestellungBean.getProperty("email"));
                this.doStatusChangedRequest(transid, this.isInternalEmail(email));
            }
            catch (Exception ex) {
                this.setErrorStatus(transid, 50, null, "Fehler beim Erstellen des Bestellungs-Objektes", ex);
            }
        }
        return fsBeanMap;
    }

    private static ProductType parseProductType(String string) {
        if (ProductType.SGK.toString().equals(string)) {
            return ProductType.SGK;
        }
        if (ProductType.ABK.toString().equals(string)) {
            return ProductType.ABK;
        }
        if (ProductType.BAB_WEITERLEITUNG.toString().equals(string)) {
            return ProductType.BAB_WEITERLEITUNG;
        }
        if (ProductType.BAB_ABSCHLUSS.toString().equals(string)) {
            return ProductType.BAB_ABSCHLUSS;
        }
        if (ProductType.LB_WEITERLEITUNG.toString().equals(string)) {
            return ProductType.LB_WEITERLEITUNG;
        }
        if (ProductType.LB_ABSCHLUSS.toString().equals(string)) {
            return ProductType.LB_ABSCHLUSS;
        }
        return null;
    }

    private Map<String, Exception> step1CreateMySqlEntries(Collection<String> transids) throws SQLException {
        HashMap<String, Exception> insertExceptionMap = new HashMap<String, Exception>(transids.size());
        for (String transid : transids) {
            this.specialLog("updating or inserting mySQL entry for: " + transid);
            FormSolutionsBestellungHandler.getMySqlHelper().insertOrUpdateStatus(transid, 100);
            this.doStatusChangedRequest(transid, false);
        }
        return insertExceptionMap;
    }

    private void step5CloseTransactions(Map<String, CidsBean> fsBeanMap) {
        if (fsBeanMap != null) {
            ArrayList<String> transids = new ArrayList<String>(fsBeanMap.keySet());
            this.specialLog("closing transactions for num of objects: " + transids.size());
            for (String transid : transids) {
                CidsBean bestellungBean = fsBeanMap.get(transid);
                if (bestellungBean == null) continue;
                try {
                    boolean closeVeto;
                    this.specialLog("closing transaction for: " + transid);
                    boolean bl = closeVeto = transid == null || transid.startsWith(TEST_CISMET00_PREFIX) || DomainServerImpl.getServerInstance().hasConfigAttr(this.getUser(), "custom.formsolutions.noclose", this.getConnectionContext());
                    if (this.isServerInProduction() && !closeVeto) {
                        this.getHttpAccessHandler().doRequest(new URL(String.format(FormSolutionsBestellungHandler.getProperties().getUrlAuftragDeleteFs(), transid.substring(0, transid.indexOf("-")), transid)), (Reader)new StringReader(""), "text/plain", AccessHandler.ACCESS_METHODS.POST_REQUEST, null, this.creds);
                    }
                    FormSolutionsBestellungHandler.getMySqlHelper().updateStatus(transid, 40);
                    String email = FormSolutionsBestellungHandler.trimedNotEmpty((String)bestellungBean.getProperty("email"));
                    this.doStatusChangedRequest(transid, this.isInternalEmail(email));
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }
    }

    public static String noNullAndTrimed(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    private InputStream downloadProduct(URL productUrl) throws Exception {
        return this.getHttpAccessHandler().doRequest(productUrl, (Reader)new StringReader(""), AccessHandler.ACCESS_METHODS.GET_REQUEST, null, this.creds);
    }

    private String extractKundenLogin(CidsBean bestellungBean) {
        if (bestellungBean == null) {
            return null;
        }
        ProductType productType = this.determineProductType(bestellungBean);
        if (productType == null) {
            return null;
        }
        switch (productType) {
            case SGK: 
            case ABK: {
                return FormSolutionsBestellungHandler.getProperties().getBillingKundeLoginKarte();
            }
            case LB_ABSCHLUSS: {
                return FormSolutionsBestellungHandler.getProperties().getBillingKundeLoginLB();
            }
            case BAB_ABSCHLUSS: {
                return FormSolutionsBestellungHandler.getProperties().getBillingKundeLoginBB();
            }
        }
        return null;
    }

    private Double extractGebuehr(CidsBean bestellungBean) {
        if (bestellungBean == null) {
            return null;
        }
        if (bestellungBean.getProperty("gutschein_code") != null) {
            return 0.0;
        }
        return (Double)bestellungBean.getProperty("gebuehr");
    }

    private InputStream createRechnung(CidsBean bestellungBean) throws Exception {
        String buchungsblattcode;
        String landparcelcode;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ProductType productType = this.determineProductType(bestellungBean);
        String landparcelcodesString = FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("landparcelcode"));
        if (landparcelcodesString != null && !landparcelcodesString.isEmpty()) {
            String[] landparcelcodes = landparcelcodesString.split(",");
            landparcelcode = landparcelcodes[0] + (landparcelcodes.length > 1 ? " u.a." : "");
        } else {
            landparcelcode = null;
        }
        String buchungsblattString = FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("buchungsblattcode"));
        if (buchungsblattString != null && !buchungsblattString.isEmpty()) {
            String[] buchungsblattcodes = buchungsblattString.split(",");
            buchungsblattcode = buchungsblattcodes[0] + (buchungsblattcodes.length > 1 ? " u.a." : "");
        } else {
            buchungsblattcode = null;
        }
        parameters.put("DATUM_HEUTE", new SimpleDateFormat("dd.MM.yyyy").format(new Date()));
        String datumEingang = bestellungBean.getProperty("eingang_ts") != null ? new SimpleDateFormat("dd.MM.yyyy").format(bestellungBean.getProperty("eingang_ts")) : "";
        parameters.put("DATUM_EINGANG", FormSolutionsBestellungHandler.noNullAndTrimed(datumEingang));
        parameters.put("FLURSTUECKSKENNZEICHEN", landparcelcode);
        parameters.put("BUCHUNGSBLATTKENNZEICHEN", buchungsblattcode);
        parameters.put("TRANSAKTIONSID", FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("transid")));
        parameters.put("LIEFER_FIRMA", FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_adresse_versand.firma")));
        parameters.put("LIEFER_VORNAME", FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_adresse_versand.vorname")));
        parameters.put("LIEFER_NAME", FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_adresse_versand.name")));
        String lieferStrasse = FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_adresse_versand.strasse"));
        String lieferHausnummer = FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_adresse_versand.hausnummer"));
        String lieferPlz = FormSolutionsBestellungHandler.noNullAndTrimed(bestellungBean.getProperty("fk_adresse_versand.plz") != null ? Integer.toString((Integer)bestellungBean.getProperty("fk_adresse_versand.plz")) : null);
        String lieferOrt = FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_adresse_versand.ort"));
        String lieferStaat = FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_adresse_versand.staat"));
        String lieferAlternativ = FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_adresse_versand.alternativ"));
        String lieferAdresse = lieferAlternativ.isEmpty() ? lieferStrasse + " " + lieferHausnummer + "\n" + lieferPlz + " " + lieferOrt : lieferAlternativ + "\n" + lieferStaat;
        parameters.put("LIEFER_STRASSE", lieferStrasse);
        parameters.put("LIEFER_HAUSNUMMER", lieferHausnummer);
        parameters.put("LIEFER_PLZ", lieferPlz);
        parameters.put("LIEFER_ORT", lieferOrt);
        parameters.put("LIEFER_ALTERNATIV", lieferAlternativ);
        parameters.put("LIEFER_ADRESSE", lieferAdresse);
        parameters.put("RECHNUNG_FIRMA", FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_adresse_rechnung.firma")));
        parameters.put("RECHNUNG_VORNAME", FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_adresse_rechnung.vorname")));
        parameters.put("RECHNUNG_NAME", FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_adresse_rechnung.name")));
        String rechnungStrasse = FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_adresse_rechnung.strasse"));
        String rechnungHausnummer = FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_adresse_rechnung.hausnummer"));
        String rechnungPlz = FormSolutionsBestellungHandler.noNullAndTrimed(bestellungBean.getProperty("fk_adresse_rechnung.plz") != null ? Integer.toString((Integer)bestellungBean.getProperty("fk_adresse_rechnung.plz")) : null);
        String rechnungOrt = FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_adresse_rechnung.ort"));
        String rechnungStaat = FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_adresse_rechnung.staat"));
        String rechnungAlternativ = FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_adresse_rechnung.alternativ"));
        String rechnungAdresse = rechnungAlternativ.isEmpty() ? rechnungStrasse + " " + rechnungHausnummer + "\n" + rechnungPlz + " " + rechnungOrt : rechnungAlternativ + "\n" + rechnungStaat;
        String gutscheinCode = (String)bestellungBean.getProperty("gutschein_code");
        parameters.put("RECHNUNG_STRASSE", rechnungStrasse);
        parameters.put("RECHNUNG_HAUSNUMMER", rechnungHausnummer);
        parameters.put("RECHNUNG_PLZ", rechnungPlz);
        parameters.put("RECHNUNG_ORT", rechnungOrt);
        parameters.put("RECHNUNG_ALTERNATIV", rechnungAlternativ);
        parameters.put("RECHNUNG_ADRESSE", rechnungAdresse);
        parameters.put("RECHNUNG_FORMAT", FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_produkt.fk_format.format")));
        parameters.put("RECHNUNG_LEISTUNG", FormSolutionsBestellungHandler.noNullAndTrimed((String)bestellungBean.getProperty("fk_produkt.fk_typ.name")) + "\n" + bestellungBean.getProperty("transid"));
        Double gebuehr = this.extractGebuehr(bestellungBean);
        float gebuehrFloat = gebuehr != null ? gebuehr.floatValue() : 0.0f;
        parameters.put("RECHNUNG_GES_BETRAG", Float.valueOf(gebuehrFloat));
        parameters.put("RECHNUNG_EINZELPREIS", Float.valueOf(gebuehrFloat));
        parameters.put("RECHNUNG_GESAMMTPREIS", Float.valueOf(gebuehrFloat));
        parameters.put("RECHNUNG_BERECH_GRUNDLAGE", ProductType.BAB_ABSCHLUSS.equals((Object)productType) ? FormSolutionsBestellungHandler.getProperties().getRechnungBerechnugsgGrundlageBaulasten() : (ProductType.LB_ABSCHLUSS.equals((Object)productType) ? FormSolutionsBestellungHandler.getProperties().getRechnungBerechnugsgGrundlageLB() : FormSolutionsBestellungHandler.getProperties().getRechnungBerechnugsgGrundlageKarte()));
        parameters.put("RECHNUNG_AUFTRAGSART", ProductType.BAB_ABSCHLUSS.equals((Object)productType) ? FormSolutionsBestellungHandler.getProperties().getRechnungAuftragsartBaulasten() : (ProductType.LB_ABSCHLUSS.equals((Object)productType) ? FormSolutionsBestellungHandler.getProperties().getRechnungAuftragsartLB() : FormSolutionsBestellungHandler.getProperties().getRechnungAuftragsartKarte()));
        parameters.put("RECHNUNG_ANZAHL", 1);
        parameters.put("RECHNUNG_RABATT", Float.valueOf(0.0f));
        parameters.put("RECHNUNG_UST", Float.valueOf(0.0f));
        parameters.put("RECHNUNG_GUTSCHEINCODE", gutscheinCode);
        parameters.put("SUBREPORT_DIR", DomainServerImpl.getServerProperties().getServerResourcesBasePath() + "/");
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(Arrays.asList(bestellungBean));
        JasperReport rechnungJasperReport = ServerResourcesLoader.getInstance().loadJasperReport(WundaBlauServerResources.FS_RECHNUNG_JASPER.getValue());
        JasperPrint print = JasperFillManager.fillReport((JasperReport)rechnungJasperReport, parameters, (JRDataSource)dataSource);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            JasperExportManager.exportReportToPdfStream((JasperPrint)print, (OutputStream)os);
            byte[] bytes = os.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void step6PruefungProdukt(Map<String, CidsBean> fsBeanMap, boolean repairErrors) {
        transids = new ArrayList<String>(fsBeanMap.keySet());
        block40: for (String transid : transids) {
            bestellungBean = fsBeanMap.get(transid);
            if (bestellungBean == null || Boolean.TRUE.equals(bestellungBean.getProperty("duplicate")) || !repairErrors && bestellungBean.getProperty("fehler") != null) continue;
            try {
                productType = this.determineProductType(bestellungBean);
                switch (4.$SwitchMap$de$cismet$cids$custom$utils$formsolutions$FormSolutionsBestellungHandler$ProductType[productType.ordinal()]) {
                    case 5: {
                        flurstueckKennzeichen = (String)bestellungBean.getProperty("landparcelcode");
                        produktbezeichnung = transid;
                        flurstuecke = new ArrayList<CidsBean>();
                        if (flurstueckKennzeichen != null) {
                            for (String einzelFSKennzeichen : flurstueckKennzeichen.split(",")) {
                                flurstueck = this.getFlurstueck(einzelFSKennzeichen);
                                if (flurstueck == null) {
                                    throw new Exception(String.format("ALKIS-Flurst\u00fcck %s konnte nicht gefunden werden!", new Object[]{einzelFSKennzeichen}));
                                }
                                flurstuecke.add(flurstueck);
                            }
                            if (flurstuecke.isEmpty()) {
                                throw new Exception(String.format("Es konnten keine Flurst\u00fccke gefunden werden.", new Object[0]));
                            }
                        }
                        protocolBuffer = new BaulastBescheinigungHelper.ProtocolBuffer();
                        statusHolder = new BaulastBescheinigungHelper.StatusHolder(){

                            @Override
                            public void setMessage(String message) {
                                super.setMessage(message);
                                LOG.info((Object)message);
                            }
                        };
                        downloadInfo = this.getBaulastBescheinigungHelper().calculateDownloadInfo(null, produktbezeichnung, null, flurstuecke, (BaulastBescheinigungHelper.ProtocolBuffer)protocolBuffer, statusHolder);
                        verwendungskeyDownload = FormSolutionsBestellungHandler.getProperties().getBillingVerwendungskeyDownload();
                        verwendungskeyPostweg = FormSolutionsBestellungHandler.getProperties().getBillingVerwendungskeyPostweg();
                        productKeyDownload = FormSolutionsBestellungHandler.getProperties().getBillingProduktkeyBBDownload();
                        productKeyPostweg = FormSolutionsBestellungHandler.getProperties().getBillingProduktkeyBBPostweg();
                        isGutschein = bestellungBean.getProperty("gutschein_code") != null;
                        gebuehr = isGutschein != false ? 0.0 : this.calculateBabGebuehr(productKeyDownload, verwendungskeyDownload, downloadInfo);
                        gebuehrPostweg = isGutschein != false ? 0.0 : this.calculateBabGebuehr(productKeyPostweg, verwendungskeyPostweg, downloadInfo);
                        bestellungBean.setProperty("gebuehr", (Object)gebuehr);
                        bestellungBean.setProperty("gebuehr_postweg", (Object)gebuehrPostweg);
                        auftragXml = (String)bestellungBean.getProperty("form_xml_orig");
                        in = IOUtils.toInputStream((String)auftragXml, (String)"UTF-8");
                        var24_38 = null;
                        formSolutionBestellung = this.createFormSolutionsBestellung(in);
                        schluessel = null;
                        if (bestellungBean.getProperty("berechtigungspruefung") == null) {
                            schluessel = BerechtigungspruefungHandler.getInstance().createNewSchluessel(downloadInfo);
                            attachementsFile = new File(String.format("%s/%s.zip", new Object[]{FormSolutionsBestellungHandler.getProperties().getAnhangTmpAbsPath(), transid}));
                            if (attachementsFile.exists()) {
                                in2 = new FileInputStream(attachementsFile);
                                var31_49 = null;
                                try {
                                    dateiName = attachementsFile.getName();
                                    data = IOUtils.toByteArray((InputStream)in2);
                                }
                                catch (Throwable var32_52) {
                                    var31_49 = var32_52;
                                    throw var32_52;
                                }
                                finally {
                                    if (in2 != null) {
                                        if (var31_49 != null) {
                                            try {
                                                in2.close();
                                            }
                                            catch (Throwable var32_51) {
                                                var31_49.addSuppressed(var32_51);
                                            }
                                        } else {
                                            in2.close();
                                        }
                                    }
                                }
                            } else {
                                dateiName = null;
                                data = null;
                            }
                            downloadInfo.setAuftragsnummer(schluessel);
                            userKey = (String)this.getUser().getKey();
                            pruefung = BerechtigungspruefungHandler.getInstance().addNewAnfrage(userKey, schluessel, downloadInfo, formSolutionBestellung.getBerechtigungsgrund(), formSolutionBestellung.getBegruendungstext(), dateiName, data);
                            if (attachementsFile.exists()) {
                                attachementsFile.delete();
                            }
                            bestellungBean.setProperty("berechtigungspruefung", (Object)pruefung);
                        }
                        this.getMetaService().updateMetaObject(this.getUser(), bestellungBean.getMetaObject(), this.getConnectionContext());
                        if (schluessel != null) {
                            FormSolutionsBestellungHandler.getMySqlHelper().updatePruefungFreigabe(schluessel, transid, 35, null);
                        }
                        if (in == null) continue block40;
                        if (var24_38 == null) ** GOTO lbl85
                        try {
                            in.close();
                        }
                        catch (Throwable formSolutionBestellung) {
                            var24_38.addSuppressed(formSolutionBestellung);
                        }
                        break;
lbl85:
                        // 1 sources

                        in.close();
                        break;
                        catch (Throwable formSolutionBestellung) {
                            try {
                                var24_38 = formSolutionBestellung;
                                throw formSolutionBestellung;
                            }
                            catch (Throwable var35_58) {
                                if (in != null) {
                                    if (var24_38 != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable var36_60) {
                                            var24_38.addSuppressed(var36_60);
                                        }
                                    } else {
                                        in.close();
                                    }
                                }
                                throw var35_58;
                            }
                        }
                    }
                    case 6: {
                        flurstueckKennzeichen = (String)bestellungBean.getProperty("landparcelcode");
                        produktbezeichnung = transid;
                        flurstuecke = new ArrayList<E>();
                        if (flurstueckKennzeichen != null) {
                            for (String einzelFSKennzeichen : flurstueckKennzeichen.split(",")) {
                                flurstueck = this.getFlurstueck(einzelFSKennzeichen);
                                if (flurstueck == null) {
                                    throw new Exception(String.format("ALKIS-Flurst\u00fcck %s konnte nicht gefunden werden!", new Object[]{einzelFSKennzeichen}));
                                }
                                flurstuecke.add(flurstueck);
                            }
                        }
                        buchungsblattKennzeichen = (String)bestellungBean.getProperty("buchungsblattcode");
                        buchungsblaetter = new ArrayList<CidsBean>();
                        if (buchungsblattKennzeichen != null) {
                            for (String einzelBBKennzeichen : buchungsblattKennzeichen.split(",")) {
                                buchungsblatt = this.getBuchungsblatt(einzelBBKennzeichen);
                                if (buchungsblatt == null) {
                                    throw new Exception("Buchungsblattcode '" + einzelBBKennzeichen + "' nicht gefunden");
                                }
                                buchungsblaetter.add(buchungsblatt);
                            }
                        }
                        if (flurstuecke.isEmpty() && buchungsblaetter.isEmpty()) {
                            throw new Exception(String.format("Es konnten keine Flurst\u00fccke und keine Buchungsbl\u00e4tter gefunden werden.", new Object[0]));
                        }
                        protocolBuffer = new LiegenschaftsbuchauszugHelper.ProtocolBuffer();
                        statusHolder = new LiegenschaftsbuchauszugHelper.StatusHolder();
                        alkisProduct = (String)bestellungBean.getProperty("fk_produkt.fk_typ.key");
                        if (alkisProduct.contains("_")) {
                            alkisProduct = alkisProduct.substring(0, alkisProduct.indexOf("_"));
                        }
                        downloadInfo = this.getLiegenschaftsbuchauszugHelper().calculateDownloadInfo(null, produktbezeichnung, null, flurstuecke, buchungsblaetter, alkisProduct, protocolBuffer, statusHolder);
                        verwendungskeyDownload = FormSolutionsBestellungHandler.getProperties().getBillingVerwendungskeyDownload();
                        verwendungskeyPostweg = FormSolutionsBestellungHandler.getProperties().getBillingVerwendungskeyPostweg();
                        productKeyDownload = null;
                        productKeyPostweg = null;
                        if (alkisProduct.startsWith("bekom")) {
                            productKeyDownload = FormSolutionsBestellungHandler.getProperties().getBillingProduktkeyLBBestDownload();
                            productKeyPostweg = FormSolutionsBestellungHandler.getProperties().getBillingProduktkeyLBBestPostweg();
                        } else {
                            productKeyDownload = FormSolutionsBestellungHandler.getProperties().getBillingProduktkeyLBDownload();
                            productKeyPostweg = FormSolutionsBestellungHandler.getProperties().getBillingProduktkeyLBPostweg();
                        }
                        isGutschein = bestellungBean.getProperty("gutschein_code") != null;
                        gebuehr = isGutschein != false ? 0.0 : this.calculateLBGebuehr(productKeyDownload, verwendungskeyDownload, downloadInfo);
                        gebuehrPostweg = isGutschein != false ? 0.0 : this.calculateLBGebuehr(productKeyPostweg, verwendungskeyPostweg, downloadInfo);
                        bestellungBean.setProperty("gebuehr", (Object)gebuehr);
                        bestellungBean.setProperty("gebuehr_postweg", (Object)gebuehrPostweg);
                        auftragXml = (String)bestellungBean.getProperty("form_xml_orig");
                        in = IOUtils.toInputStream((String)auftragXml, (String)"UTF-8");
                        var27_43 = null;
                        formSolutionBestellung = this.createFormSolutionsBestellung(in);
                        schluessel = null;
                        if (bestellungBean.getProperty("berechtigungspruefung") == null) {
                            schluessel = BerechtigungspruefungHandler.getInstance().createNewSchluessel(downloadInfo);
                            attachementsFile = new File(String.format("%s/%s.zip", new Object[]{FormSolutionsBestellungHandler.getProperties().getAnhangTmpAbsPath(), transid}));
                            if (attachementsFile.exists()) {
                                in2 = new FileInputStream(attachementsFile);
                                var34_55 = null;
                                try {
                                    dateiName = attachementsFile.getName();
                                    data = IOUtils.toByteArray((InputStream)in2);
                                }
                                catch (Throwable var35_59) {
                                    var34_55 = var35_59;
                                    throw var35_59;
                                }
                                finally {
                                    if (in2 != null) {
                                        if (var34_55 != null) {
                                            try {
                                                in2.close();
                                            }
                                            catch (Throwable var35_57) {
                                                var34_55.addSuppressed(var35_57);
                                            }
                                        } else {
                                            in2.close();
                                        }
                                    }
                                }
                            } else {
                                dateiName = null;
                                data = null;
                            }
                            downloadInfo.setAuftragsnummer(schluessel);
                            userKey = (String)this.getUser().getKey();
                            pruefung = BerechtigungspruefungHandler.getInstance().addNewAnfrage(userKey, schluessel, downloadInfo, formSolutionBestellung.getBerechtigungsgrund(), formSolutionBestellung.getBegruendungstext(), dateiName, data);
                            if (attachementsFile.exists()) {
                                attachementsFile.delete();
                            }
                            bestellungBean.setProperty("berechtigungspruefung", (Object)pruefung);
                        }
                        this.getMetaService().updateMetaObject(this.getUser(), bestellungBean.getMetaObject(), this.getConnectionContext());
                        if (schluessel != null) {
                            FormSolutionsBestellungHandler.getMySqlHelper().updatePruefungFreigabe(schluessel, transid, 35, null);
                        }
                        if (in == null) break;
                        if (var27_43 == null) ** GOTO lbl198
                        try {
                            in.close();
                        }
                        catch (Throwable var28_45) {
                            var27_43.addSuppressed(var28_45);
                        }
                        break;
lbl198:
                        // 1 sources

                        in.close();
                        break;
                        catch (Throwable var28_46) {
                            try {
                                var27_43 = var28_46;
                                throw var28_46;
                            }
                            catch (Throwable var39_63) {
                                if (in != null) {
                                    if (var27_43 != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable var40_64) {
                                            var27_43.addSuppressed(var40_64);
                                        }
                                    } else {
                                        in.close();
                                    }
                                }
                                throw var39_63;
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.setErrorStatus(transid, 34, bestellungBean, "Fehler beim Vorlage der Bestellung zur Pr\u00fcfung.", ex);
                fsBeanMap.remove(transid);
            }
        }
    }

    private static String createTransidHash(String transid) {
        return DigestUtils.md5Hex((String)(FormSolutionsBestellungHandler.getProperties().getTransidHashpepper() + transid));
    }

    private void uploadAndFillProduktFields(String fileNameOrig, InputStream in, CidsBean bestellungBean, boolean testPdf, boolean fillProduktFields) throws Exception {
        String transid = (String)bestellungBean.getProperty("transid");
        String fileNameFtp = transid + (fillProduktFields ? "" : "-1") + "." + FilenameUtils.getExtension((String)fileNameOrig);
        if (FormSolutionsBestellungHandler.getProperties().isFtpEnabled()) {
            this.uploadProduktToFtp(in, fileNameFtp, testPdf);
        } else {
            this.saveProduktInFtpMount(in, fileNameFtp, testPdf);
        }
        if (fillProduktFields) {
            bestellungBean.setProperty("produkt_dateipfad", (Object)fileNameFtp);
            bestellungBean.setProperty("produkt_dateiname_orig", (Object)fileNameOrig);
            bestellungBean.setProperty("produkt_ts", (Object)new Timestamp(new Date().getTime()));
            this.createUploadAndFillRechnungFields(bestellungBean);
        }
    }

    private void createUploadAndFillRechnungFields(CidsBean bestellungBean) throws Exception {
        String transid = (String)bestellungBean.getProperty("transid");
        String fileNameRechnung = "RE_" + transid + ".pdf";
        bestellungBean.setProperty("rechnung_dateipfad", (Object)fileNameRechnung);
        bestellungBean.setProperty("rechnung_dateiname_orig", (Object)("Rechnung - Produktbestellung " + transid + ".pdf"));
        try (InputStream in = this.createRechnung(bestellungBean);){
            if (FormSolutionsBestellungHandler.getProperties().isFtpEnabled()) {
                this.uploadProduktToFtp(in, fileNameRechnung, true);
            } else {
                this.saveProduktInFtpMount(in, fileNameRechnung, true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, BerechtigungspruefungDownloadInfo> step7CreateProducts(Map<String, CidsBean> fsBeanMap, boolean repairErrors) {
        HashMap<String, BerechtigungspruefungDownloadInfo> downloadInfoMap = new HashMap<String, BerechtigungspruefungDownloadInfo>();
        if (fsBeanMap == null) return downloadInfoMap;
        ArrayList<String> transids = new ArrayList<String>(fsBeanMap.keySet());
        block34: for (String transid : transids) {
            CidsBean bestellungBean = fsBeanMap.get(transid);
            if (bestellungBean == null || Boolean.TRUE.equals(bestellungBean.getProperty("duplicate")) || !repairErrors && bestellungBean.getProperty("fehler") != null) continue;
            try {
                bestellungBean.setProperty("erledigt", (Object)Boolean.FALSE);
                bestellungBean.setProperty("fehler", null);
                bestellungBean.setProperty("fehler_ts", null);
                bestellungBean.setProperty("exception", null);
                bestellungBean.setProperty("produkt_dateipfad", null);
                bestellungBean.setProperty("produkt_dateiname_orig", null);
                bestellungBean.setProperty("produkt_ts", null);
                if (bestellungBean.getProperty("geometrie.geo_field") == null) {
                    this.createGeom(bestellungBean);
                }
                this.getMetaService().updateMetaObject(this.getUser(), bestellungBean.getMetaObject(), this.getConnectionContext());
                ProductType productType = this.determineProductType(bestellungBean);
                switch (productType) {
                    case SGK: 
                    case ABK: {
                        URL productUrl = this.createProductUrl(bestellungBean, repairErrors);
                        bestellungBean.setProperty("request_url", (Object)productUrl.toString());
                        String fileNameOrig = String.format("%s.%s.pdf", (String)bestellungBean.getProperty("fk_produkt.fk_typ.key"), ((String)bestellungBean.getProperty("landparcelcode")).split(",")[0].replace("/", "--"));
                        try (InputStream in = this.downloadProduct(productUrl);){
                            this.uploadAndFillProduktFields(fileNameOrig, in, bestellungBean, true, true);
                        }
                        this.getMetaService().updateMetaObject(this.getUser(), bestellungBean.getMetaObject(), this.getConnectionContext());
                        FormSolutionsBestellungHandler.getMySqlHelper().insertOrUpdateProduct(transid, 20, (String)bestellungBean.getProperty("landparcelcode"), (String)bestellungBean.getProperty("buchungsblattcode"), (String)bestellungBean.getProperty("fk_produkt.fk_typ.name"), (Boolean)bestellungBean.getProperty("postweg"), (String)bestellungBean.getProperty("email"), null, (String)bestellungBean.getProperty("produkt_dateipfad"), (String)bestellungBean.getProperty("produkt_dateiname_orig"));
                        String email = FormSolutionsBestellungHandler.trimedNotEmpty((String)bestellungBean.getProperty("email"));
                        this.doStatusChangedRequest(transid, this.isInternalEmail(email));
                        break;
                    }
                    case BAB_WEITERLEITUNG: 
                    case LB_WEITERLEITUNG: {
                        CidsBean berechtigungspruefung = (CidsBean)bestellungBean.getProperty("berechtigungspruefung");
                        if (berechtigungspruefung == null) continue block34;
                        if (Boolean.TRUE.equals(berechtigungspruefung.getProperty("pruefstatus"))) {
                            String transidHash = FormSolutionsBestellungHandler.createTransidHash(transid);
                            String redirectorUrlTemplate = FormSolutionsBestellungHandler.getProperties().getCidsActionHttpRedirectorUrl();
                            String redirect2formsolutions = String.format(redirectorUrlTemplate, transidHash);
                            bestellungBean.setProperty("request_url", (Object)new URL(redirect2formsolutions).toExternalForm());
                            bestellungBean.setProperty("produkt_ts", (Object)new Timestamp(new Date().getTime()));
                            this.getMetaService().updateMetaObject(this.getUser(), bestellungBean.getMetaObject(), this.getConnectionContext());
                            LOG.info((Object)redirect2formsolutions);
                            FormSolutionsBestellungHandler.getMySqlHelper().updatePruefungFreigabe((String)berechtigungspruefung.getProperty("schluessel"), transid, 37, redirect2formsolutions);
                            String email = FormSolutionsBestellungHandler.trimedNotEmpty((String)bestellungBean.getProperty("email"));
                            this.doStatusChangedRequest(transid, this.isInternalEmail(email));
                            break;
                        }
                        if (!Boolean.FALSE.equals(berechtigungspruefung.getProperty("pruefstatus"))) continue block34;
                        FormSolutionsBestellungHandler.getMySqlHelper().updatePruefungAblehnung((String)berechtigungspruefung.getProperty("schluessel"), transid, -35, (String)berechtigungspruefung.getProperty("pruefkommentar"));
                        String email = FormSolutionsBestellungHandler.trimedNotEmpty((String)bestellungBean.getProperty("email"));
                        this.doStatusChangedRequest(transid, this.isInternalEmail(email));
                        break;
                    }
                    case LB_ABSCHLUSS: 
                    case BAB_ABSCHLUSS: {
                        BerechtigungspruefungAlkisEinzelnachweisDownloadInfo info;
                        CidsBean vorgaengerBestellungBean = (CidsBean)bestellungBean.getProperty("nachfolger_von");
                        if (vorgaengerBestellungBean == null) throw new Exception("Daten des vorgelagerten Formulars wurden nicht gefunden.");
                        CidsBean berechtigungspruefung = (CidsBean)vorgaengerBestellungBean.getProperty("berechtigungspruefung");
                        String downloadinfoJson = (String)berechtigungspruefung.getProperty("downloadinfo_json");
                        bestellungBean.setProperty("request_url", (Object)downloadinfoJson);
                        bestellungBean.setProperty("berechtigungspruefung", vorgaengerBestellungBean.getProperty("berechtigungspruefung"));
                        this.getMetaService().updateMetaObject(this.getUser(), bestellungBean.getMetaObject(), this.getConnectionContext());
                        this.getMetaService().updateMetaObject(this.getUser(), vorgaengerBestellungBean.getMetaObject(), this.getConnectionContext());
                        BerechtigungspruefungBillingDownloadInfo downloadInfo = null;
                        String fileNameOrig = productType.equals((Object)ProductType.LB_ABSCHLUSS) ? ((info = (BerechtigungspruefungAlkisEinzelnachweisDownloadInfo)(downloadInfo = (BerechtigungspruefungBillingDownloadInfo)new ObjectMapper().readValue(downloadinfoJson, BerechtigungspruefungAlkisEinzelnachweisDownloadInfo.class))).getAlkisCodes() != null && info.getAlkisCodes().size() == 1 ? info.getAlkisProdukt() + "." + info.getAlkisCodes().get(0) + ".pdf" : "liegenschaftsbuch.zip") : "baulastbescheinigung.zip";
                        File tmpFile = new File(String.format("%s/%s.%s", FormSolutionsBestellungHandler.getProperties().getProduktTmpAbsPath(), transid, FilenameUtils.getExtension((String)fileNameOrig)));
                        File origProd = null;
                        if (productType.equals((Object)ProductType.LB_ABSCHLUSS)) {
                            origProd = this.getLiegenschaftsbuchauszugHelper().writeFullBescheinigung((BerechtigungspruefungAlkisEinzelnachweisDownloadInfo)downloadInfo, tmpFile, transid);
                        } else {
                            downloadInfo = (BerechtigungspruefungBillingDownloadInfo)new ObjectMapper().readValue(downloadinfoJson, BerechtigungspruefungBescheinigungDownloadInfo.class);
                            origProd = this.getBaulastBescheinigungHelper().writeFullBescheinigung((BerechtigungspruefungBescheinigungDownloadInfo)downloadInfo, tmpFile, transid);
                        }
                        try (FileInputStream in = new FileInputStream(tmpFile);){
                            this.uploadAndFillProduktFields(fileNameOrig, in, bestellungBean, false, true);
                        }
                        if (origProd != null) {
                            in = new FileInputStream(origProd);
                            var17_22 = null;
                            try {
                                this.uploadAndFillProduktFields(fileNameOrig, in, bestellungBean, false, false);
                            }
                            catch (Throwable throwable) {
                                var17_22 = throwable;
                                throw throwable;
                            }
                            finally {
                                if (in != null) {
                                    if (var17_22 != null) {
                                        try {
                                            ((InputStream)in).close();
                                        }
                                        catch (Throwable throwable) {
                                            var17_22.addSuppressed(throwable);
                                        }
                                    } else {
                                        ((InputStream)in).close();
                                    }
                                }
                            }
                        }
                        if (!FormSolutionsBestellungHandler.getProperties().isDeleteTmpProductAfterSuccessfulUploadDisabled()) {
                            tmpFile.delete();
                            if (origProd != null) {
                                origProd.delete();
                            }
                        }
                        downloadInfoMap.put(transid, downloadInfo);
                        FormSolutionsBestellungHandler.getMySqlHelper().insertOrUpdateProduct(transid, 20, (String)bestellungBean.getProperty("landparcelcode"), (String)bestellungBean.getProperty("buchungsblattcode"), (String)bestellungBean.getProperty("fk_product.fk_typ.name"), (Boolean)bestellungBean.getProperty("postweg"), (String)bestellungBean.getProperty("email"), (String)berechtigungspruefung.getProperty("schluessel"), (String)bestellungBean.getProperty("produkt_dateipfad"), (String)bestellungBean.getProperty("produkt_dateiname_orig"));
                        String email = FormSolutionsBestellungHandler.trimedNotEmpty((String)bestellungBean.getProperty("email"));
                        this.doStatusChangedRequest(transid, this.isInternalEmail(email));
                        break;
                    }
                }
            }
            catch (Exception ex) {
                this.setErrorStatus(transid, 20, bestellungBean, "Fehler beim Erzeugen des Produktes", ex);
                fsBeanMap.remove(transid);
            }
        }
        return downloadInfoMap;
    }

    private ProductType determineProductType(CidsBean bestellungBean) {
        String type;
        String string = type = bestellungBean != null && bestellungBean.getProperty("fk_produkt.fk_typ.key") != null ? (String)bestellungBean.getProperty("fk_produkt.fk_typ.key") : null;
        if (type != null) {
            switch (type) {
                case "LK.NRW.K.F": 
                case "LK.NRW.K.SW": {
                    return ProductType.SGK;
                }
                case "LK.GDBNRW.A.ABKF": 
                case "LK.GDBNRW.A.ABKSW": {
                    return ProductType.ABK;
                }
                case "BAB_WEITERLEITUNG": {
                    return ProductType.BAB_WEITERLEITUNG;
                }
                case "BAB": {
                    return ProductType.BAB_ABSCHLUSS;
                }
                case "bekom_WEITERLEITUNG": 
                case "fsueKom_WEITERLEITUNG": {
                    return ProductType.LB_WEITERLEITUNG;
                }
                case "bekom": 
                case "fsueKom": {
                    return ProductType.LB_ABSCHLUSS;
                }
            }
        }
        return null;
    }

    private void specialLog(String message) {
        FormSolutionBestellungSpecialLogger.getInstance().log(message);
    }

    private SimpleHttpAccessHandler getHttpAccessHandler() {
        return this.httpHandler;
    }

    private ObjectMapper getObjectMapper() {
        return MAPPER;
    }

    private static FormSolutionsProperties getProperties() {
        return FormSolutionsProperties.getInstance();
    }

    private static FormSolutionsMySqlHelper getMySqlHelper() {
        return FormSolutionsMySqlHelper.getInstance();
    }

    private static FormSolutionsFtpClient getFtpClient() {
        return FormSolutionsFtpClient.getInstance();
    }

    public static enum ProductType {
        SGK,
        ABK,
        BAB_WEITERLEITUNG,
        BAB_ABSCHLUSS,
        LB_WEITERLEITUNG,
        LB_ABSCHLUSS;

    }
}

