/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.formsolutions;

import de.cismet.cids.custom.utils.formsolutions.FormSolutionsProperties;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;

public class FormSolutionsFtpClient {
    private final FormSolutionsProperties properties;

    private FormSolutionsFtpClient(FormSolutionsProperties properties) {
        this.properties = properties;
    }

    public FormSolutionsProperties getProperties() {
        return this.properties;
    }

    public void upload(InputStream in, String destinationPath) throws Exception {
        FTPClient ftpClient = this.getConnectedFTPClient();
        ftpClient.setFileType(2);
        ftpClient.storeFile(destinationPath, in);
        ftpClient.disconnect();
    }

    public void test() throws Exception {
        FTPClient ftpClient = this.getConnectedFTPClient();
        System.out.println(ftpClient.printWorkingDirectory());
        for (FTPFile ftpFile : ftpClient.listFiles()) {
            System.out.println(ftpFile.getName());
        }
        ftpClient.disconnect();
    }

    public void download(String destinationPath, OutputStream out) throws Exception {
        FTPClient ftpClient = this.getConnectedFTPClient();
        ftpClient.setFileType(2);
        if (!ftpClient.retrieveFile(destinationPath, out)) {
            throw new Exception("file " + destinationPath + " not found");
        }
        ftpClient.disconnect();
    }

    private FTPClient getConnectedFTPClient() throws Exception {
        String host = this.getProperties().getFtpHost();
        String username = this.getProperties().getFtpLogin();
        String password = this.getProperties().getFtpPass();
        boolean secure = this.getProperties().isFtpOverTls();
        FTPSClient ftpClient = secure ? new FTPSClient() : new FTPClient();
        ftpClient.connect(host);
        int reply = ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            ftpClient.disconnect();
            throw new Exception("Exception in connecting to FTP Server");
        }
        ftpClient.enterLocalPassiveMode();
        if (!ftpClient.login(username, password)) {
            throw new Exception("Login failed");
        }
        return ftpClient;
    }

    public static FormSolutionsFtpClient getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    private static final class LazyInitialiser {
        private static final FormSolutionsFtpClient INSTANCE = new FormSolutionsFtpClient(FormSolutionsProperties.getInstance());

        private LazyInitialiser() {
        }
    }
}

