/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.vermessungsunterlagen;

import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenJob;
import de.cismet.cids.custom.utils.vermessungsunterlagen.exceptions.VermessungsunterlagenException;

public class VermessungsunterlagenJobInfoWrapper {
    private VermessungsunterlagenJob job;
    private VermessungsunterlagenJob.Status jobStatus;
    private String jobResult;
    private String jobError;

    public VermessungsunterlagenJobInfoWrapper(VermessungsunterlagenJob job) {
        this.job = job;
    }

    private void refreshJobError() {
        if (this.job != null) {
            VermessungsunterlagenException exception = this.job.getException();
            this.jobError = exception != null ? exception.getMessage() : null;
        }
    }

    public String getJobError() {
        this.refreshJobError();
        return this.jobError;
    }

    private void refreshJobResult() {
        if (this.job != null) {
            String jobResultFrom = this.job.getProperties().getJobResultFrom();
            if ("ftp".equals(jobResultFrom)) {
                this.jobResult = this.job.getFtpZipPath();
            } else if ("webdav".equals(jobResultFrom)) {
                this.jobResult = this.job.getWebDAVPath();
            }
        }
    }

    public String getJobResult() {
        this.refreshJobResult();
        return this.jobResult;
    }

    private void refreshJobStatus() {
        if (this.job != null) {
            this.jobStatus = this.job.getStatus();
        }
    }

    public VermessungsunterlagenJob.Status getJobStatus() {
        this.refreshJobStatus();
        return this.jobStatus;
    }

    public void cleanup() {
        this.refreshJobStatus();
        this.refreshJobResult();
        this.refreshJobError();
        this.job = null;
    }
}

