/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.vermessungsunterlagen;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import de.cismet.cids.custom.utils.alkis.AlkisProductDescription;
import de.cismet.cids.custom.utils.alkis.AlkisProducts;
import de.cismet.cids.custom.utils.alkis.ServerAlkisProducts;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenAnfrageBean;
import de.cismet.commons.security.AccessHandler;
import de.cismet.commons.security.handler.SimpleHttpAccessHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import org.apache.log4j.Logger;

public class VermessungsunterlagenUtils {
    public static final int SRID = 25832;
    private static final ObjectMapper EXCEPTION_MAPPER = new ObjectMapper();
    private static final transient Logger LOG = Logger.getLogger(VermessungsunterlagenUtils.class);
    private static final ObjectMapper JOB_MAPPER;
    private static final int MAX_BUFFER_SIZE = 1024;

    public static String getExceptionJson(Exception ex) throws Exception {
        return EXCEPTION_MAPPER.writeValueAsString((Object)ex);
    }

    public static void writeExceptionJson(Exception ex, String filname) {
        try {
            File file = new File(filname);
            EXCEPTION_MAPPER.writeValue(file, (Object)ex);
        }
        catch (IOException ex1) {
            LOG.error((Object)(filname + " could not be written !"), (Throwable)ex1);
        }
    }

    public static Polygon createAnfragepolygon(JsonNode polygonArrayNode, boolean wrapped) {
        GeometryFactory geometryFactory = new GeometryFactory();
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>(polygonArrayNode.size());
        for (JsonNode objNode : polygonArrayNode) {
            Double x = (wrapped ? objNode.get("polygon").get(0).get("$value") : objNode.get("x")).asDouble();
            Double y = (wrapped ? objNode.get("polygon").get(1).get("$value") : objNode.get("y")).asDouble();
            coordinates.add(new Coordinate(x.doubleValue(), y.doubleValue()));
        }
        LinearRing ring = new LinearRing((CoordinateSequence)new CoordinateArraySequence(coordinates.toArray(new Coordinate[0])), geometryFactory);
        Polygon anfragepolygon = geometryFactory.createPolygon(ring, new LinearRing[0]);
        anfragepolygon.setSRID(25832);
        return anfragepolygon;
    }

    public static VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean createPunktnummernreservierungBean(JsonNode objNode, boolean wrapped) {
        VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean punktnummernreservierungBean = new VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean();
        punktnummernreservierungBean.setAnzahlPunktnummern(VermessungsunterlagenUtils.getInteger("anzahlPunktnummern", objNode, wrapped));
        punktnummernreservierungBean.setKatasteramtsID(VermessungsunterlagenUtils.getString("katasteramtsID", objNode, wrapped));
        punktnummernreservierungBean.setUtmKilometerQuadrat(VermessungsunterlagenUtils.getString("utmKilometerQuadrat", objNode, wrapped));
        return punktnummernreservierungBean;
    }

    private static JsonNode getValueNode(JsonNode tmpNode, boolean wrapped) {
        if (tmpNode == null) {
            return null;
        }
        return wrapped ? (tmpNode.get("$value") != null ? tmpNode.get("$value") : null) : tmpNode;
    }

    private static String getString(JsonNode tmpNode, boolean wrapped) {
        JsonNode valueNode = VermessungsunterlagenUtils.getValueNode(tmpNode, wrapped);
        return valueNode != null ? valueNode.asText() : null;
    }

    private static String getString(String attribute, JsonNode parentNode, boolean wrapped) {
        JsonNode tmpNode = parentNode.get(attribute);
        return VermessungsunterlagenUtils.getString(tmpNode, wrapped);
    }

    private static Boolean getBoolean(String attribute, JsonNode parentNode, boolean wrapped) {
        JsonNode tmpNode = parentNode.get(attribute);
        JsonNode valueNode = VermessungsunterlagenUtils.getValueNode(tmpNode, wrapped);
        return valueNode != null ? Boolean.valueOf(valueNode.asBoolean()) : null;
    }

    private static Integer getInteger(String attribute, JsonNode parentNode, boolean wrapped) {
        JsonNode tmpNode = parentNode.get(attribute);
        JsonNode valueNode = VermessungsunterlagenUtils.getValueNode(tmpNode, wrapped);
        return valueNode != null ? Integer.valueOf(valueNode.asInt()) : null;
    }

    public static VermessungsunterlagenAnfrageBean createAnfrageBean(String json) throws IOException {
        boolean wrapped;
        JsonNode rootNode = JOB_MAPPER.readTree(json);
        VermessungsunterlagenAnfrageBean anfrageBean = new VermessungsunterlagenAnfrageBean();
        anfrageBean.setPortalVersion(VermessungsunterlagenUtils.getString("portalVersion", rootNode, false));
        boolean bl = wrapped = !anfrageBean.isNewPortalVersion();
        if (wrapped) {
            JsonNode polygonArrayNode;
            JsonNode in0 = rootNode.get("in0");
            ArrayList<Polygon> anfragepolygonList = new ArrayList<Polygon>();
            JsonNode anfragepolygonArrayNode = in0.get("anfragepolygonArray").get("anfragepolygonArray");
            if (anfragepolygonArrayNode != null && (polygonArrayNode = anfragepolygonArrayNode.get("polygon").get("polygon")).isArray()) {
                anfragepolygonList.add(VermessungsunterlagenUtils.createAnfragepolygon(polygonArrayNode, wrapped));
            }
            ArrayList<Object> antragsflurstueckList = new ArrayList<Object>();
            JsonNode antragsflurstuecksArrayNode = in0.get("antragsflurstuecksArray").get("antragsflurstuecksArray");
            if (antragsflurstuecksArrayNode != null) {
                if (antragsflurstuecksArrayNode.isArray()) {
                    for (JsonNode objNode : antragsflurstuecksArrayNode) {
                        VermessungsunterlagenAnfrageBean.AntragsflurstueckBean antragsflurstueckBean = VermessungsunterlagenUtils.createAntragsflurstueckBean(objNode, wrapped);
                        antragsflurstueckList.add(antragsflurstueckBean);
                    }
                } else {
                    JsonNode objNode = antragsflurstuecksArrayNode;
                    VermessungsunterlagenAnfrageBean.AntragsflurstueckBean antragsflurstueckBean = VermessungsunterlagenUtils.createAntragsflurstueckBean(objNode, wrapped);
                    antragsflurstueckList.add(antragsflurstueckBean);
                }
            }
            ArrayList<String> artderVermessungList = new ArrayList<String>();
            JsonNode artderVermessungNode = in0.get("artderVermessung").get("artderVermessung");
            if (artderVermessungNode != null) {
                if (artderVermessungNode.isArray()) {
                    for (JsonNode objNode : artderVermessungNode) {
                        artderVermessungList.add(VermessungsunterlagenUtils.getString(objNode, wrapped));
                    }
                } else {
                    JsonNode objNode = artderVermessungNode;
                    artderVermessungList.add(VermessungsunterlagenUtils.getString(objNode, wrapped));
                }
            }
            ArrayList<VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean> punktnummernreservierungList = new ArrayList<VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean>();
            JsonNode punktnummernreservierungsArrayNode = in0.get("punktnummernreservierungsArray").get("punktnummernreservierungsArray");
            if (punktnummernreservierungsArrayNode != null) {
                if (punktnummernreservierungsArrayNode.isArray()) {
                    for (JsonNode objNode : punktnummernreservierungsArrayNode) {
                        VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean punktnummernreservierungBean = VermessungsunterlagenUtils.createPunktnummernreservierungBean(objNode, wrapped);
                        punktnummernreservierungList.add(punktnummernreservierungBean);
                    }
                } else {
                    JsonNode objNode = punktnummernreservierungsArrayNode;
                    VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean punktnummernreservierungBean = VermessungsunterlagenUtils.createPunktnummernreservierungBean(objNode, wrapped);
                    punktnummernreservierungList.add(punktnummernreservierungBean);
                }
            }
            anfrageBean.setAnfragepolygonArray(anfragepolygonList.toArray(new Polygon[0]));
            anfrageBean.setAntragsflurstuecksArray(antragsflurstueckList.toArray(new VermessungsunterlagenAnfrageBean.AntragsflurstueckBean[0]));
            anfrageBean.setArtderVermessung(artderVermessungList.toArray(new String[0]));
            anfrageBean.setPunktnummernreservierungsArray(punktnummernreservierungList.toArray(new VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean[0]));
            anfrageBean.setAktenzeichenKatasteramt(VermessungsunterlagenUtils.getString("aktenzeichenKatasteramt", in0, wrapped));
            anfrageBean.setAnonymousOrder(null);
            anfrageBean.setGeschaeftsbuchnummer(VermessungsunterlagenUtils.getString("geschaeftsbuchnummer", in0, wrapped));
            anfrageBean.setKatasteramtAuftragsnummer(VermessungsunterlagenUtils.getString("katasteramtAuftragsnummer", in0, wrapped));
            anfrageBean.setKatasteramtsId(VermessungsunterlagenUtils.getString("katasteramtsId", in0, wrapped));
            anfrageBean.setNameVermessungsstelle(VermessungsunterlagenUtils.getString("nameVermessungsstelle", in0, wrapped));
            anfrageBean.setZulassungsnummerVermessungsstelle(VermessungsunterlagenUtils.getString("zulassungsnummerVermessungsstelle", in0, wrapped));
            anfrageBean.setSaumAPSuche(VermessungsunterlagenUtils.getString("saumAPSuche", in0, wrapped));
            boolean nurPNR = Boolean.TRUE.equals(VermessungsunterlagenUtils.getBoolean("nurPunktnummernreservierung", in0, wrapped));
            anfrageBean.setMitAPBeschreibungen(!nurPNR);
            anfrageBean.setMitAPKarten(!nurPNR);
            anfrageBean.setMitAPUebersichten(!nurPNR);
            anfrageBean.setMitNIVPBeschreibungen(!nurPNR);
            anfrageBean.setMitNIVPUebersichten(!nurPNR);
            anfrageBean.setMitAlkisBestandsdatenmitEigentuemerinfo(!nurPNR);
            anfrageBean.setMitAlkisBestandsdatenohneEigentuemerinfo(false);
            anfrageBean.setMitAlkisBestandsdatennurPunkte(!nurPNR);
            anfrageBean.setMitRisse(!nurPNR);
            anfrageBean.setMitGrenzniederschriften(VermessungsunterlagenUtils.getBoolean("mitGrenzniederschriften", in0, wrapped));
            anfrageBean.setMitPunktnummernreservierung(!punktnummernreservierungList.isEmpty());
        } else {
            JsonNode datenSatzNode = rootNode.get("AntragsdatensatzBean");
            ArrayList<Polygon> anfragepolygonList = new ArrayList<Polygon>();
            JsonNode anfragepolygonArrayNode = datenSatzNode.get("antragsPolygone");
            if (anfragepolygonArrayNode != null && anfragepolygonArrayNode.isArray()) {
                for (JsonNode anfragepolygonNode : anfragepolygonArrayNode) {
                    anfragepolygonList.add(VermessungsunterlagenUtils.createAnfragepolygon(anfragepolygonNode.get("points"), wrapped));
                }
            }
            ArrayList antragsflurstueckList = new ArrayList();
            JsonNode antragsflurstuecksArrayNode = datenSatzNode.get("antragsflurstuecke");
            if (antragsflurstuecksArrayNode != null) {
                if (antragsflurstuecksArrayNode.isArray()) {
                    for (JsonNode objNode : antragsflurstuecksArrayNode) {
                        VermessungsunterlagenAnfrageBean.AntragsflurstueckBean antragsflurstueckBean = VermessungsunterlagenUtils.createAntragsflurstueckBean(objNode, wrapped);
                        antragsflurstueckList.add(antragsflurstueckBean);
                    }
                } else {
                    JsonNode objNode = antragsflurstuecksArrayNode;
                    VermessungsunterlagenAnfrageBean.AntragsflurstueckBean antragsflurstueckBean = VermessungsunterlagenUtils.createAntragsflurstueckBean(objNode, wrapped);
                    antragsflurstueckList.add(antragsflurstueckBean);
                }
            }
            ArrayList artderVermessungList = new ArrayList();
            JsonNode artderVermessungNode = datenSatzNode.get("artderVermessung");
            if (artderVermessungNode != null) {
                if (artderVermessungNode.isArray()) {
                    for (JsonNode objNode : artderVermessungNode) {
                        artderVermessungList.add(VermessungsunterlagenUtils.getString(objNode, wrapped));
                    }
                } else {
                    JsonNode objNode = artderVermessungNode;
                    artderVermessungList.add(VermessungsunterlagenUtils.getString(objNode, wrapped));
                }
            }
            ArrayList<VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean> punktnummernreservierungList = new ArrayList<VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean>();
            JsonNode punktnummernreservierungsArrayNode = datenSatzNode.get("punktnummernreservierungen");
            if (punktnummernreservierungsArrayNode != null) {
                if (punktnummernreservierungsArrayNode.isArray()) {
                    for (JsonNode objNode : punktnummernreservierungsArrayNode) {
                        VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean punktnummernreservierungBean = VermessungsunterlagenUtils.createPunktnummernreservierungBean(objNode, wrapped);
                        punktnummernreservierungList.add(punktnummernreservierungBean);
                    }
                } else {
                    JsonNode objNode = punktnummernreservierungsArrayNode;
                    VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean punktnummernreservierungBean = VermessungsunterlagenUtils.createPunktnummernreservierungBean(objNode, wrapped);
                    punktnummernreservierungList.add(punktnummernreservierungBean);
                }
            }
            anfrageBean.setAnfragepolygonArray(anfragepolygonList.toArray(new Polygon[0]));
            anfrageBean.setAntragsflurstuecksArray(antragsflurstueckList.toArray(new VermessungsunterlagenAnfrageBean.AntragsflurstueckBean[0]));
            anfrageBean.setArtderVermessung(artderVermessungList.toArray(new String[0]));
            anfrageBean.setPunktnummernreservierungsArray(punktnummernreservierungList.toArray(new VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean[0]));
            anfrageBean.setAktenzeichenKatasteramt(VermessungsunterlagenUtils.getString("aktenzeichenKatasteramt", datenSatzNode, wrapped));
            anfrageBean.setAnonymousOrder(VermessungsunterlagenUtils.getBoolean("anonymousOrder", datenSatzNode, wrapped));
            anfrageBean.setGeschaeftsbuchnummer(VermessungsunterlagenUtils.getString("geschaeftsbuchnummer", datenSatzNode, wrapped));
            anfrageBean.setKatasteramtAuftragsnummer(VermessungsunterlagenUtils.getString("katasteramtAuftragsnummer", datenSatzNode, wrapped));
            anfrageBean.setKatasteramtsId(VermessungsunterlagenUtils.getString("katasteramtsId", datenSatzNode, wrapped));
            anfrageBean.setNameVermessungsstelle(VermessungsunterlagenUtils.getString("nameVermessungsstelle", datenSatzNode, wrapped));
            anfrageBean.setZulassungsnummerVermessungsstelle(VermessungsunterlagenUtils.getString("zulassungsnummerVermessungsstelle", datenSatzNode, wrapped));
            anfrageBean.setSaumAPSuche(VermessungsunterlagenUtils.getString("saumAPSuche", datenSatzNode, wrapped));
            anfrageBean.setMitAPBeschreibungen(VermessungsunterlagenUtils.getBoolean("mitAPBeschreibungen", datenSatzNode, wrapped));
            anfrageBean.setMitAPKarten(VermessungsunterlagenUtils.getBoolean("mitAPKarten", datenSatzNode, wrapped));
            anfrageBean.setMitAPUebersichten(VermessungsunterlagenUtils.getBoolean("mitAPUebersichten", datenSatzNode, wrapped));
            anfrageBean.setMitNIVPBeschreibungen(false);
            anfrageBean.setMitNIVPUebersichten(false);
            anfrageBean.setMitAlkisBestandsdatenmitEigentuemerinfo(VermessungsunterlagenUtils.getBoolean("mitAlkisBestandsdatenmitEigentuemerinfo", datenSatzNode, wrapped));
            anfrageBean.setMitAlkisBestandsdatennurPunkte(VermessungsunterlagenUtils.getBoolean("mitAlkisBestandsdatennurPunkte", datenSatzNode, wrapped));
            anfrageBean.setMitAlkisBestandsdatenohneEigentuemerinfo(VermessungsunterlagenUtils.getBoolean("mitAlkisBestandsdatenohneEigentuemerinfo", datenSatzNode, wrapped));
            anfrageBean.setMitRisse(VermessungsunterlagenUtils.getBoolean("mitRisse", datenSatzNode, wrapped));
            anfrageBean.setMitGrenzniederschriften(VermessungsunterlagenUtils.getBoolean("mitGrenzniederschriften", datenSatzNode, wrapped));
            anfrageBean.setMitPunktnummernreservierung(VermessungsunterlagenUtils.getBoolean("mitPunktnummernreservierung", datenSatzNode, wrapped));
            anfrageBean.setTest(true);
        }
        return anfrageBean;
    }

    public static VermessungsunterlagenAnfrageBean.AntragsflurstueckBean createAntragsflurstueckBean(JsonNode objNode, boolean wrapped) {
        VermessungsunterlagenAnfrageBean.AntragsflurstueckBean antragsflurstueckBean = new VermessungsunterlagenAnfrageBean.AntragsflurstueckBean();
        antragsflurstueckBean.setFlurID(VermessungsunterlagenUtils.getString("flurID", objNode, wrapped));
        antragsflurstueckBean.setFlurstuecksID(VermessungsunterlagenUtils.getString("flurstuecksID", objNode, wrapped));
        antragsflurstueckBean.setGemarkungsID(VermessungsunterlagenUtils.getString("gemarkungsID", objNode, wrapped));
        return antragsflurstueckBean;
    }

    public static void downloadStream(InputStream src, OutputStream dest) throws IOException {
        boolean downloading = true;
        while (downloading) {
            byte[] buffer = new byte[1024];
            int read = src.read(buffer);
            if (read == -1) {
                downloading = false;
                continue;
            }
            dest.write(buffer, 0, read);
        }
    }

    public static InputStream doPostRequest(URL url, Reader requestParameter) throws Exception {
        return new SimpleHttpAccessHandler().doRequest(url, requestParameter, AccessHandler.ACCESS_METHODS.POST_REQUEST, AlkisProducts.POST_HEADER);
    }

    public static InputStream doGetRequest(URL url) throws Exception {
        return new SimpleHttpAccessHandler().doRequest(url);
    }

    private static boolean doesBoundingBoxFitIntoLayout(Envelope box, int width, int height, double scale) {
        double realWorldLayoutWidth = (double)width / 1000.0 * scale;
        double realWorldLayoutHeigth = (double)height / 1000.0 * scale;
        return realWorldLayoutWidth >= box.getWidth() && realWorldLayoutHeigth >= box.getHeight();
    }

    public static AlkisProductDescription determineAlkisProduct(String clazz, String type, Envelope boundingBox) {
        AlkisProductDescription minimalWidthFittingProduct = null;
        AlkisProductDescription minimalHeightFittingProduct = null;
        AlkisProductDescription defaultProduct = null;
        for (AlkisProductDescription product : ServerAlkisProducts.getInstance().getAlkisMapProducts()) {
            boolean fitting;
            if (!clazz.equals(product.getClazz()) || !type.equals(product.getType())) continue;
            if (product.isDefaultProduct()) {
                defaultProduct = product;
            }
            if (!(fitting = VermessungsunterlagenUtils.doesBoundingBoxFitIntoLayout(boundingBox, product.getWidth(), product.getHeight(), Integer.parseInt(String.valueOf(product.getMassstab()))))) continue;
            if (minimalWidthFittingProduct == null) {
                minimalWidthFittingProduct = product;
            } else if (product.getWidth() <= minimalWidthFittingProduct.getWidth()) {
                if (product.getWidth() < minimalWidthFittingProduct.getWidth()) {
                    minimalWidthFittingProduct = product;
                } else if (Integer.parseInt(String.valueOf(product.getMassstab())) < Integer.parseInt(String.valueOf(minimalHeightFittingProduct.getMassstab()))) {
                    minimalWidthFittingProduct = product;
                }
            }
            if (minimalHeightFittingProduct == null) {
                minimalHeightFittingProduct = product;
                continue;
            }
            if (product.getHeight() > minimalHeightFittingProduct.getHeight()) continue;
            if (product.getHeight() < minimalHeightFittingProduct.getHeight()) {
                minimalHeightFittingProduct = product;
                continue;
            }
            if (Integer.parseInt(String.valueOf(product.getMassstab())) >= Integer.parseInt(String.valueOf(minimalHeightFittingProduct.getMassstab()))) continue;
            minimalHeightFittingProduct = product;
        }
        if (minimalWidthFittingProduct != null && minimalHeightFittingProduct != null) {
            boolean isMinimalHeightHoch;
            boolean isMinimalWidthHoch = minimalWidthFittingProduct.getWidth() < minimalWidthFittingProduct.getHeight();
            boolean bl = isMinimalHeightHoch = minimalHeightFittingProduct.getWidth() < minimalHeightFittingProduct.getHeight();
            if (isMinimalWidthHoch && isMinimalHeightHoch) {
                return minimalWidthFittingProduct;
            }
            if (isMinimalWidthHoch) {
                return minimalWidthFittingProduct;
            }
            return minimalHeightFittingProduct;
        }
        if (minimalWidthFittingProduct != null) {
            return minimalWidthFittingProduct;
        }
        if (minimalHeightFittingProduct != null) {
            return minimalHeightFittingProduct;
        }
        return defaultProduct;
    }

    public static void jasperReportDownload(JasperReport jasperReport, Map parameters, JRDataSource dataSource, OutputStream outputStream) throws Exception {
        JasperPrint print = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)parameters, (JRDataSource)dataSource);
        JasperExportManager.exportReportToPdfStream((JasperPrint)print, (OutputStream)outputStream);
    }

    public static String[] createFlurstueckParts(String gemarkung, String flur, String zaehler, String nenner) {
        try {
            String formattedGemarkung = gemarkung.startsWith("05") ? gemarkung.substring(2) : gemarkung;
            String formattedFlur = String.format("%03d", Integer.parseInt(flur));
            String formattedZahler = Integer.valueOf(zaehler).toString();
            String formattedNenner = nenner != null ? Integer.valueOf(nenner).toString() : "0";
            return new String[]{formattedGemarkung, formattedFlur, formattedZahler, formattedNenner};
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JOB_MAPPER = mapper;
    }
}

