/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.vermessungsunterlagen;

import Sirius.server.localserver.attribute.ObjectAttribute;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.LightweightMetaObject;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenAnfrageBean;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenHandler;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenUtils;
import de.cismet.cids.custom.utils.vermessungsunterlagen.exceptions.VermessungsunterlagenException;
import de.cismet.cids.custom.utils.vermessungsunterlagen.exceptions.VermessungsunterlagenValidatorException;
import de.cismet.cids.custom.wunda_blau.search.server.AlbFlurstueckKickerLightweightSearch;
import de.cismet.cids.custom.wunda_blau.search.server.BufferingGeosearch;
import de.cismet.cids.custom.wunda_blau.search.server.CidsAlkisSearchStatement;
import de.cismet.cids.custom.wunda_blau.search.server.KundeByVermessungsStellenNummerSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class VermessungsunterlagenValidator
implements ConnectionContextProvider {
    public static final String CONTACT = " E-Mail: geodatenzentrum@stadt.wuppertal.de  Tel.: +49 202 563 5399 ";
    public static final int MAX_PNR_PRO_KM = 100;
    public static final int MAX_SAUM = 999;
    private final Collection<CidsBean> flurstuecke = new ArrayList<CidsBean>();
    private boolean vermessungsstelleKnown = false;
    private final VermessungsunterlagenHandler helper;
    private boolean ignoreError = false;
    private boolean pnrNotZero = false;
    private boolean geometryFromFlurstuecke = true;
    private final ConnectionContext connectionContext;

    public VermessungsunterlagenValidator(VermessungsunterlagenHandler helper, ConnectionContext connectionContext) {
        this.helper = helper;
        this.connectionContext = connectionContext;
    }

    public boolean validateAndGetErrorMessage(VermessungsunterlagenAnfrageBean anfrageBean) throws VermessungsunterlagenException {
        this.vermessungsstelleKnown = this.isVermessungsstelleKnown(anfrageBean.getZulassungsnummerVermessungsstelle());
        if (anfrageBean.getGeschaeftsbuchnummer() == null || "".equals(anfrageBean.getGeschaeftsbuchnummer().trim())) {
            throw VermessungsunterlagenValidator.getExceptionByErrorCode(Error.NO_GESCHAEFTSBUCHNUMMER);
        }
        boolean bl = this.ignoreError = anfrageBean.getAktenzeichenKatasteramt() != null && anfrageBean.getAktenzeichenKatasteramt().startsWith("[i_e]");
        if (anfrageBean.getPunktnummernreservierungsArray() != null && anfrageBean.getPunktnummernreservierungsArray().length > 0) {
            for (VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean pnrOvject : anfrageBean.getPunktnummernreservierungsArray()) {
                if (pnrOvject.getAnzahlPunktnummern() == null || pnrOvject.getUtmKilometerQuadrat() == null || pnrOvject.getAnzahlPunktnummern() == null) {
                    throw VermessungsunterlagenValidator.getExceptionByErrorCode(Error.UNSUFFICENT_PNR);
                }
                if (pnrOvject.getAnzahlPunktnummern() < 0 || pnrOvject.getAnzahlPunktnummern() > 100) {
                    throw VermessungsunterlagenValidator.getExceptionByErrorCode(Error.WRONG_PNR);
                }
                if (pnrOvject.getAnzahlPunktnummern() == null || pnrOvject.getAnzahlPunktnummern() <= 0) continue;
                this.pnrNotZero = true;
            }
        }
        if (anfrageBean.getArtderVermessung() == null || anfrageBean.getArtderVermessung().length <= 0) {
            throw VermessungsunterlagenValidator.getExceptionByErrorCode(Error.NO_ART);
        }
        if (Boolean.TRUE.equals(anfrageBean.getNurPunktnummernreservierung())) {
            return true;
        }
        ArrayList<VermessungsunterlagenAnfrageBean.AntragsflurstueckBean> valideFlurstuecke = new ArrayList<VermessungsunterlagenAnfrageBean.AntragsflurstueckBean>();
        ArrayList<VermessungsunterlagenAnfrageBean.AntragsflurstueckBean> wuppFlurstuecke = new ArrayList<VermessungsunterlagenAnfrageBean.AntragsflurstueckBean>();
        if (anfrageBean.getAntragsflurstuecksArray() != null) {
            for (VermessungsunterlagenAnfrageBean.AntragsflurstueckBean antragsFlurstueck : anfrageBean.getAntragsflurstuecksArray()) {
                if (this.isFlurstueckValide(antragsFlurstueck)) {
                    valideFlurstuecke.add(antragsFlurstueck);
                }
                if (!this.isWuppGemarkung(antragsFlurstueck)) continue;
                wuppFlurstuecke.add(antragsFlurstueck);
            }
        }
        if (valideFlurstuecke.isEmpty() && !Boolean.TRUE.equals(anfrageBean.getAnonymousOrder())) {
            throw VermessungsunterlagenValidator.getExceptionByErrorCode(Error.NO_ANTRAGSFLURSTUECK);
        }
        boolean bl2 = this.geometryFromFlurstuecke = !wuppFlurstuecke.isEmpty();
        if (wuppFlurstuecke.isEmpty()) {
            Polygon[] polygonArray = anfrageBean.getAnfragepolygonArray();
            if (polygonArray == null || polygonArray.length <= 0 || polygonArray[0] == null) {
                throw VermessungsunterlagenValidator.getExceptionByErrorCode(Error.WRONG_GEBIET);
            }
            Polygon polygon = polygonArray[0];
            try {
                Geometry anfrageGeometrie = polygon.getGeometryN(0);
                anfrageGeometrie.setSRID(25832);
                for (CidsBean flurstueck : this.searchFlurstuecke(anfrageGeometrie, Boolean.TRUE.equals(anfrageBean.getAnonymousOrder()))) {
                    String[] alkisParts = ((String)flurstueck.getProperty("alkis_id")).split("-");
                    VermessungsunterlagenAnfrageBean.AntragsflurstueckBean wuppFlurstueck = new VermessungsunterlagenAnfrageBean.AntragsflurstueckBean();
                    wuppFlurstueck.setGemarkungsID(alkisParts[0]);
                    wuppFlurstueck.setFlurID(alkisParts[1]);
                    wuppFlurstueck.setFlurstuecksID(alkisParts[2]);
                    wuppFlurstuecke.add(wuppFlurstueck);
                }
            }
            catch (Exception ex) {
                throw new VermessungsunterlagenValidatorException("Fehler beim laden der Flurst\u00fccke f\u00fcr das Vermessungsgebiet.", ex);
            }
        }
        for (VermessungsunterlagenAnfrageBean.AntragsflurstueckBean wuppFlurstueck : wuppFlurstuecke) {
            boolean isWuppFlurstueckExisting;
            if (!this.isFlurstueckValide(wuppFlurstueck)) {
                throw VermessungsunterlagenValidator.getExceptionByErrorCode(Error.WRONG_ANTRAGSFLURSTUECK);
            }
            String alkisId = this.getAlkisId(wuppFlurstueck);
            Collection<CidsBean> flurstuecke = this.getWuppFlurstuecke(alkisId);
            boolean bl3 = isWuppFlurstueckExisting = flurstuecke != null && !flurstuecke.isEmpty();
            if (!isWuppFlurstueckExisting) {
                throw VermessungsunterlagenValidator.getExceptionByErrorCode(Error.UNKNOWN_ANTRAGSFLURSTUECK);
            }
            this.flurstuecke.addAll(flurstuecke);
        }
        if (anfrageBean.getSaumAPSuche() == null || "".equals(anfrageBean.getSaumAPSuche().trim())) {
            throw VermessungsunterlagenValidator.getExceptionByErrorCode(Error.NO_SAUM);
        }
        int iSaum = -1;
        try {
            if (!anfrageBean.getSaumAPSuche().contains("e") && !anfrageBean.getSaumAPSuche().contains("E")) {
                iSaum = Integer.parseInt(anfrageBean.getSaumAPSuche());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iSaum < 0 || iSaum > 999) {
            throw VermessungsunterlagenValidator.getExceptionByErrorCode(Error.WRONG_SAUM);
        }
        return true;
    }

    private boolean isFlurstueckValide(VermessungsunterlagenAnfrageBean.AntragsflurstueckBean fs) {
        if (fs == null) {
            return false;
        }
        String gemarkung = fs.getGemarkungsID();
        String flur = fs.getFlurID();
        String zaehlernenner = fs.getFlurstuecksID();
        return gemarkung != null && !gemarkung.trim().isEmpty() && !"OpenData".equals(gemarkung) && flur != null && !flur.trim().isEmpty() && !"OpenData".equals(flur) && zaehlernenner != null && !zaehlernenner.trim().isEmpty() && !"OpenData".equals(zaehlernenner);
    }

    private static VermessungsunterlagenException getExceptionByErrorCode(Error code) {
        String message;
        switch (code) {
            case NO_GESCHAEFTSBUCHNUMMER: {
                message = "Die angegebene Gesch\u00e4ftsbuchnummer ist leer. Bitte geben Sie eine g\u00fcltige Gesch\u00e4ftsbuchnummer an.";
                break;
            }
            case NO_ANTRAGSFLURSTUECK: {
                message = "Es wurde kein g\u00fcltiges Antragsflurst\u00fcck \u00fcbergeben. Geben Sie mindestens ein g\u00fcltiges Flurst\u00fcck an.";
                break;
            }
            case WRONG_ANTRAGSFLURSTUECK: {
                message = "Die Anfrage enth\u00e4lt mindestens eine unvollst\u00e4ndige Gemarkung-, Flur- oder Flurst\u00fcckseingabe.";
                break;
            }
            case UNKNOWN_ANTRAGSFLURSTUECK: {
                message = "Die Anfrage enth\u00e4lt mindestens eine unbekannte oder vor der ALKIS Einf\u00fchrung historisierte Flurst\u00fccksnummer.";
                break;
            }
            case WRONG_PNR: {
                message = "Die Anzahl der zu reservierenden Punkte muss pro Kilometerquadrat muss gr\u00f6\u00dfer oder gleich 0 und kleiner als 100 sein.";
                break;
            }
            case NO_SAUM: {
                message = "Es wurde kein g\u00fcltiger Saum angegeben.";
                break;
            }
            case WRONG_SAUM: {
                message = "Der angegebene Saum ist ung\u00fcltig. Nur ganzzahlige Eingaben zwischen 0 und 999 sind g\u00fcltig.";
                break;
            }
            case NO_ART: {
                message = "Es wurde keine oder keine g\u00fcltige Art der Vermessung angegeben.";
                break;
            }
            case UNSUFFICENT_PNR: {
                message = "Die Angaben zur Punktnummernreservierung sind unvollst\u00e4ndig.";
                break;
            }
            case WRONG_GEBIET: {
                message = "Es wurde kein oder kein g\u00fcltiges Vermessungsgebiet angegeben.";
                break;
            }
            default: {
                message = "";
            }
        }
        return new VermessungsunterlagenValidatorException(message);
    }

    private boolean isVermessungsstelleKnown(String vermessungsstelle) throws VermessungsunterlagenException {
        if ("053290".equals(vermessungsstelle)) {
            return true;
        }
        try {
            KundeByVermessungsStellenNummerSearch search = new KundeByVermessungsStellenNummerSearch(vermessungsstelle.startsWith("05") ? vermessungsstelle.substring(2) : vermessungsstelle);
            this.helper.performSearch((CidsServerSearch)search);
            Collection res = search.performServerSearch();
            return res != null && !res.isEmpty();
        }
        catch (SearchException ex) {
            return false;
        }
    }

    private boolean isWuppGemarkung(VermessungsunterlagenAnfrageBean.AntragsflurstueckBean flurstueckBean) throws VermessungsunterlagenValidatorException {
        if (flurstueckBean == null || flurstueckBean.getGemarkungsID() == null || "OpenData".equals(flurstueckBean.getGemarkungsID())) {
            return false;
        }
        try {
            int gemarkungId = Integer.parseInt(flurstueckBean.getGemarkungsID().trim().substring(2));
            if (gemarkungId == 0) {
                return false;
            }
            AlbFlurstueckKickerLightweightSearch search = new AlbFlurstueckKickerLightweightSearch();
            search.setSearchFor(AlbFlurstueckKickerLightweightSearch.SearchFor.GEMARKUNGEN);
            search.setRepresentationFields(new String[]{"id", "gemarkung", "name"});
            Collection lwmos = this.helper.performSearch((CidsServerSearch)search);
            if (lwmos != null) {
                for (LightweightMetaObject lwmo : lwmos) {
                    Object value;
                    ObjectAttribute oa;
                    if (lwmo == null || (oa = lwmo.getAttributeByFieldName("gemarkung")) == null || !((value = oa.getValue()) instanceof Integer) || !((Integer)value).equals(gemarkungId)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            throw new VermessungsunterlagenValidatorException("Fehler beim Suchen der Gemarkung: " + flurstueckBean.getGemarkungsID(), ex);
        }
    }

    private String getAlkisId(VermessungsunterlagenAnfrageBean.AntragsflurstueckBean flurstueckBean) {
        String alkisId;
        if (flurstueckBean == null) {
            return null;
        }
        try {
            String nenner;
            String zaehler;
            String zaehlernenner = flurstueckBean.getFlurstuecksID();
            if (zaehlernenner.contains("/")) {
                String[] split = zaehlernenner.split("/");
                if (split.length != 2) {
                    return null;
                }
                zaehler = split[0];
                nenner = split[1];
            } else {
                zaehler = zaehlernenner;
                nenner = "0";
            }
            alkisId = this.toAlkisId(flurstueckBean.getGemarkungsID(), Integer.valueOf(flurstueckBean.getFlurID()), Integer.valueOf(zaehler), Integer.valueOf(nenner));
        }
        catch (Exception ex) {
            return null;
        }
        return alkisId;
    }

    private Collection<CidsBean> getWuppFlurstuecke(String alkisId) throws VermessungsunterlagenException {
        if (alkisId == null) {
            return null;
        }
        try {
            ArrayList<CidsBean> flurstuecke = new ArrayList<CidsBean>();
            CidsBean fsCidsBean = this.searchFlurstueck(alkisId);
            if (fsCidsBean != null) {
                for (CidsBean aktuell : this.getAktuelle(fsCidsBean)) {
                    CidsAlkisSearchStatement alkisSearch = new CidsAlkisSearchStatement(CidsAlkisSearchStatement.Resulttyp.FLURSTUECK, CidsAlkisSearchStatement.SucheUeber.FLURSTUECKSNUMMER, (String)aktuell.getProperty("alkis_id"), null);
                    Collection mons = this.helper.performSearch((CidsServerSearch)alkisSearch);
                    for (MetaObjectNode mon : mons) {
                        CidsBean alkisBean = this.helper.loadCidsBean(mon);
                        flurstuecke.add(alkisBean);
                    }
                }
            }
            return flurstuecke;
        }
        catch (Exception ex) {
            throw new VermessungsunterlagenValidatorException("Fehler beim Laden des Flurst\u00fccks: " + alkisId, ex);
        }
    }

    private Collection<CidsBean> getAktuelle(CidsBean fsCidsBean) throws Exception {
        ArrayList<CidsBean> aktuelle = new ArrayList<CidsBean>();
        if (fsCidsBean != null) {
            if (fsCidsBean.getProperty("historisch") == null) {
                aktuelle.add(fsCidsBean);
            } else {
                for (CidsBean nachfolger : this.getNachfolger(fsCidsBean)) {
                    aktuelle.addAll(this.getAktuelle(nachfolger));
                }
            }
        }
        return aktuelle;
    }

    private Collection<CidsBean> getNachfolger(CidsBean flurstueck) throws Exception {
        ArrayList<CidsBean> nachfolgerBeans = new ArrayList<CidsBean>();
        String query = "SELECT flurstueckskennzeichen_neu FROM lookup_alkis_ffn WHERE ffn LIKE '" + (String)flurstueck.getProperty("fortfuehrungsnummer") + "' AND flurstueckskennzeichen_alt LIKE '" + ((String)flurstueck.getProperty("alkis_id")).replace("-", "") + "_%';";
        MetaService metaService = this.helper.getMetaService();
        for (ArrayList fields : metaService.performCustomSearch(query, this.getConnectionContext())) {
            String kennzeichen = (String)fields.get(0);
            CidsBean nachfolgerBean = this.searchFlurstueck(this.toAlkisId(kennzeichen.substring(0, 6), Integer.valueOf(kennzeichen.substring(6, 9)), Integer.valueOf(kennzeichen.substring(9, 14)), Integer.valueOf(kennzeichen.substring(14).replaceAll("_", "0"))));
            if (nachfolgerBean == null) continue;
            nachfolgerBeans.add(nachfolgerBean);
        }
        return nachfolgerBeans;
    }

    private String toAlkisId(String gemarkung, int flur, int zaehler, int nenner) {
        String nf = String.format("%04d", nenner);
        return gemarkung + "-" + String.format("%03d", flur) + "-" + String.format("%05d", zaehler) + (!nf.equals("0000") ? "/" + nf : "");
    }

    private Collection<CidsBean> searchFlurstuecke(Geometry geom, boolean anon) throws Exception {
        boolean keepOnlyBiggestIntersection;
        BufferingGeosearch search = new BufferingGeosearch();
        search.setGeometry(geom);
        MetaClass mc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"alkis_landparcel", (ConnectionContext)this.getConnectionContext());
        search.setValidClasses(Arrays.asList(mc));
        ArrayList mons = new ArrayList();
        if (anon) {
            search.setGeomMode(BufferingGeosearch.GeomMode.WITHIN);
            mons.addAll(this.helper.performSearch((CidsServerSearch)search));
            keepOnlyBiggestIntersection = mons.isEmpty();
            if (mons.isEmpty()) {
                search.setGeomMode(BufferingGeosearch.GeomMode.INTERSECTS);
            }
        } else {
            keepOnlyBiggestIntersection = false;
        }
        if (mons.isEmpty()) {
            mons.addAll(this.helper.performSearch((CidsServerSearch)search));
        }
        ArrayList<CidsBean> flurstuecke = new ArrayList<CidsBean>();
        for (MetaObjectNode mon : mons) {
            CidsBean flurstueck = this.helper.loadCidsBean(mon);
            flurstuecke.add(flurstueck);
        }
        if (keepOnlyBiggestIntersection) {
            CidsBean biggestIntersectionFlurstueck = null;
            double biggestIntersectionArea = -1.0;
            for (CidsBean flurstueck : flurstuecke) {
                Geometry flurstueckGeom = (Geometry)flurstueck.getProperty("geometrie");
                Geometry intersectGeom = flurstueckGeom.intersection(geom);
                double intersectionArea = intersectGeom.getArea();
                if (!(intersectionArea > biggestIntersectionArea)) continue;
                biggestIntersectionArea = intersectionArea;
                biggestIntersectionFlurstueck = flurstueck;
            }
            return Arrays.asList(biggestIntersectionFlurstueck);
        }
        return flurstuecke;
    }

    private CidsBean searchFlurstueck(String alkisId) throws Exception {
        String nenner;
        String zaehler;
        String zaehlernenner = alkisId.substring(11);
        if (zaehlernenner.contains("/")) {
            String[] split = zaehlernenner.split("/");
            zaehler = split[0];
            nenner = split[1];
        } else {
            zaehler = zaehlernenner;
            nenner = null;
        }
        String[] parts = VermessungsunterlagenUtils.createFlurstueckParts(alkisId.substring(0, 6), alkisId.substring(7, 10), zaehler, nenner);
        if (parts == null) {
            return null;
        }
        AlbFlurstueckKickerLightweightSearch search = new AlbFlurstueckKickerLightweightSearch();
        search.setSearchFor(AlbFlurstueckKickerLightweightSearch.SearchFor.FLURSTUECK);
        search.setGemarkungsnummer(parts[0]);
        search.setFlur(parts[1]);
        search.setZaehler(parts[2]);
        search.setNenner(parts[3]);
        search.setRepresentationFields(new String[]{"id", "gemarkung", "flur", "zaehler", "nenner"});
        Collection result = this.helper.performSearch((CidsServerSearch)search);
        if (result != null && !result.isEmpty()) {
            CidsBean cidsBean = this.helper.loadCidsBean((LightweightMetaObject)result.iterator().next());
            CidsBean fsCidsBean = (CidsBean)cidsBean.getProperty("fs_referenz");
            return fsCidsBean;
        }
        return null;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public Collection<CidsBean> getFlurstuecke() {
        return this.flurstuecke;
    }

    public boolean isVermessungsstelleKnown() {
        return this.vermessungsstelleKnown;
    }

    public VermessungsunterlagenHandler getHelper() {
        return this.helper;
    }

    public boolean isIgnoreError() {
        return this.ignoreError;
    }

    public boolean isPnrNotZero() {
        return this.pnrNotZero;
    }

    public boolean isGeometryFromFlurstuecke() {
        return this.geometryFromFlurstuecke;
    }

    public static enum Error {
        NO_GESCHAEFTSBUCHNUMMER,
        NO_ANTRAGSFLURSTUECK,
        WRONG_ANTRAGSFLURSTUECK,
        UNKNOWN_ANTRAGSFLURSTUECK,
        UNSUFFICENT_PNR,
        WRONG_PNR,
        NO_SAUM,
        WRONG_SAUM,
        NO_ART,
        WRONG_GEBIET;

    }
}

