/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.vermessungsunterlagen.tasks;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.utils.alkis.NivellementPunktReportBean;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenUtils;
import de.cismet.cids.custom.utils.vermessungsunterlagen.exceptions.VermessungsunterlagenTaskException;
import de.cismet.cids.custom.utils.vermessungsunterlagen.tasks.VermUntTaskNivP;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class VermUntTaskNivPBeschreibungen
extends VermUntTaskNivP {
    public static final String TYPE = "NivP_Beschreibungen";

    public VermUntTaskNivPBeschreibungen(String jobkey, Collection<CidsBean> nivPoints) {
        super(TYPE, jobkey, nivPoints);
    }

    @Override
    public void performTask() throws VermessungsunterlagenTaskException {
        try {
            String prefix = "NivP-Bericht";
            String suffix = this.getJobKey().substring(this.getJobKey().indexOf("_") + 1, this.getJobKey().length());
            String filename = this.getPath() + "/" + "NivP-Bericht" + "_" + suffix.replace("/", "--") + ".pdf";
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("SUBREPORT_DIR", DomainServerImpl.getServerProperties().getServerResourcesBasePath() + "/");
            try (FileOutputStream out = new FileOutputStream(filename);){
                VermessungsunterlagenUtils.jasperReportDownload(ServerResourcesLoader.getInstance().loadJasperReport(WundaBlauServerResources.NIVP_JASPER.getValue()), parameters, (JRDataSource)new JRBeanCollectionDataSource(Arrays.asList(new NivellementPunktReportBean(this.getNivPoints()))), out);
            }
        }
        catch (Exception ex) {
            String message = "Beim Erstellen des NIVP-Berichtes kam es zu einem unerwarteten Fehler.";
            throw new VermessungsunterlagenTaskException(this.getType(), "Beim Erstellen des NIVP-Berichtes kam es zu einem unerwarteten Fehler.", ex);
        }
    }
}

