/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.newuser.User;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.wunda_blau.search.actions.OpenChannelInfo;
import de.cismet.cids.custom.wunda_blau.search.actions.SocketIOSocketProvider;
import de.cismet.cids.custom.wunda_blau.search.actions.StamperServerAction;
import de.cismet.cids.custom.wunda_blau.search.actions.orbit.OrbitStacTools;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import io.socket.client.Socket;
import java.util.Properties;
import org.apache.log4j.Logger;

public class GetOrbitStacAction
implements ServerAction,
UserAwareServerAction {
    private static final Logger LOG = Logger.getLogger(StamperServerAction.class);
    public static final String TASK_NAME = "getOrbitStac";
    private User user;

    public Object execute(Object body, ServerActionParameter ... saps) {
        String ipAddress = null;
        String stacOptions = null;
        ObjectMapper mapper = new ObjectMapper();
        String stac = OrbitStacTools.getInstance().createStac(this.user.getName(), ipAddress, stacOptions);
        try {
            Properties settings = ServerResourcesLoader.getInstance().loadProperties(WundaBlauServerResources.ORBIT_SETTINGS_PROPERTIES.getValue());
            String OPEN_CHANNELS_SECRET = settings.getProperty("openChannelsSecret");
            String SOCKET_BROADCASTER = settings.getProperty("socketBroadcaster");
            int OPEN_CHANNEL_TIMEOUT = Integer.parseInt(settings.getProperty("openChannelTimeout"));
            for (ServerActionParameter sap : saps) {
                if (sap.getKey().equals(PARAMETER_TYPE.IP.toString())) {
                    ipAddress = (String)sap.getValue();
                    continue;
                }
                if (!sap.getKey().equals(PARAMETER_TYPE.STAC_OPTIONS.toString())) continue;
                stacOptions = (String)sap.getValue();
            }
            String socketChannelId = OrbitStacTools.getInstance().getEntry(stac).getSocketChannelId();
            GetOrbitStacAction.openChannels(socketChannelId, OPEN_CHANNELS_SECRET, OPEN_CHANNEL_TIMEOUT);
            return "{\"stac\":\"" + stac + "\",\"socketChannelId\":\"" + socketChannelId + "\"}";
        }
        catch (Exception e) {
            LOG.error((Object)"Error during GetOrbitStacAction. Will send STAC only. (No Socket-Functionality available.)", (Throwable)e);
            return "{\"stac\":\"" + stac + "\"}";
        }
    }

    private static void openChannels(String socketChannelId, String OPEN_CHANNELS_SECRET, int OPEN_CHANNEL_TIMEOUT) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        OpenChannelInfo info = new OpenChannelInfo();
        String[] channels = new String[]{"toOrbit:" + socketChannelId, "fromOrbit:" + socketChannelId};
        info.setSecret(OPEN_CHANNELS_SECRET);
        info.setChannels(channels);
        info.setTimeoutS(OPEN_CHANNEL_TIMEOUT);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("try to open channels for " + socketChannelId));
        }
        Socket socket = SocketIOSocketProvider.getInstance().getSocket();
        socket.emit("open", new Object[]{mapper.writeValueAsString((Object)info)});
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public static enum PARAMETER_TYPE {
        IP,
        STAC_OPTIONS;

    }
}

