/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class ImageAnnotator {
    static int LINES = 1;
    private static Font calibriFont;
    private static final transient Logger LOG;
    BufferedImage image = null;
    BufferedImage watermark = null;
    int width = 0;
    int height = 0;
    int newHeight = 0;
    int newWidth = 0;
    int maximalTextHeight = 0;
    int maximalTextWidth = 0;
    String text = "";
    float ratio = 1.03f;
    Color textColor = Color.BLACK;
    Color backGroundColor = new Color(235, 235, 235);
    String filename = "";

    public ImageAnnotator(String filename, String text) throws IOException {
        this.filename = filename;
        this.image = this.loadImage(filename);
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.text = text;
    }

    public ImageAnnotator(URL filename, String text) throws IOException {
        this.image = this.loadImage(filename);
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.text = text;
    }

    public ImageAnnotator(String filename, BufferedImage watermark) throws IOException {
        this.filename = filename;
        this.image = this.loadImage(filename);
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.watermark = watermark;
    }

    public ImageAnnotator(String filename, String watermarkFilename, String text) throws IOException {
        this.filename = filename;
        this.image = this.loadImage(filename);
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.watermark = this.loadImage(watermarkFilename);
        this.text = text;
    }

    public ImageAnnotator(String filename, BufferedImage watermarkFilename, String text) throws IOException {
        this(filename, watermarkFilename);
        this.text = text;
    }

    public ImageAnnotator(URL file, URL watermark, String text) throws IOException {
        this.image = this.loadImage(file);
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.watermark = this.loadImage(watermark);
        this.text = text;
    }

    public ImageAnnotator(URL file, BufferedImage watermark, String text) throws IOException {
        this.image = this.loadImage(file);
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.watermark = watermark;
        this.text = text;
    }

    protected final BufferedImage loadImage(String filename) throws IOException {
        String type = this.extractImageType(filename);
        if (type.length() == 0) {
            type = "TIF";
        }
        File f = new File(filename);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Info : file :" + filename + " file " + f));
        }
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(type);
        ImageReader reader = readers.next();
        ImageInputStream iis = ImageIO.createImageInputStream(f);
        reader.setInput(iis, false);
        boolean imageIndex = false;
        return reader.read(0);
    }

    protected final BufferedImage loadImage(URL imgUrl) throws IOException {
        String type = this.extractImageType(imgUrl.getFile());
        if (type.length() == 0) {
            type = "TIF";
        }
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(type);
        ImageReader reader = readers.next();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)imgUrl);
        }
        ImageInputStream iis = ImageIO.createImageInputStream(imgUrl.openStream());
        reader.setInput(iis, false, true);
        boolean imageIndex = false;
        return reader.read(0);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void addText(String text) {
        this.text = this.text + text;
    }

    public float getRatio() {
        return this.ratio;
    }

    public void setRatio(float ratio) {
        this.ratio = ratio;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Color getBackGroundColor() {
        return this.backGroundColor;
    }

    public void setBackGroundColor(Color backGroundColor) {
        this.backGroundColor = backGroundColor;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public BufferedImage getWatermark() {
        return this.watermark;
    }

    public void setWatermark(BufferedImage watermark) {
        this.watermark = watermark;
    }

    public BufferedImage getAnnotatedImage() {
        this.newHeight = (int)((float)this.height * this.ratio);
        this.newWidth = this.width;
        int thickness = (this.newHeight - this.height) / 20;
        BufferedImage bi = new BufferedImage(this.newWidth, this.newHeight, 1);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.setColor(this.backGroundColor);
        g.fillRect(0, 0, this.newWidth, this.newHeight);
        if (this.watermark != null) {
            g.drawImage((Image)this.watermark, this.newWidth - (this.watermark.getWidth() + 5), this.newHeight - (this.watermark.getHeight() + 5), null);
        }
        g.drawImage((Image)this.image, 0, 0, null);
        g.setColor(Color.black);
        g.setStroke(new BasicStroke(thickness));
        boolean x = false;
        boolean y = false;
        g.drawRect(0 + thickness / 2, 0 + thickness / 2, this.width - 2 * (thickness / 2), this.newHeight - 2 * (thickness / 2) - 1);
        if (this.text.length() > 0) {
            this.drawText(g);
        }
        return bi;
    }

    protected void drawText(Graphics g) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            System.out.println("set antialiasing");
        }
        int rectangleHeight = this.newHeight - this.height;
        this.maximalTextHeight = rectangleHeight / 2;
        int fontSize = this.maximalTextHeight / LINES;
        this.maximalTextWidth = this.width - 2 * (this.width / 10);
        Font f = calibriFont.deriveFont((float)fontSize * 1.0f);
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        String[] linesToDraw = this.testDraw(fm);
        while (linesToDraw.length > LINES) {
            this.maximalTextWidth = this.width - this.width / 10;
            f = calibriFont.deriveFont((float)(--fontSize) * 1.0f);
            g.setFont(f);
            fm = g.getFontMetrics();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying new fontsize : " + fontSize));
            }
            linesToDraw = this.testDraw(fm);
        }
        int stringPos = this.height + rectangleHeight / 2 + fm.getAscent() / 3;
        for (String line : linesToDraw) {
            g.drawString(line, fontSize / 3, stringPos);
            stringPos += fontSize - 2;
        }
    }

    private String[] testDraw(FontMetrics fontMetrics) {
        String stillToDraw = this.text;
        ArrayList<String> linesToDraw = new ArrayList<String>();
        while (!stillToDraw.isEmpty() || !stillToDraw.matches("\\s*")) {
            String drawString = this.getSubstringFittingOneLine(stillToDraw, fontMetrics);
            linesToDraw.add(drawString);
            stillToDraw = stillToDraw.substring(drawString.length()).trim();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("stillToDraw: " + stillToDraw));
        }
        return linesToDraw.toArray(new String[linesToDraw.size()]);
    }

    private String getSubstringFittingOneLine(String stillToDraw, FontMetrics fontMetrics) {
        if (fontMetrics.stringWidth(stillToDraw) < this.maximalTextWidth) {
            return stillToDraw;
        }
        int space = stillToDraw.lastIndexOf(" ");
        String fitsOneLine = stillToDraw.substring(0, space + 1);
        while (fontMetrics.stringWidth(fitsOneLine) > this.maximalTextWidth) {
            space = fitsOneLine.lastIndexOf(" ");
            fitsOneLine = stillToDraw.substring(0, space);
        }
        return fitsOneLine;
    }

    public void saveImage(BufferedImage im, String filename) throws IOException {
        String type = this.extractImageType(filename);
        if (type.length() == 0) {
            type = "TIF";
        }
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(type);
        ImageWriter writer = writers.next();
        File f = new File(filename);
        ImageOutputStream ios = ImageIO.createImageOutputStream(f);
        writer.setOutput(ios);
        writer.write(im);
    }

    private String extractImageType(String filename) {
        String type = "";
        int endingIndex = filename.lastIndexOf(".");
        if (endingIndex > 0) {
            type = filename.substring(endingIndex + 1, filename.length());
        }
        return type;
    }

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure();
        String txt = "Kommunale Geodaten der Stadt Wuppertal (Bildnummer $bnr$), \u00a9 Ressort Vermessung, Katasteramt und Geodaten";
        String bildnummer = "004711";
        txt = txt.replace("$bnr$", "004711");
        URL imgUrl = null;
        ImageAnnotator t = null;
        imgUrl = new URL("http://127.0.0.1:8000/haus.jpg");
        t = new ImageAnnotator(imgUrl, txt);
        t.saveImage(t.getAnnotatedImage(), "/tmp/haus.jpg");
        imgUrl = new URL("http://127.0.0.1:8000/treppe.jpg");
        t = new ImageAnnotator(imgUrl, txt);
        t.saveImage(t.getAnnotatedImage(), "/tmp/treppe.jpg");
        System.out.println("done");
    }

    static {
        LOG = Logger.getLogger(ImageAnnotator.class);
        try {
            calibriFont = Font.createFont(0, new ByteArrayInputStream(ServerResourcesLoader.getInstance().loadBinary(WundaBlauServerResources.IMAGE_ANNOTATOR_FONT.getValue())));
        }
        catch (Exception ex) {
            LOG.warn((Object)"Calibri could not be loaded", (Throwable)ex);
            calibriFont = new Font("SansSerif", 1, 100);
        }
    }
}

