/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.pointnumberreservation.PointNumberReservation;
import de.cismet.cids.custom.utils.pointnumberreservation.PointNumberReservationRequest;
import de.cismet.cids.custom.utils.pointnumberreservation.PointNumberReservationService;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class PointNumberReservationServerAction
implements UserAwareServerAction,
MetaServiceStore,
ConnectionContextStore {
    private static final String ANR_SEPERATOR = "_";
    private MetaService metaService;
    private User user;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    private Collection<String> getAllAntragsNummern() {
        Collection<PointNumberReservationRequest> requests = PointNumberReservationService.instance().getAllBenAuftr(this.getProfilKennung());
        ArrayList<String> antragsNummern = new ArrayList<String>();
        if (requests != null) {
            for (PointNumberReservationRequest r : requests) {
                antragsNummern.add(r.getAntragsnummer());
            }
        }
        return antragsNummern;
    }

    private Collection<String> getAllAntragsNummern(String aPrefix) {
        String anr = aPrefix + "*";
        Collection<PointNumberReservationRequest> requests = PointNumberReservationService.instance().getAllBenAuftrWithWildCard(anr, this.getProfilKennung());
        ArrayList<String> antragsNummern = new ArrayList<String>();
        if (requests != null) {
            for (PointNumberReservationRequest r : requests) {
                antragsNummern.add(r.getAntragsnummer());
            }
        }
        return antragsNummern;
    }

    private boolean isAntragsNummerAlreadyExisting(String aPrefix, String aNummer) {
        String anr = aPrefix + ANR_SEPERATOR + aNummer;
        if (!this.isAuftragsNummerValid(anr)) {
            return false;
        }
        return PointNumberReservationService.instance().isAntragsNummerExisting(anr, this.getProfilKennung());
    }

    private Object doReservierung(String aPrefix, String aNummer, String nbz, int anzahl, int startwert) {
        String anr = aPrefix + ANR_SEPERATOR + aNummer;
        if (!this.isAuftragsNummerValid(anr)) {
            return null;
        }
        return PointNumberReservationService.instance().doReservation(aPrefix, anr, nbz, anzahl, startwert, this.getProfilKennung());
    }

    private Collection<PointNumberReservation> getReserviertePunkte(String aPrefix, String aNummer) {
        String anr = aPrefix + ANR_SEPERATOR + aNummer;
        PointNumberReservationRequest result = PointNumberReservationService.instance().getBenAuftr(anr, this.getProfilKennung());
        if (result != null) {
            return result.getPointNumbers();
        }
        return null;
    }

    private PointNumberReservationRequest doStorno(String aPrefix, String aNummer, String nbz, int on1, int on2) {
        String anr = aPrefix + ANR_SEPERATOR + aNummer;
        if (!this.isAuftragsNummerValid(anr)) {
            return null;
        }
        return PointNumberReservationService.instance().doReleaseReservation(aPrefix, anr, nbz, on1, on2, this.getProfilKennung());
    }

    private String getProfilKennung() {
        String profilKennung = "WUNDA_RES";
        try {
            String conf = ((DomainServerImpl)this.getMetaService()).getConfigAttr(this.getUser(), "custom.punktnummernreservierung.profilkennung", this.getConnectionContext());
            if (conf != null) {
                profilKennung = conf;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return profilKennung;
    }

    private Object doVerlaengern(String aPrefix, String aNummer, Collection<Long> ps, Date date) {
        String anr = aPrefix + ANR_SEPERATOR + aNummer;
        if (!this.isAuftragsNummerValid(anr)) {
            return null;
        }
        return PointNumberReservationService.instance().doProlongReservation(aPrefix, anr, ps, date, this.getProfilKennung());
    }

    private boolean isAuftragsNummerValid(String requestId) {
        return requestId.length() <= 50 && requestId.matches("[a-zA-Z0-9_-]*");
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        Enum method = null;
        String prefix = null;
        String auftragsNummer = null;
        String nbz = null;
        int anzahl = 0;
        int startwert = 0;
        int on1 = 0;
        int on2 = 0;
        Date prolongDate = null;
        ArrayList<Long> pointnumbers = new ArrayList<Long>();
        for (ServerActionParameter sap : params) {
            if (sap.getKey().equals(Parameter.ACTION.toString())) {
                method = (Action)((Object)sap.getValue());
                continue;
            }
            if (sap.getKey().equals(Parameter.AUFTRAG_NUMMER.toString())) {
                auftragsNummer = (String)sap.getValue();
                continue;
            }
            if (sap.getKey().equals(Parameter.PREFIX.toString())) {
                prefix = (String)sap.getValue();
                continue;
            }
            if (sap.getKey().equals(Parameter.NBZ.toString())) {
                nbz = (String)sap.getValue();
                continue;
            }
            if (sap.getKey().equals(Parameter.ANZAHL.toString())) {
                anzahl = (Integer)sap.getValue();
                continue;
            }
            if (sap.getKey().equals(Parameter.STARTWERT.toString())) {
                startwert = (Integer)sap.getValue();
                continue;
            }
            if (sap.getKey().equals(Parameter.ON1.toString())) {
                on1 = (Integer)sap.getValue();
                continue;
            }
            if (sap.getKey().equals(Parameter.ON2.toString())) {
                on2 = (Integer)sap.getValue();
                continue;
            }
            if (sap.getKey().equals(Parameter.POINT_NUMBER.toString())) {
                pointnumbers.add((Long)sap.getValue());
                continue;
            }
            if (!sap.getKey().equals(Parameter.PROLONG_DATE.toString())) continue;
            prolongDate = (Date)sap.getValue();
        }
        if (method != null) {
            switch (1.$SwitchMap$de$cismet$cids$custom$wunda_blau$search$actions$PointNumberReservationServerAction$Action[method.ordinal()]) {
                case 1: {
                    if (prefix != null && auftragsNummer != null && nbz != null && anzahl > 0) {
                        if (!this.isAntragsNummerAlreadyExisting(prefix, auftragsNummer)) {
                            return this.doReservierung(prefix, auftragsNummer, nbz, anzahl, startwert);
                        }
                        throw new IllegalStateException("Antragsnummer " + prefix + ANR_SEPERATOR + auftragsNummer + " existiert bereits");
                    }
                    return null;
                }
                case 2: {
                    if (prefix != null && auftragsNummer != null && nbz != null && on1 > 0 && on2 > 0 && on1 <= on2) {
                        return this.doStorno(prefix, auftragsNummer, nbz, on1, on2);
                    }
                    return null;
                }
                case 3: {
                    if (prefix != null && auftragsNummer != null && prolongDate != null && !pointnumbers.isEmpty()) {
                        return this.doVerlaengern(prefix, auftragsNummer, pointnumbers, prolongDate);
                    }
                    return null;
                }
                case 4: {
                    if (prefix != null && auftragsNummer != null && nbz != null && anzahl > 0 && this.isAntragsNummerAlreadyExisting(prefix, auftragsNummer)) {
                        return this.doReservierung(prefix, auftragsNummer, nbz, anzahl, startwert);
                    }
                    return null;
                }
                case 5: {
                    if (prefix == null) {
                        return this.getAllAntragsNummern();
                    }
                    return this.getAllAntragsNummern(prefix);
                }
                case 6: {
                    if (prefix != null && auftragsNummer != null) {
                        return this.getReserviertePunkte(prefix, auftragsNummer);
                    }
                    return null;
                }
                case 7: {
                    if (prefix != null && auftragsNummer != null) {
                        return this.isAntragsNummerAlreadyExisting(prefix, auftragsNummer);
                    }
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public String getTaskName() {
        return "pointNumberReservation";
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setMetaService(MetaService metaSevice) {
        this.metaService = metaSevice;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum Parameter {
        ACTION,
        PREFIX,
        AUFTRAG_NUMMER,
        NBZ,
        ANZAHL,
        STARTWERT,
        ON1,
        ON2,
        POINT_NUMBER,
        PROLONG_DATE;

    }

    public static enum Action {
        GET_ALL_RESERVATIONS,
        IS_ANTRAG_EXISTING,
        DO_RESERVATION,
        DO_ADDITION,
        GET_POINT_NUMBERS,
        DO_STORNO,
        DO_PROLONGATION;

    }
}

