/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.utils.PotenzialflaecheReportCreator;
import de.cismet.cids.custom.utils.PotenzialflaechenMapsJson;
import de.cismet.cids.custom.utils.PotenzialflaechenProperties;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.wunda_blau.search.server.AlkisLandparcelGeometryMonSearch;
import de.cismet.cids.custom.wunda_blau.search.server.BodenrichtwertZoneMonSearch;
import de.cismet.cids.custom.wunda_blau.search.server.BplaeneMonSearch;
import de.cismet.cids.custom.wunda_blau.search.server.FnpHauptnutzungenMonSearch;
import de.cismet.cids.custom.wunda_blau.search.server.GeometrySearch;
import de.cismet.cids.custom.wunda_blau.search.server.KstGeometryMonSearch;
import de.cismet.cids.custom.wunda_blau.search.server.PotenzialflaecheSearch;
import de.cismet.cids.custom.wunda_blau.search.server.RestApiMonSearch;
import de.cismet.cids.custom.wunda_blau.search.server.RpdKategorieMonSearch;
import de.cismet.cids.custom.wunda_blau.search.server.StadtraumtypMonSearch;
import de.cismet.cids.custom.wunda_blau.search.server.WohnlagenKategorisierungMonSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.DefaultServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.utils.serverresources.JsonServerResource;
import de.cismet.cids.utils.serverresources.PropertiesServerResource;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.connectioncontext.ConnectionContext;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;

public class PotenzialflaecheReportServerAction
extends DefaultServerAction {
    private static final transient Logger LOG = Logger.getLogger(PotenzialflaecheReportServerAction.class);
    public static final String TASK_NAME = "potenzialflaecheReport";
    private static String TEMPLATEREPLACER_INPUT_FILELIST = "{PDF_INPUT_FILELIST}";
    private static String TEMPLATEREPLACER_OUTPUT_FILE = "{PDF_OUTPUT_FILE}";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final PropertiesServerResource POTENZIALFLAECHEN_PROPERTIES = (PropertiesServerResource)WundaBlauServerResources.POTENZIALFLAECHEN_PROPERTIES.getValue();
    private final JsonServerResource POTENZIALFLAECHEN_MAPS_JSON = (JsonServerResource)WundaBlauServerResources.POTENZIALFLAECHEN_MAPS_JSON.getValue();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    private MetaObjectNode getFor(Object object, String table_name, String key) throws Exception {
        List singelResult;
        if (object instanceof MetaObjectNode) {
            return (MetaObjectNode)object;
        }
        if (object instanceof Integer) {
            return new MetaObjectNode("WUNDA_BLAU", ((Integer)object).intValue(), CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)table_name, (ConnectionContext)this.getConnectionContext()).getId());
        }
        if (object instanceof String && (singelResult = (List)this.getMetaService().performCustomSearch(String.format("SELECT id, (SELECT id FROM cs_class WHERE table_name ILIKE '%1$s') FROM %1$s WHERE %2$s = '%3$s' LIMIT 1;", table_name, key, StringEscapeUtils.escapeSql((String)((String)object))), this.getConnectionContext()).iterator().next()) != null && singelResult.size() == 2) {
            return new MetaObjectNode("WUNDA_BLAU", ((Integer)singelResult.get(0)).intValue(), ((Integer)singelResult.get(1)).intValue());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(Object body, ServerActionParameter ... params) {
        try {
            CidsBean templateBean;
            HashSet<MetaObjectNode> kategorieMons;
            HashSet<MetaObjectNode> flaecheMons;
            ResultType resultType;
            block46: {
                BodyType bodyType;
                block44: {
                    block47: {
                        block45: {
                            bodyType = BodyType.POTENZIALFLAECHE;
                            resultType = ResultType.PDF;
                            flaecheMons = new HashSet<MetaObjectNode>();
                            kategorieMons = new HashSet<MetaObjectNode>();
                            MetaObjectNode templateMon = null;
                            if (params != null) {
                                for (ServerActionParameter sap : params) {
                                    Object value = sap.getValue();
                                    if (sap.getKey().equals(Parameter.BODY_TYPE.toString())) {
                                        bodyType = value instanceof BodyType ? (BodyType)((Object)value) : (value instanceof String ? BodyType.valueOf((String)value) : null);
                                        continue;
                                    }
                                    if (sap.getKey().equals(Parameter.RESULT_TYPE.toString())) {
                                        resultType = value instanceof ResultType ? (ResultType)((Object)value) : (value instanceof String ? ResultType.valueOf((String)value) : null);
                                        continue;
                                    }
                                    if (sap.getKey().equals(Parameter.POTENZIALFLAECHE.toString())) {
                                        flaecheMons.add(this.getFor(sap.getValue(), "pf_potenzialflaeche", "nummer"));
                                        continue;
                                    }
                                    if (sap.getKey().equals(Parameter.KATEGORIE.toString())) {
                                        kategorieMons.add(this.getFor(sap.getValue(), "pf_kampagne", "bezeichnung"));
                                        continue;
                                    }
                                    if (!sap.getKey().equals(Parameter.TEMPLATE.toString())) continue;
                                    templateMon = this.getFor(sap.getValue(), "pf_steckbrieftemplate", "bezeichnung");
                                }
                            }
                            CidsBean cidsBean = templateBean = templateMon != null ? this.getMetaService().getMetaObject(this.getUser(), templateMon.getObjectId(), templateMon.getClassId(), this.getConnectionContext()).getBean() : null;
                            if (!BodyType.POTENZIALFLAECHE.equals((Object)bodyType)) break block44;
                            if (!(body instanceof MetaObjectNode)) break block45;
                            flaecheMons.add((MetaObjectNode)body);
                            break block46;
                        }
                        if (!(body instanceof byte[])) break block47;
                        flaecheMons.add(this.getFor(new String((byte[])body), "pf_potenzialflaeche", "nummer"));
                        break block46;
                    }
                    if (body instanceof MetaObjectNode[]) {
                        flaecheMons.addAll(Arrays.asList((MetaObjectNode[])body));
                        break block46;
                    } else if (body instanceof Collection) {
                        flaecheMons.addAll((Collection)body);
                    }
                    break block46;
                }
                if (BodyType.KATEGORIE.equals((Object)bodyType)) {
                    if (body instanceof MetaObjectNode) {
                        kategorieMons.add((MetaObjectNode)body);
                    } else if (body instanceof byte[]) {
                        kategorieMons.add(this.getFor(new String((byte[])body), "pf_kampagne", "bezeichnung"));
                    } else if (body instanceof MetaObjectNode[]) {
                        kategorieMons.addAll(Arrays.asList((MetaObjectNode[])body));
                    } else if (body instanceof Collection) {
                        kategorieMons.addAll((Collection)body);
                    }
                }
            }
            if (!kategorieMons.isEmpty()) {
                for (MetaObjectNode kategorieMon : kategorieMons) {
                    PotenzialflaecheSearch.Configuration configuration = new PotenzialflaecheSearch.Configuration();
                    configuration.addFilter(Property.KAMPAGNE, kategorieMon);
                    PotenzialflaecheSearch search = new PotenzialflaecheSearch(true);
                    HashMap<String, MetaService> localServers = new HashMap<String, MetaService>();
                    localServers.put("WUNDA_BLAU", this.getMetaService());
                    search.setActiveLocalServers(localServers);
                    search.setUser(this.getUser());
                    search.setConfiguration(configuration);
                    flaecheMons.addAll(search.performServerSearch());
                }
            }
            String reportsDirectoryName = this.getProperties().getReportsDirectory();
            String random = RandomStringUtils.randomAlphanumeric((int)24);
            if (flaecheMons.isEmpty()) {
                throw new Exception("flaeche not given");
            }
            if (ResultType.PDF.equals((Object)resultType)) {
                File reportsDirectory = new File(reportsDirectoryName);
                String pdfName = String.format("%s.pdf", random);
                File pdfFile = new File(reportsDirectoryName, pdfName);
                if (flaecheMons.size() == 1) {
                    MetaObjectNode flaecheMon = (MetaObjectNode)flaecheMons.iterator().next();
                    CidsBean flaecheBean = this.getMetaService().getMetaObject(this.getUser(), flaecheMon.getObjectId(), flaecheMon.getClassId(), this.getConnectionContext()).getBean();
                    this.createSingleReport(flaecheBean, templateBean, pdfFile);
                    return pdfName;
                }
                String cmdTemplate = this.getProperties().getPdfMergeCmdTemplate();
                if (cmdTemplate == null) throw new Exception("can't create multi-report pdf, no merge command provided");
                if (cmdTemplate.isEmpty()) throw new Exception("can't create multi-report pdf, no merge command provided");
                File tmpDir = new File(reportsDirectoryName, random);
                if (!tmpDir.exists()) {
                    tmpDir.mkdir();
                }
                for (MetaObjectNode metaObjectNode : flaecheMons) {
                    CidsBean flaecheBean = this.getMetaService().getMetaObject(this.getUser(), metaObjectNode.getObjectId(), metaObjectNode.getClassId(), this.getConnectionContext()).getBean();
                    File pdfTmpFile = new File(tmpDir, String.format("%s.pdf", (String)flaecheBean.getProperty("nummer")));
                    this.createSingleReport(flaecheBean, templateBean, pdfTmpFile);
                }
                String cmd = cmdTemplate.replaceAll(Pattern.quote(TEMPLATEREPLACER_INPUT_FILELIST), Matcher.quoteReplacement(String.format("\"%s\"/*", tmpDir))).replaceAll(Pattern.quote(TEMPLATEREPLACER_OUTPUT_FILE), Matcher.quoteReplacement(String.format("\"%s\"", pdfFile)));
                LOG.info((Object)String.format("executing CMD: %s", cmd));
                PotenzialflaecheReportServerAction.executeCmd(cmd, reportsDirectory);
                File[] fileArray = tmpDir.listFiles();
                int flaecheBean = fileArray.length;
                int pdfTmpFile = 0;
                while (true) {
                    if (pdfTmpFile >= flaecheBean) {
                        tmpDir.delete();
                        return pdfName;
                    }
                    File tmpFile = fileArray[pdfTmpFile];
                    tmpFile.delete();
                    ++pdfTmpFile;
                }
            }
            if (!ResultType.ZIP.equals((Object)resultType)) return null;
            File tmpDir = new File(this.getProperties().getReportsDirectory());
            String zipName = String.format("%s.zip", random);
            File zipFile = new File(tmpDir, zipName);
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile));){
                StringBuffer errorAppender = new StringBuffer();
                for (MetaObjectNode flaecheMon : flaecheMons) {
                    String pdfName = String.format("%s.pdf", RandomStringUtils.randomAlphanumeric((int)24));
                    File pdfFile = new File(tmpDir, pdfName);
                    try {
                        CidsBean flaecheBean = this.getMetaService().getMetaObject(this.getUser(), flaecheMon.getObjectId(), flaecheMon.getClassId(), this.getConnectionContext()).getBean();
                        this.createSingleReport(flaecheBean, templateBean, pdfFile);
                        this.appendZipEntryFor(pdfFile, String.format("%s.pdf", (String)flaecheBean.getProperty("nummer")), zipOutputStream);
                        pdfFile.delete();
                    }
                    catch (Exception ex) {
                        errorAppender.append(String.format("-----%s-----\n==========\n%s\n==========\n", flaecheMon.toString(), ex.getMessage()));
                    }
                }
                String string2 = errorAppender.toString();
                if (!string2.isEmpty()) {
                    this.appendZipEntryFor(string2, "errors.txt", zipOutputStream);
                }
                zipOutputStream.closeEntry();
                zipOutputStream.finish();
                zipOutputStream.flush();
                String string = zipName;
                return string;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"error while creating report", (Throwable)ex);
            return ex;
        }
    }

    private static String executeCmd(String cmd, File workingDir) throws Exception {
        ProcessBuilder builder = new ProcessBuilder("/bin/sh", "-c", cmd).directory(workingDir);
        Process process = builder.start();
        InputStream is = process.getInputStream();
        return IOUtils.toString((Reader)new InputStreamReader(is));
    }

    public ZipOutputStream appendZipEntryFor(File file, String entryName, ZipOutputStream zipOutputStream) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            ZipOutputStream zipOutputStream2 = this.appendZipEntryFor(fileInputStream, entryName, zipOutputStream);
            return zipOutputStream2;
        }
    }

    public ZipOutputStream appendZipEntryFor(String string, String entryName, ZipOutputStream zipOutputStream) throws IOException {
        return this.appendZipEntryFor(IOUtils.toInputStream((String)string, (String)"UTF-8"), entryName, zipOutputStream);
    }

    public ZipOutputStream appendZipEntryFor(InputStream inputStream, String entryName, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(entryName);
        zipOutputStream.putNextEntry(zipEntry);
        IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
        zipOutputStream.closeEntry();
        return zipOutputStream;
    }

    private void createSingleReport(CidsBean flaecheBean, CidsBean templateBean, File file) throws Exception {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            PotenzialflaecheReportCreator creator = new PotenzialflaecheReportCreator(this.getProperties(), this.getMapsJson(), flaecheBean, this.getUser(), this.getMetaService(), this.getConnectionContext());
            creator.writeReportToOutputStream(flaecheBean, templateBean, fileOutputStream);
        }
    }

    public PotenzialflaechenProperties getProperties() throws Exception {
        return (PotenzialflaechenProperties)ServerResourcesLoader.getInstance().get(this.POTENZIALFLAECHEN_PROPERTIES);
    }

    public PotenzialflaechenMapsJson getMapsJson() throws Exception {
        return (PotenzialflaechenMapsJson)ServerResourcesLoader.getInstance().get(this.POTENZIALFLAECHEN_MAPS_JSON);
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static abstract class MonSearchReportProperty
    extends VirtualReportProperty {
        private final String tableName;

        public MonSearchReportProperty(String tableName) {
            this.tableName = tableName;
        }

        public abstract RestApiMonSearch createMonServerSearch();

        @Override
        public Collection calculateProperty(PotenzialflaecheReportCreator creator) {
            RestApiMonSearch serverSearch = this.createMonServerSearch();
            if (serverSearch != null) {
                if (serverSearch instanceof GeometrySearch) {
                    CidsBean flaecheBean = creator.getFlaecheBean();
                    ((GeometrySearch)((Object)serverSearch)).setGeometry((Geometry)flaecheBean.getProperty("geometrie.geo_field"));
                }
                ArrayList<String> names = new ArrayList<String>();
                try {
                    for (MetaObjectNode mon : creator.executeSearch((CidsServerSearch)serverSearch)) {
                        names.add(mon.getName());
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    return null;
                }
                return names;
            }
            return null;
        }

        public String getTableName() {
            return this.tableName;
        }
    }

    public static abstract class VirtualReportProperty
    extends ReportProperty {
    }

    public static class MultiKeytableReportProperty
    extends KeytableReportProperty {
        public MultiKeytableReportProperty(String bindingPath, String filterPath, String foreignTable) {
            super(bindingPath, filterPath, foreignTable);
        }

        @Override
        public Object calculateProperty(PotenzialflaecheReportCreator creator) throws Exception {
            return creator.getFlaecheBean().getBeanCollectionProperty(this.getPath());
        }
    }

    public static class KeytableReportProperty
    extends PathReportProperty {
        private final String foreignTable;
        private final String filterPath;

        public KeytableReportProperty(String bindingPath, String foreignTable) {
            this(bindingPath, bindingPath, foreignTable);
        }

        public KeytableReportProperty(String bindingPath, String filterPath, String foreignTable) {
            super(bindingPath);
            this.foreignTable = foreignTable;
            this.filterPath = filterPath;
        }

        public String getForeignTable() {
            return this.foreignTable;
        }

        public String getFilterPath() {
            return this.filterPath;
        }
    }

    public static class SimpleFieldReportProperty
    extends PathReportProperty {
        private final String className;

        public SimpleFieldReportProperty(String path) {
            this(path, null);
        }

        public SimpleFieldReportProperty(String path, String className) {
            super(path);
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }
    }

    public static abstract class PathReportProperty
    extends ReportProperty {
        private final String path;

        public PathReportProperty(String path) {
            this.path = path;
        }

        @Override
        public Object calculateProperty(PotenzialflaecheReportCreator creator) throws Exception {
            return creator.getFlaecheBean().getProperty(this.getPath());
        }

        public String getPath() {
            return this.path;
        }
    }

    public static abstract class ReportProperty {
        public abstract Object calculateProperty(PotenzialflaecheReportCreator var1) throws Exception;
    }

    public static enum ResultType {
        PDF,
        ZIP;

    }

    public static enum BodyType {
        POTENZIALFLAECHE,
        KATEGORIE;

    }

    public static enum Parameter {
        POTENZIALFLAECHE,
        KATEGORIE,
        BODY_TYPE,
        RESULT_TYPE,
        TEMPLATE,
        EXTERNAL;

    }

    public static enum Property {
        BEZEICHNUNG(new SimpleFieldReportProperty("bezeichnung", String.class.getCanonicalName()), "Bezeichnung"),
        NUMMER(new SimpleFieldReportProperty("nummer", String.class.getCanonicalName()), "Nummer"),
        BESCHREIBUNG_FLAECHE(new SimpleFieldReportProperty("beschreibung_flaeche", String.class.getCanonicalName()), "Beschreibung der Fl\u00e4che"),
        NOTWENDIGE_MASSNAHMEN(new SimpleFieldReportProperty("notwendige_massnahmen", String.class.getCanonicalName()), "Notwendige Ma\u00dfnahmen"),
        INTERNE_HINWEISE(new SimpleFieldReportProperty("interne_hinweise", String.class.getCanonicalName()), "Interne Hinweise"),
        QUELLE(new SimpleFieldReportProperty("quelle", String.class.getCanonicalName()), "Quelle"),
        WOHNEINHEITEN_ANZAHL(new SimpleFieldReportProperty("anzahl_wohneinheiten", Integer.class.getCanonicalName()), "Anzahl m\u00f6gl. Wohneinheiten"),
        FESTSETZUNGEN_BPLAN(new SimpleFieldReportProperty("festsetzungen_bplan", String.class.getCanonicalName()), "Festsetzungen"),
        BAUORDNUNGSRECHT_STAND(new SimpleFieldReportProperty("stand_bauordnungsrecht", Date.class.getCanonicalName()), "Stand des Bauordnungsrechts"),
        STAND(new SimpleFieldReportProperty("stand", Date.class.getCanonicalName()), "Stand der Beschreibung"),
        JAHR_NUTZUNGSAUFGABE(new SimpleFieldReportProperty("jahr_brachflaeche", Date.class.getCanonicalName()), "Nutzungsaufgabe"),
        VORHANDENE_BEBAUUNG(new SimpleFieldReportProperty("bestand_bebauung", String.class.getCanonicalName()), "Bestand Bebauung"),
        KAMPAGNE(new KeytableReportProperty("kampagne", "pf_kampagne"), "Kategorie"),
        LAGEBEWERTUNG_VERKEHR(new KeytableReportProperty("fk_lagebewertung_verkehr", "pf_lagebewertung_verkehr"), "Lagebewertung, Verkehr"),
        SIEDLUNGSRAEUMLICHE_LAGE(new KeytableReportProperty("fk_siedlungsraeumliche_lage", "pf_siedlungsraeumliche_lage"), "Siedlungsr\u00e4umliche Lage"),
        TOPOGRAFIE(new KeytableReportProperty("topografie", "pf_topografie"), "Topografie"),
        HANG(new KeytableReportProperty("fk_ausrichtung", "pf_ausrichtung"), "Hang"),
        VERWERTBARKEIT(new KeytableReportProperty("fk_verwertbarkeit", "pf_verwertbarkeit"), "Verwertbarkeit"),
        VERFUEGBBARKEIT(new KeytableReportProperty("verfuegbarkeit", "pf_verfuegbarkeit"), "Verf\u00fcgbarkeit"),
        ENTWICKLUNGSAUSSSICHTEN(new KeytableReportProperty("fk_entwicklungsaussichten", "pf_entwicklungsaussichten"), "Entwicklungsaussichten"),
        ENTWICKLUNGSSTAND(new KeytableReportProperty("fk_entwicklungsstand", "pf_entwicklungsstand"), "Entwicklungsstand"),
        REVITALISIERUNG(new KeytableReportProperty("fk_revitalisierung", "pf_revitalisierung"), "Revitalisierung"),
        AEUSSERE_ERSCHLIESSUNG(new KeytableReportProperty("fk_aeussere_erschliessung", "pf_aeussere_erschliessung"), "\u00c4u\u00dfere Erschlie\u00dfung"),
        POTENZIALART(new KeytableReportProperty("fk_potenzialart", "pf_potenzialart"), "Potenzialart"),
        KATEGORIE(new KeytableReportProperty("fk_kategorie", "pf_kategorie"), "Entwicklungsart"),
        WOHNEINHEITEN(new KeytableReportProperty("fk_wohneinheiten", "pf_wohneinheiten"), "Wohneinheiten"),
        OEPNV_ANBINDUNG(new KeytableReportProperty("fk_oepnv", "pf_oepnv"), "\u00d6PNV-Qualit\u00e4t"),
        KLIMAINFORMATIONEN(new KeytableReportProperty("fk_klimainformationen", "pf_klimainformationen"), "Klimainformationen"),
        VERSIEGELUNG(new KeytableReportProperty("fk_versiegelung", "pf_versiegelung"), "Versiegelung"),
        BAUORDNUNGSRECHT_GENEHMIGUNG(new KeytableReportProperty("fk_bauordnungsrecht_genehmigung", "pf_bauordnungsrecht_genehmigung"), "Bauordnungsrecht (Genehmigung)"),
        BAUORDNUNGSRECHT_BAULAST(new KeytableReportProperty("fk_bauordnungsrecht_baulast", "pf_bauordnungsrecht_baulast"), "Bauordnungsrecht (Baulast)"),
        HANDLUNGSDRUCK(new KeytableReportProperty("handlungsdruck", "pf_handlungsdruck"), "Handlungsdruck"),
        HANDLUNGSPRIORITAET(new KeytableReportProperty("fk_handlungsprioritaet", "pf_handlungsprioritaet"), "Handlungspriorit\u00e4t"),
        EIGENTUEMER(new MultiKeytableReportProperty("arr_eigentuemer", "pf_eigentuemer_arr.fk_eigentuemer", "pf_eigentuemer"), "Eigent\u00fcmer"),
        BISHERIGE_NUTZUNG(new MultiKeytableReportProperty("bisherige_nutzung", "pf_potenzialflaechen_bisherige_nutzung.nutzung", "pf_nutzung"), "Bisherige Nutzung"),
        UMGEBUNGSNUTZUNG(new MultiKeytableReportProperty("umgebungsnutzung", "pf_potenzialflaechen_umgebungsnutzung.nutzung", "pf_nutzung"), "Umgebungsnutzung"),
        NAEHE_ZU(new MultiKeytableReportProperty("arr_naehen_zu", "pf_naehen_zu.fk_naehe_zu", "pf_naehe_zu"), "N\u00e4he zu"),
        BRACHFLAECHENKATEGORIE(new MultiKeytableReportProperty("arr_brachflaechen", "pf_brachflaechen.fk_brachflaeche", "pf_brachflaeche"), "Brachfl\u00e4che"),
        EMPFOHLENE_NUTZUNGEN(new MultiKeytableReportProperty("arr_empfohlene_nutzungen", "pf_empfohlene_nutzungen.fk_empfohlene_nutzung", "pf_empfohlene_nutzung"), "Empfohlene Nutzung"),
        EMPFOHLENE_NUTZUNGEN_WOHNEN(new MultiKeytableReportProperty("arr_empfohlene_nutzungen_wohnen", "pf_empfohlene_nutzungen_wohnen.fk_empfohlene_nutzung_wohnen", "pf_empfohlene_nutzung_wohnen"), "Empfohlene Art der Wohnnutzung"),
        RESTRIKTIONEN(new MultiKeytableReportProperty("arr_restriktionen", "pf_restriktionen.fk_restriktion", "pf_restriktion"), "Restriktionen"),
        GROESSE(new VirtualReportProperty(){

            @Override
            public String calculateProperty(PotenzialflaecheReportCreator creator) {
                CidsBean flaecheBean = creator.getFlaecheBean();
                Object geo = flaecheBean.getProperty("geometrie.geo_field");
                double area = 0.0;
                if (geo instanceof Geometry) {
                    area = ((Geometry)geo).getArea();
                }
                double m2 = (double)Math.round(area * 100.0) / 100.0;
                double ha = (double)Math.round(area / 1000.0) / 10.0;
                return String.format("%,.2f m\u00b2 (circa %,.1f ha)", m2, ha);
            }
        }, "Gr\u00f6\u00dfe"),
        BEBAUUNGSPLAN(new MonSearchReportProperty("bplan_verfahren"){

            @Override
            public RestApiMonSearch createMonServerSearch() {
                return new BplaeneMonSearch(-3.0, new BplaeneMonSearch.SubUnion("nummer || ' (' || vstandr || ' ' || TO_CHAR(TO_DATE(datumr, 'DD.MM.YYYY'), 'DD.MM.YYYY') || ')'", "LEFT JOIN geom ON geom.id = bplan_verfahren.geometrie", "vstandr IS NOT NULL", "('-'||LPAD(REGEXP_REPLACE(COALESCE(nummer, '0'), '[^0-9]+.*$', '', 'g'), 4, '0') || LPAD(COALESCE(TO_CHAR(TO_DATE(datumr, 'DD.MM.YYYY'), 'YYYYMMDD'), '0'), 8, '0'))::bigint"), new BplaeneMonSearch.SubUnion("nummer || ' (' || vstandi || ' ' || TO_CHAR(TO_DATE(datumi, 'DD.MM.YYYY'), 'DD.MM.YYYY') || ')'", "LEFT JOIN geom ON geom.id = bplan_verfahren.georefi", "vstandi IS NOT NULL", "('-'||LPAD(REGEXP_REPLACE(COALESCE(nummer, '0'), '[^0-9]+.*$', '', 'g'), 4, '0') || LPAD(COALESCE(TO_CHAR(TO_DATE(datumi, 'DD.MM.YYYY'), 'YYYYMMDD'), '0'), 8, '0'))::bigint"));
            }
        }, "BPlan"),
        STADTBEZIRK(new MonSearchReportProperty("kst_stadtbezirk"){

            @Override
            public RestApiMonSearch createMonServerSearch() {
                return new KstGeometryMonSearch(KstGeometryMonSearch.SearchFor.BEZIRK, -2.0);
            }
        }, "Stadtbezirke"),
        QUARTIER(new MonSearchReportProperty("kst_quartier"){

            @Override
            public RestApiMonSearch createMonServerSearch() {
                return new KstGeometryMonSearch(KstGeometryMonSearch.SearchFor.QUARTIER, -2.0);
            }
        }, "Quartiere"),
        FLURSTUECKE(new MonSearchReportProperty("alkis_landparcel"){

            @Override
            public RestApiMonSearch createMonServerSearch() {
                return new AlkisLandparcelGeometryMonSearch(-2.0);
            }
        }, "Flurst\u00fccke"),
        WOHNLAGEN(new MonSearchReportProperty("wohnlage_kategorie"){

            @Override
            public RestApiMonSearch createMonServerSearch() {
                return new WohnlagenKategorisierungMonSearch((Double)0.1, -2.0);
            }
        }, "Wohnlagen"),
        STADTRAUMTYPEN(new MonSearchReportProperty("srt_kategorie"){

            @Override
            public RestApiMonSearch createMonServerSearch() {
                return new StadtraumtypMonSearch(-2.0);
            }
        }, "Stadtraumtypen"),
        FLAECHENNUTZUNGSPLAN(new MonSearchReportProperty("fnp_hn_kategorie"){

            @Override
            public RestApiMonSearch createMonServerSearch() {
                return new FnpHauptnutzungenMonSearch((Double)0.1, -2.0);
            }
        }, "Fl\u00e4chennutzungsplan"),
        REGIONALPLAN(new MonSearchReportProperty("rpd_kategorie"){

            @Override
            public RestApiMonSearch createMonServerSearch() {
                return new RpdKategorieMonSearch((Double)0.2, -2.0);
            }
        }, "Regionalplan"),
        BODENRICHTWERTE(new MonSearchReportProperty("brw_zone"){

            @Override
            public RestApiMonSearch createMonServerSearch() {
                return new BodenrichtwertZoneMonSearch(-2.0);
            }
        }, "Bodenrichtwerte"),
        BACKCOLOR(new VirtualReportProperty(){

            @Override
            public String calculateProperty(PotenzialflaecheReportCreator creator) {
                CidsBean flaecheBean = creator.getFlaecheBean();
                String colorcode = (String)flaecheBean.getProperty("kampagne.colorcode");
                return colorcode;
            }
        }, "Gr\u00f6\u00dfe"),
        FORECOLOR(new VirtualReportProperty(){

            @Override
            public String calculateProperty(PotenzialflaecheReportCreator creator) {
                CidsBean flaecheBean = creator.getFlaecheBean();
                String colorcode = (String)flaecheBean.getProperty("kampagne.colorcode");
                Color backgroundColor = Color.decode(colorcode);
                double luminance = 0.2126 * (double)backgroundColor.getRed() + 0.7152 * (double)backgroundColor.getGreen() + 0.0722 * (double)backgroundColor.getBlue();
                return luminance < 140.0 ? "#FFFFFF" : "#000000";
            }
        }, "Gr\u00f6\u00dfe");

        private final ReportProperty value;
        private final String toString;

        private Property(ReportProperty value, String toString) {
            this.value = value;
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }

        public ReportProperty getValue() {
            return this.value;
        }
    }
}

